/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.sql.SQLException;

public class DB2ScrollableResultSet
extends DB2ResultSet {
    private int rowNumber = 0;
    private int activeFetchSize = -1;
    private int rowSetStart = -1;
    private int rowSetEnd = -1;
    static final int SQL_POSITION = 0;
    static final int SQL_LOCK_NO_CHANGE = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DB2ScrollableResultSet(DB2Statement stmt, int colNum, int rowNum) throws SQLException {
        super(stmt, colNum);
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2ScrollableResultSet( colNum=" + colNum + ",rowNum=" + rowNum + ")");
            }
            this.rowNumber = rowNum;
            this.rsType = 1004;
            this.currentRowId = 0;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "DB2ScrollableResultSet()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset(int cols, int rows) throws SQLException {
        int rc2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "reset( " + cols + ", " + rows + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (rows == -1 && this.statement.sql != null && this.statement.getStatementType(this.statement.sql) == 24) {
                rc2 = this.SQLFetch(this.statement.statementHandle);
                if (rc2 != 0) {
                    this.sqlExcptGen.check_return_code(this.statement, rc2);
                }
                rows = 0;
            }
            this.reset(cols);
            this.rowNumber = rows;
            this.currentRowId = 0;
            this.rowSetStart = -1;
            this.rowSetEnd = -1;
            this.fetchSize = this.statement.fetchSize;
            this.fetchDirection = this.statement.fetchDirection;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "reset()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetRows(int rows) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "resetRows( " + rows + " )");
            }
            this.rowNumber = rows;
            this.currentRowId = 0;
            this.rowSetStart = -1;
            this.rowSetEnd = -1;
            this.fetchSize = this.statement.fetchSize;
            this.fetchDirection = this.statement.fetchDirection;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "resetRows()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBeforeFirst() throws SQLException {
        boolean bl2;
        block3: {
            boolean rv = false;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "isBeforeFirst()");
                }
                bl2 = rv = this.rowNumber > 0 && this.currentRowId < 1;
                Object var4_3 = null;
                if (!DB2Trace.TraceOn) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var4_4 = null;
                    if (!DB2Trace.TraceOn) break block4;
                    DB2Trace.methodExit((Object)this, "isBeforeFirst()", String.valueOf(rv));
                }
                throw throwable;
            }
            DB2Trace.methodExit((Object)this, "isBeforeFirst()", String.valueOf(rv));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAfterLast() throws SQLException {
        boolean bl2;
        block3: {
            boolean rv = false;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "isAfterLast()");
                }
                bl2 = rv = this.rowNumber > 0 && this.currentRowId > this.rowNumber;
                Object var4_3 = null;
                if (!DB2Trace.TraceOn) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var4_4 = null;
                    if (!DB2Trace.TraceOn) break block4;
                    DB2Trace.methodExit((Object)this, "isAfterLast()", String.valueOf(rv));
                }
                throw throwable;
            }
            DB2Trace.methodExit((Object)this, "isAfterLast()", String.valueOf(rv));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirst() throws SQLException {
        boolean bl2;
        block3: {
            boolean rv = false;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "isFirst()");
                }
                bl2 = rv = this.rowNumber > 0 && 1 == this.currentRowId;
                Object var4_3 = null;
                if (!DB2Trace.TraceOn) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var4_4 = null;
                    if (!DB2Trace.TraceOn) break block4;
                    DB2Trace.methodExit((Object)this, "isFirst()", String.valueOf(rv));
                }
                throw throwable;
            }
            DB2Trace.methodExit((Object)this, "isFirst()", String.valueOf(rv));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLast() throws SQLException {
        boolean bl2;
        block3: {
            boolean rv = false;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "isLast()");
                }
                bl2 = rv = this.rowNumber > 0 && this.currentRowId == this.rowNumber;
                Object var4_3 = null;
                if (!DB2Trace.TraceOn) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var4_4 = null;
                    if (!DB2Trace.TraceOn) break block4;
                    DB2Trace.methodExit((Object)this, "isLast()", String.valueOf(rv));
                }
                throw throwable;
            }
            DB2Trace.methodExit((Object)this, "isLast()", String.valueOf(rv));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beforeFirst() throws SQLException {
        try {
            block8: {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "beforeFirst()");
                }
                if (this.connection.closed) {
                    this.sqlExcptGen.throwConnectionClosedError();
                }
                if (this.statement.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                if (0 == this.rowNumber) break block8;
                if (this.currentRowId >= 1) break block9;
            }
            Object var2_1 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "currentRowId", this.currentRowId);
            DB2Trace.methodExit(this, "beforeFirst()");
            throw throwable;
        }
        DB2Trace.data(10, "currentRowId", this.currentRowId);
        DB2Trace.methodExit(this, "beforeFirst()");
        {
            block9: {
                return;
            }
            this.fetchRowSet(0);
            this.currentRowId = 0;
        }
        Object var2_2 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.data(10, "currentRowId", this.currentRowId);
        DB2Trace.methodExit(this, "beforeFirst()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterLast() throws SQLException {
        try {
            block8: {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "afterLast()");
                }
                if (this.connection.closed) {
                    this.sqlExcptGen.throwConnectionClosedError();
                }
                if (this.statement.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                if (0 == this.rowNumber) break block8;
                if (this.currentRowId <= this.rowNumber) break block9;
            }
            Object var2_1 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "currentRowId", this.currentRowId);
            DB2Trace.methodExit(this, "afterLast()");
            throw throwable;
        }
        DB2Trace.data(10, "currentRowId", this.currentRowId);
        DB2Trace.methodExit(this, "afterLast()");
        {
            block9: {
                return;
            }
            this.fetchRowSet(this.rowNumber + 1);
            this.currentRowId = this.rowNumber + 1;
        }
        Object var2_2 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.data(10, "currentRowId", this.currentRowId);
        DB2Trace.methodExit(this, "afterLast()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean first() throws SQLException {
        boolean bl2;
        block11: {
            boolean rv;
            block9: {
                boolean bl3;
                block10: {
                    block7: {
                        boolean bl4;
                        block8: {
                            rv = false;
                            try {
                                if (DB2Trace.TraceOn) {
                                    DB2Trace.methodEntry(this, "first()");
                                }
                                if (this.connection.closed) {
                                    this.sqlExcptGen.throwConnectionClosedError();
                                }
                                if (this.statement.closed) {
                                    this.sqlExcptGen.throwClosedError();
                                }
                                if (0 != this.rowNumber) break block7;
                                rv = false;
                                bl4 = false;
                                Object var4_5 = null;
                                if (!DB2Trace.TraceOn) break block8;
                            }
                            catch (Throwable throwable) {
                                block12: {
                                    Object var4_8 = null;
                                    if (!DB2Trace.TraceOn) break block12;
                                    DB2Trace.methodExit((Object)this, "first()", String.valueOf(rv));
                                }
                                throw throwable;
                            }
                            DB2Trace.methodExit((Object)this, "first()", String.valueOf(rv));
                        }
                        return bl4;
                    }
                    if (1 != this.currentRowId) break block9;
                    rv = true;
                    bl3 = true;
                    Object var4_6 = null;
                    if (!DB2Trace.TraceOn) break block10;
                    DB2Trace.methodExit((Object)this, "first()", String.valueOf(rv));
                }
                return bl3;
            }
            rv = this.fetchRowSet(1);
            this.currentRowId = 1;
            bl2 = rv;
            Object var4_7 = null;
            if (!DB2Trace.TraceOn) break block11;
            DB2Trace.methodExit((Object)this, "first()", String.valueOf(rv));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean last() throws SQLException {
        boolean bl2;
        block11: {
            boolean rv;
            block9: {
                boolean bl3;
                block10: {
                    block7: {
                        boolean bl4;
                        block8: {
                            rv = false;
                            try {
                                if (DB2Trace.TraceOn) {
                                    DB2Trace.methodEntry(this, "last()");
                                }
                                if (this.connection.closed) {
                                    this.sqlExcptGen.throwConnectionClosedError();
                                }
                                if (this.statement.closed) {
                                    this.sqlExcptGen.throwClosedError();
                                }
                                if (0 != this.rowNumber) break block7;
                                rv = false;
                                bl4 = false;
                                Object var4_5 = null;
                                if (!DB2Trace.TraceOn) break block8;
                            }
                            catch (Throwable throwable) {
                                block12: {
                                    Object var4_8 = null;
                                    if (!DB2Trace.TraceOn) break block12;
                                    DB2Trace.methodExit((Object)this, "last()", String.valueOf(rv));
                                }
                                throw throwable;
                            }
                            DB2Trace.methodExit((Object)this, "last()", String.valueOf(rv));
                        }
                        return bl4;
                    }
                    if (this.currentRowId != this.rowNumber) break block9;
                    rv = true;
                    bl3 = true;
                    Object var4_6 = null;
                    if (!DB2Trace.TraceOn) break block10;
                    DB2Trace.methodExit((Object)this, "last()", String.valueOf(rv));
                }
                return bl3;
            }
            rv = this.fetchRowSet(this.rowNumber);
            this.currentRowId = this.rowNumber;
            bl2 = rv;
            Object var4_7 = null;
            if (!DB2Trace.TraceOn) break block11;
            DB2Trace.methodExit((Object)this, "last()", String.valueOf(rv));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws SQLException {
        int rv = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getRow()");
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            rv = 0 == this.rowNumber || this.currentRowId < 1 || this.currentRowId > this.rowNumber ? 0 : this.currentRowId;
            int n2 = rv;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getRow()", rv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean absolute(int row) throws SQLException {
        boolean bl2;
        boolean rv;
        block19: {
            boolean bl3;
            block18: {
                boolean bl4;
                block17: {
                    boolean bl5;
                    block16: {
                        boolean bl6;
                        block15: {
                            rv = false;
                            try {
                                if (DB2Trace.TraceOn) {
                                    DB2Trace.methodEntry(this, "absolute()");
                                }
                                if (this.connection.closed) {
                                    this.sqlExcptGen.throwConnectionClosedError();
                                }
                                if (this.statement.closed) {
                                    this.sqlExcptGen.throwClosedError();
                                }
                                if (0 == row) {
                                    this.sqlExcptGen.throwInvalidAbsoluteCall();
                                }
                                if (0 == this.rowNumber) {
                                    rv = false;
                                    bl6 = false;
                                    Object var5_8 = null;
                                    if (!DB2Trace.TraceOn) return bl6;
                                    break block15;
                                }
                                if (row > this.rowNumber) {
                                    if (this.currentRowId > this.rowNumber) {
                                        rv = false;
                                        bl5 = false;
                                        break block16;
                                    }
                                    row = this.rowNumber + 1;
                                } else if (-row > this.rowNumber) {
                                    if (this.currentRowId < 1) {
                                        rv = false;
                                        bl4 = false;
                                        break block17;
                                    }
                                    row = 0;
                                } else if (row < 0) {
                                    row = this.rowNumber + row + 1;
                                }
                                if (row == this.currentRowId) {
                                    rv = true;
                                    bl3 = true;
                                    break block18;
                                }
                                rv = this.fetchRowSet(row);
                                this.currentRowId = row;
                                bl2 = rv;
                                break block19;
                            }
                            catch (Throwable throwable) {
                                Object var5_13 = null;
                                if (!DB2Trace.TraceOn) throw throwable;
                                DB2Trace.methodExit((Object)this, "absolute()", String.valueOf(rv));
                                throw throwable;
                            }
                        }
                        DB2Trace.methodExit((Object)this, "absolute()", String.valueOf(rv));
                        return bl6;
                    }
                    Object var5_9 = null;
                    if (!DB2Trace.TraceOn) return bl5;
                    DB2Trace.methodExit((Object)this, "absolute()", String.valueOf(rv));
                    return bl5;
                }
                Object var5_10 = null;
                if (!DB2Trace.TraceOn) return bl4;
                DB2Trace.methodExit((Object)this, "absolute()", String.valueOf(rv));
                return bl4;
            }
            Object var5_11 = null;
            if (!DB2Trace.TraceOn) return bl3;
            DB2Trace.methodExit((Object)this, "absolute()", String.valueOf(rv));
            return bl3;
        }
        Object var5_12 = null;
        if (!DB2Trace.TraceOn) return bl2;
        DB2Trace.methodExit((Object)this, "absolute()", String.valueOf(rv));
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relative(int rows) throws SQLException {
        boolean bl2;
        block12: {
            int row;
            boolean rv;
            block10: {
                boolean bl3;
                block11: {
                    block8: {
                        boolean bl4;
                        block9: {
                            rv = false;
                            try {
                                if (DB2Trace.TraceOn) {
                                    DB2Trace.methodEntry(this, "relative()");
                                }
                                if (this.connection.closed) {
                                    this.sqlExcptGen.throwConnectionClosedError();
                                }
                                if (this.statement.closed) {
                                    this.sqlExcptGen.throwClosedError();
                                }
                                if (0 == this.getRow()) {
                                    this.sqlExcptGen.throwInvalidRelativeCall();
                                }
                                if (0 != this.rowNumber) break block8;
                                rv = false;
                                bl4 = false;
                                Object var6_5 = null;
                                if (!DB2Trace.TraceOn) break block9;
                            }
                            catch (Throwable throwable) {
                                block13: {
                                    Object var6_8 = null;
                                    if (!DB2Trace.TraceOn) break block13;
                                    DB2Trace.methodExit((Object)this, "relative()", String.valueOf(rv));
                                }
                                throw throwable;
                            }
                            DB2Trace.methodExit((Object)this, "relative()", String.valueOf(rv));
                        }
                        return bl4;
                    }
                    row = this.currentRowId + rows;
                    if (row > 0) break block10;
                    this.beforeFirst();
                    rv = false;
                    bl3 = false;
                    Object var6_6 = null;
                    if (!DB2Trace.TraceOn) break block11;
                    DB2Trace.methodExit((Object)this, "relative()", String.valueOf(rv));
                }
                return bl3;
            }
            bl2 = rv = this.absolute(row);
            Object var6_7 = null;
            if (!DB2Trace.TraceOn) break block12;
            DB2Trace.methodExit((Object)this, "relative()", String.valueOf(rv));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SQLException {
        boolean bl2;
        block5: {
            boolean rv = false;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "previous()");
                }
                if (this.connection.closed) {
                    this.sqlExcptGen.throwConnectionClosedError();
                }
                if (this.statement.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                rv = 0 == this.rowNumber || this.currentRowId < 1 ? false : this.fetchRowSet(this.currentRowId - 1);
                --this.currentRowId;
                bl2 = rv;
                Object var4_3 = null;
                if (!DB2Trace.TraceOn) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var4_4 = null;
                    if (!DB2Trace.TraceOn) break block6;
                    DB2Trace.methodExit((Object)this, "previous()", String.valueOf(rv));
                }
                throw throwable;
            }
            DB2Trace.methodExit((Object)this, "previous()", String.valueOf(rv));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        boolean bl2;
        block5: {
            boolean rv = false;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "next()");
                }
                if (this.connection.closed) {
                    this.sqlExcptGen.throwConnectionClosedError();
                }
                if (this.statement.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                rv = 0 == this.rowNumber || this.currentRowId > this.rowNumber ? false : this.fetchRowSet(this.currentRowId + 1);
                ++this.currentRowId;
                bl2 = rv;
                Object var4_3 = null;
                if (!DB2Trace.TraceOn) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var4_4 = null;
                    if (!DB2Trace.TraceOn) break block6;
                    DB2Trace.methodExit((Object)this, "next()", String.valueOf(rv));
                }
                throw throwable;
            }
            DB2Trace.methodExit((Object)this, "next()", String.valueOf(rv));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fetchRowSet(int nextRowId) throws SQLException {
        boolean bl2;
        block25: {
            boolean returnValue = false;
            int tmpFetchSize = this.fetchSize;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "fetchRowSet(" + nextRowId + ")");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    DB2Trace.data(10, "rowSetStart, rowSetEnd, fetchSize, fetchDirection, rowNumber, currentRowId", this.rowSetStart + "," + this.rowSetEnd + "," + this.fetchSize + "," + this.fetchDirection + "," + this.rowNumber + "," + this.currentRowId);
                }
                this.clearIsList();
                this.clearWarnings();
                if (nextRowId >= this.rowSetStart && nextRowId <= this.rowSetEnd) {
                    returnValue = this.setPos(nextRowId);
                } else {
                    int rc2;
                    if (this.fetchSize < 1) {
                        tmpFetchSize = 1;
                    }
                    int rowSetStartPrev = this.rowSetStart;
                    int rowSetEndPrev = this.rowSetEnd;
                    switch (this.fetchDirection) {
                        case 1000: {
                            this.rowSetStart = Math.max(1, nextRowId);
                            this.rowSetEnd = Math.min(this.rowNumber, this.rowSetStart + tmpFetchSize - 1);
                            break;
                        }
                        case 1001: {
                            this.rowSetEnd = Math.min(this.rowNumber, nextRowId);
                            this.rowSetStart = Math.max(1, this.rowSetEnd - tmpFetchSize + 1);
                            break;
                        }
                        case 1002: {
                            int bottomGap = (tmpFetchSize - 1) / 2;
                            this.rowSetStart = Math.max(1, nextRowId - bottomGap);
                            this.rowSetEnd = Math.min(this.rowNumber, this.rowSetStart + tmpFetchSize - 1);
                            break;
                        }
                        default: {
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(10, "Unknown fetch direction of " + this.fetchDirection);
                                DB2Trace.data(10, "Assuming Forward Only");
                            }
                            this.rowSetStart = Math.max(1, nextRowId);
                            this.rowSetEnd = Math.min(this.rowNumber, this.rowSetStart + tmpFetchSize - 1);
                        }
                    }
                    int fetchOrientation = 5;
                    if (this.rowSetStart == rowSetEndPrev + 1 && this.fetchDirection == 1000) {
                        fetchOrientation = 1;
                    } else if (this.rowSetEnd == rowSetStartPrev - 1 && this.fetchDirection == 1001) {
                        fetchOrientation = 4;
                    }
                    if (nextRowId < this.rowSetStart || nextRowId > this.rowSetEnd) {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(10, "Moving to Invalid Row SQLFetchScroll(" + nextRowId + ")");
                        }
                        rc2 = this.SQLFetchScroll(this.statement.statementHandle, fetchOrientation, nextRowId, 0);
                    } else if (this.activeFetchSize == tmpFetchSize) {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(10, "SQLFetchScroll(" + this.rowSetStart + ", resetFetchSize=FALSE )");
                        }
                        rc2 = this.SQLFetchScroll(this.statement.statementHandle, fetchOrientation, this.rowSetStart, 0);
                    } else {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(10, "SQLFetchScroll(" + this.rowSetStart + ", resetFetchSize=" + tmpFetchSize + ")");
                        }
                        rc2 = this.SQLFetchScroll(this.statement.statementHandle, fetchOrientation, this.rowSetStart, tmpFetchSize);
                    }
                    if (rc2 != 100) {
                        this.sqlExcptGen.check_return_code(this.statement, this, rc2);
                        returnValue = true;
                        this.activeFetchSize = tmpFetchSize;
                        if (nextRowId != this.rowSetStart) {
                            returnValue = this.setPos(nextRowId);
                        }
                    } else {
                        returnValue = false;
                        this.rowSetStart = -1;
                        this.rowSetEnd = -1;
                        this.activeFetchSize = -1;
                    }
                }
                bl2 = returnValue;
                Object var9_8 = null;
                if (!DB2Trace.TraceOn) break block25;
            }
            catch (Throwable throwable) {
                block26: {
                    Object var9_9 = null;
                    if (!DB2Trace.TraceOn) break block26;
                    DB2Trace.data(10, "rowSetStart, rowSetEnd, fetchSize, tmpFetchSize, fetchDirection, rowNumber, currentRowId", this.rowSetStart + "," + this.rowSetEnd + "," + this.fetchSize + "," + tmpFetchSize + "," + this.fetchDirection + "," + this.rowNumber + "," + this.currentRowId);
                    DB2Trace.methodExit((Object)this, "fetchRowSet", String.valueOf(returnValue));
                }
                throw throwable;
            }
            DB2Trace.data(10, "rowSetStart, rowSetEnd, fetchSize, tmpFetchSize, fetchDirection, rowNumber, currentRowId", this.rowSetStart + "," + this.rowSetEnd + "," + this.fetchSize + "," + tmpFetchSize + "," + this.fetchDirection + "," + this.rowNumber + "," + this.currentRowId);
            DB2Trace.methodExit((Object)this, "fetchRowSet", String.valueOf(returnValue));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setPos(int nextRowId) throws SQLException {
        boolean bl2;
        block7: {
            int rowInSet = 0;
            boolean returnValue = false;
            try {
                int rc2;
                rowInSet = nextRowId - this.rowSetStart + 1;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "setPos(" + nextRowId + ")");
                    DB2Trace.data(10, "rowInSet", rowInSet);
                }
                if ((rc2 = this.SQLSetPos(this.statement.statementHandle, rowInSet, 0, 0)) == 0) {
                    returnValue = true;
                } else if (rc2 == 1) {
                    this.sqlExcptGen.check_return_code(this.statement, this, rc2);
                    returnValue = true;
                } else {
                    returnValue = false;
                }
                bl2 = returnValue;
                Object var7_6 = null;
                if (!DB2Trace.TraceOn) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var7_7 = null;
                    if (!DB2Trace.TraceOn) break block8;
                    DB2Trace.methodExit((Object)this, "setPos", String.valueOf(returnValue));
                }
                throw throwable;
            }
            DB2Trace.methodExit((Object)this, "setPos", String.valueOf(returnValue));
        }
        return bl2;
    }
}

