/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.math.BigDecimal;
import java.sql.SQLException;

public class DB2SQLTypeMappingResultSet
extends DB2ResultSet {
    private int[] typeColumns;

    public DB2SQLTypeMappingResultSet(DB2Statement stmt, int[] map, int mappedColumns) throws SQLException {
        super(stmt, stmt.getColCount(), mappedColumns);
        this.typeColumns = map;
    }

    public DB2SQLTypeMappingResultSet(DB2Statement stmt, int[] map, int mappedColumns, String[] mappedColNames) throws SQLException {
        super(stmt, 0, mappedColumns, mappedColNames);
        this.typeColumns = map;
    }

    private boolean isTypeColumn(int column) {
        boolean itIs = false;
        if (this.typeColumns == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.typeColumns.length; ++i2) {
            if (column != this.typeColumns[i2]) continue;
            itIs = true;
        }
        return itIs;
    }

    private boolean restAre(byte[] result, int thisInt) {
        int i2;
        boolean are1 = true;
        boolean are2 = true;
        for (i2 = 1; i2 < result.length; ++i2) {
            if (result[i2] == thisInt) continue;
            are1 = false;
        }
        for (i2 = 0; i2 < result.length - 1; ++i2) {
            if (result[i2] == thisInt) continue;
            are2 = false;
        }
        return are1 && are2;
    }

    protected String getString2(int column) throws SQLException {
        String result = super.getString2(column);
        if (this.isTypeColumn(column)) {
            result = new Integer(this.connection.adjust(new Integer(result))).toString();
        }
        return result;
    }

    protected byte getByte2(int column) throws SQLException {
        byte result = super.getByte2(column);
        if (this.isTypeColumn(column)) {
            result = (byte)this.connection.adjust(result);
        }
        return result;
    }

    protected short getShort2(int column) throws SQLException {
        short result = super.getShort2(column);
        if (this.isTypeColumn(column)) {
            result = (short)this.connection.adjust(result);
        }
        return result;
    }

    protected int getInt2(int column) throws SQLException {
        int result = super.getInt2(column);
        if (this.isTypeColumn(column)) {
            result = this.connection.adjust(result);
        }
        return result;
    }

    protected long getLong2(int column) throws SQLException {
        long result = super.getLong2(column);
        if (this.isTypeColumn(column)) {
            result = this.connection.adjust((int)result);
        }
        return result;
    }

    protected float getFloat2(int column) throws SQLException {
        float result = super.getFloat2(column);
        if (this.isTypeColumn(column)) {
            result = this.connection.adjust((int)result);
        }
        return result;
    }

    protected double getDouble2(int column) throws SQLException {
        double result = super.getDouble2(column);
        if (this.isTypeColumn(column)) {
            result = this.connection.adjust((int)result);
        }
        return result;
    }

    protected BigDecimal getBigDecimal2(int column, int scale) throws SQLException {
        BigDecimal result = super.getBigDecimal2(column, scale);
        if (this.isTypeColumn(column)) {
            result = new BigDecimal((double)this.connection.adjust(result.intValue()));
        }
        return result;
    }

    protected byte[] getBytes2(int column) throws SQLException {
        byte[] result = super.getBytes2(column);
        if (this.isTypeColumn(column)) {
            int index = result.length - 1;
            if (this.restAre(result, -1)) {
                if (result[0] == -98) {
                    result[0] = -44;
                } else if (result[index] == -98) {
                    result[index] = -44;
                } else if (result[0] == -99) {
                    result[0] = -43;
                } else if (result[index] == -99) {
                    result[index] = -43;
                } else if (result[0] == -95) {
                    result[0] = 1;
                } else if (result[index] == -95) {
                    result[index] = 1;
                } else if (result[0] == -96) {
                    result[0] = 12;
                } else if (result[index] == -96) {
                    result[index] = 12;
                }
                return result;
            }
            byte[] b2 = this.int2Binary(-350);
            if (b2[0] == result[0] && b2[1] == result[0] && b2[2] == result[2] && b2[3] == result[3]) {
                return this.int2Binary(2005);
            }
            if (b2[0] == result[3] && b2[1] == result[2] && b2[2] == result[1] && b2[3] == result[0]) {
                return this.reverse(this.int2Binary(2005));
            }
            return result;
        }
        return result;
    }

    protected byte[] int2Binary(int i2) {
        byte[] buf = new byte[]{(byte)(i2 & 0xFF), (byte)((i2 & 0xFF00) >> 8), (byte)((i2 & 0xFF0000) >> 16), (byte)((i2 & 0xFF000000) >> 24)};
        return buf;
    }

    protected byte[] reverse(byte[] ba) {
        byte[] b2 = new byte[ba.length];
        for (int i2 = 0; i2 < ba.length; ++i2) {
            b2[i2] = ba[ba.length - i2 - 1];
        }
        return b2;
    }
}

