/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Binary2AsciiInputStream;
import COM.ibm.db2.jdbc.app.DB2Binary2UnicodeInputStream;
import COM.ibm.db2.jdbc.app.DB2Blob;
import COM.ibm.db2.jdbc.app.DB2CharReader;
import COM.ibm.db2.jdbc.app.DB2Clob;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2InputStream;
import COM.ibm.db2.jdbc.app.DB2PreparedStatement;
import COM.ibm.db2.jdbc.app.DB2ResultSetMetaData;
import COM.ibm.db2.jdbc.app.DB2ResultSetMetaDataTrace;
import COM.ibm.db2.jdbc.app.DB2ScrollableResultSet;
import COM.ibm.db2.jdbc.app.DB2Statement;
import COM.ibm.db2.jdbc.app.DB2UnicodeStream;
import COM.ibm.db2.jdbc.app.SQLExceptionGenerator;
import com.ibm.db2.jcc.SQLJResultSet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class DB2ResultSet
implements ResultSet,
SQLJResultSet {
    private Hashtable name2Index;
    private DB2ResultSetMetaData rsMetaData;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected SQLExceptionGenerator sqlExcptGen;
    protected int numCols = 0;
    protected boolean mappedRS = false;
    protected boolean nullTag = true;
    protected boolean closed = false;
    protected Vector isList = new Vector();
    protected int currentRowId = 0;
    protected boolean isSQLJSelectInto = false;
    private int year = 0;
    private int month = 0;
    private int date = 0;
    private int hour = 0;
    private int minute = 0;
    private int second = 0;
    private int nano = 0;
    private int sqlSuccess = 0;
    protected int[] colTypes = null;
    protected int[] colSizes = null;
    protected String[] mappedColumnNames = null;
    protected int returnCode = 0;
    protected int returnLen = 0;
    protected int fetchDirection = 1000;
    protected int fetchSize = 0;
    protected int rsType = 1003;
    protected int rsConcur = 1007;
    protected int maxRows = 0;

    protected native int SQLGetColumnCount(int var1);

    protected native int SQLSetPos(int var1, int var2, int var3, int var4);

    protected native int SQLFetchScroll(int var1, int var2, int var3, int var4);

    protected native int SQLFetch(int var1);

    protected native int SQLFreeStmtClose(int var1);

    protected native String SQLGetCursorName(int var1, int var2);

    protected native int SQLGetDateData(int var1, int var2);

    protected native double SQLGetDoubleData(int var1, int var2);

    protected native int SQLGetIntegerData(int var1, int var2);

    protected native long SQLGetLongData(int var1, int var2);

    protected native int SQLGetLocator(int var1, int var2, Integer var3, int var4);

    protected native byte[] SQLGetLongBinaryData(int var1, int var2, int var3, int var4, int var5);

    protected native byte[] SQLGetLongCharData(int var1, int var2, int var3);

    protected native String SQLGetNumericStringData(int var1, int var2);

    protected native int SQLGetSmallIntData(int var1, int var2);

    protected native String SQLGetStringData(int var1, int var2, int var3, int var4, int var5);

    protected native int SQLGetTimeData(int var1, int var2);

    protected native int SQLGetTimestampData(int var1, int var2);

    protected native int SQLGetType(int var1, int var2, int var3);

    protected native byte[] SQLGetRowDataInternal(int var1);

    public String toString() {
        return this.toString("", true);
    }

    protected String toString(String ident, boolean displayStmtObj) {
        StringBuffer sb2 = new StringBuffer("\r\n" + ident + "DB2ResultSet \r\n" + ident + "{");
        if (displayStmtObj) {
            if (this.statement != null) {
                sb2.append(this.statement.toString(ident + "    Statement -> ", false) + "\r\n");
            } else {
                sb2.append(ident + "    Statement -> null\r\n    ");
            }
        } else {
            sb2.append("\r\n");
        }
        sb2.append(ident + "    numCols = " + this.numCols + "\r\n");
        sb2.append(ident + "    mappedRS = " + this.mappedRS + "\r\n");
        sb2.append(ident + "    nullTag = " + this.nullTag + "\r\n");
        sb2.append(ident + "    closed = " + this.closed + "\r\n");
        sb2.append(ident + "    maxFieldSize = " + this.statement.maxFieldSize + "\r\n");
        sb2.append(ident + "    returnCode = " + this.returnCode + "\r\n");
        sb2.append(ident + "    returnLen = " + this.returnLen + "\r\n");
        for (int i2 = 0; i2 < this.numCols; ++i2) {
            sb2.append(ident + "    colTypes[" + i2 + "] = " + this.colTypes[i2] + "\r\n");
            sb2.append(ident + "    colSizes[" + i2 + "] = " + this.colSizes[i2] + "\r\n");
        }
        sb2.append(ident + "}\r\n");
        return sb2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DB2ResultSet(DB2Statement stmt, int nCols) throws SQLException {
        int rc2 = this.sqlSuccess;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2ResultSet( stmt, nCols=" + nCols + ")");
            }
            this.statement = stmt;
            this.connection = this.statement.getDB2Connection();
            this.fetchSize = this.statement.fetchSize;
            this.fetchDirection = this.statement.fetchDirection;
            this.sqlExcptGen = stmt.sqlExcptGen;
            if (this.statement instanceof DB2PreparedStatement && ((DB2PreparedStatement)this.statement).statementType == 27 && ((DB2PreparedStatement)this.statement).CLIStatementType == 40) {
                this.isSQLJSelectInto = true;
            }
            if (this instanceof DB2ScrollableResultSet && this.statement.sql != null && this.statement.getStatementType(this.statement.sql) == 24 && this.statement.rowCount == -1 && (rc2 = this.SQLFetch(this.statement.statementHandle)) != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, rc2);
            }
            this.numCols = this.getColCount();
            this.nullTag = true;
            this.closed = false;
            this.mappedRS = false;
            this.rsMetaData = null;
            this.name2Index = null;
            this.colTypes = new int[this.numCols];
            this.colSizes = new int[this.numCols];
            for (int i2 = 0; i2 < this.numCols; ++i2) {
                this.colTypes[i2] = 0;
                this.colSizes[i2] = 0;
            }
            Object var6_5 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "numCols", this.numCols);
            DB2Trace.methodExit(this, "DB2ResultSet()");
            throw throwable;
        }
        DB2Trace.data(10, "numCols", this.numCols);
        DB2Trace.methodExit(this, "DB2ResultSet()");
    }

    public DB2ResultSet(DB2Statement stmt, int nCols, int mappedCols) throws SQLException {
        this(stmt, nCols);
        this.numCols = mappedCols;
    }

    public DB2ResultSet(DB2Statement stmt, int nCols, int mappedCols, String[] mappedColNames) throws SQLException {
        this(stmt, nCols);
        this.mappedColumnNames = mappedColNames;
        this.numCols = mappedCols;
    }

    protected void addIsList(DB2InputStream is) {
        if (null != is) {
            this.isList.addElement(is);
        }
    }

    protected void clearIsList() throws SQLException {
        if (!this.isList.isEmpty()) {
            Enumeration e2 = this.isList.elements();
            while (e2.hasMoreElements()) {
                DB2InputStream is = (DB2InputStream)e2.nextElement();
                is.close();
            }
            this.isList.removeAllElements();
        }
    }

    protected void checkHandlesAndIndex(int column) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (column != Integer.MAX_VALUE && (column < 1 || column > this.numCols)) {
            this.sqlExcptGen.throwColumnIndexError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getColType(int column, boolean getLen) throws SQLException {
        int sqlType = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getColType( " + column + ", " + getLen + " ) ");
            }
            if (this.colTypes != null) {
                sqlType = this.colTypes[column - 1];
            }
            if (sqlType == 0) {
                int doGetLen = 0;
                if (getLen) {
                    doGetLen = 1;
                }
                this.returnCode = this.sqlSuccess;
                this.returnLen = 0;
                sqlType = this.SQLGetType(column, doGetLen, this.statement.statementHandle);
                if (this.returnCode != this.sqlSuccess) {
                    this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "sqlType", sqlType);
                }
                if (sqlType == -450) {
                    if (this.rsMetaData == null) {
                        this.rsMetaData = this.getMetaData2();
                    }
                    if (this.rsMetaData.colBaseTypesNotAdjusted == null || this.rsMetaData.colBaseTypesNotAdjusted[column - 1] == -99999) {
                        this.rsMetaData.getColumnType(column);
                    }
                    sqlType = this.rsMetaData.colBaseTypesNotAdjusted[column - 1];
                }
                switch (sqlType) {
                    case -97: 
                    case -10: {
                        sqlType = -1;
                        break;
                    }
                    case -95: 
                    case -8: {
                        sqlType = 1;
                        break;
                    }
                    case -96: 
                    case -9: {
                        sqlType = 12;
                        break;
                    }
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "sqlType", sqlType);
                    DB2Trace.data(20, "returnLen", this.returnLen);
                }
                this.colTypes[column - 1] = sqlType;
                this.colSizes[column - 1] = this.returnLen;
            }
            int n2 = sqlType;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getColType()", sqlType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "isClosed()");
            }
            boolean bl2 = this.closed;
            return bl2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "isClosed()", this.closed);
            }
        }
    }

    protected void setClosed(boolean value) {
        this.closed = value;
    }

    public boolean next() throws SQLException {
        boolean retValue;
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        this.clearIsList();
        this.clearWarnings();
        int rc2 = this.SQLFetch(this.statement.statementHandle);
        if (rc2 != 100) {
            if (rc2 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, rc2);
            }
            this.closed = false;
            retValue = true;
            ++this.currentRowId;
        } else {
            retValue = false;
            this.currentRowId = 0;
        }
        return retValue;
    }

    public boolean wasNull() throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        return this.nullTag;
    }

    public String getString(int column) throws SQLException {
        this.checkHandlesAndIndex(column);
        return this.getString2(column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getString2(int column) throws SQLException {
        String retStr;
        if (this.colTypes[column - 1] == 0) {
            this.getColType(column, true);
        }
        this.returnCode = this.sqlSuccess;
        this.returnLen = 1;
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            retStr = this.SQLGetStringData(column, this.colTypes[column - 1], this.colSizes[column - 1], this.statement.statementHandle, this.connection.connectionHandle);
        }
        if (this.returnCode == 100) {
            this.nullTag = true;
            return null;
        }
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 == this.returnLen) {
            this.nullTag = true;
            return null;
        }
        if (this.returnLen == 0) {
            retStr = "";
        } else if (this.colTypes[column - 1] == -400) {
            StringTokenizer tokenizer = new StringTokenizer(retStr, ",");
            String urlLenStr = tokenizer.nextToken();
            urlLenStr = tokenizer.nextToken();
            urlLenStr = tokenizer.nextToken();
            int urlLen = Integer.parseInt(urlLenStr);
            int urlPos = retStr.lastIndexOf(44) + 1;
            retStr = retStr.substring(urlPos, urlPos + urlLen);
        }
        this.nullTag = false;
        if (0 == this.statement.maxFieldSize || retStr.length() <= this.statement.maxFieldSize || this.colTypes[column - 1] != 1 && this.colTypes[column - 1] != 12 && this.colTypes[column - 1] != -1 && this.colTypes[column - 1] != -2 && this.colTypes[column - 1] != -3 && this.colTypes[column - 1] != -4 && this.colTypes[column - 1] != -95 && this.colTypes[column - 1] != -96 && this.colTypes[column - 1] != -97) {
            return retStr;
        }
        return retStr.substring(0, this.statement.maxFieldSize);
    }

    public boolean getBoolean(int column) throws SQLException {
        this.checkHandlesAndIndex(column);
        return this.getBoolean2(column);
    }

    protected boolean getBoolean2(int column) throws SQLException {
        short r2;
        String strVal;
        boolean retVal = false;
        if (this.colTypes[column - 1] == 0) {
            this.getColType(column, false);
        }
        retVal = this.colTypes[column - 1] == 1 || this.colTypes[column - 1] == 12 || this.colTypes[column - 1] == -1 || this.colTypes[column - 1] == -99 ? ((strVal = this.getString(column)) == null ? false : ((strVal = strVal.trim()).equals("1") ? true : new Boolean(strVal))) : (r2 = this.getShort2(column)) != 0;
        return retVal;
    }

    public byte getByte(int column) throws SQLException {
        this.checkHandlesAndIndex(column);
        return this.getByte2(column);
    }

    protected byte getByte2(int column) throws SQLException {
        return (byte)this.getShort2(column);
    }

    public short getShort(int column) throws SQLException {
        this.checkHandlesAndIndex(column);
        return this.getShort2(column);
    }

    protected short getShort2(int column) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        int retSmallInt = this.SQLGetSmallIntData(column, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 == this.returnLen) {
            this.nullTag = true;
        }
        return (short)retSmallInt;
    }

    public int getInt(int column) throws SQLException {
        this.checkHandlesAndIndex(column);
        return this.getInt2(column);
    }

    protected int getInt2(int column) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        int retInteger = this.SQLGetIntegerData(column, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 == this.returnLen) {
            this.nullTag = true;
        }
        return retInteger;
    }

    public long getLong(int column) throws SQLException {
        this.checkHandlesAndIndex(column);
        return this.getLong2(column);
    }

    protected long getLong2(int column) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        long retLong = this.SQLGetLongData(column, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 == this.returnLen) {
            this.nullTag = true;
        }
        return retLong;
    }

    public float getFloat(int column) throws SQLException {
        this.checkHandlesAndIndex(column);
        return this.getFloat2(column);
    }

    protected float getFloat2(int column) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        double dValue = this.SQLGetDoubleData(column, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 == this.returnLen) {
            this.nullTag = true;
        }
        float retFloat = (float)dValue;
        if (Math.abs(dValue) != Double.POSITIVE_INFINITY && Math.abs(retFloat) == Float.POSITIVE_INFINITY) {
            this.statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
        }
        return retFloat;
    }

    public double getDouble(int column) throws SQLException {
        this.checkHandlesAndIndex(column);
        return this.getDouble2(column);
    }

    protected double getDouble2(int column) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        double retDouble = this.SQLGetDoubleData(column, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 == this.returnLen) {
            this.nullTag = true;
        }
        return retDouble;
    }

    protected static String cvtScientific(String s2) throws NumberFormatException {
        char c2;
        int i2;
        if (null == s2) {
            return s2;
        }
        int len = s2.length();
        if (0 == len) {
            return s2;
        }
        int iFirstChar = -1;
        int iDecimal = -1;
        int iExp = -1;
        int iLastChar = -1;
        for (i2 = 0; i2 < len; ++i2) {
            c2 = s2.charAt(i2);
            if (iFirstChar < 0) {
                if (Character.isWhitespace(c2)) continue;
                iFirstChar = iLastChar = i2;
                if ('.' != c2 && ',' != c2) continue;
                iDecimal = i2;
                continue;
            }
            if (iDecimal < 0 && iExp < 0 && (',' == c2 || '.' == c2)) {
                iDecimal = iLastChar = i2;
                continue;
            }
            if (iExp < 0 && ('e' == c2 || 'E' == c2)) {
                iExp = iLastChar = i2;
                continue;
            }
            if (Character.isWhitespace(c2)) continue;
            iLastChar = i2;
        }
        if (iFirstChar < 0) {
            return "";
        }
        if (iExp < 0) {
            if (iFirstChar > 0 || iLastChar < len - 1) {
                s2 = s2.substring(iFirstChar, iLastChar + 1);
            }
            if (iDecimal >= 0 && s2.charAt(iDecimal) == ',') {
                s2 = s2.replace(',', '.');
            }
        } else {
            int sign = 1;
            int exp = 0;
            i2 = iExp + 1;
            c2 = s2.charAt(i2);
            if ('-' == c2) {
                sign = -1;
                ++i2;
            } else if ('+' == c2) {
                ++i2;
            }
            while (i2 <= iLastChar) {
                if (!Character.isDigit(c2 = s2.charAt(i2++))) {
                    throw new NumberFormatException();
                }
                exp = exp * 10 + Character.digit(c2, 10);
            }
            exp *= sign;
            if (iDecimal >= 0) {
                exp -= iExp - iDecimal - 1;
            }
            if ('-' == (c2 = s2.charAt(iFirstChar))) {
                sign = -1;
                ++iFirstChar;
            } else if ('+' == c2) {
                sign = 1;
                ++iFirstChar;
            } else {
                sign = 1;
            }
            int numDigits = iExp - iFirstChar - (iDecimal >= 0 ? 1 : 0);
            int digitPos = 0;
            int decimalPos = -1;
            int bufferSize = 0;
            if (exp >= 0) {
                decimalPos = -1;
                digitPos = 0;
                bufferSize = numDigits + exp;
            } else if (exp < 0 && -exp >= numDigits) {
                decimalPos = 0;
                digitPos = -exp - numDigits + 1;
                bufferSize = digitPos + numDigits;
            } else {
                decimalPos = numDigits + exp;
                digitPos = 0;
                bufferSize = numDigits + 1;
            }
            if (sign < 0) {
                if (decimalPos >= 0) {
                    ++decimalPos;
                }
                ++digitPos;
                ++bufferSize;
            }
            char[] buffer = new char[bufferSize];
            for (i2 = 0; i2 < bufferSize; ++i2) {
                buffer[i2] = 48;
            }
            if (sign < 0) {
                buffer[0] = 45;
            }
            if (decimalPos >= 0) {
                buffer[decimalPos] = 46;
            }
            i2 = digitPos;
            for (int j2 = iFirstChar; j2 < iExp && (j2 != iDecimal || ++j2 < iExp); ++j2) {
                if (i2 == decimalPos) {
                    ++i2;
                }
                buffer[i2] = s2.charAt(j2);
                ++i2;
            }
            s2 = new String(buffer);
        }
        return s2;
    }

    public BigDecimal getBigDecimal(int column, int scale) throws SQLException {
        this.checkHandlesAndIndex(column);
        return this.getBigDecimal2(column, scale);
    }

    protected BigDecimal getBigDecimal2(int columnIndex, int scale) throws SQLException {
        BigDecimal bd2 = this.getBigDecimal2(columnIndex);
        if (bd2 == null || scale == -1) {
            return bd2;
        }
        return bd2.setScale(scale, 4);
    }

    public BigDecimal getBigDecimal(int column) throws SQLException {
        this.checkHandlesAndIndex(column);
        return this.getBigDecimal2(column);
    }

    protected BigDecimal getBigDecimal2(int column) throws SQLException {
        int colType = this.getColType(column, false);
        if (-2 == colType || -3 == colType || -4 == colType || 91 == colType || 92 == colType || 93 == colType) {
            this.sqlExcptGen.rsException("07006");
        }
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        String retStr = this.SQLGetNumericStringData(column, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess && this.returnCode != 100) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 != this.returnLen) {
            this.nullTag = false;
            BigDecimal retNum = null;
            try {
                retStr = DB2ResultSet.cvtScientific(retStr);
                retNum = new BigDecimal(retStr);
            }
            catch (NumberFormatException e2) {
                this.sqlExcptGen.rsException("22005");
            }
            return retNum;
        }
        this.nullTag = true;
        return null;
    }

    public byte[] getBytes(int column) throws SQLException {
        this.checkHandlesAndIndex(column);
        return this.getBytes2(column);
    }

    protected byte[] getBytes2(int column) throws SQLException {
        if (this.colTypes[column - 1] == 0) {
            this.getColType(column, true);
        }
        this.returnCode = this.sqlSuccess;
        this.returnLen = 0;
        byte[] b2 = this.SQLGetLongBinaryData(column, this.colTypes[column - 1], this.colSizes[column - 1], this.statement.statementHandle, this.connection.connectionHandle);
        if (this.returnCode == 100) {
            this.nullTag = true;
            return null;
        }
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 == this.returnLen) {
            this.nullTag = true;
            return null;
        }
        this.nullTag = false;
        if (0 == this.statement.maxFieldSize || b2.length <= this.statement.maxFieldSize || this.colTypes[column - 1] != 1 && this.colTypes[column - 1] != 12 && this.colTypes[column - 1] != -1 && this.colTypes[column - 1] != -2 && this.colTypes[column - 1] != -3 && this.colTypes[column - 1] != -4 && this.colTypes[column - 1] != -95 && this.colTypes[column - 1] != -96 && this.colTypes[column - 1] != -97) {
            return b2;
        }
        byte[] retBuf = new byte[this.statement.maxFieldSize];
        System.arraycopy(b2, 0, retBuf, 0, this.statement.maxFieldSize);
        return retBuf;
    }

    public Date getDate(int column) throws SQLException {
        return this.getDate2(column, new GregorianCalendar());
    }

    protected Date getDate2(int column) throws SQLException {
        return this.getDate2(column, new GregorianCalendar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date getDate2(int column, Calendar cal) throws SQLException {
        Date date;
        block8: {
            Date retDate = null;
            this.nullTag = true;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "getDate2(" + column + ", calTimeZone=" + cal.getTimeZone().getID() + ")");
                }
                this.checkHandlesAndIndex(column);
                this.returnCode = this.sqlSuccess;
                this.returnLen = this.sqlSuccess;
                this.year = this.SQLGetDateData(column, this.statement.statementHandle);
                if (this.returnCode != this.sqlSuccess) {
                    this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
                }
                if (-1 != this.returnLen) {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "Year from DB", this.year);
                        DB2Trace.data(10, "Month from DB (1 less)", this.month);
                        DB2Trace.data(10, "Date from DB", this.date);
                    }
                    cal = (Calendar)cal.clone();
                    cal.set(this.year + 1900, this.month, this.date, 0, 0, 0);
                    cal.set(14, 0);
                    retDate = new Date(cal.getTime().getTime());
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "Date", retDate.toString());
                    }
                    this.nullTag = false;
                } else {
                    this.nullTag = true;
                }
                date = retDate;
                Object var6_5 = null;
                if (!DB2Trace.TraceOn) break block8;
                DB2Trace.methodExit((Object)this, "getDate2()", retDate == null ? "NULL" : retDate.toString());
            }
            catch (Throwable throwable) {
                block9: {
                    Object var6_6 = null;
                    if (!DB2Trace.TraceOn) break block9;
                    DB2Trace.methodExit((Object)this, "getDate2()", retDate == null ? "NULL" : retDate.toString());
                }
                throw throwable;
            }
        }
        return date;
    }

    public Time getTime(int column) throws SQLException {
        return this.getTime2(column, new GregorianCalendar());
    }

    protected Time getTime2(int column) throws SQLException {
        return this.getTime2(column, new GregorianCalendar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Time getTime2(int column, Calendar cal) throws SQLException {
        Time time;
        block8: {
            Time retTime = null;
            this.nullTag = true;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "getTime2(" + column + ", calTimeZone=" + cal.getTimeZone().getID() + ")");
                }
                this.checkHandlesAndIndex(column);
                this.returnCode = this.sqlSuccess;
                this.returnLen = this.sqlSuccess;
                this.hour = this.SQLGetTimeData(column, this.statement.statementHandle);
                if (this.returnCode != this.sqlSuccess) {
                    this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
                }
                if (-1 != this.returnLen) {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "Hour", this.hour);
                        DB2Trace.data(10, "Minute", this.minute);
                        DB2Trace.data(10, "Second", this.second);
                    }
                    cal = (Calendar)cal.clone();
                    cal.set(1970, 0, 1, this.hour, this.minute, this.second);
                    cal.set(14, 0);
                    retTime = new Time(cal.getTime().getTime());
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "Time", retTime.toString());
                    }
                    this.nullTag = false;
                } else {
                    this.nullTag = true;
                }
                time = retTime;
                Object var6_5 = null;
                if (!DB2Trace.TraceOn) break block8;
                DB2Trace.methodExit((Object)this, "getTime2()", retTime == null ? "NULL" : retTime.toString());
            }
            catch (Throwable throwable) {
                block9: {
                    Object var6_6 = null;
                    if (!DB2Trace.TraceOn) break block9;
                    DB2Trace.methodExit((Object)this, "getTime2()", retTime == null ? "NULL" : retTime.toString());
                }
                throw throwable;
            }
        }
        return time;
    }

    public Timestamp getTimestamp(int column) throws SQLException {
        return this.getTimestamp2(column, new GregorianCalendar());
    }

    protected Timestamp getTimestamp2(int column) throws SQLException {
        return this.getTimestamp2(column, new GregorianCalendar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Timestamp getTimestamp2(int column, Calendar cal) throws SQLException {
        Timestamp timestamp;
        block9: {
            Timestamp retTimestamp = null;
            this.nullTag = true;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "getTimestamp2(" + column + ", calTimeZone=" + cal.getTimeZone().getID() + ")");
                }
                this.checkHandlesAndIndex(column);
                int colType = this.getColType(column, false);
                if (92 == colType) {
                    this.sqlExcptGen.rsException("07006");
                }
                this.returnCode = this.sqlSuccess;
                this.returnLen = this.sqlSuccess;
                this.year = this.SQLGetTimestampData(column, this.statement.statementHandle);
                if (this.returnCode != this.sqlSuccess) {
                    this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
                }
                if (-1 != this.returnLen) {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "Year", this.year);
                        DB2Trace.data(10, "Month", this.month);
                        DB2Trace.data(10, "Date", this.date);
                        DB2Trace.data(10, "Hour", this.hour);
                        DB2Trace.data(10, "Minute", this.minute);
                        DB2Trace.data(10, "Second", this.second);
                        DB2Trace.data(10, "Nano", this.nano);
                    }
                    cal = (Calendar)cal.clone();
                    cal.set(this.year + 1900, this.month, this.date, this.hour, this.minute, this.second);
                    cal.set(14, 0);
                    retTimestamp = new Timestamp(cal.getTime().getTime());
                    retTimestamp.setNanos(this.nano);
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "Timestamp", retTimestamp.toString());
                    }
                    this.nullTag = false;
                } else {
                    this.nullTag = true;
                }
                timestamp = retTimestamp;
                Object var7_6 = null;
                if (!DB2Trace.TraceOn) break block9;
                DB2Trace.methodExit((Object)this, "getTimestamp2()", retTimestamp == null ? "NULL" : retTimestamp.toString());
            }
            catch (Throwable throwable) {
                block10: {
                    Object var7_7 = null;
                    if (!DB2Trace.TraceOn) break block10;
                    DB2Trace.methodExit((Object)this, "getTimestamp2()", retTimestamp == null ? "NULL" : retTimestamp.toString());
                }
                throw throwable;
            }
        }
        return timestamp;
    }

    protected byte[] getAsciiString(int column) throws SQLException {
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        byte[] b2 = this.SQLGetLongCharData(column, this.statement.statementHandle, this.connection.connectionHandle);
        if (this.returnCode != this.sqlSuccess && this.returnCode != 100) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 == this.returnLen) {
            this.nullTag = true;
            return null;
        }
        this.nullTag = false;
        if (0 == this.statement.maxFieldSize || b2.length <= this.statement.maxFieldSize || this.colTypes[column - 1] != 1 && this.colTypes[column - 1] != 12 && this.colTypes[column - 1] != -1 && this.colTypes[column - 1] != -2 && this.colTypes[column - 1] != -3 && this.colTypes[column - 1] != -4 && this.colTypes[column - 1] != -95 && this.colTypes[column - 1] != -96 && this.colTypes[column - 1] != -97) {
            return b2;
        }
        byte[] retBuf = new byte[this.statement.maxFieldSize];
        System.arraycopy(b2, 0, retBuf, 0, this.statement.maxFieldSize);
        return retBuf;
    }

    public InputStream getAsciiStream(int column) throws SQLException {
        this.checkHandlesAndIndex(column);
        if (this.connection.materializeLobData || this.isSQLJSelectInto) {
            byte[] tempBytes = this.getAsciiString(column);
            if (tempBytes != null) {
                return new ByteArrayInputStream(tempBytes);
            }
            return null;
        }
        return this.getAsciiStream2(column);
    }

    protected InputStream getAsciiStream2(int column) throws SQLException {
        int lobType = 41;
        int colType = this.getColType(column, true);
        if (-99 == colType || -98 == colType || -350 == colType) {
            switch (colType) {
                case -99: {
                    lobType = 41;
                    break;
                }
                case -98: {
                    lobType = 31;
                    break;
                }
                case -350: {
                    lobType = -351;
                }
            }
            Integer intRC = new Integer(this.sqlSuccess);
            int locator = this.SQLGetLocator(column, lobType, intRC, this.statement.statementHandle);
            int rc2 = intRC;
            if (rc2 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, rc2);
            }
            if (-1 != this.returnLen) {
                this.nullTag = false;
                if (31 != lobType) {
                    DB2InputStream is = new DB2InputStream(this.statement, locator, lobType);
                    this.addIsList(is);
                    return is;
                }
                DB2Binary2AsciiInputStream is = new DB2Binary2AsciiInputStream(this.statement, locator, lobType);
                this.addIsList(is);
                return is;
            }
            this.nullTag = true;
            return null;
        }
        byte[] data = this.getAsciiString(column);
        if (data != null) {
            this.nullTag = false;
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            return bais;
        }
        this.nullTag = true;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getUniString(int column) throws SQLException {
        String str = null;
        if (this.colTypes[column - 1] == 0) {
            this.getColType(column, true);
        }
        this.returnCode = this.sqlSuccess;
        this.returnLen = 1;
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            str = this.SQLGetStringData(column, this.colTypes[column - 1], this.colSizes[column - 1], this.statement.statementHandle, this.connection.connectionHandle);
        }
        if (this.returnCode != this.sqlSuccess && this.returnCode != 100) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (-1 == this.returnLen || this.returnCode == 100) {
            this.nullTag = true;
            return null;
        }
        if (this.returnLen == 0) {
            str = "";
        }
        this.nullTag = false;
        byte[] b2 = null;
        try {
            b2 = 0 == this.statement.maxFieldSize || str.length() <= this.statement.maxFieldSize ? str.getBytes("UTF8") : str.substring(0, this.statement.maxFieldSize).getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e2) {
            // empty catch block
        }
        return b2;
    }

    public InputStream getUnicodeStream(int column) throws SQLException {
        this.checkHandlesAndIndex(column);
        return this.getUnicodeStream2(column);
    }

    protected InputStream getUnicodeStream2(int column) throws SQLException {
        int lobType = 41;
        int colType = this.getColType(column, true);
        if (-99 == colType || -98 == colType || -350 == colType) {
            switch (colType) {
                case -99: {
                    lobType = 41;
                    break;
                }
                case -98: {
                    lobType = 31;
                    break;
                }
                case -350: {
                    lobType = -351;
                }
            }
            Integer intRC = new Integer(this.sqlSuccess);
            int locator = this.SQLGetLocator(column, lobType, intRC, this.statement.statementHandle);
            int rc2 = intRC;
            if (rc2 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, rc2);
            }
            if (-1 != this.returnLen) {
                this.nullTag = false;
                DB2InputStream is = null;
                switch (lobType) {
                    case -351: 
                    case 41: {
                        is = new DB2UnicodeStream(this.statement, locator, lobType);
                        break;
                    }
                    case 31: {
                        is = new DB2Binary2UnicodeInputStream(this.statement, locator, lobType);
                    }
                }
                this.addIsList(is);
                return is;
            }
            this.nullTag = true;
            return null;
        }
        byte[] data = this.getUniString(column);
        if (null == data) {
            return null;
        }
        return new ByteArrayInputStream(data);
    }

    public InputStream getBinaryStream(int column) throws SQLException {
        this.checkHandlesAndIndex(column);
        return this.getBinaryStream2(column);
    }

    protected InputStream getBinaryStream2(int column) throws SQLException {
        int lobType = 41;
        int colType = this.getColType(column, true);
        if (!(colType != -99 && colType != -98 && colType != -350 || this.isSQLJSelectInto)) {
            switch (colType) {
                case -99: {
                    lobType = 41;
                    break;
                }
                case -98: {
                    lobType = 31;
                    break;
                }
                case -350: {
                    lobType = -351;
                }
            }
            Integer intRC = new Integer(this.sqlSuccess);
            int locator = this.SQLGetLocator(column, lobType, intRC, this.statement.statementHandle);
            int rc2 = intRC;
            if (rc2 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, rc2);
            }
            if (this.returnLen != -1) {
                this.nullTag = false;
                DB2InputStream is = new DB2InputStream(this.statement, locator, lobType);
                this.addIsList(is);
                return is;
            }
            this.nullTag = true;
            return null;
        }
        byte[] data = this.getBytes(column);
        if (null == data) {
            return null;
        }
        return new ByteArrayInputStream(data);
    }

    public void close() throws SQLException {
        if (!this.closed && this.statement != null && !this.statement.closed) {
            this.statement.getMoreResults();
            if (this.statement.moreResults) {
                this.statement.prefetchedMoreResults = true;
                this.closed = true;
            } else if (this.connection != null && !this.connection.SPConnected) {
                this.realClose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void realClose() throws SQLException {
        block23: {
            block22: {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "realClose()");
                }
                this.closed = true;
                if (null != this.statement) break block22;
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(5, "statement is null");
                }
                if (!DB2Trace.TraceOn) return;
                DB2Trace.methodExit(this, "realClose()");
                return;
            }
            DB2Statement dB2Statement = this.statement;
            // MONITORENTER : dB2Statement
            if (!this.statement.closed) break block23;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "statement is closed");
            }
            // MONITOREXIT : dB2Statement
            if (!DB2Trace.TraceOn) return;
            DB2Trace.methodExit(this, "realClose()");
            return;
        }
        if (this.connection == null) {
            if (DB2Trace.TraceOn) {
                DB2Trace.data(20, "connection is null");
            }
            // MONITOREXIT : dB2Statement
            if (!DB2Trace.TraceOn) return;
            DB2Trace.methodExit(this, "realClose()");
            return;
        }
        DB2Connection dB2Connection = this.connection;
        // MONITORENTER : dB2Connection
        if (this.connection.closed) {
            if (DB2Trace.TraceOn) {
                DB2Trace.data(25, "connection is closed");
            }
            // MONITOREXIT : dB2Connection
            // MONITOREXIT : dB2Statement
            if (!DB2Trace.TraceOn) return;
            DB2Trace.methodExit(this, "realClose()");
            return;
        }
        try {
            this.clearIsList();
            int retInteger = this.SQLFreeStmtClose(this.statement.statementHandle);
            if (retInteger != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, retInteger);
            }
            this.statement.prefetchedMoreResults = false;
            // MONITOREXIT : dB2Connection
            // MONITOREXIT : dB2Statement
            if (!this.statement.internalStmt) return;
            this.statement.close2(true);
            return;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "realClose()");
            }
        }
    }

    public String getString(String columnName) throws SQLException {
        return this.getString2(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean2(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte2(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort2(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt2(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong2(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat2(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble2(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal2(this.findColumn(columnName), scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes2(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream2(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream2(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream2(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        return this.statement.warnings;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        this.statement.warnings = null;
    }

    protected void addWarning(SQLWarning warning) {
        this.statement.addWarning(warning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCursorName() throws SQLException {
        String retCursorName;
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            retCursorName = this.SQLGetCursorName(this.statement.statementHandle, this.connection.connectionHandle);
        }
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        return retCursorName;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        if (this.rsMetaData != null) {
            return this.rsMetaData;
        }
        return this.getMetaData2();
    }

    public DB2ResultSetMetaData getMetaData2() throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        this.rsMetaData = DB2Trace.TraceOn ? new DB2ResultSetMetaDataTrace(this.statement, this, this.numCols, this.mappedRS) : new DB2ResultSetMetaData(this.statement, this, this.numCols, this.mappedRS);
        return this.rsMetaData;
    }

    protected Object getObject(int columnIndex, int targetSqlType, int scale) throws SQLException {
        Object obj = null;
        switch (targetSqlType) {
            case -1: 
            case 1: 
            case 12: {
                obj = this.getString(columnIndex);
                break;
            }
            case 2: 
            case 3: {
                obj = this.getBigDecimal(columnIndex, scale);
                break;
            }
            case -7: {
                boolean b2 = this.getBoolean(columnIndex);
                if (this.wasNull()) break;
                obj = new Boolean(b2);
                break;
            }
            case -6: {
                short s2 = this.getShort(columnIndex);
                if (this.wasNull()) break;
                obj = new Integer(s2);
                break;
            }
            case 5: {
                short s3 = this.getShort(columnIndex);
                if (this.wasNull()) break;
                obj = new Integer(s3);
                break;
            }
            case 4: {
                int i2 = this.getInt(columnIndex);
                if (this.wasNull()) break;
                obj = new Integer(i2);
                break;
            }
            case -5: {
                long l2 = this.getLong(columnIndex);
                if (this.wasNull()) break;
                obj = new Long(l2);
                break;
            }
            case 7: {
                float f2 = this.getFloat(columnIndex);
                if (this.wasNull()) break;
                obj = new Float(f2);
                break;
            }
            case 6: 
            case 8: {
                double d2 = this.getDouble(columnIndex);
                if (this.wasNull()) break;
                obj = new Double(d2);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                obj = this.getBytes(columnIndex);
                break;
            }
            case 91: {
                obj = this.getDate(columnIndex);
                break;
            }
            case 92: {
                obj = this.getTime(columnIndex);
                break;
            }
            case 93: {
                obj = this.getTimestamp(columnIndex);
                break;
            }
            case -98: {
                obj = this.getBlob(columnIndex);
                break;
            }
            case -350: 
            case -99: {
                obj = this.getClob(columnIndex);
                break;
            }
            case -400: 
            case 70: {
                obj = this.getURL(columnIndex);
                break;
            }
            default: {
                this.sqlExcptGen.rsException("22005");
            }
        }
        return obj;
    }

    protected Object getObject(int columnIndex, int targetSqlType) throws SQLException {
        return this.getObject(columnIndex, targetSqlType, -1);
    }

    public Object getObject(int columnIndex) throws SQLException {
        this.checkHandlesAndIndex(columnIndex);
        int sqlType = this.getColType(columnIndex, true);
        return this.getObject(columnIndex, sqlType);
    }

    protected Object getObject(String columnName, int targetSqlType, int scale) throws SQLException {
        return this.getObject(this.findColumn(columnName), targetSqlType, scale);
    }

    protected Object getObject(String columnName, int targetSqlType) throws SQLException {
        return this.getObject(this.findColumn(columnName), targetSqlType);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public int findColumn(String columnName) throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        int rc2 = 0;
        int numOfColumns = 0;
        if (this.rsMetaData == null) {
            this.rsMetaData = this.getMetaData2();
        }
        columnName = columnName.toUpperCase(Locale.US);
        if (null == this.name2Index) {
            numOfColumns = this.statement.colCount4JSQL > 0 ? this.statement.colCount4JSQL : this.rsMetaData.getColumnCount();
            this.name2Index = new Hashtable((int)((double)numOfColumns / 0.75 + 0.7));
            for (int i2 = 1; i2 <= numOfColumns; ++i2) {
                String cName = this.statement.colCount4JSQL > 0 ? this.statement.colNames4JSQL[i2 - 1] : this.rsMetaData.getColumnName(i2);
                if (cName == null || this.name2Index.containsKey(cName = cName.toUpperCase(Locale.US))) continue;
                this.name2Index.put(cName, new Integer(i2));
                if (!cName.equals(columnName)) continue;
                rc2 = i2;
            }
        } else {
            Integer x2 = (Integer)this.name2Index.get(columnName);
            if (x2 != null) {
                return x2;
            }
        }
        if (rc2 == 0) {
            this.sqlExcptGen.rsException("S0022");
        }
        return rc2;
    }

    protected DB2Statement getStmt() {
        return this.statement;
    }

    protected int getMappedColumn(int column) throws SQLException {
        return column;
    }

    protected int getColCount() throws SQLException {
        int colCount = this.SQLGetColumnCount(this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (colCount == 0 && this.isSQLJSelectInto) {
            colCount = ((DB2PreparedStatement)this.statement).resultSetMetaData.getColumns();
        }
        return colCount;
    }

    protected void reset(int cols, int rows) throws SQLException {
        this.reset(cols);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset(int cols) throws SQLException {
        try {
            int i2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "reset( " + cols + ") ");
            }
            this.numCols = this.statement.moreResults ? this.getColCount() : 0;
            this.currentRowId = 0;
            this.nullTag = true;
            this.closed = false;
            this.mappedRS = false;
            this.name2Index = null;
            if (this.colTypes.length < this.numCols) {
                this.colTypes = new int[this.numCols];
                this.colSizes = new int[this.numCols];
            }
            for (i2 = 0; i2 < this.numCols; ++i2) {
                this.colTypes[i2] = 0;
                this.colSizes[i2] = 0;
            }
            if (this.rsMetaData != null) {
                this.rsMetaData.numberOfColumns = this.numCols;
                if (this.rsMetaData.colBaseTypesNotAdjusted != null) {
                    if (this.rsMetaData.colBaseTypesNotAdjusted.length < this.numCols) {
                        this.rsMetaData.colBaseTypesNotAdjusted = null;
                    } else {
                        for (i2 = 0; i2 < this.numCols; ++i2) {
                            this.rsMetaData.colBaseTypesNotAdjusted[i2] = -99999;
                        }
                    }
                }
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "reset()");
            }
        }
    }

    protected void resetRows(int rows) throws SQLException {
    }

    public synchronized byte[] getDB2RowData() throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        byte[] b2 = this.SQLGetRowDataInternal(this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess && this.returnCode != 100) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        return b2;
    }

    protected String getTraceHandle() {
        String handle = "??";
        if (this.statement != null) {
            handle = this.statement.getTraceHandle();
        }
        return handle;
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        int lobType;
        this.checkHandlesAndIndex(columnIndex);
        if (this.connection.materializeLobData || this.isSQLJSelectInto) {
            String tempStr = this.getString(columnIndex);
            if (tempStr != null) {
                return new StringReader(tempStr);
            }
            return null;
        }
        int sqltype = this.getColType(columnIndex, false);
        if (sqltype != -99 && sqltype != -350 && sqltype != -98) {
            String tempVal = this.getString(columnIndex);
            if (tempVal != null) {
                return new StringReader(tempVal);
            }
            return null;
        }
        if (sqltype == -99) {
            lobType = 41;
        } else {
            lobType = -351;
            if (sqltype == -98) {
                this.sqlExcptGen.rsException("22005");
            }
        }
        Integer intRC = new Integer(this.sqlSuccess);
        int locator = this.SQLGetLocator(columnIndex, lobType, intRC, this.statement.statementHandle);
        int rc2 = intRC;
        if (rc2 != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, rc2);
        }
        if (-1 == this.returnLen) {
            this.nullTag = true;
            return null;
        }
        this.nullTag = false;
        return new DB2CharReader(this.statement, lobType, locator);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public boolean isBeforeFirst() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean isAfterLast() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean isFirst() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean isLast() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public void beforeFirst() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
    }

    public void afterLast() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
    }

    public boolean first() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean last() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getRow()");
            }
            int n2 = this.currentRowId;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getRow()", this.currentRowId);
            }
        }
    }

    public boolean absolute(int row) throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean relative(int rows) throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean previous() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        this.statement.checkFetchDirection(this.rsType, direction);
        this.fetchDirection = direction;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkHandlesAndIndex(Integer.MAX_VALUE);
        this.statement.checkFetchSize(this.maxRows, rows);
        this.fetchSize = rows;
    }

    public int getFetchSize() throws SQLException {
        if (this.fetchSize > 0) {
            return this.fetchSize;
        }
        return 1;
    }

    public int getType() throws SQLException {
        return this.rsType;
    }

    public int getConcurrency() throws SQLException {
        return this.rsConcur;
    }

    public boolean rowUpdated() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
        return false;
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBoolean(int columnIndex, boolean x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateByte(int columnIndex, byte x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateShort(int columnIndex, short x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateInt(int columnIndex, int x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateLong(int columnIndex, long x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateFloat(int columnIndex, float x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateDouble(int columnIndex, double x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateString(int columnIndex, String x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBytes(int columnIndex, byte[] x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateDate(int columnIndex, Date x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateTime(int columnIndex, Time x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateTimestamp(int columnIndex, Timestamp x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateAsciiStream(int columnIndex, InputStream x2, int length) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBinaryStream(int columnIndex, InputStream x2, int length) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateCharacterStream(int columnIndex, Reader reader, int length) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateObject(int columnIndex, Object x2, int scale) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateObject(int columnIndex, Object x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateNull(String columnName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBoolean(String columnName, boolean x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateByte(String columnName, byte x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateShort(String columnName, short x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateInt(String columnName, int x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateLong(String columnName, long x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateFloat(String columnName, float x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateDouble(String columnName, double x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBigDecimal(String columnName, BigDecimal x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateString(String columnName, String x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBytes(String columnName, byte[] x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateDate(String columnName, Date x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateTime(String columnName, Time x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateTimestamp(String columnName, Timestamp x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateAsciiStream(String columnName, InputStream x2, int length) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBinaryStream(String columnName, InputStream x2, int length) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateObject(String columnName, Object x2, int scale) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateObject(String columnName, Object x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void insertRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void deleteRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void refreshRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void moveToInsertRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void moveToCurrentRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public Object getObject(int i2, Map map) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("GetObject with user-defined mapping");
        return null;
    }

    public Ref getRef(int i2) throws SQLException {
        return null;
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkHandlesAndIndex(columnIndex);
        int colType = this.getColType(columnIndex, false);
        if (-98 != colType) {
            this.sqlExcptGen.rsException("22005");
            return null;
        }
        if (this.isSQLJSelectInto) {
            byte[] b2 = this.getBytes(columnIndex);
            if (null == b2) {
                return null;
            }
            return new DB2Blob(b2);
        }
        int lobType = 31;
        lobType = 31;
        Integer intRC = new Integer(this.sqlSuccess);
        int locator = this.SQLGetLocator(columnIndex, lobType, intRC, this.statement.statementHandle);
        int rc2 = intRC;
        if (rc2 != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, rc2);
        }
        if (-1 != this.returnLen) {
            this.nullTag = false;
            return new DB2Blob(this.statement, locator, lobType);
        }
        this.nullTag = true;
        return null;
    }

    public Clob getClob(int columnIndex) throws SQLException {
        this.checkHandlesAndIndex(columnIndex);
        int colType = this.getColType(columnIndex, false);
        if (colType != -99 && colType != -350) {
            this.sqlExcptGen.rsException("22005");
            return null;
        }
        if (this.connection.materializeLobData || this.isSQLJSelectInto) {
            String tempStr = this.getString(columnIndex);
            if (tempStr != null) {
                return new DB2Clob(tempStr);
            }
            return null;
        }
        int lobType = 41;
        lobType = -99 == colType ? 41 : -351;
        Integer intRC = new Integer(this.sqlSuccess);
        int locator = this.SQLGetLocator(columnIndex, lobType, intRC, this.statement.statementHandle);
        int rc2 = intRC;
        if (rc2 != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, rc2);
        }
        if (-1 != this.returnLen) {
            this.nullTag = false;
            return new DB2Clob(this.statement, locator, lobType);
        }
        this.nullTag = true;
        return null;
    }

    public URL getURL(int columnIndex) throws SQLException {
        this.checkHandlesAndIndex(columnIndex);
        try {
            String urlString = this.getString(columnIndex);
            if (urlString == null) {
                return null;
            }
            return new URL(urlString);
        }
        catch (MalformedURLException mue) {
            throw new SQLException(mue.getMessage());
        }
    }

    public Array getArray(int i2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Array Type");
        return null;
    }

    public Object getObject(String colName, Map map) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("GetObject with user-defined mapping");
        return null;
    }

    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findColumn(colName));
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    public URL getURL(String colName) throws SQLException {
        return this.getURL(this.findColumn(colName));
    }

    public Array getArray(String colName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Array Type");
        return null;
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate2(columnIndex, cal);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate2(this.findColumn(columnName), cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime2(columnIndex, cal);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime2(this.findColumn(columnName), cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp2(columnIndex, cal);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp2(this.findColumn(columnName), cal);
    }

    public void cancelRowUpdates() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void positionServerToCurrentRow() {
    }

    public long getQueryInstanceIdentifier() {
        return ((DB2PreparedStatement)this.statement).queryInstanceIdentifier;
    }

    public void updateRef(int columnIndex, Ref x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("updateRef");
    }

    public void updateRef(String columnName, Ref x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("updateRef");
    }

    public void updateBlob(int columnIndex, Blob x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("updateBlob");
    }

    public void updateBlob(String columnName, Blob x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("updateBlob");
    }

    public void updateClob(int columnIndex, Clob x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("updateClob");
    }

    public void updateClob(String columnName, Clob x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("updateClob");
    }

    public void updateArray(int columnIndex, Array x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("updateArray");
    }

    public void updateArray(String columnName, Array x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("updateArray");
    }
}

