/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Blob;
import COM.ibm.db2.jdbc.app.DB2Clob;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2Constants;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2ResultSetMetaData;
import COM.ibm.db2.jdbc.app.DB2Statement;
import com.ibm.db2.jcc.SQLJColumnMetaData;
import com.ibm.db2.jcc.SQLJPackage;
import com.ibm.db2.jcc.SQLJPreparedStatement;
import com.ibm.db2.jcc.SQLJResultSet;
import com.ibm.db2.jcc.SQLJSection;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.Vector;

public class DB2PreparedStatement
extends DB2Statement
implements PreparedStatement,
SQLJPreparedStatement {
    protected short maxNumParams = 0;
    protected byte[] SQLJPID = null;
    protected long[] parameters = null;
    protected int[] direction = null;
    protected int[] sqltypes = null;
    protected long[] precisions = null;
    protected boolean[] sqltypeGuessed = null;
    protected int[] ctypes = null;
    protected int[] maxWholeDigits = null;
    protected int[] scales = null;
    protected boolean[] wasBound = null;
    protected short[] described = null;
    protected ParamElement[] paramRow = null;
    protected Vector paramSet = new Vector();
    protected static final int BUFLEN = 32699;
    protected boolean executed = false;
    private boolean resetParamSetSize = false;
    protected short statementType;
    private boolean[] SQLJParmIsGraphic = null;
    private String sqljDescribeInfo = null;
    private boolean sqljPSCloned = false;
    SQLJSection section = null;
    SQLJColumnMetaData parameterMetaData = null;
    SQLJColumnMetaData resultSetMetaData = null;
    boolean isSQLJSingletonQuery = false;
    short CLIStatementType = 0;
    Vector SQLJBatchStatements = null;
    long queryInstanceIdentifier;

    protected native int SQLPrepare(String var1, int var2, int var3, byte[] var4);

    protected native int SQLJPrepare(String var1, int var2, short var3, short var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9);

    protected native int SQLExecute(int var1, boolean var2);

    protected native int SQLBindNull(int var1, int var2, int var3, long var4, int var6, int var7, long var8, long[] var10, int var11);

    protected native int SQLBindNull2(long var1);

    protected native int SQLBindSmallInt(int var1, int var2, int var3, int var4, long var5, int var7, long var8, long[] var10, int var11);

    protected native int SQLBindSmallInt2(int var1, long var2);

    protected native int SQLBindInteger(int var1, int var2, int var3, int var4, long var5, int var7, long var8, long[] var10, int var11);

    protected native int SQLBindInteger2(int var1, long var2);

    protected native int SQLBindBigInt(int var1, int var2, long var3, int var5, long var6, int var8, long var9, long[] var11, int var12);

    protected native int SQLBindBigInt2(long var1, long var3);

    protected native int SQLBindReal(int var1, int var2, long var3, int var5, int var6, float var7, long var8, long[] var10, int var11);

    protected native int SQLBindReal2(float var1, long var2);

    protected native int SQLBindDouble(int var1, int var2, double var3, int var5, long var6, int var8, long var9, long[] var11, int var12);

    protected native int SQLBindDouble2(double var1, long var3);

    protected native int SQLBindChar(int var1, int var2, long var3, int var5, String var6, int var7, int var8, long var9, long[] var11, int var12, int var13, boolean var14);

    protected native int SQLBindBinary(int var1, int var2, long var3, int var5, int var6, byte[] var7, long var8, long[] var10, int var11, boolean var12);

    protected native int SQLBindDate(int var1, int var2, int var3, int var4, int var5, int var6, long var7, int var9, long var10, long[] var12, int var13);

    protected native int SQLBindDate2(int var1, int var2, int var3, long var4);

    protected native int SQLBindTime(int var1, int var2, int var3, int var4, int var5, int var6, long var7, int var9, long var10, long[] var12, int var13);

    protected native int SQLBindTime2(int var1, int var2, int var3, long var4);

    protected native int SQLBindTimestamp(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, int var13, long var14, long[] var16, int var17);

    protected native int SQLBindTimestamp2(int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, int var10);

    protected native int SQLBindStream(int var1, int var2, long var3, int var5, int var6, int var7, int var8, boolean var9, long var10, long[] var12, int var13);

    protected native int SQLPutByteData(byte[] var1, int var2, int var3);

    protected native int SQLPutStringData(char[] var1, int var2, int var3, int var4);

    protected native int SQLGetNumParams(int var1);

    protected native int SQLParamData(int var1);

    protected native int SQLParamDataBatch(int var1, long[] var2, int var3, int var4);

    protected native int SQLBindLob(int var1, int var2, int var3, int var4, long var5, long[] var7, int var8);

    protected native int SQLBindLobArray(int var1, int var2, int var3, int[] var4, int[] var5, long var6, long[] var8, int var9);

    protected native int SQLBindIntArray(int var1, int var2, int var3, int[] var4, int[] var5, long var6, long[] var8, int var9);

    protected native int SQLBindShortArray(int var1, int var2, int var3, short[] var4, int[] var5, long var6, long[] var8, int var9);

    protected native int SQLBindFloatArray(int var1, int var2, int var3, float[] var4, int[] var5, long var6, long[] var8, int var9);

    protected native int SQLBindDoubleArray(int var1, int var2, int var3, double[] var4, int[] var5, long var6, long[] var8, int var9);

    protected native int SQLBindDateArray(int var1, int var2, int var3, int[][] var4, int[] var5, long var6, long[] var8, int var9);

    protected native int SQLBindTimeArray(int var1, int var2, int var3, int[][] var4, int[] var5, long var6, long[] var8, int var9);

    protected native int SQLBindTimestampArray(int var1, int var2, int var3, int[][] var4, int[] var5, long var6, long[] var8, int var9);

    protected native int SQLBindByteArrayArray(int var1, int var2, long var3, int var5, byte[][] var6, int[] var7, long var8, long[] var10, int var11);

    protected native int SQLBindStringArray(int var1, int var2, int var3, long var4, int var6, int var7, int var8, String[] var9, int[] var10, long var11, long[] var13, int var14);

    protected native int SQLBindLongArray(int var1, int var2, int var3, long[] var4, int[] var5, long var6, long[] var8, int var9);

    protected native int SQLExecBatchData(int var1, int[] var2, int var3);

    protected native int SQLDescribeParam(int var1, int var2, int[] var3, long[] var4, int[] var5);

    protected native int SQLFreeStmtClearParameters(int var1);

    protected native void freeArrays(int var1, long[] var2);

    public String toString() {
        return this.toString("", true);
    }

    public String toString(String ident, boolean displayRSObj) {
        StringBuffer sb2 = new StringBuffer("\r\n" + ident + "DB2PreparedStatement \r\n" + ident + "{");
        sb2.append(super.toString(ident + "    ", displayRSObj));
        sb2.append("\r\n");
        sb2.append(ident + "    statementType = " + this.statementType + "\r\n");
        sb2.append(ident + "    executed = " + this.executed + "\r\n");
        sb2.append(ident + "    maxNumParams = " + this.maxNumParams + "\r\n");
        for (int i2 = 0; i2 < this.maxNumParams; ++i2) {
            sb2.append(ident + "    parameters[" + i2 + "] = " + this.parameters[i2] + "\r\n");
            sb2.append(ident + "    direction[" + i2 + "] = " + this.direction[i2] + "\r\n");
            sb2.append(ident + "    sqltypes[" + i2 + "] = " + this.sqltypes[i2] + "\r\n");
            sb2.append(ident + "    sqltypeGuessed[" + i2 + "] = " + this.sqltypeGuessed[i2] + "\r\n");
            sb2.append(ident + "    precisions[" + i2 + "] = " + this.precisions[i2] + "\r\n");
            sb2.append(ident + "    ctypes[" + i2 + "] = " + this.ctypes[i2] + "\r\n");
            sb2.append(ident + "    scales[" + i2 + "] = " + this.scales[i2] + "\r\n");
            sb2.append(ident + "    described[" + i2 + "] = " + this.described[i2] + "\r\n");
        }
        sb2.append(ident + "}\r\n");
        return sb2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DB2PreparedStatement(String inSQL, DB2Connection con, int rsType, int rsConcur) throws SQLException {
        super(con, rsType, rsConcur);
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2PreparedStatement( \"" + inSQL + "\", con, " + rsType + ", " + rsConcur + " )");
            }
            if (null == inSQL || 0 == inSQL.trim().length()) {
                this.sqlExcptGen.throwNullError();
            }
            this.statementType = this.getStatementType(inSQL);
            this.sql = 27 == this.statementType ? this.parseSQLJ(inSQL) : inSQL;
            this.returnCode = 0;
            DB2Connection dB2Connection = this.connection;
            synchronized (dB2Connection) {
                this.maxNumParams = (short)this.SQLPrepare(this.sql, this.statementHandle, con.connectionHandle, this.SQLJPID);
            }
            if (this.returnCode != 0) {
                try {
                    this.sqlExcptGen.check_return_code(this, this.returnCode);
                    this.maxNumParams = (short)this.SQLGetNumParams(this.statementHandle);
                }
                catch (SQLException se2) {
                    this.close();
                    throw se2;
                }
            }
            this.initParameterVariables();
            if (27 == this.statementType && this.sqljDescribeInfo != null) {
                this.processSQLJDescribeInfo();
            }
            Object var8_8 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "maxNumParam", this.maxNumParams);
            DB2Trace.methodExit(this, "DB2PreparedStatement()");
            throw throwable;
        }
        DB2Trace.data(10, "maxNumParam", this.maxNumParams);
        DB2Trace.methodExit(this, "DB2PreparedStatement()");
    }

    private void initParameterVariables() {
        this.parameters = new long[this.maxNumParams];
        this.direction = new int[this.maxNumParams];
        this.sqltypes = new int[this.maxNumParams];
        this.precisions = new long[this.maxNumParams];
        this.sqltypeGuessed = new boolean[this.maxNumParams];
        this.ctypes = new int[this.maxNumParams];
        this.maxWholeDigits = new int[this.maxNumParams];
        this.scales = new int[this.maxNumParams];
        this.wasBound = new boolean[this.maxNumParams];
        this.described = new short[this.maxNumParams];
        this.paramRow = new ParamElement[this.maxNumParams];
        for (int i2 = 0; i2 < this.maxNumParams; ++i2) {
            this.parameters[i2] = 0L;
            this.direction[i2] = 0;
            this.sqltypes[i2] = 0;
            this.precisions[i2] = 0L;
            this.sqltypeGuessed[i2] = false;
            this.ctypes[i2] = 0;
            this.scales[i2] = 0;
            this.wasBound[i2] = false;
            this.described[i2] = 0;
            this.paramRow[i2] = new ParamElement();
        }
    }

    public DB2PreparedStatement(String inSQL, DB2Connection con) throws SQLException {
        this(inSQL, con, 1003, 1007);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseSQLJ(String inSQL) throws SQLException {
        String string;
        block25: {
            String outSQL;
            block26: {
                outSQL = null;
                try {
                    int i2;
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "parseSQLJ( " + inSQL + " )");
                    }
                    outSQL = inSQL.substring(inSQL.indexOf("{"));
                    int db2jrtIndex = outSQL.indexOf("db2jrt");
                    int db2jrtLen = 6;
                    int sIndex = inSQL.indexOf(",");
                    int numOfTokens = Integer.parseInt(inSQL.substring(1, sIndex));
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "numOfTokens", numOfTokens);
                    }
                    if (numOfTokens > 0) {
                        int[] iToken = new int[numOfTokens];
                        int eIndex = 0;
                        ++sIndex;
                        for (i2 = 0; i2 < numOfTokens; ++i2) {
                            eIndex = inSQL.indexOf(",", sIndex);
                            iToken[i2] = Integer.parseInt(inSQL.substring(sIndex, eIndex));
                            sIndex = eIndex + 1;
                        }
                        this.colCount4JSQL = numOfTokens;
                        this.colNames4JSQL = new String[numOfTokens];
                        for (i2 = 0; i2 < numOfTokens; ++i2) {
                            eIndex = sIndex + iToken[i2];
                            this.colNames4JSQL[i2] = new String(inSQL.substring(sIndex, eIndex));
                            sIndex = eIndex;
                        }
                    }
                    int eIndex = inSQL.indexOf(",", ++sIndex);
                    int cursorName_len = Integer.parseInt(inSQL.substring(sIndex, eIndex));
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "cursorName_len", cursorName_len);
                    }
                    if (cursorName_len > 0) {
                        sIndex = eIndex + 1;
                        eIndex = inSQL.indexOf(",", sIndex);
                        int cursor_pid_sp = Integer.parseInt(inSQL.substring(sIndex, eIndex));
                        sIndex = eIndex + 1;
                        eIndex = inSQL.indexOf(",", sIndex);
                        int cursor_pid_ep = Integer.parseInt(inSQL.substring(sIndex, eIndex));
                        String cursor_pid = outSQL.substring(cursor_pid_sp, cursor_pid_ep);
                        sIndex = eIndex + 1;
                        eIndex = sIndex + cursorName_len;
                        String cursorName = new String(inSQL.substring(sIndex, eIndex)) + "," + cursor_pid;
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(20, "cursor_pid_ep", cursor_pid_ep);
                            DB2Trace.data(20, "cursorName", cursorName);
                        }
                        this.setCursorName(cursorName);
                    } else {
                        int i22 = outSQL.lastIndexOf(125);
                        i22 = outSQL.lastIndexOf(41, i22 - 1);
                        i22 = outSQL.lastIndexOf(39, i22 - 1);
                        int i1 = outSQL.lastIndexOf("','", i22 - 1);
                        String SQL2 = outSQL.substring(i1 + 3, i22);
                        i22 = i1;
                        String SQL1 = outSQL.substring((i1 = outSQL.lastIndexOf("','", i22 - 1)) + 3, i22);
                        if (SQL1.length() > 0 || SQL2.length() > 0) {
                            i1 = db2jrtIndex + db2jrtLen;
                            i1 = outSQL.indexOf("'", i1) + 1;
                            i22 = outSQL.indexOf(44, i1);
                            int i3 = outSQL.indexOf("',", i22);
                            String CursorName = outSQL.substring(i1, i22);
                            String PIDString = outSQL.substring(i22 + 1, i3);
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(20, "CursorName", CursorName);
                                DB2Trace.data(20, "PIDString", PIDString);
                            }
                            outSQL = SQL1 + CursorName + SQL2;
                            ByteArrayOutputStream os = new ByteArrayOutputStream(162);
                            int value = 0;
                            int len = PIDString.length();
                            for (int i4 = 0; i4 < len; ++i4) {
                                char c2 = PIDString.charAt(i4);
                                if (',' == c2) {
                                    os.write(value);
                                    value = 0;
                                    continue;
                                }
                                if (' ' == c2) continue;
                                value = value * 10 + Character.digit(c2, 10);
                            }
                            this.SQLJPID = os.toByteArray();
                        }
                    }
                    if (outSQL.indexOf("db2jrt") != -1) {
                        sIndex = outSQL.indexOf("db2jrt");
                        for (i2 = 0; i2 < 5; ++i2) {
                            sIndex = outSQL.indexOf("'", sIndex + 1);
                        }
                        eIndex = outSQL.indexOf("'", sIndex + 1);
                        if (outSQL.substring(sIndex, eIndex + 1).indexOf(",") != -1) {
                            this.sqljDescribeInfo = outSQL.substring(sIndex + 1, eIndex);
                        }
                    }
                    if (this.sqljDescribeInfo == null) {
                        sIndex = outSQL.indexOf(39, db2jrtIndex + db2jrtLen + 1);
                        sIndex = outSQL.indexOf(39, sIndex + 1);
                        sIndex = outSQL.indexOf(44, sIndex + 1);
                        sIndex = outSQL.indexOf(44, sIndex + 1);
                        sIndex = outSQL.indexOf(44, sIndex + 1);
                        sIndex = outSQL.indexOf(44, sIndex + 1);
                        eIndex = outSQL.indexOf(39, (sIndex = outSQL.indexOf(39, sIndex + 1)) + 1);
                        if (eIndex - sIndex > 1) {
                            this.SQLJParmIsGraphic = new boolean[eIndex - sIndex - 1];
                            ++sIndex;
                            i2 = 0;
                            while (i2 < this.SQLJParmIsGraphic.length) {
                                if (outSQL.charAt(sIndex) == '1') {
                                    this.SQLJParmIsGraphic[i2] = true;
                                }
                                ++i2;
                                ++sIndex;
                            }
                        }
                    }
                    string = outSQL;
                    Object var22_23 = null;
                    if (!DB2Trace.TraceOn) break block25;
                    if (this.SQLJParmIsGraphic == null) break block26;
                }
                catch (Throwable throwable) {
                    block27: {
                        Object var22_24 = null;
                        if (!DB2Trace.TraceOn) break block27;
                        if (this.SQLJParmIsGraphic != null) {
                            for (int i5 = 0; i5 < this.SQLJParmIsGraphic.length; ++i5) {
                                DB2Trace.data(100, "SQLJParmIsGraphic[" + i5 + "]", String.valueOf(this.SQLJParmIsGraphic[i5]));
                            }
                        }
                        DB2Trace.methodExit((Object)this, "parseSQLJ()", outSQL);
                    }
                    throw throwable;
                }
                for (int i5 = 0; i5 < this.SQLJParmIsGraphic.length; ++i5) {
                    DB2Trace.data(100, "SQLJParmIsGraphic[" + i5 + "]", String.valueOf(this.SQLJParmIsGraphic[i5]));
                }
            }
            DB2Trace.methodExit((Object)this, "parseSQLJ()", outSQL);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkForSQLJGraphic(int parameterIndex) {
        int i2 = parameterIndex - 1;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "checkForSQLJGraphic( " + parameterIndex + " )");
                DB2Trace.data(10, "sqltypes[" + i2 + "]", this.sqltypes[i2]);
            }
            if (27 == this.statementType && this.SQLJParmIsGraphic != null && this.SQLJParmIsGraphic.length > i2 && this.SQLJParmIsGraphic[i2]) {
                int oldSQLType = this.sqltypes[i2];
                switch (this.sqltypes[i2]) {
                    case 1: {
                        this.sqltypes[i2] = -95;
                        break;
                    }
                    case 12: {
                        this.sqltypes[i2] = -96;
                        break;
                    }
                    case -1: {
                        this.sqltypes[i2] = -97;
                        break;
                    }
                    case -99: {
                        this.sqltypes[i2] = -350;
                    }
                }
                if (this.sqltypes[i2] != oldSQLType) {
                    this.wasBound[i2] = false;
                }
            }
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(100, "sqltypes[" + i2 + "]", this.sqltypes[i2]);
            DB2Trace.methodExit(this, "checkForSQLJGraphic()");
            throw throwable;
        }
        DB2Trace.data(100, "sqltypes[" + i2 + "]", this.sqltypes[i2]);
        DB2Trace.methodExit(this, "checkForSQLJGraphic()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSQLJDescribeInfo() {
        try {
            StringTokenizer sTok;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "processSQLJDescribeInfo()");
            }
            if ((sTok = new StringTokenizer(this.sqljDescribeInfo, ",", false)).countTokens() > 0) {
                int numVars = sTok.countTokens() - 1;
                String sqljVars = "";
                sTok.nextToken();
                for (int i2 = 0; i2 < numVars; ++i2) {
                    sqljVars = sTok.nextToken();
                    int sIndex = 0;
                    int eIndex = 0;
                    if (sqljVars.indexOf(" ") != -1) {
                        eIndex = sqljVars.indexOf("(");
                        this.sqltypes[i2] = new Integer(sqljVars.substring(sIndex, eIndex));
                        sIndex = eIndex + 1;
                        eIndex = sqljVars.indexOf(" ");
                        this.precisions[i2] = new Integer(sqljVars.substring(sIndex, eIndex)).intValue();
                        sqljVars.substring(sIndex, eIndex);
                        sIndex = eIndex + 1;
                        eIndex = sqljVars.indexOf(")");
                        this.scales[i2] = new Integer(sqljVars.substring(sIndex, eIndex));
                    } else if (sqljVars.indexOf("(") != -1) {
                        eIndex = sqljVars.indexOf("(");
                        this.sqltypes[i2] = new Integer(sqljVars.substring(sIndex, eIndex));
                        sIndex = eIndex + 1;
                        eIndex = sqljVars.indexOf(")");
                        this.precisions[i2] = new Integer(sqljVars.substring(sIndex, eIndex)).intValue();
                    } else {
                        this.sqltypes[i2] = new Integer(sqljVars);
                    }
                    this.described[i2] = this.sqltypes[i2] == 0 ? (short)0 : 1;
                }
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "processSQLJDescribeInfo()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void close2(boolean explicitClose) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "close2( " + explicitClose + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                DB2Trace.data(10, "Closed (Entry)", String.valueOf(this.closed));
                DB2Trace.data(10, "sqljPSCloned", String.valueOf(this.sqljPSCloned));
            }
            if (!this.closed) {
                super.close2(explicitClose);
                if (this.parameters != null && this.maxNumParams != 0 && !this.sqljPSCloned) {
                    this.freeArrays(this.maxNumParams, this.parameters);
                }
            }
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(20, "Closed (Exit)", String.valueOf(this.closed));
            DB2Trace.methodExit(this, "close2()");
            throw throwable;
        }
        DB2Trace.data(20, "Closed (Exit)", String.valueOf(this.closed));
        DB2Trace.methodExit(this, "close2()");
    }

    protected void setDirection(int parameterIndex, int sqlType, int cType) throws SQLException {
        this.setDirection(parameterIndex, sqlType, cType, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setDirection(int parameterIndex, int sqlType, int cType, int scale) throws SQLException {
        int dIndex = parameterIndex - 1;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setDirection( " + parameterIndex + ", " + sqlType + ", " + cType + ", " + scale + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.direction[dIndex] == 4) {
                this.direction[dIndex] = 2;
                this.wasBound[dIndex] = false;
            } else if (this.direction[dIndex] == 0) {
                this.direction[dIndex] = 1;
                this.wasBound[dIndex] = false;
            }
            if (this.described[dIndex] != 1 && sqlType != 0) {
                if (this.sqltypes[dIndex] != sqlType) {
                    this.sqltypes[dIndex] = sqlType;
                    this.wasBound[dIndex] = false;
                }
                this.sqltypeGuessed[dIndex] = false;
            }
            if ((this.sqltypes[dIndex] == 3 || this.sqltypes[dIndex] == 2 && this.sqljDescribeInfo == null) && scale != -1 && scale != this.scales[dIndex]) {
                this.scales[dIndex] = scale;
                this.wasBound[dIndex] = false;
            }
            if (this.ctypes[dIndex] != cType) {
                if (this.batchSize > 0 && this.ctypes[dIndex] != 0) {
                    this.sqlExcptGen.throwBatchCTypeChanged(parameterIndex);
                }
                this.ctypes[dIndex] = cType;
                this.wasBound[dIndex] = false;
            }
            Object var7_6 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(20, "direction[" + dIndex + "]", this.direction[dIndex]);
            DB2Trace.data(20, "wasBound[" + dIndex + "]", String.valueOf(this.wasBound[dIndex]));
            DB2Trace.data(20, "sqltypes[" + dIndex + "]", this.sqltypes[dIndex]);
            DB2Trace.data(20, "ctypes[" + dIndex + "]", this.ctypes[dIndex]);
            DB2Trace.data(20, "scales[" + dIndex + "]", this.scales[dIndex]);
            DB2Trace.methodExit(this, "setDirection()");
            throw throwable;
        }
        DB2Trace.data(20, "direction[" + dIndex + "]", this.direction[dIndex]);
        DB2Trace.data(20, "wasBound[" + dIndex + "]", String.valueOf(this.wasBound[dIndex]));
        DB2Trace.data(20, "sqltypes[" + dIndex + "]", this.sqltypes[dIndex]);
        DB2Trace.data(20, "ctypes[" + dIndex + "]", this.ctypes[dIndex]);
        DB2Trace.data(20, "scales[" + dIndex + "]", this.scales[dIndex]);
        DB2Trace.methodExit(this, "setDirection()");
    }

    protected void checkParameters() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int loadBatchParameters() throws SQLException {
        this.returnCode = 0;
        int specifier = -99999;
        int paramNum = -99999;
        int setNum = -99999;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "loadBatchParameters()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            Vector[] streamParamArray = new Vector[this.maxNumParams];
            for (int i2 = 0; i2 < this.maxNumParams; ++i2) {
                streamParamArray[i2] = new Vector();
            }
            for (int j2 = 0; j2 < this.maxNumParams; ++j2) {
                for (int i3 = 0; i3 < this.batchSize; ++i3) {
                    this.paramRow = (ParamElement[])this.paramSet.elementAt(i3);
                    if (!this.paramRow[j2].isStream()) continue;
                    streamParamArray[j2].addElement(new Integer(i3));
                    if (!DB2Trace.TraceOn) continue;
                    DB2Trace.data(10, "Stream param 0-based (param,set)", j2 + "," + i3);
                }
            }
            specifier = this.SQLParamDataBatch(this.statementHandle, this.parameters, this.batchSize, this.maxNumParams);
            if (this.returnCode != 99 && this.returnCode != 0) {
                this.sqlExcptGen.check_batch_return_code(this, this.returnCode);
            }
            while (this.returnCode == 99) {
                paramNum = specifier - 1;
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "SQLParamDataBatch specifier (1-based)", specifier);
                }
                if (streamParamArray[paramNum].isEmpty()) {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "Error: No more sets contains streams for param", paramNum);
                    }
                    throw new SQLException("Error encountered loading stream parameter" + paramNum);
                }
                setNum = (Integer)streamParamArray[paramNum].remove(0);
                this.loadParameters2(setNum, paramNum);
                specifier = this.SQLParamDataBatch(this.statementHandle, this.parameters, this.batchSize, this.maxNumParams);
                if (this.returnCode == 99 || this.returnCode == 0) continue;
                this.sqlExcptGen.check_batch_return_code(this, this.returnCode);
            }
        }
        catch (SQLException e2) {
            if (DB2Trace.TraceOn) {
                DB2Trace.data(20, "SQLException thrown. paramNum, setNum", "" + paramNum + "," + setNum);
            }
            throw e2;
        }
        catch (Exception ex) {
            if (DB2Trace.TraceOn) {
                DB2Trace.data(20, "Exception thrown. paramNum, setNum, specifier", paramNum + "," + setNum + "," + specifier);
                DB2Trace.data(20, "Error", ex.getMessage());
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "loadBatchParameters()", this.returnCode);
            }
        }
        return this.returnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int loadParameters() throws SQLException {
        this.returnCode = 0;
        int rc2 = -99999;
        int specifier = -1;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "loadParameters()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            specifier = this.SQLParamData(this.statementHandle);
            if (this.returnCode != 99 && this.returnCode != 0) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            while (this.returnCode == 99) {
                this.loadParameters2(-1, specifier - 1);
                specifier = this.SQLParamData(this.statementHandle);
                if (this.returnCode == 100) {
                    int n2 = this.returnCode;
                    return n2;
                }
                if (this.returnCode == 99 || this.returnCode == 0) continue;
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            int n3 = this.returnCode;
            return n3;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "loadParameters()", this.returnCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadParameters2(int setNum, int paramNum) throws SQLException {
        this.returnCode = 0;
        int n2 = -99999;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "loadParameters2(setNum=" + setNum + ",paramNum=" + paramNum + ")");
            }
            if (setNum >= 0) {
                try {
                    this.paramRow = (ParamElement[])this.paramSet.elementAt(setNum);
                }
                catch (ArrayIndexOutOfBoundsException aEx) {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "(ArrayIndexOutOfBoundException) batchSize", this.batchSize);
                    }
                    throw aEx;
                }
            }
            try {
                boolean dataRead = false;
                int rc2 = -99999;
                int toRead = this.paramRow[paramNum].getLength();
                if (this.paramRow[paramNum].doConversion()) {
                    BufferedReader br = new BufferedReader((Reader)this.paramRow[paramNum].getValue());
                    char[] ca = new char[Math.min(16349, toRead)];
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "paramRow[" + paramNum + "].doConversion", "True");
                        DB2Trace.data(20, "chars toRead", toRead);
                    }
                    while (toRead != 0 && (n2 = br.read(ca, 0, Math.min(ca.length, toRead))) != -1) {
                        toRead -= n2;
                        if (0 == n2) break;
                        DB2Connection dB2Connection = this.connection;
                        synchronized (dB2Connection) {
                            rc2 = this.SQLPutStringData(ca, n2, this.statementHandle, this.connection.connectionHandle);
                        }
                        if (rc2 != 0) {
                            this.sqlExcptGen.check_return_code(this, rc2);
                        }
                        dataRead = true;
                    }
                    n2 = br.read();
                } else {
                    InputStream stream = (InputStream)this.paramRow[paramNum].getValue();
                    byte[] buffer = new byte[Math.min(32699, toRead)];
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "paramRow[" + paramNum + "].doConversion", "False");
                        DB2Trace.data(20, "bytes toRead", toRead);
                    }
                    while (toRead != 0 && (n2 = stream.read(buffer, 0, Math.min(32699, toRead))) != -1) {
                        toRead -= n2;
                        if (0 == n2) break;
                        rc2 = this.SQLPutByteData(buffer, n2, this.statementHandle);
                        if (rc2 != 0) {
                            this.sqlExcptGen.check_return_code(this, rc2);
                        }
                        dataRead = true;
                    }
                    n2 = stream.read();
                }
                if (!Boolean.getBoolean("DB2.ignore.stream.length") && (-1 == n2 && toRead != 0 || -1 != n2 && toRead == 0)) {
                    this.cancel();
                    DB2Trace.data(30, "Data length provided to stream did not match the stream length sent to server. Throwing an SQLException");
                    throw new SQLException("The stream contains more or less data than was specified");
                }
                if (!dataRead) {
                    DB2Trace.data(30, "No data read from InputStream. Throwing IOException");
                    throw new IOException("No data available from InputStream");
                }
            }
            catch (IOException e2) {
                this.sqlExcptGen.throw_IOException(e2);
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "loadParameters2()", this.returnCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "executeQuery()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                DB2Trace.data(10, "statementType", this.statementType);
            }
            if (24 != this.statementType && 25 != this.statementType && 27 != this.statementType) {
                this.sqlExcptGen.throwInvalidQueryError();
            }
            this.execute2();
            this.getResultSet();
            DB2ResultSet dB2ResultSet = this.resultSet;
            return dB2ResultSet;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "executeQuery()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        int retVal = -2;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "executeUpdate()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                DB2Trace.data(10, "statementType", this.statementType);
            }
            if (24 == this.statementType) {
                this.sqlExcptGen.throwInvalidUpdateError();
            }
            this.execute2();
            int n2 = retVal = this.getUpdateCount();
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "executeUpdate()", retVal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute2() throws SQLException {
        block46: {
            block45: {
                this.moreResults = true;
                this.prefetchedMoreResults = false;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "execute2()");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (this.connection.closed) {
                        this.sqlExcptGen.throwConnectionClosedError();
                    }
                    if (this.closed) {
                        this.sqlExcptGen.throwClosedError();
                    }
                    this.warnings = null;
                    this.batchReturn = null;
                    for (int i2 = 0; i2 < this.maxNumParams; ++i2) {
                        if (this.paramRow[i2].isSet()) {
                            int rc2;
                            Object x2 = this.paramRow[i2].getValue();
                            if (this.paramRow[i2].isStream() && this.direction[i2] == 2) {
                                this.sqlExcptGen.pstmtException("S1003");
                            }
                            if (this.sqltypes[i2] == 0 || this.sqltypeGuessed[i2]) {
                                this.guessSQLType(i2 + 1, this.paramRow[i2].getLength());
                            }
                            if (27 == this.statementType && this.sqljDescribeInfo == null) {
                                this.checkForSQLJGraphic(i2 + 1);
                            }
                            if (!this.wasBound[i2]) {
                                this.setPrecision(i2 + 1);
                            }
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(10, "wasBound[" + i2 + "] = " + this.wasBound[i2]);
                                DB2Trace.data(10, "sqltypes[" + i2 + "] = " + this.sqltypes[i2]);
                                DB2Trace.data(10, "sqltypeGuessed[" + i2 + "] = " + this.sqltypeGuessed[i2]);
                                DB2Trace.data(10, "precisions[" + i2 + "] = " + this.precisions[i2]);
                                DB2Trace.data(10, "scales[" + i2 + "] = " + this.scales[i2]);
                                DB2Trace.data(10, "ctypes[" + i2 + "] = " + this.ctypes[i2]);
                                DB2Trace.data(10, "described[" + i2 + "] = " + this.described[i2]);
                                DB2Trace.data(10, "direction[" + i2 + "] = " + this.direction[i2]);
                                DB2Trace.data(10, "About to BIND...");
                            }
                            if (x2 == null) {
                                rc2 = !this.wasBound[i2] ? this.SQLBindNull(this.direction[i2], i2 + 1, this.sqltypes[i2], this.precisions[i2], this.scales[i2], this.ctypes[i2], this.parameters[i2], this.parameters, this.statementHandle) : this.SQLBindNull2(this.parameters[i2]);
                                this.sqlExcptGen.check_return_code(this, rc2);
                            } else {
                                switch (this.ctypes[i2]) {
                                    case -25: {
                                        rc2 = !this.wasBound[i2] ? this.SQLBindBigInt(this.direction[i2], i2 + 1, ((PrimitiveData)x2).longValue(), this.sqltypes[i2], this.precisions[i2], this.scales[i2], this.parameters[i2], this.parameters, this.statementHandle) : this.SQLBindBigInt2(((PrimitiveData)x2).longValue(), this.parameters[i2]);
                                        this.sqlExcptGen.check_return_code(this, rc2);
                                        break;
                                    }
                                    case 4: {
                                        rc2 = !this.wasBound[i2] ? this.SQLBindInteger(this.direction[i2], i2 + 1, ((PrimitiveData)x2).intValue(), this.sqltypes[i2], this.precisions[i2], this.scales[i2], this.parameters[i2], this.parameters, this.statementHandle) : this.SQLBindInteger2(((PrimitiveData)x2).intValue(), this.parameters[i2]);
                                        this.sqlExcptGen.check_return_code(this, rc2);
                                        break;
                                    }
                                    case -7: 
                                    case -6: 
                                    case 5: {
                                        rc2 = !this.wasBound[i2] ? this.SQLBindSmallInt(this.direction[i2], i2 + 1, ((PrimitiveData)x2).shortValue(), this.sqltypes[i2], this.precisions[i2], this.scales[i2], this.parameters[i2], this.parameters, this.statementHandle) : this.SQLBindSmallInt2(((PrimitiveData)x2).shortValue(), this.parameters[i2]);
                                        this.sqlExcptGen.check_return_code(this, rc2);
                                        break;
                                    }
                                    case 7: {
                                        rc2 = !this.wasBound[i2] ? this.SQLBindReal(this.direction[i2], this.sqltypes[i2], this.precisions[i2], this.scales[i2], i2 + 1, ((PrimitiveData)x2).floatValue(), this.parameters[i2], this.parameters, this.statementHandle) : this.SQLBindReal2(((PrimitiveData)x2).floatValue(), this.parameters[i2]);
                                        this.sqlExcptGen.check_return_code(this, rc2);
                                        break;
                                    }
                                    case 8: {
                                        rc2 = !this.wasBound[i2] ? this.SQLBindDouble(this.direction[i2], i2 + 1, ((PrimitiveData)x2).doubleValue(), this.sqltypes[i2], this.precisions[i2], this.scales[i2], this.parameters[i2], this.parameters, this.statementHandle) : this.SQLBindDouble2(((PrimitiveData)x2).doubleValue(), this.parameters[i2]);
                                        this.sqlExcptGen.check_return_code(this, rc2);
                                        break;
                                    }
                                    case -8: 
                                    case 1: {
                                        if (this.paramRow[i2].isStream()) {
                                            rc2 = this.SQLBindStream(this.direction[i2], this.sqltypes[i2], this.precisions[i2], this.scales[i2], this.ctypes[i2], i2 + 1, this.paramRow[i2].getLength() * 2, this.paramRow[i2].doConversion(), this.parameters[i2], this.parameters, this.statementHandle);
                                        } else {
                                            DB2Connection dB2Connection = this.connection;
                                            synchronized (dB2Connection) {
                                                rc2 = this.SQLBindChar(this.direction[i2], this.sqltypes[i2], this.precisions[i2], i2 + 1, (String)x2, this.scales[i2], this.ctypes[i2], this.parameters[i2], this.parameters, this.statementHandle, this.connection.connectionHandle, !this.wasBound[i2]);
                                            }
                                        }
                                        this.sqlExcptGen.check_return_code(this, rc2);
                                        break;
                                    }
                                    case -2: {
                                        rc2 = this.paramRow[i2].isStream() ? this.SQLBindStream(this.direction[i2], this.sqltypes[i2], this.precisions[i2], this.scales[i2], this.ctypes[i2], i2 + 1, this.paramRow[i2].getLength(), this.paramRow[i2].doConversion(), this.parameters[i2], this.parameters, this.statementHandle) : this.SQLBindBinary(this.direction[i2], this.sqltypes[i2], this.precisions[i2], this.scales[i2], i2 + 1, (byte[])x2, this.parameters[i2], this.parameters, this.statementHandle, !this.wasBound[i2]);
                                        this.sqlExcptGen.check_return_code(this, rc2);
                                        break;
                                    }
                                    case 31: {
                                        int locator = ((DB2Blob)x2).getLocator();
                                        rc2 = this.SQLBindLob(this.direction[i2], i2 + 1, locator, this.ctypes[i2], this.parameters[i2], this.parameters, this.statementHandle);
                                        this.sqlExcptGen.check_return_code(this, rc2);
                                        break;
                                    }
                                    case -351: 
                                    case 41: {
                                        int locator = ((DB2Clob)x2).getLocator();
                                        rc2 = this.SQLBindLob(this.direction[i2], i2 + 1, locator, this.ctypes[i2], this.parameters[i2], this.parameters, this.statementHandle);
                                        this.sqlExcptGen.check_return_code(this, rc2);
                                        break;
                                    }
                                    case 9: {
                                        rc2 = !this.wasBound[i2] ? this.SQLBindDate(this.direction[i2], i2 + 1, ((int[])x2)[0], ((int[])x2)[1], ((int[])x2)[2], this.sqltypes[i2], this.precisions[i2], this.scales[i2], this.parameters[i2], this.parameters, this.statementHandle) : this.SQLBindDate2(((int[])x2)[0], ((int[])x2)[1], ((int[])x2)[2], this.parameters[i2]);
                                        this.sqlExcptGen.check_return_code(this, rc2);
                                        break;
                                    }
                                    case 10: {
                                        rc2 = !this.wasBound[i2] ? this.SQLBindTime(this.direction[i2], i2 + 1, ((int[])x2)[0], ((int[])x2)[1], ((int[])x2)[2], this.sqltypes[i2], this.precisions[i2], this.scales[i2], this.parameters[i2], this.parameters, this.statementHandle) : this.SQLBindTime2(((int[])x2)[0], ((int[])x2)[1], ((int[])x2)[2], this.parameters[i2]);
                                        this.sqlExcptGen.check_return_code(this, rc2);
                                        break;
                                    }
                                    case 11: {
                                        rc2 = !this.wasBound[i2] ? this.SQLBindTimestamp(this.direction[i2], i2 + 1, ((int[])x2)[0], ((int[])x2)[1], ((int[])x2)[2], ((int[])x2)[3], ((int[])x2)[4], ((int[])x2)[5], ((int[])x2)[6], this.sqltypes[i2], this.precisions[i2], this.scales[i2], this.parameters[i2], this.parameters, this.statementHandle) : this.SQLBindTimestamp2(((int[])x2)[0], ((int[])x2)[1], ((int[])x2)[2], ((int[])x2)[3], ((int[])x2)[4], ((int[])x2)[5], ((int[])x2)[6], this.parameters[i2], this.sqltypes[i2]);
                                        this.sqlExcptGen.check_return_code(this, rc2);
                                        break;
                                    }
                                    default: {
                                        this.sqlExcptGen.pstmtException("S1003");
                                    }
                                }
                            }
                            if (this.paramRow[i2].isStream()) {
                                this.wasBound[i2] = false;
                                continue;
                            }
                            this.wasBound[i2] = true;
                            continue;
                        }
                        if (27 == this.statementType && this.sqljDescribeInfo == null) {
                            this.checkForSQLJGraphic(i2 + 1);
                        }
                        if (!DB2Trace.TraceOn || this.direction[i2] == 4) continue;
                        DB2Trace.data(20, "Error: param[" + i2 + "].isSet()", "false");
                    }
                    if (this.resultSet != null) {
                        this.resultSet.realClose();
                    }
                    this.rowCount = 0;
                    this.colCount = 0;
                    this.checkParameters();
                    this.returnCode = 0;
                    this.returnCode = this.SQLExecute(this.statementHandle, this.resetParamSetSize);
                    if (0 == this.returnCode || 1 == this.returnCode) {
                        this.resetParamSetSize = false;
                    }
                    if (DB2Trace.TraceOn) {
                        switch (this.returnCode) {
                            case 0: {
                                DB2Trace.data(10, "SQLExecute()- returnCode", "SQL_SUCCESS");
                                break;
                            }
                            case 99: {
                                DB2Trace.data(10, "SQLExecute()- returnCode", "SQL_NEED_DATA");
                                break;
                            }
                            case 100: {
                                DB2Trace.data(10, "SQLExecute()- returnCode", "SQL_NO_DATA_FOUND");
                                break;
                            }
                            default: {
                                DB2Trace.data(10, "SQLExecute()- returnCode", this.returnCode);
                            }
                        }
                    }
                    if (this.returnCode == 99) {
                        this.returnCode = this.loadParameters();
                    }
                    if (this.returnCode == 100) {
                        this.rowCount = 0;
                        this.addWarning(new SQLWarning("No row was found for FETCH, UPDATE or DELETE; or the result of a query is an empty table.", "02000", 100));
                        Object var7_7 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block45;
                    }
                    if (this.returnCode != 0) {
                        this.sqlExcptGen.check_return_code(this, this.returnCode);
                    }
                    this.executed = true;
                    break block46;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.data(20, "executed (Exit)", String.valueOf(this.executed));
                    DB2Trace.methodExit(this, "execute2()");
                    throw throwable;
                }
            }
            DB2Trace.data(20, "executed (Exit)", String.valueOf(this.executed));
            DB2Trace.methodExit(this, "execute2()");
            return;
        }
        Object var7_8 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.data(20, "executed (Exit)", String.valueOf(this.executed));
        DB2Trace.methodExit(this, "execute2()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull(int parameterIndex, int inType) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setNull( " + parameterIndex + ", " + inType + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            if (inType == 0) {
                this.sqlExcptGen.pstmtException("S1003");
            }
            if (inType == 2001 || inType == 2002 || inType == 2006) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "parameterIndex", parameterIndex);
                    DB2Trace.data(10, "inType", inType);
                }
                this.describeParam(parameterIndex, true);
                inType = this.sqltypes[parameterIndex - 1];
            }
            int sqlType = this.convert2SQLType(inType);
            int cType = this.ctypes[parameterIndex - 1];
            if (cType == 0) {
                cType = this.sqlType2cType(sqlType);
            }
            this.setDirection(parameterIndex, sqlType, cType);
            this.paramRow[parameterIndex - 1].set(-1, null);
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setNull()");
            }
        }
    }

    public void setNull(int parameterIndex, int inType, String typeName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("User-named/REF type");
    }

    public void setBoolean(int parameterIndex, boolean x2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setBoolean(parameterIndex, x2, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBoolean(int parameterIndex, boolean x2, int sqlType) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setBoolean( " + parameterIndex + ", " + x2 + ", " + sqlType + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (x2) {
                this.setShort(parameterIndex, (short)1, sqlType);
            } else {
                this.setShort(parameterIndex, (short)0, sqlType);
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setBoolean()");
            }
        }
    }

    public void setByte(int parameterIndex, byte x2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setByte(parameterIndex, x2, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setByte(int parameterIndex, byte x2, int sqlType) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setByte( " + parameterIndex + ", " + sqlType + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            this.setShort(parameterIndex, x2, sqlType);
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setByte()");
            }
        }
    }

    public void setShort(int parameterIndex, short x2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setShort(parameterIndex, x2, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setShort(int parameterIndex, short x2, int sqlType) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setShort( " + parameterIndex + ", " + x2 + ", " + sqlType + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            this.setDirection(parameterIndex, sqlType, 5);
            this.paramRow[parameterIndex - 1].set(0, x2);
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setShort()");
            }
        }
    }

    public void setInt(int parameterIndex, int x2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setInt(parameterIndex, x2, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInt(int parameterIndex, int x2, int sqlType) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setInt( " + parameterIndex + ", " + x2 + ", " + sqlType + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            this.setDirection(parameterIndex, sqlType, 4);
            this.paramRow[parameterIndex - 1].set(0, x2);
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setInt()");
            }
        }
    }

    public void setLong(int parameterIndex, long x2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setLong(parameterIndex, x2, -5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLong(int parameterIndex, long x2, int inType) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setLong( " + parameterIndex + ", " + x2 + ", " + inType + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            int sqlType = this.convert2SQLType(-5);
            this.setDirection(parameterIndex, sqlType, -25);
            if (-5 == sqlType) {
                this.paramRow[parameterIndex - 1].set(0, x2);
            } else {
                this.paramRow[parameterIndex - 1].set(0, (int)x2);
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setLong()");
            }
        }
    }

    public void setFloat(int parameterIndex, float x2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setFloat(parameterIndex, x2, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFloat(int parameterIndex, float x2, int sqlType) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setFloat( " + parameterIndex + ", " + x2 + ", " + sqlType + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            sqlType = this.convert2SQLType(sqlType);
            this.setDirection(parameterIndex, sqlType, 7);
            this.paramRow[parameterIndex - 1].set(0, x2);
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setFloat()");
            }
        }
    }

    public void setDouble(int parameterIndex, double x2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setDouble(parameterIndex, x2, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDouble(int parameterIndex, double x2, int sqlType) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setDouble( " + parameterIndex + ", " + x2 + ", " + sqlType + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            this.setDirection(parameterIndex, sqlType, 8);
            this.paramRow[parameterIndex - 1].set(0, x2);
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setDouble()");
            }
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setBigDecimal(parameterIndex, x2, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBigDecimal(int parameterIndex, BigDecimal x2, int sqlType) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setBigDecimal( " + parameterIndex + ", " + x2 + ", " + sqlType + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            if (x2 == null) {
                this.setNull(parameterIndex, sqlType);
                return;
            }
            this.setDirection(parameterIndex, sqlType, -8);
            int index = parameterIndex - 1;
            this.setPrecisionAndScale(index, x2);
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setBigDecimal()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPrecisionAndScale(int index, BigDecimal x2) {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setPrecisionAndScale( " + index + ", " + x2 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (27 == this.statementType && this.sqljDescribeInfo != null) {
                this.paramRow[index].set((int)this.precisions[index], x2.toString());
            } else {
                int oldScale = this.scales[index];
                String sBD = x2.abs().toString();
                int scaleAdjust = 0;
                int strLen = sBD.length();
                if (sBD.indexOf(46) != -1) {
                    scaleAdjust = 1;
                }
                for (int i2 = 0; i2 < strLen && sBD.startsWith("0", i2); ++i2) {
                    ++scaleAdjust;
                }
                int xScale = x2.scale();
                int xPrecision = strLen - scaleAdjust;
                xPrecision = Math.max(xPrecision, 1);
                if (xScale > this.scales[index]) {
                    this.scales[index] = xScale;
                } else {
                    xPrecision += this.scales[index] - xScale;
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "scale", xScale);
                    DB2Trace.data(10, "precision", xPrecision);
                }
                if (oldScale != this.scales[index]) {
                    this.wasBound[index] = false;
                }
                this.paramRow[index].set(xPrecision, x2.toString());
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setPrecisionAndScale()");
            }
        }
    }

    public void setString(int parameterIndex, String x2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (x2 == null) {
            int i2 = parameterIndex - 1;
            if (this.ctypes[i2] == 0) {
                this.ctypes[i2] = -8;
                this.wasBound[i2] = false;
            }
            this.setDirection(parameterIndex, 0, this.ctypes[i2]);
            this.paramRow[parameterIndex - 1].set(-1, null);
            return;
        }
        this.setString(parameterIndex, x2, 0, -1);
    }

    protected void setString(int parameterIndex, String x2, int sqlType) throws SQLException {
        this.setString(parameterIndex, x2, sqlType, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setString(int parameterIndex, String x2, int sqlType, int scale) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setString( " + parameterIndex + ", " + x2 + ", " + sqlType + ", " + scale + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            this.setDirection(parameterIndex, sqlType, -8, scale);
            int length = x2.length();
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "String length", length);
            }
            this.paramRow[parameterIndex - 1].set(length, x2);
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setString()");
            }
        }
    }

    protected byte[] toByteArray(String s2) {
        char[] c2 = new char[s2.length()];
        s2.getChars(0, c2.length, c2, 0);
        byte[] b2 = new byte[c2.length * 2];
        for (int i2 = 0; i2 < c2.length; ++i2) {
            b2[i2 * 2] = (byte)((c2[i2] & 0xFF00) >> 8);
            b2[i2 * 2 + 1] = (byte)(c2[i2] & 0xFF);
        }
        return b2;
    }

    public void setBytes(int parameterIndex, byte[] x2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (x2 == null) {
            int i2 = parameterIndex - 1;
            if (this.ctypes[i2] == 0) {
                this.ctypes[i2] = -2;
                this.wasBound[i2] = false;
            }
            this.setDirection(parameterIndex, 0, this.ctypes[i2]);
            this.paramRow[parameterIndex - 1].set(-1, null);
            return;
        }
        this.setBytes(parameterIndex, x2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBytes(int parameterIndex, byte[] x2, int sqlType) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setBytes( " + parameterIndex + ", " + sqlType + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            switch (sqlType) {
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 91: 
                case 92: 
                case 93: {
                    this.sqlExcptGen.pstmtException("22003");
                }
            }
            this.setDirection(parameterIndex, sqlType, -2);
            this.paramRow[parameterIndex - 1].set(x2.length, x2);
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setBytes()");
            }
        }
    }

    public void setDate(int parameterIndex, Date x2) throws SQLException {
        this.setDate(parameterIndex, x2, 91, new GregorianCalendar());
    }

    protected void setDate(int parameterIndex, Date x2, int sqlType) throws SQLException {
        this.setDate(parameterIndex, x2, sqlType, new GregorianCalendar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDate(int parameterIndex, Date x2, int sqlType, Calendar cal) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setDate( " + parameterIndex + ", sqlType=" + sqlType + ", Date=" + x2 + ",calTimeZone=" + cal.getTimeZone().getID() + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            if (null == x2) {
                this.setNull(parameterIndex, sqlType);
                return;
            }
            this.setDirection(parameterIndex, sqlType, 9);
            cal = (Calendar)cal.clone();
            cal.setTime(x2);
            int[] ymd = new int[]{cal.get(1), cal.get(2) + 1, cal.get(5)};
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "Year", ymd[0]);
                DB2Trace.data(10, "Month", ymd[1]);
                DB2Trace.data(10, "Day", ymd[2]);
            }
            this.paramRow[parameterIndex - 1].set(0, ymd);
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setDate()");
            }
        }
    }

    public void setTime(int parameterIndex, Time x2) throws SQLException {
        this.setTime(parameterIndex, x2, 92, new GregorianCalendar());
    }

    protected void setTime(int parameterIndex, Time x2, int sqlType) throws SQLException {
        this.setTime(parameterIndex, x2, sqlType, new GregorianCalendar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTime(int parameterIndex, Time x2, int sqlType, Calendar cal) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setTime( " + parameterIndex + ",sqlType=" + sqlType + ", Time=" + x2 + ", calTimeZone=" + cal.getTimeZone().getID() + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            if (x2 == null) {
                this.setNull(parameterIndex, sqlType);
                return;
            }
            this.setDirection(parameterIndex, sqlType, 10);
            cal = (Calendar)cal.clone();
            cal.setTime(x2);
            int[] hms = new int[]{cal.get(11), cal.get(12), cal.get(13)};
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "Hour", hms[0]);
                DB2Trace.data(10, "Minute", hms[1]);
                DB2Trace.data(10, "Second", hms[2]);
            }
            this.paramRow[parameterIndex - 1].set(0, hms);
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setTime()");
            }
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x2) throws SQLException {
        this.setTimestamp(parameterIndex, x2, 93, new GregorianCalendar());
    }

    protected void setTimestamp(int parameterIndex, Timestamp x2, int sqlType) throws SQLException {
        this.setTimestamp(parameterIndex, x2, sqlType, new GregorianCalendar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTimestamp(int parameterIndex, Timestamp x2, int sqlType, Calendar cal) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setTimestamp( " + parameterIndex + ", sqlType=" + sqlType + ",TimeStamp=" + x2 + ", calTimeZone=" + cal.getTimeZone().getID() + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            if (x2 == null) {
                this.setNull(parameterIndex, sqlType);
                return;
            }
            this.setDirection(parameterIndex, sqlType, 11);
            cal = (Calendar)cal.clone();
            cal.setTime(x2);
            int[] ts = new int[]{cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), x2.getNanos()};
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "Year", ts[0]);
                DB2Trace.data(10, "Month", ts[1]);
                DB2Trace.data(10, "Day", ts[2]);
                DB2Trace.data(10, "Hour_of_Day", ts[3]);
                DB2Trace.data(10, "Minute", ts[4]);
                DB2Trace.data(10, "Second", ts[5]);
                DB2Trace.data(10, "Nano", ts[6]);
            }
            this.paramRow[parameterIndex - 1].set(0, ts);
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setTimestamp()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setAsciiStream(" + parameterIndex + ", " + x2 + ", " + length + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            if (null == x2) {
                int i2 = parameterIndex - 1;
                if (this.ctypes[i2] == 0) {
                    this.ctypes[i2] = 1;
                    this.wasBound[i2] = false;
                }
                this.setDirection(parameterIndex, 0, this.ctypes[i2]);
                this.paramRow[parameterIndex - 1].set(-1, null);
                return;
            }
            if (0 == length) {
                String str = new String();
                this.setString(parameterIndex, str);
                return;
            }
            this.setDirection(parameterIndex, 0, 1);
            this.paramRow[parameterIndex - 1].set(length, x2, true, false);
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setAsciiStream()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnicodeStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setUnicodeStream(" + parameterIndex + ", " + length + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            if (null == x2) {
                int i2 = parameterIndex - 1;
                if (this.ctypes[i2] == 0) {
                    this.ctypes[i2] = -8;
                    this.wasBound[i2] = false;
                }
                this.setDirection(parameterIndex, 0, this.ctypes[i2]);
                this.paramRow[parameterIndex - 1].set(-1, null);
                return;
            }
            if (0 == length) {
                String str = new String();
                this.setString(parameterIndex, str);
                return;
            }
            this.setDirection(parameterIndex, 0, -8);
            InputStreamReader r2 = null;
            try {
                r2 = new InputStreamReader(x2, "UnicodeBig");
            }
            catch (UnsupportedEncodingException e2) {
                e2.printStackTrace();
            }
            this.paramRow[parameterIndex - 1].set(length / 2, r2, true, true);
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setUnicodeStream()");
            }
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (x2 == null) {
            int i2 = parameterIndex - 1;
            if (this.ctypes[i2] == 0) {
                this.ctypes[i2] = -2;
                this.wasBound[i2] = false;
            }
            this.setDirection(parameterIndex, 0, this.ctypes[i2]);
            this.paramRow[parameterIndex - 1].set(-1, null);
            return;
        }
        this.setBinaryStream(parameterIndex, x2, length, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBinaryStream(int parameterIndex, InputStream x2, int length, int SQLType2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setBinaryStream( " + parameterIndex + " , " + x2 + ", " + length + " , " + SQLType2 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (0 == length) {
                this.setBytes(parameterIndex, new byte[0], SQLType2);
                return;
            }
            this.setDirection(parameterIndex, SQLType2, -2);
            this.paramRow[parameterIndex - 1].set(length, x2, true, false);
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setBinaryStream()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearParameters() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "clearParameters()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                DB2Trace.data(10, "sqljPSCloned", String.valueOf(this.sqljPSCloned));
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (this.parameters != null && this.maxNumParams != 0 && !this.sqljPSCloned) {
                this.freeArrays(this.maxNumParams, this.parameters);
            }
            for (int i2 = 0; i2 < this.maxNumParams; ++i2) {
                if (!this.sqljPSCloned) {
                    this.parameters[i2] = 0L;
                    this.paramRow[i2].unset();
                    this.direction[i2] = 0;
                }
                this.wasBound[i2] = false;
            }
            if (!this.sqljPSCloned) {
                this.SQLFreeStmtClearParameters(this.statementHandle);
            }
        }
        finally {
            DB2Trace.methodExit(this, "clearParameters()");
        }
    }

    public void setObject(int parameterIndex, Object x2) throws SQLException {
        this.setObject(parameterIndex, x2, 0, -1);
    }

    public void setObject(int parameterIndex, Object x2, int targetType) throws SQLException {
        this.setObject(parameterIndex, x2, targetType, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int parameterIndex, Object x2, int targetType, int scale) throws SQLException {
        block56: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "setObject( " + parameterIndex + ", " + x2 + ", " + targetType + ", " + scale + " )");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                if (this.connection.closed) {
                    this.sqlExcptGen.throwConnectionClosedError();
                }
                if (this.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
                    this.sqlExcptGen.throwParamIndexError();
                }
                if (x2 == null) {
                    this.setNull(parameterIndex, targetType);
                    return;
                }
                if (targetType == 2001 || targetType == 2002 || targetType == 2006) {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "parameterIndex", parameterIndex);
                        DB2Trace.data(10, "targetType", targetType);
                    }
                    this.describeParam(parameterIndex, true);
                    targetType = this.sqltypes[parameterIndex - 1];
                }
                if (targetType == 0) {
                    try {
                        if (x2 instanceof String) {
                            this.setString(parameterIndex, (String)x2);
                            break block56;
                        }
                        if (x2 instanceof Character) {
                            this.setString(parameterIndex, ((Character)x2).toString());
                            break block56;
                        }
                        if (x2 instanceof BigDecimal) {
                            BigDecimal bd2 = scale == -1 ? (BigDecimal)x2 : ((BigDecimal)x2).setScale(scale, 4);
                            this.setBigDecimal(parameterIndex, bd2);
                            break block56;
                        }
                        if (x2 instanceof Boolean) {
                            this.setBoolean(parameterIndex, (Boolean)x2);
                            break block56;
                        }
                        if (x2 instanceof Short) {
                            this.setShort(parameterIndex, (Short)x2);
                            break block56;
                        }
                        if (x2 instanceof Integer) {
                            this.setInt(parameterIndex, (Integer)x2);
                            break block56;
                        }
                        if (x2 instanceof Long) {
                            this.setLong(parameterIndex, (Long)x2);
                            break block56;
                        }
                        if (x2 instanceof Float) {
                            this.setFloat(parameterIndex, ((Float)x2).floatValue());
                            break block56;
                        }
                        if (x2 instanceof Double) {
                            this.setDouble(parameterIndex, (Double)x2);
                            break block56;
                        }
                        if (x2 instanceof byte[]) {
                            this.setBytes(parameterIndex, (byte[])x2);
                            break block56;
                        }
                        if (x2 instanceof Date) {
                            this.setDate(parameterIndex, (Date)x2);
                            break block56;
                        }
                        if (x2 instanceof Time) {
                            this.setTime(parameterIndex, (Time)x2);
                            break block56;
                        }
                        if (x2 instanceof Timestamp) {
                            this.setTimestamp(parameterIndex, (Timestamp)x2);
                            break block56;
                        }
                        if (x2 instanceof Blob) {
                            this.setBlob(parameterIndex, (Blob)x2);
                            break block56;
                        }
                        if (x2 instanceof Clob) {
                            this.setClob(parameterIndex, (Clob)x2);
                            break block56;
                        }
                        if (x2 instanceof URL) {
                            this.setURL(parameterIndex, (URL)x2);
                            break block56;
                        }
                        this.sqlExcptGen.pstmtException("S1003");
                    }
                    catch (ClassCastException e2) {
                        this.sqlExcptGen.pstmtException("S1003");
                    }
                    break block56;
                }
                targetType = this.convert2SQLType(targetType);
                try {
                    if (x2 instanceof String) {
                        if (targetType == 3 || targetType == 8 || targetType == 6 || targetType == 2 || targetType == 7) {
                            this.setString(parameterIndex, DB2PreparedStatement.translateFloat((String)x2), targetType, scale);
                            break block56;
                        }
                        if (targetType == 70 || targetType == -400) {
                            try {
                                URL tempURL = new URL((String)x2);
                                this.setURL(parameterIndex, tempURL, targetType);
                                break block56;
                            }
                            catch (MalformedURLException mue) {
                                throw new SQLException(mue.getMessage());
                            }
                        }
                        this.setString(parameterIndex, (String)x2, targetType);
                        break block56;
                    }
                    if (x2 instanceof Character) {
                        if (targetType == 3 || targetType == 8 || targetType == 6 || targetType == 2 || targetType == 7) {
                            this.setString(parameterIndex, DB2PreparedStatement.translateFloat(((Character)x2).toString()), targetType, scale);
                        } else {
                            this.setString(parameterIndex, ((Character)x2).toString(), targetType);
                        }
                        break block56;
                    }
                    if (x2 instanceof BigDecimal) {
                        BigDecimal bd3 = scale == -1 ? (BigDecimal)x2 : ((BigDecimal)x2).setScale(scale, 4);
                        this.setBigDecimal(parameterIndex, bd3, targetType);
                        break block56;
                    }
                    if (x2 instanceof Boolean) {
                        if (targetType == 1 || targetType == 12 || targetType == -1 || targetType == -99) {
                            this.setString(parameterIndex, ((Boolean)x2).toString(), targetType);
                        } else {
                            this.setBoolean(parameterIndex, (Boolean)x2, targetType);
                        }
                        break block56;
                    }
                    if (x2 instanceof Short) {
                        this.setShort(parameterIndex, (Short)x2, targetType);
                        break block56;
                    }
                    if (x2 instanceof Integer) {
                        this.setInt(parameterIndex, (Integer)x2, targetType);
                        break block56;
                    }
                    if (x2 instanceof Long) {
                        this.setLong(parameterIndex, (Long)x2, targetType);
                        break block56;
                    }
                    if (x2 instanceof Float) {
                        this.setFloat(parameterIndex, ((Float)x2).floatValue(), targetType);
                        break block56;
                    }
                    if (x2 instanceof Double) {
                        this.setDouble(parameterIndex, (Double)x2, targetType);
                        break block56;
                    }
                    if (x2 instanceof byte[]) {
                        this.setBytes(parameterIndex, (byte[])x2, targetType);
                        break block56;
                    }
                    if (x2 instanceof Date) {
                        this.setDate(parameterIndex, (Date)x2, targetType);
                        break block56;
                    }
                    if (x2 instanceof Time) {
                        this.setTime(parameterIndex, (Time)x2, targetType);
                        break block56;
                    }
                    if (x2 instanceof Timestamp) {
                        this.setTimestamp(parameterIndex, (Timestamp)x2, targetType);
                        break block56;
                    }
                    if (x2 instanceof Blob) {
                        this.setBlob(parameterIndex, (Blob)x2, targetType);
                        break block56;
                    }
                    if (x2 instanceof Clob) {
                        this.setClob(parameterIndex, (Clob)x2, targetType);
                        break block56;
                    }
                    if (x2 instanceof URL) {
                        this.setURL(parameterIndex, (URL)x2, targetType);
                        break block56;
                    }
                    this.sqlExcptGen.pstmtException("S1003");
                }
                catch (ClassCastException e3) {
                    this.sqlExcptGen.pstmtException("S1003");
                }
            }
            finally {
                DB2Trace.methodExit(this, "setObject()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        boolean retVal = false;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "execute()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            this.execute2();
            this.getResultSet();
            if (this.resultSet.numCols > 0) {
                retVal = true;
                boolean bl2 = true;
                return bl2;
            }
            retVal = false;
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "execute()", retVal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DB2ResultSetMetaData getResultSetMetaData() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getResultSetMetaData()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            DB2ResultSetMetaData dB2ResultSetMetaData = new DB2ResultSetMetaData(this);
            return dB2ResultSetMetaData;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "getParameterMetaData()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int convert2SQLType(int inType) throws SQLException {
        int sqltype = inType;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "convert2SQLType( " + inType + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            switch (sqltype) {
                case -7: 
                case -6: {
                    sqltype = 5;
                    break;
                }
                case 3: {
                    sqltype = 2;
                    break;
                }
                case 6: {
                    sqltype = 8;
                    break;
                }
                case -5: {
                    sqltype = -5;
                    break;
                }
                case 7: {
                    sqltype = this.connection.getRealSqlType();
                    break;
                }
                case 2004: {
                    sqltype = -98;
                    break;
                }
                case 2005: {
                    sqltype = -99;
                    break;
                }
                case 70: {
                    sqltype = -400;
                }
            }
            int n2 = sqltype;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "convert2SQLType()", sqltype);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int sqlType2cType(int sqlType) {
        int cType = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "sqlType2cType( " + sqlType + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            switch (sqlType) {
                case -5: {
                    cType = -25;
                    break;
                }
                case 2: 
                case 3: {
                    cType = -8;
                    break;
                }
                case -98: 
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    cType = -2;
                    break;
                }
                case -400: 
                case -99: 
                case -1: 
                case 1: 
                case 12: 
                case 70: 
                case 2005: {
                    cType = -8;
                    break;
                }
                case 91: {
                    cType = 9;
                    break;
                }
                case 92: {
                    cType = 10;
                    break;
                }
                case 93: {
                    cType = 11;
                    break;
                }
                default: {
                    cType = sqlType;
                }
            }
            int n2 = cType;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "sqlType2cType()", cType);
            }
        }
    }

    protected static String translateFloat(String number) {
        char d2 = new DecimalFormatSymbols().getDecimalSeparator();
        if (d2 != '.') {
            return number.replace(d2, '.');
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setPrecision(int parameterIndex) throws SQLException {
        int i2;
        block17: {
            block16: {
                i2 = parameterIndex - 1;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setPrecision( " + parameterIndex + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (1 == this.described[i2]) {
                        Object var7_3 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block16;
                    }
                    boolean describeFlag = false;
                    long oldPrecision = this.precisions[i2];
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "precisions[" + i2 + "]", this.precisions[i2]);
                        DB2Trace.data(20, "direction[" + i2 + "]", this.direction[i2]);
                        DB2Trace.data(20, "ctypes[" + i2 + "]", this.ctypes[i2]);
                        DB2Trace.data(20, "sqltypes[" + i2 + "]", this.sqltypes[i2]);
                    }
                    if (2 == this.sqltypes[i2] || 3 == this.sqltypes[i2]) {
                        this.precisions[i2] = this.connection.getTypeMaxLength(this.sqltypes[i2]);
                    } else if (1 != this.direction[i2]) {
                        if (this.ctypes[i2] != 1 && this.ctypes[i2] != -8 && this.ctypes[i2] != -2) {
                            this.precisions[i2] = this.connection.getTypeMaxLength(this.sqltypes[i2]);
                        } else if (this.sqltypes[i2] == 1 || this.sqltypes[i2] == 12 || this.sqltypes[i2] == -1 || this.sqltypes[i2] == -2 || this.sqltypes[i2] == -3 || this.sqltypes[i2] == -4 || this.sqltypes[i2] == -95 || this.sqltypes[i2] == -96 || this.sqltypes[i2] == -97) {
                            if (2 != this.described[i2] && this.connection.isDescribeParamSupported()) {
                                this.describeParam(parameterIndex, false);
                            }
                            if (1 != this.described[i2]) {
                                this.precisions[i2] = this.connection.getTypeMaxLength(this.sqltypes[i2]);
                            }
                        } else if (this.sqltypes[i2] == -98 || this.sqltypes[i2] == -99 || this.sqltypes[i2] == -350) {
                            this.describeParam(parameterIndex, true);
                        }
                    }
                    if (this.precisions[i2] != oldPrecision) {
                        this.wasBound[i2] = false;
                    }
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.data(10, "wasBound[" + i2 + "]", String.valueOf(this.wasBound[i2]));
                    DB2Trace.data(10, "precisions[" + i2 + "]", this.precisions[i2]);
                    DB2Trace.methodExit(this, "setPrecision()");
                    throw throwable;
                }
            }
            DB2Trace.data(10, "wasBound[" + i2 + "]", String.valueOf(this.wasBound[i2]));
            DB2Trace.data(10, "precisions[" + i2 + "]", this.precisions[i2]);
            DB2Trace.methodExit(this, "setPrecision()");
            return;
        }
        Object var7_4 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.data(10, "wasBound[" + i2 + "]", String.valueOf(this.wasBound[i2]));
        DB2Trace.data(10, "precisions[" + i2 + "]", this.precisions[i2]);
        DB2Trace.methodExit(this, "setPrecision()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void describeParam(int parameterIndex, boolean throwExcept) throws SQLException {
        int i2;
        int rc2;
        block11: {
            block10: {
                rc2 = 0;
                i2 = parameterIndex - 1;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "describeParam( parameterIndex=" + parameterIndex + "," + "throwExcept=" + String.valueOf(throwExcept) + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (1 == this.described[i2]) {
                        Object var7_5 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block10;
                    }
                    if (DB2Trace.TraceOn && !this.connection.isDescribeParamSupported()) {
                        DB2Trace.data(10, "Describe not supported");
                    }
                    if (0 == (rc2 = this.SQLDescribeParam(this.statementHandle, parameterIndex, this.sqltypes, this.precisions, this.scales))) {
                        this.described[i2] = 1;
                        this.sqltypeGuessed[i2] = false;
                        break block11;
                    }
                    this.described[i2] = 2;
                    try {
                        this.sqlExcptGen.check_return_code(this, rc2);
                    }
                    catch (SQLException e2) {
                        if (throwExcept) {
                            throw e2;
                        }
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(10, "Describe failed but JDBC not propagating error to application.");
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.data(10, "described[" + i2 + "]", this.described[i2]);
                    DB2Trace.data(10, "sqltypeGuessed[" + i2 + "]", String.valueOf(this.sqltypeGuessed[i2]));
                    DB2Trace.methodExit((Object)this, "describeParam()", rc2);
                    throw throwable;
                }
            }
            DB2Trace.data(10, "described[" + i2 + "]", this.described[i2]);
            DB2Trace.data(10, "sqltypeGuessed[" + i2 + "]", String.valueOf(this.sqltypeGuessed[i2]));
            DB2Trace.methodExit((Object)this, "describeParam()", rc2);
            return;
        }
        Object var7_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.data(10, "described[" + i2 + "]", this.described[i2]);
        DB2Trace.data(10, "sqltypeGuessed[" + i2 + "]", String.valueOf(this.sqltypeGuessed[i2]));
        DB2Trace.methodExit((Object)this, "describeParam()", rc2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void guessSQLType(int parameterIndex, int length) throws SQLException {
        int i2;
        block15: {
            block14: {
                block13: {
                    i2 = parameterIndex - 1;
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "guessSQLType( " + parameterIndex + "," + length + ")");
                        }
                        if (this.sqltypes[i2] != 0 && !this.sqltypeGuessed[i2]) {
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(10, "Cannot override user provided sqlType");
                            }
                            Object var6_4 = null;
                            if (!DB2Trace.TraceOn) return;
                            break block13;
                        }
                        this.sqltypeGuessed[i2] = true;
                        if (this.sqltypes[i2] == -99 || this.sqltypes[i2] == -350 || this.sqltypes[i2] == -98) {
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(10, "sqlType already at maximum type (LOB)");
                            }
                            break block14;
                        }
                        int oldSQLType = this.sqltypes[i2];
                        if (length == -1) {
                            length = 0;
                        }
                        if (!(length > this.connection.getTypeMaxLength(12) || this.paramRow[i2].isStream() || this.ctypes[i2] == 1 && this.sqltypes[i2] == -1 || this.ctypes[i2] == -8 && this.sqltypes[i2] == -1 || this.ctypes[i2] == -2 && this.sqltypes[i2] == -4)) {
                            this.sqltypes[i2] = this.ctypes[i2] == -2 ? -3 : 12;
                        } else if (length <= this.connection.getTypeMaxLength(-1) || !this.connection.isLOBSupported()) {
                            this.sqltypes[i2] = this.ctypes[i2] == -2 ? -4 : -1;
                        } else {
                            int n2 = this.sqltypes[i2] = this.ctypes[i2] == -2 ? -98 : -99;
                        }
                        if (this.sqltypes[i2] != oldSQLType) {
                            this.wasBound[i2] = false;
                        }
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (!DB2Trace.TraceOn) throw throwable;
                        DB2Trace.data(20, "sqltype[" + i2 + "]", this.sqltypes[i2]);
                        DB2Trace.data(20, "wasBound[" + i2 + "]", String.valueOf(this.wasBound[i2]));
                        DB2Trace.data(20, "length", length);
                        DB2Trace.methodExit(this, "guessSQLType");
                        throw throwable;
                    }
                }
                DB2Trace.data(20, "sqltype[" + i2 + "]", this.sqltypes[i2]);
                DB2Trace.data(20, "wasBound[" + i2 + "]", String.valueOf(this.wasBound[i2]));
                DB2Trace.data(20, "length", length);
                DB2Trace.methodExit(this, "guessSQLType");
                return;
            }
            Object var6_5 = null;
            if (!DB2Trace.TraceOn) return;
            DB2Trace.data(20, "sqltype[" + i2 + "]", this.sqltypes[i2]);
            DB2Trace.data(20, "wasBound[" + i2 + "]", String.valueOf(this.wasBound[i2]));
            DB2Trace.data(20, "length", length);
            DB2Trace.methodExit(this, "guessSQLType");
            return;
        }
        Object var6_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.data(20, "sqltype[" + i2 + "]", this.sqltypes[i2]);
        DB2Trace.data(20, "wasBound[" + i2 + "]", String.valueOf(this.wasBound[i2]));
        DB2Trace.data(20, "length", length);
        DB2Trace.methodExit(this, "guessSQLType");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "addBatch()");
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.paramSet.addElement(this.paramRow);
            this.paramRow = new ParamElement[this.maxNumParams];
            for (int i2 = 0; i2 < this.maxNumParams; ++i2) {
                this.paramRow[i2] = new ParamElement();
            }
            ++this.batchSize;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "addBatch()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBatch() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "clearBatch()");
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.batchSize = 0;
            this.paramSet.removeAllElements();
            for (int i2 = 0; i2 < this.maxNumParams; ++i2) {
                this.paramRow[i2].unset();
                this.wasBound[i2] = false;
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "clearBatch()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        try {
            int i2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "executeBatch()");
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.batchReturn = new int[this.batchSize];
            if (this.resultSet != null) {
                this.resultSet.realClose();
            }
            if (0 == this.batchSize) {
                int[] nArray = this.batchReturn;
                return nArray;
            }
            for (int k2 = 0; k2 < this.batchSize; ++k2) {
                this.batchReturn[k2] = -3;
            }
            if (24 == this.statementType) {
                throw new BatchUpdateException(this.sqlExcptGen.errMsgClass.getString("0641"), "HY000", -99999, this.batchReturn);
            }
            ParamElement[][] peArr = null;
            ParamElement[] paramRowPrev = null;
            ParamElement[][] peArr2 = new ParamElement[this.batchSize][this.maxNumParams];
            int row = 0;
            int badRowCnt = 0;
            int goodRowCnt = 0;
            int batchSizeAdjusted = -1;
            BatchUpdateException head = null;
            SQLException current = null;
            Object e2 = this.paramSet.elements();
            while (e2.hasMoreElements()) {
                peArr2[row] = (ParamElement[])e2.nextElement();
                boolean badRow = false;
                for (int j2 = 0; j2 < this.maxNumParams; ++j2) {
                    boolean badParam = false;
                    if (peArr2[row][j2].isSet()) continue;
                    if (paramRowPrev == null || !paramRowPrev[j2].isSet()) {
                        badRow = true;
                        try {
                            this.sqlExcptGen.throwNotSet(row, j2, this.batchReturn);
                        }
                        catch (BatchUpdateException b2) {
                            if (head == null) {
                                head = b2;
                                current = b2;
                                continue;
                            }
                            current.setNextException(b2);
                            current = b2;
                        }
                        continue;
                    }
                    peArr2[row][j2] = paramRowPrev[j2];
                }
                if (!badRow) {
                    if (peArr == null) {
                        batchSizeAdjusted = this.batchSize - badRowCnt;
                        peArr = new ParamElement[batchSizeAdjusted][this.maxNumParams];
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(10, "First row with all params (zero-based)", row);
                        }
                    }
                    peArr[goodRowCnt] = peArr2[row];
                    ++goodRowCnt;
                } else {
                    ++badRowCnt;
                }
                paramRowPrev = peArr2[row];
                ++row;
            }
            if (DB2Trace.TraceOn) {
                DB2Trace.data(20, "batchSize", this.batchSize);
                DB2Trace.data(20, "batchSizeAdjusted", batchSizeAdjusted);
                DB2Trace.data(20, "Number of bad rows (badRowCnt)", badRowCnt);
                DB2Trace.data(20, "Number of good rows (goodRowCnt)", goodRowCnt);
            }
            if (batchSizeAdjusted < 1) {
                if (head != null) {
                    throw head;
                }
                e2 = this.batchReturn;
                return e2;
            }
            int[] batchReturnAdjusted = new int[batchSizeAdjusted];
            for (int i3 = 0; i3 < batchSizeAdjusted; ++i3) {
                batchReturnAdjusted[i3] = -3;
            }
            Object valueObj = null;
            int[] dataLength = new int[batchSizeAdjusted];
            int rc2 = 0;
            block37: for (i2 = 0; i2 < this.maxNumParams; ++i2) {
                switch (this.ctypes[i2]) {
                    case -25: {
                        long[] valueLong = new long[batchSizeAdjusted];
                        for (int j3 = 0; j3 < batchSizeAdjusted; ++j3) {
                            valueObj = peArr[j3][i2].getValue();
                            dataLength[j3] = peArr[j3][i2].getLength();
                            if (null == valueObj) continue;
                            valueLong[j3] = ((PrimitiveData)valueObj).longValue();
                        }
                        rc2 = this.SQLBindLongArray(i2 + 1, this.sqltypes[i2], batchSizeAdjusted, valueLong, dataLength, this.parameters[i2], this.parameters, this.statementHandle);
                        this.sqlExcptGen.check_return_code(this, rc2);
                        continue block37;
                    }
                    case 4: {
                        int[] valueInt = new int[batchSizeAdjusted];
                        for (int j4 = 0; j4 < batchSizeAdjusted; ++j4) {
                            valueObj = peArr[j4][i2].getValue();
                            dataLength[j4] = peArr[j4][i2].getLength();
                            if (null == valueObj) continue;
                            valueInt[j4] = ((PrimitiveData)valueObj).intValue();
                        }
                        rc2 = this.SQLBindIntArray(i2 + 1, this.sqltypes[i2], batchSizeAdjusted, valueInt, dataLength, this.parameters[i2], this.parameters, this.statementHandle);
                        this.sqlExcptGen.check_return_code(this, rc2);
                        continue block37;
                    }
                    case -7: 
                    case -6: 
                    case 5: {
                        short[] valueShort = new short[batchSizeAdjusted];
                        for (int j5 = 0; j5 < batchSizeAdjusted; ++j5) {
                            valueObj = peArr[j5][i2].getValue();
                            dataLength[j5] = peArr[j5][i2].getLength();
                            if (null == valueObj) continue;
                            valueShort[j5] = ((PrimitiveData)valueObj).shortValue();
                        }
                        rc2 = this.SQLBindShortArray(i2 + 1, this.sqltypes[i2], batchSizeAdjusted, valueShort, dataLength, this.parameters[i2], this.parameters, this.statementHandle);
                        this.sqlExcptGen.check_return_code(this, rc2);
                        continue block37;
                    }
                    case 7: {
                        float[] valueFloat = new float[batchSizeAdjusted];
                        for (int j6 = 0; j6 < batchSizeAdjusted; ++j6) {
                            valueObj = peArr[j6][i2].getValue();
                            dataLength[j6] = peArr[j6][i2].getLength();
                            if (null == valueObj) continue;
                            valueFloat[j6] = ((PrimitiveData)valueObj).floatValue();
                        }
                        rc2 = this.SQLBindFloatArray(i2 + 1, this.sqltypes[i2], batchSizeAdjusted, valueFloat, dataLength, this.parameters[i2], this.parameters, this.statementHandle);
                        this.sqlExcptGen.check_return_code(this, rc2);
                        continue block37;
                    }
                    case 8: {
                        double[] valueDouble = new double[batchSizeAdjusted];
                        for (int j7 = 0; j7 < batchSizeAdjusted; ++j7) {
                            valueObj = peArr[j7][i2].getValue();
                            dataLength[j7] = peArr[j7][i2].getLength();
                            if (null == valueObj) continue;
                            valueDouble[j7] = ((PrimitiveData)valueObj).doubleValue();
                        }
                        rc2 = this.SQLBindDoubleArray(i2 + 1, this.sqltypes[i2], batchSizeAdjusted, valueDouble, dataLength, this.parameters[i2], this.parameters, this.statementHandle);
                        this.sqlExcptGen.check_return_code(this, rc2);
                        continue block37;
                    }
                    case -8: 
                    case 1: {
                        String[] valueString = new String[batchSizeAdjusted];
                        int largestLen = 0;
                        this.paramRow = peArr[0];
                        for (int j8 = 0; j8 < batchSizeAdjusted; ++j8) {
                            valueObj = peArr[j8][i2].getValue();
                            dataLength[j8] = peArr[j8][i2].getLength();
                            if (dataLength[j8] > largestLen) {
                                largestLen = dataLength[j8];
                            }
                            if (null == valueObj) continue;
                            if (peArr[j8][i2].isStream()) {
                                dataLength[j8] = -2;
                                this.paramRow = peArr[j8];
                                continue;
                            }
                            valueString[j8] = (String)valueObj;
                        }
                        if (this.sqltypes[i2] == 0 || this.sqltypeGuessed[i2]) {
                            this.guessSQLType(i2 + 1, largestLen);
                        }
                        if (!this.wasBound[i2]) {
                            this.setPrecision(i2 + 1);
                        }
                        rc2 = this.SQLBindStringArray(i2 + 1, this.sqltypes[i2], this.ctypes[i2], this.precisions[i2], this.scales[i2], this.direction[i2], batchSizeAdjusted, valueString, dataLength, this.parameters[i2], this.parameters, this.statementHandle);
                        this.sqlExcptGen.check_return_code(this, rc2);
                        continue block37;
                    }
                    case -2: {
                        byte[][] valueByte = new byte[batchSizeAdjusted][];
                        int largestLen = 0;
                        this.paramRow = peArr[0];
                        for (int j9 = 0; j9 < batchSizeAdjusted; ++j9) {
                            valueObj = peArr[j9][i2].getValue();
                            dataLength[j9] = peArr[j9][i2].getLength();
                            if (dataLength[j9] > largestLen) {
                                largestLen = dataLength[j9];
                            }
                            if (null == valueObj) continue;
                            if (peArr[j9][i2].isStream()) {
                                dataLength[j9] = -2;
                                this.paramRow = peArr[j9];
                                continue;
                            }
                            valueByte[j9] = new byte[dataLength[j9]];
                            System.arraycopy((byte[])valueObj, 0, valueByte[j9], 0, dataLength[j9]);
                        }
                        if (this.sqltypes[i2] == 0 || this.sqltypeGuessed[i2]) {
                            this.guessSQLType(i2 + 1, largestLen);
                        }
                        if (!this.wasBound[i2]) {
                            this.setPrecision(i2 + 1);
                        }
                        rc2 = this.SQLBindByteArrayArray(i2 + 1, this.sqltypes[i2], this.precisions[i2], batchSizeAdjusted, valueByte, dataLength, this.parameters[i2], this.parameters, this.statementHandle);
                        this.sqlExcptGen.check_return_code(this, rc2);
                        continue block37;
                    }
                    case 9: {
                        int[][] valueDate = new int[batchSizeAdjusted][3];
                        for (int j10 = 0; j10 < batchSizeAdjusted; ++j10) {
                            valueObj = peArr[j10][i2].getValue();
                            dataLength[j10] = peArr[j10][i2].getLength();
                            if (null == valueObj) continue;
                            int[] d2 = (int[])valueObj;
                            System.arraycopy(d2, 0, valueDate[j10], 0, 3);
                        }
                        rc2 = this.SQLBindDateArray(i2 + 1, this.sqltypes[i2], batchSizeAdjusted, valueDate, dataLength, this.parameters[i2], this.parameters, this.statementHandle);
                        this.sqlExcptGen.check_return_code(this, rc2);
                        continue block37;
                    }
                    case 10: {
                        int[][] valueTime = new int[batchSizeAdjusted][3];
                        for (int j11 = 0; j11 < batchSizeAdjusted; ++j11) {
                            valueObj = peArr[j11][i2].getValue();
                            dataLength[j11] = peArr[j11][i2].getLength();
                            if (null == valueObj) continue;
                            int[] t2 = (int[])valueObj;
                            System.arraycopy(t2, 0, valueTime[j11], 0, 3);
                        }
                        rc2 = this.SQLBindTimeArray(i2 + 1, this.sqltypes[i2], batchSizeAdjusted, valueTime, dataLength, this.parameters[i2], this.parameters, this.statementHandle);
                        this.sqlExcptGen.check_return_code(this, rc2);
                        continue block37;
                    }
                    case 11: {
                        int[][] valueTS = new int[batchSizeAdjusted][7];
                        for (int j12 = 0; j12 < batchSizeAdjusted; ++j12) {
                            valueObj = peArr[j12][i2].getValue();
                            dataLength[j12] = peArr[j12][i2].getLength();
                            if (null == valueObj) continue;
                            int[] ts = (int[])valueObj;
                            System.arraycopy(ts, 0, valueTS[j12], 0, 7);
                        }
                        rc2 = this.SQLBindTimestampArray(i2 + 1, this.sqltypes[i2], batchSizeAdjusted, valueTS, dataLength, this.parameters[i2], this.parameters, this.statementHandle);
                        this.sqlExcptGen.check_return_code(this, rc2);
                        continue block37;
                    }
                    case -351: 
                    case 31: 
                    case 41: {
                        int[] locators = new int[batchSizeAdjusted];
                        for (int j13 = 0; j13 < batchSizeAdjusted; ++j13) {
                            valueObj = peArr[j13][i2].getValue();
                            dataLength[j13] = peArr[j13][i2].getLength();
                            if (valueObj == null) continue;
                            locators[j13] = 31 == this.ctypes[i2] ? ((DB2Blob)valueObj).getLocator() : ((DB2Clob)valueObj).getLocator();
                        }
                        rc2 = this.SQLBindLobArray(i2 + 1, this.ctypes[i2], batchSizeAdjusted, locators, dataLength, this.parameters[i2], this.parameters, this.statementHandle);
                        this.sqlExcptGen.check_return_code(this, rc2);
                        continue block37;
                    }
                    default: {
                        this.sqlExcptGen.throwNotSet(0, i2, this.batchReturn);
                    }
                }
            }
            rc2 = this.SQLExecBatchData(batchSizeAdjusted, batchReturnAdjusted, this.statementHandle);
            this.resetParamSetSize = true;
            if (DB2Trace.TraceOn) {
                block49: for (i2 = 0; i2 < batchReturnAdjusted.length; ++i2) {
                    switch (batchReturnAdjusted[i2]) {
                        case 0: {
                            DB2Trace.data(100, "returnCode[" + i2 + "]", "SQL_PARAM_SUCCESS");
                            continue block49;
                        }
                        case 6: {
                            DB2Trace.data(100, "returnCode[" + i2 + "]", "SQL_PARAM_SUCCESS_WITH_INFO");
                            continue block49;
                        }
                        case 5: {
                            DB2Trace.data(100, "returnCode[" + i2 + "]", "SQL_PARAM_ERROR");
                            continue block49;
                        }
                        case 7: {
                            DB2Trace.data(100, "returnCode[" + i2 + "]", "SQL_PARAM_UNUSED");
                        }
                    }
                }
            }
            block50: for (int k3 = 0; k3 < batchReturnAdjusted.length; ++k3) {
                switch (batchReturnAdjusted[k3]) {
                    case 0: 
                    case 6: {
                        this.batchReturn[k3 + badRowCnt] = -2;
                        continue block50;
                    }
                    case 5: {
                        this.batchReturn[k3 + badRowCnt] = -3;
                        continue block50;
                    }
                    case 7: {
                        this.batchReturn[k3 + badRowCnt] = 0;
                    }
                }
            }
            try {
                if (rc2 == 100 && batchSizeAdjusted == 1) {
                    rc2 = 1;
                }
                this.sqlExcptGen.check_batch_return_code(this, rc2);
            }
            catch (BatchUpdateException b3) {
                if (head != null) {
                    current.setNextException(b3);
                }
                head = b3;
            }
            if (head != null) {
                throw head;
            }
            int[] nArray = this.batchReturn;
            return nArray;
        }
        finally {
            this.clearBatch();
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "executeBatch()");
            }
        }
    }

    protected final boolean isElementNull(ParamElement pe2, int row, int column) throws SQLException {
        if (!pe2.isSet()) {
            this.sqlExcptGen.throwNotSet(row, column, this.batchReturn);
        }
        return false;
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (reader == null) {
            int i2 = parameterIndex - 1;
            if (this.ctypes[i2] == 0) {
                this.ctypes[i2] = -8;
                this.wasBound[i2] = false;
            }
            this.setDirection(parameterIndex, 0, this.ctypes[i2]);
            this.paramRow[parameterIndex - 1].set(-1, null);
            return;
        }
        this.setCharacterStream(parameterIndex, reader, length, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCharacterStream(int parameterIndex, Reader reader, int length, int SQLType2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setCharacterStream( " + parameterIndex + ", " + reader + ", " + length + ", " + SQLType2 + " )");
            }
            if (0 == length) {
                this.setString(parameterIndex, new String(), SQLType2);
                return;
            }
            this.setDirection(parameterIndex, SQLType2, -8);
            this.paramRow[parameterIndex - 1].set(length, reader, true, true);
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setCharacterStream()");
            }
        }
    }

    public void setRef(int i2, Ref x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setRef()");
    }

    public void setBlob(int i2, Blob x2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (i2 < 1 || i2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (null == x2) {
            this.setNull(i2, -98);
            return;
        }
        this.setBlob(i2, x2, -98);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBlob(int i2, Blob x2, int sqlType) throws SQLException {
        try {
            int length;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setBlob( " + i2 + ", " + x2 + ", " + sqlType + " )");
            }
            if (0 == (length = (int)x2.length())) {
                this.setBytes(i2, new byte[0], sqlType);
                return;
            }
            if (x2 instanceof DB2Blob && ((DB2Blob)x2).data == null && 25 != this.statementType) {
                DB2Blob db2blob = (DB2Blob)x2;
                this.setDirection(i2, sqlType, 31);
                this.paramRow[i2 - 1].set(length, db2blob, false, false);
            } else if (25 == this.statementType) {
                this.setBytes(i2, x2.getBytes(1L, (int)x2.length()), sqlType);
            } else {
                this.setBinaryStream(i2, x2.getBinaryStream(), length, sqlType);
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setBlob()");
            }
        }
    }

    public void setClob(int i2, Clob x2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (i2 < 1 || i2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (null == x2) {
            this.setNull(i2, -99);
            return;
        }
        this.setClob(i2, x2, -99);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClob(int i2, Clob x2, int sqlType) throws SQLException {
        try {
            int length;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setClob( " + i2 + ", " + x2 + ", " + sqlType + " )");
            }
            if (0 == (length = (int)x2.length())) {
                this.setString(i2, new String(), sqlType);
                return;
            }
            if (x2 instanceof DB2Clob && ((DB2Clob)x2).data == null & 25 != this.statementType) {
                DB2Clob db2clob = (DB2Clob)x2;
                sqlType = db2clob.lobType == 41 ? -99 : -350;
                this.setDirection(i2, sqlType, db2clob.lobType);
                this.paramRow[i2 - 1].set(length, db2clob, false, true);
            } else if (25 == this.statementType) {
                this.setString(i2, x2.getSubString(1L, (int)x2.length()), sqlType);
            } else {
                this.setCharacterStream(i2, x2.getCharacterStream(), length, sqlType);
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setClob()");
            }
        }
    }

    public void setArray(int i2, Array x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setArray()");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.getResultSetMetaData();
    }

    public void setDate(int parameterIndex, Date x2, Calendar cal) throws SQLException {
        this.setDate(parameterIndex, x2, 91, cal);
    }

    public void setTime(int parameterIndex, Time x2, Calendar cal) throws SQLException {
        this.setTime(parameterIndex, x2, 92, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        this.setTimestamp(parameterIndex, x2, 93, cal);
    }

    public void setURL(int i2, URL x2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (i2 < 1 || i2 > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (null == x2) {
            this.setNull(i2, 70);
            return;
        }
        this.setURL(i2, x2, -400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setURL(int i2, URL x2, int sqlType) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setURL( " + i2 + ", " + x2 + ", " + sqlType + " )");
            }
            this.setDirection(i2, sqlType, 1);
            this.paramRow[i2 - 1].set(x2.toExternalForm().length(), x2.toExternalForm());
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setURL()");
            }
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getParameterMetaData");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DB2PreparedStatement(String sql, DB2Connection con, int statementRole, SQLJSection section, SQLJColumnMetaData parameterMetaData, SQLJColumnMetaData resultSetMetaData, boolean dynamicExecution, boolean needsDescribe, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(con, resultSetType, resultSetConcurrency);
        try {
            String cname;
            int rc2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2PreparedStatement( \"" + sql + "\", " + con.connectionHandle + ", " + statementRole + ", " + (section != null ? "section number=" + section.getSectionNumber() : "null") + ", " + (parameterMetaData != null ? "num parameters=" + parameterMetaData.getColumns() : "null") + ", " + (resultSetMetaData != null ? "num columns=" + resultSetMetaData.getColumns() : "null") + ", " + dynamicExecution + ", " + needsDescribe + ", " + resultSetType + ", " + resultSetConcurrency + ", " + "pkgname: " + this.section.getPackage().getPackageName() + ", " + "pkgname_len: " + this.section.getPackage().getPackageName().length() + " )");
            }
            this.sql = sql;
            this.section = section;
            SQLJPackage pkg = section.getPackage();
            this.statementType = (short)27;
            this.CLIStatementType = DB2Constants.mapSQLJRoleToStmtType(statementRole, dynamicExecution, true);
            this.parameterMetaData = parameterMetaData;
            this.resultSetMetaData = resultSetMetaData;
            int[] SQLJTypes = null;
            long[] SQLJLengths = null;
            int[] SQLJPrecisions = null;
            int[] SQLJScales = null;
            if (parameterMetaData != null) {
                this.maxNumParams = (short)parameterMetaData.getColumns();
                SQLJTypes = parameterMetaData.getSqlTypes();
                SQLJLengths = parameterMetaData.getLengths();
                SQLJPrecisions = parameterMetaData.getPrecisions();
                SQLJScales = parameterMetaData.getScales();
            }
            if ((rc2 = this.SQLJPrepare(sql, sql == null ? 0 : sql.length(), this.CLIStatementType, this.maxNumParams, this.statementHandle, section.getSectionNumber(), pkg.getPackageName().getBytes(), pkg.getConsistencyToken(), pkg.getCollectionName().getBytes())) != 0) {
                this.sqlExcptGen.check_return_code(this, rc2);
            }
            if ((cname = section.getServerCursorName()) != null && cname.length() > 0) {
                this.setCursorName(cname);
            }
            this.initParameterVariables();
            if (!needsDescribe) {
                for (int i2 = 0; i2 < this.maxNumParams; ++i2) {
                    this.sqltypes[i2] = DB2Constants.mapSQLDATypeToCLISQLType(SQLJTypes[i2]);
                    this.scales[i2] = SQLJScales[i2];
                    this.precisions[i2] = this.sqltypes[i2] == 3 || this.sqltypes[i2] == 2 ? (long)SQLJPrecisions[i2] : SQLJLengths[i2];
                    if (this.sqltypes[i2] != 0) {
                        this.described[i2] = 1;
                    }
                    if (!DB2Trace.TraceOn) continue;
                    DB2Trace.data(10, "sqltype[" + i2 + "]", this.sqltypes[i2]);
                    DB2Trace.data(10, "precisions[" + i2 + "]", this.precisions[i2]);
                    DB2Trace.data(10, "scales[" + i2 + "]", this.scales[i2]);
                }
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "DB2PreparedStatement()");
            }
        }
    }

    public void setInputs(Object[] inputs) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setInputs()");
            DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
        }
        DB2PreparedStatement pstmt = (DB2PreparedStatement)inputs[0];
        this.maxNumParams = pstmt.maxNumParams;
        this.parameters = pstmt.parameters;
        this.direction = pstmt.direction;
        this.sqltypes = pstmt.sqltypes;
        this.precisions = pstmt.precisions;
        this.sqltypeGuessed = pstmt.sqltypeGuessed;
        this.ctypes = pstmt.ctypes;
        this.maxWholeDigits = pstmt.maxWholeDigits;
        this.scales = pstmt.scales;
        this.wasBound = pstmt.wasBound;
        this.described = pstmt.described;
        this.paramRow = pstmt.paramRow;
        this.paramSet = pstmt.paramSet;
        for (int i2 = 0; i2 < this.maxNumParams; ++i2) {
            this.wasBound[i2] = false;
        }
        this.sqljPSCloned = true;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setInputs()");
        }
    }

    public Object[] getInputs() {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getInputs()");
            DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
        }
        Object[] returnValue = new Object[]{this};
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "getInputs()");
        }
        return returnValue;
    }

    public SQLJColumnMetaData getParameterColumnMetaData() {
        return this.parameterMetaData;
    }

    public SQLJColumnMetaData getResultSetColumnMetaData() {
        return this.resultSetMetaData;
    }

    public SQLJSection getSection() {
        return this.section;
    }

    public void setSection(SQLJSection section) {
        int rc2 = 0;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setSection( " + (section != null ? "section number=" + section.getSectionNumber() : "null") + " )");
            DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
        }
        this.section = section;
        SQLJPackage pkg = section.getPackage();
        rc2 = this.SQLJPrepare(this.sql, this.sql == null ? 0 : this.sql.length(), this.CLIStatementType, this.maxNumParams, this.statementHandle, section.getSectionNumber(), pkg.getPackageName().getBytes(), pkg.getConsistencyToken(), pkg.getCollectionName().getBytes());
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "setSection()", rc2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch(boolean sqljBatch) throws SQLException {
        int[] nArray;
        block16: {
            StringBuffer sb22;
            block17: {
                int[] updateCount = null;
                int batchCount = 0;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "executeBatch( " + sqljBatch + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (this.maxNumParams > 0) {
                        updateCount = this.executeBatch();
                    } else {
                        batchCount = this.SQLJBatchStatements.size();
                        updateCount = new int[batchCount];
                        SQLException exception = null;
                        for (int i2 = 0; i2 < batchCount; ++i2) {
                            try {
                                updateCount[i2] = ((PreparedStatement)this.SQLJBatchStatements.elementAt(i2)).executeUpdate();
                                continue;
                            }
                            catch (SQLException e2) {
                                updateCount[i2] = -3;
                                if (null == exception) {
                                    exception = new BatchUpdateException(e2.getMessage(), e2.getSQLState(), e2.getErrorCode(), updateCount);
                                    if (e2.getNextException() == null) continue;
                                    exception.setNextException(exception.getNextException());
                                    continue;
                                }
                                exception.setNextException(e2);
                            }
                        }
                    }
                    nArray = updateCount;
                    Object var8_7 = null;
                    if (this.SQLJBatchStatements != null) {
                        this.SQLJBatchStatements.removeAllElements();
                    }
                    if (!DB2Trace.TraceOn) break block16;
                    sb22 = new StringBuffer();
                    if (updateCount == null) break block17;
                    sb22.append('[');
                }
                catch (Throwable throwable) {
                    block18: {
                        Object var8_8 = null;
                        if (this.SQLJBatchStatements != null) {
                            this.SQLJBatchStatements.removeAllElements();
                        }
                        if (!DB2Trace.TraceOn) break block18;
                        StringBuffer sb22 = new StringBuffer();
                        if (updateCount != null) {
                            sb22.append('[');
                            for (int i3 = 0; i3 < updateCount.length; ++i3) {
                                if (i3 > 0) {
                                    sb22.append(',');
                                }
                                sb22.append(updateCount[i3]);
                            }
                            sb22.append(']');
                        }
                        DB2Trace.methodExit((Object)this, "executeBatch()", sb22.toString());
                    }
                    throw throwable;
                }
                for (int i3 = 0; i3 < updateCount.length; ++i3) {
                    if (i3 > 0) {
                        sb22.append(',');
                    }
                    sb22.append(updateCount[i3]);
                }
                sb22.append(']');
            }
            DB2Trace.methodExit((Object)this, "executeBatch()", sb22.toString());
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch(SQLJPreparedStatement preparedStatementI) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "addBatch( Statement Handle=" + ((DB2PreparedStatement)preparedStatementI).getTraceHandle() + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.maxNumParams > 0) {
                this.addBatch();
            } else {
                if (null == this.SQLJBatchStatements) {
                    this.SQLJBatchStatements = new Vector();
                }
                this.SQLJBatchStatements.add(preparedStatementI);
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "addBatch()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLJResultSet getSingletonResultSet() {
        SQLJResultSet rs = null;
        try {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "getSingletonResultSet()");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                rs = (SQLJResultSet)this.getResultSet();
            }
            catch (SQLException e2) {
                rs = null;
                Object var4_3 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit((Object)this, "getSingletonResultSet()", null == rs ? "ResultSet is null" : "ResultSet is not null");
                }
            }
            Object var4_2 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getSingletonResultSet()", null == rs ? "ResultSet is null" : "ResultSet is not null");
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getSingletonResultSet()", null == rs ? "ResultSet is null" : "ResultSet is not null");
            }
            throw throwable;
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeSetCurrentPackageset() throws SQLException {
        int rc2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "executeSetCurrentPackageset()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                DB2Trace.data(10, "Collection", (String)this.paramRow[0].getValue());
            }
            this.section.getPackage().changeCollectionName((String)this.paramRow[0].getValue());
            int n2 = rc2;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "executeSetCurrentPackageset()", rc2);
            }
        }
    }

    public void setSQLJSingletonQuery(boolean isSelectOrValuesIntoStatement) {
        this.isSQLJSingletonQuery = isSelectOrValuesIntoStatement;
    }

    public boolean getSQLJSingletonQuery() {
        return this.isSQLJSingletonQuery;
    }

    public void setQueryInstanceIdentifier(long queryInstanceIdentifier) {
        this.queryInstanceIdentifier = queryInstanceIdentifier;
    }

    class ParamElement {
        int length;
        Object value;
        boolean isStream;
        boolean doConversion;
        boolean fSet = false;
        PrimitiveData primitiveData = new PrimitiveData();

        public ParamElement() {
        }

        public ParamElement(int l2, Object o2) {
            this.length = l2;
            this.value = o2;
            if (this.value == null) {
                this.length = -1;
            }
            this.isStream = false;
            this.doConversion = false;
            this.fSet = true;
        }

        public ParamElement(int l2, Object o2, boolean b2, boolean c2) {
            this(l2, o2);
            this.isStream = b2;
            this.doConversion = c2;
        }

        public void set(int l2, double val) {
            this.primitiveData.set(val);
            this.set(l2, this.primitiveData, false, false);
        }

        public void set(int l2, int val) {
            this.primitiveData.set(val);
            this.set(l2, this.primitiveData, false, false);
        }

        public void set(int l2, float val) {
            this.primitiveData.set(val);
            this.set(l2, this.primitiveData, false, false);
        }

        public void set(int l2, long val) {
            this.primitiveData.set(val);
            this.set(l2, this.primitiveData, false, false);
        }

        public void set(int l2, short val) {
            this.primitiveData.set(val);
            this.set(l2, this.primitiveData, false, false);
        }

        public void set(int l2, Object o2) {
            this.set(l2, o2, false, false);
        }

        public void set(int l2, Object o2, boolean b2, boolean c2) {
            this.length = l2;
            this.value = o2;
            if (this.value == null) {
                this.length = -1;
            }
            this.isStream = b2;
            this.doConversion = c2;
            this.fSet = true;
        }

        public void unset() {
            this.fSet = false;
            this.value = null;
        }

        public final boolean isSet() {
            return this.fSet;
        }

        public final int getLength() {
            return this.length;
        }

        public final Object getValue() {
            return this.value;
        }

        public final boolean isStream() {
            return this.isStream;
        }

        public final boolean doConversion() {
            return this.doConversion;
        }
    }

    class PrimitiveData {
        double doubleVal;
        int intVal;
        float floatVal;
        long longVal;
        short shortVal;

        public double doubleValue() {
            return this.doubleVal;
        }

        public int intValue() {
            return this.intVal;
        }

        public float floatValue() {
            return this.floatVal;
        }

        public long longValue() {
            return this.longVal;
        }

        public short shortValue() {
            return this.shortVal;
        }

        public void set(double val) {
            this.doubleVal = val;
        }

        public void set(int val) {
            this.intVal = val;
        }

        public void set(float val) {
            this.floatVal = val;
        }

        public void set(long val) {
            this.longVal = val;
        }

        public void set(short val) {
            this.shortVal = val;
        }
    }
}

