/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.app.DB2PreparedStatement;
import java.sql.SQLException;

public class DB2ParameterMetaData {
    protected DB2PreparedStatement preparedStmt;
    protected int statementHandle;
    protected int paramCount = 0;
    protected short[] paramType;
    protected int[] paramPrecision;
    protected short[] paramScale;

    protected native int SQLDescribeParam(int var1, int var2, short[] var3, int[] var4, short[] var5);

    public DB2ParameterMetaData(DB2PreparedStatement pstmt) throws SQLException {
        this.preparedStmt = pstmt;
        this.statementHandle = pstmt.statementHandle;
        this.paramCount = pstmt.maxNumParams;
        this.paramType = new short[this.paramCount];
        this.paramPrecision = new int[this.paramCount];
        this.paramScale = new short[this.paramCount];
        for (int i2 = 0; i2 < this.paramCount; ++i2) {
            this.paramPrecision[i2] = -1;
        }
    }

    public short getParameterCount() {
        return (short)this.paramCount;
    }

    public short getType(int index) throws SQLException {
        int rc2;
        if (index < 1 || index > this.paramCount) {
            this.preparedStmt.sqlExcptGen.throwParamIndexError();
        }
        if (-1 == this.paramPrecision[index - 1] && (rc2 = this.SQLDescribeParam(index, this.statementHandle, this.paramType, this.paramPrecision, this.paramScale)) != 0) {
            this.preparedStmt.sqlExcptGen.check_return_code(this.preparedStmt, rc2);
        }
        return this.paramType[index - 1];
    }

    public int getPrecision(int index) throws SQLException {
        int rc2;
        if (index < 1 || index > this.paramCount) {
            this.preparedStmt.sqlExcptGen.throwParamIndexError();
        }
        if (-1 == this.paramPrecision[index - 1] && (rc2 = this.SQLDescribeParam(index, this.statementHandle, this.paramType, this.paramPrecision, this.paramScale)) != 0) {
            this.preparedStmt.sqlExcptGen.check_return_code(this.preparedStmt, rc2);
        }
        return this.paramPrecision[index - 1];
    }

    public short getScale(int index) throws SQLException {
        int rc2;
        if (index < 1 || index > this.paramCount) {
            this.preparedStmt.sqlExcptGen.throwParamIndexError();
        }
        if (-1 == this.paramPrecision[index - 1] && (rc2 = this.SQLDescribeParam(index, this.statementHandle, this.paramType, this.paramPrecision, this.paramScale)) != 0) {
            this.preparedStmt.sqlExcptGen.check_return_code(this.preparedStmt, rc2);
        }
        return this.paramScale[index - 1];
    }

    public boolean isNullable(int index) {
        return true;
    }
}

