/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class DB2InputStream
extends InputStream {
    protected int locator;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected int currentPosition;
    protected int docLength;
    protected int lobType;
    protected int marked;
    protected int bufferPos = 0;
    protected int bufferEnd = 0;
    protected static final int defaultBufferSize = 32000;
    protected byte[] buffer = null;
    protected int numBytesRead = 0;
    protected boolean closed = false;

    protected native int SQLGetLength(Integer var1, int var2, int var3, int var4);

    protected native int SQLReadArrayOfByte(byte[] var1, Integer var2, int var3, int var4, int var5, int var6);

    public DB2InputStream() {
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DB2InputStream(DB2Statement stmt, int loc, int type) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2InputStream( stmt, " + loc + ", " + type + " )");
            }
            this.connection = stmt.getDB2Connection();
            this.statement = this.connection.getInputStreamStmt();
            this.locator = loc;
            this.currentPosition = 1;
            this.marked = 1;
            this.lobType = type;
            Integer rcObj = new Integer(0);
            DB2Statement dB2Statement = this.statement;
            synchronized (dB2Statement) {
                int rc2;
                this.docLength = this.SQLGetLength(rcObj, this.lobType, this.locator, this.statement.statementHandle);
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "docLength", this.docLength);
                }
                if ((rc2 = rcObj.intValue()) != 0) {
                    this.connection.sqlExcptGen.check_return_code(this.statement, rc2);
                }
            }
            this.closed = false;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "DB2InputStream()");
            }
        }
    }

    protected boolean hasMore() {
        return this.currentPosition <= this.docLength;
    }

    public int available() throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        int bytesAvailable = 0;
        if (this.buffer != null) {
            bytesAvailable = this.bufferEnd - this.bufferPos;
        }
        if (this.currentPosition <= this.docLength) {
            bytesAvailable += this.docLength - this.currentPosition + 1;
        }
        return bytesAvailable;
    }

    public synchronized int read() throws IOException {
        byte[] b2;
        int rc2;
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "read()");
        }
        int retValue = (rc2 = this.read(b2 = new byte[1])) == -1 ? rc2 : (b2[0] < 0 ? b2[0] + 256 : b2[0]);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "read()", retValue);
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b2) throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        int bytesRead = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "read( b )");
            }
            if (this.available() == 0) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(5, "No more data available from the database");
                }
                bytesRead = -1;
            } else {
                int bytesAvailable;
                int bytesToRead = b2.length;
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "bytesToRead", bytesToRead);
                }
                if (this.buffer != null) {
                    bytesAvailable = this.bufferEnd - this.bufferPos;
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "bytesAvailable", bytesAvailable);
                    }
                    if (bytesAvailable != 0) {
                        if (bytesToRead <= bytesAvailable) {
                            System.arraycopy(this.buffer, this.bufferPos, b2, 0, bytesToRead);
                            this.bufferPos += bytesToRead;
                            bytesRead = bytesToRead;
                            bytesToRead = 0;
                        } else {
                            System.arraycopy(this.buffer, this.bufferPos, b2, 0, bytesAvailable);
                            this.bufferPos += bytesAvailable;
                            bytesRead = bytesAvailable;
                            bytesToRead -= bytesAvailable;
                        }
                    }
                }
                if (bytesToRead != 0) {
                    this.buffer = new byte[Math.min(this.docLength - this.currentPosition + 1, Math.max(32000, bytesToRead))];
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(30, "currentPosition", this.currentPosition);
                        DB2Trace.data(30, "bytesToRead", bytesToRead);
                        DB2Trace.data(30, "buffer.length", this.buffer.length);
                    }
                    bytesAvailable = 0;
                    if (this.buffer.length != 0) {
                        Integer rcObj = new Integer(0);
                        try {
                            this.numBytesRead = 0;
                            DB2Statement dB2Statement = this.statement;
                            synchronized (dB2Statement) {
                                bytesAvailable = this.SQLReadArrayOfByte(this.buffer, rcObj, this.lobType, this.locator, this.currentPosition, this.statement.statementHandle);
                                int rc2 = rcObj;
                                if (rc2 != 0) {
                                    this.connection.sqlExcptGen.check_return_code(this.statement, rc2);
                                }
                            }
                            this.currentPosition += this.numBytesRead;
                            if (this.lobType == -351) {
                                String str = null;
                                String osArch = System.getProperty("os.arch");
                                str = osArch.indexOf("86") == -1 && osArch.indexOf("ia64") == -1 ? new String(this.buffer, 0, bytesAvailable, "UnicodeBig") : new String(this.buffer, 0, bytesAvailable, "UnicodeLittle");
                                this.buffer = str.getBytes();
                                bytesAvailable = this.buffer.length;
                            }
                        }
                        catch (SQLException e2) {
                            throw new IOException(e2.toString());
                        }
                    }
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(40, "bytesAvailable", bytesAvailable);
                    }
                    this.bufferPos = 0;
                    this.bufferEnd = bytesAvailable;
                    if (bytesAvailable != 0) {
                        if (bytesToRead <= bytesAvailable) {
                            System.arraycopy(this.buffer, this.bufferPos, b2, bytesRead, bytesToRead);
                            this.bufferPos += bytesToRead;
                            bytesRead += bytesToRead;
                        } else {
                            System.arraycopy(this.buffer, this.bufferPos, b2, bytesRead, bytesAvailable);
                            this.bufferPos += bytesAvailable;
                            bytesRead += bytesAvailable;
                        }
                    }
                }
            }
            int n2 = bytesRead;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "read()", bytesRead);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(byte[] b2, int offset, int len) throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        int numRead = -1;
        try {
            byte[] buf;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "read( b, " + offset + ", " + len + " )");
            }
            if ((numRead = this.read(buf = new byte[len])) != -1) {
                System.arraycopy(buf, 0, b2, offset, numRead);
            }
            int n2 = numRead;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "read()", numRead);
            }
        }
    }

    public synchronized long skip(long n2) throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        if (this.buffer != null && n2 >= (long)(this.bufferEnd - this.bufferPos)) {
            this.buffer = null;
            n2 -= (long)(this.bufferEnd - this.bufferPos);
        }
        if (this.buffer == null) {
            if (this.currentPosition + (int)n2 > this.docLength) {
                this.currentPosition = this.docLength + 1;
                n2 = this.docLength - this.currentPosition;
            } else {
                this.currentPosition += (int)n2;
            }
        }
        return n2;
    }

    public synchronized void mark(int m2) {
        this.marked = m2;
    }

    public synchronized void reset() throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        this.currentPosition = this.marked;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long getLength() throws SQLException {
        Integer rcObj = new Integer(0);
        DB2Statement dB2Statement = this.statement;
        synchronized (dB2Statement) {
            this.docLength = this.SQLGetLength(rcObj, this.lobType, this.locator, this.statement.statementHandle);
            int rc2 = rcObj;
            if (rc2 != 0) {
                this.connection.sqlExcptGen.check_return_code(this.statement, rc2);
            }
        }
        return this.docLength;
    }

    void moveTo(int pos) {
        this.currentPosition = pos < this.docLength ? pos : this.docLength;
    }
}

