/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2ColumnMappingResultSet;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2Constants;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2ResultSetTrace;
import COM.ibm.db2.jdbc.app.DB2SQLTypeMappingResultSet;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DB2DatabaseMetaData
implements DatabaseMetaData {
    protected DB2Connection connection;
    private static final String bogusSchema = new String("SysBogus");
    public int procedureResultUnknown = 0;
    public int procedureNoResult = 1;
    public int procedureReturnsResult = 2;
    public int procedureColumnUnknown = 0;
    public int procedureColumnIn = 1;
    public int procedureColumnInOut = 2;
    public int procedureColumnResult = 3;
    public int procedureColumnOut = 4;
    public int procedureColumnReturn = 5;
    int bestRowTemporary = 0;
    int bestRowTransaction = 1;
    int bestRowSession = 2;
    int bestRowUnknown = 0;
    int bestRowNotPseudo = 1;
    int bestRowPseudo = 2;
    int versionColumnUnknown = 0;
    int versionColumnNotPseudo = 1;
    int versionColumnPseudo = 2;
    int importedKeyCascade = 0;
    int importedKeyRestrict = 1;
    int importedKeySetNull = 2;
    int typeUnSearchable = 0;
    int typeSearchLikeOnly = 1;
    int typeSearchNotLike = 2;
    int typeSearchable = 3;
    short tableIndexStatistic = 0;
    short tableIndexClustered = 1;
    short tableIndexHashed = (short)2;
    short tableIndexOther = (short)3;

    public DB2DatabaseMetaData(DB2Connection c2) {
        this.connection = c2;
    }

    protected native String SQLGetStrInfo(int var1, Integer var2, int var3);

    protected native int SQLGetIntInfo(int var1, Integer var2, int var3);

    protected native int SQLGetShortInfo(int var1, Integer var2, int var3);

    protected native int SQLGetProcedures(int var1, String var2, String var3, String var4, int var5);

    protected native int SQLGetProcedureColumns(int var1, String var2, String var3, String var4, String var5, int var6);

    protected native int SQLGetTables(int var1, String var2, String var3, String var4, String var5, int var6);

    protected native int SQLGetSchemas(int var1);

    protected native int SQLGetCatalogs(int var1);

    protected native int SQLGetTableTypes(int var1);

    protected native int SQLGetColumns(int var1, String var2, String var3, String var4, String var5, int var6);

    protected native int SQLGetColumnPrivileges(int var1, String var2, String var3, String var4, String var5, int var6);

    protected native int SQLTablePrivileges(int var1, String var2, String var3, int var4);

    protected native int SQLSpecialColumns(int var1, int var2, String var3, String var4, int var5, int var6, int var7);

    protected native int SQLPrimaryKeys(int var1, String var2, String var3, int var4);

    protected native int SQLGetTypeInfo(int var1, int var2);

    protected native int SQLStatistics(int var1, String var2, String var3, int var4, int var5, int var6);

    protected native int SQLForeignKeys(int var1, String var2, String var3, String var4, String var5, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String SQLGetStringInfo(int fInfoType) throws SQLException {
        String result;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        Integer rc2 = new Integer(0);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            result = this.SQLGetStrInfo(fInfoType, rc2, this.connection.connectionHandle);
        }
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.connection, rcValue);
        }
        return result;
    }

    protected int SQLGetIntegerInfo(int fInfoType) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        Integer rc2 = new Integer(0);
        int result = this.SQLGetIntInfo(fInfoType, rc2, this.connection.connectionHandle);
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.connection, rcValue);
        }
        return result;
    }

    protected short getShortInfo(int fInfoType) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        Integer rc2 = new Integer(0);
        short result = (short)this.SQLGetShortInfo(fInfoType, rc2, this.connection.connectionHandle);
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.connection, rcValue);
        }
        return result;
    }

    protected boolean SQLGetBooleanInfo(int fInfoType) throws SQLException {
        String result = this.SQLGetStringInfo(fInfoType);
        return result.equals("Y");
    }

    protected boolean SQLGetBooleanInfo(int fInfoType, int bitmask) throws SQLException {
        int result = this.SQLGetIntegerInfo(fInfoType);
        return (result & bitmask) > 0;
    }

    protected boolean SQLCompShort(int fInfoType, int expected) throws SQLException {
        short result = this.getShortInfo(fInfoType);
        return result == expected;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return this.SQLGetBooleanInfo(20);
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return this.SQLGetBooleanInfo(19);
    }

    public String getURL() throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        return "jdbc:deprecated-db2:" + this.connection.getSource();
    }

    public String getUserName() throws SQLException {
        return this.SQLGetStringInfo(47);
    }

    public boolean isReadOnly() throws SQLException {
        return this.SQLGetBooleanInfo(25);
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return this.SQLCompShort(85, 0);
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return this.SQLCompShort(85, 1);
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.SQLCompShort(85, 2);
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.SQLCompShort(85, 4);
    }

    public String getDatabaseProductName() throws SQLException {
        return this.SQLGetStringInfo(17);
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.SQLGetStringInfo(18);
    }

    public String getDriverName() throws SQLException {
        return "IBM DB2 JDBC 2.0 Type 2";
    }

    public String getDriverVersion() throws SQLException {
        return this.SQLGetStringInfo(7);
    }

    public int getDriverMajorVersion() {
        return 9;
    }

    public int getDriverMinorVersion() {
        return 5;
    }

    public boolean usesLocalFiles() throws SQLException {
        return this.SQLCompShort(84, 2);
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return this.SQLCompShort(84, 1);
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.getShortInfo(28) == 3;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.getShortInfo(28) == 1;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.getShortInfo(28) == 2;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.getShortInfo(28) == 4;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.getShortInfo(93) == 3;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.getShortInfo(93) == 1;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.getShortInfo(93) == 2;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.getShortInfo(93) == 4;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return this.SQLGetStringInfo(29);
    }

    public String getSQLKeywords() throws SQLException {
        String s2 = this.SQLGetStringInfo(89);
        if (s2.indexOf("INDEX") == -1) {
            s2 = s2.concat(",INDEX");
        }
        return s2;
    }

    public String getNumericFunctions() throws SQLException {
        int bitmask = this.SQLGetIntegerInfo(49);
        StringBuffer strb = new StringBuffer();
        for (int i2 = 0; i2 < DB2Constants.SQL_FN_NUM_MAPPING.length; ++i2) {
            if (DB2Constants.SQL_FN_NUM_MAPPING[i2].bitMask != (bitmask & DB2Constants.SQL_FN_NUM_MAPPING[i2].bitMask)) continue;
            strb.append(',');
            strb.append(DB2Constants.SQL_FN_NUM_MAPPING[i2].nameStr);
        }
        String str = strb.toString();
        if (',' == str.charAt(0)) {
            return str.substring(1);
        }
        return str;
    }

    public String getStringFunctions() throws SQLException {
        int bitmask = this.SQLGetIntegerInfo(50);
        StringBuffer strb = new StringBuffer();
        for (int i2 = 0; i2 < DB2Constants.SQL_FN_STR_MAPPING.length; ++i2) {
            if (DB2Constants.SQL_FN_STR_MAPPING[i2].bitMask != (bitmask & DB2Constants.SQL_FN_STR_MAPPING[i2].bitMask)) continue;
            strb.append(',');
            strb.append(DB2Constants.SQL_FN_STR_MAPPING[i2].nameStr);
        }
        String str = strb.toString();
        if (',' == str.charAt(0)) {
            return str.substring(1);
        }
        return str;
    }

    public String getSystemFunctions() throws SQLException {
        int bitmask = this.SQLGetIntegerInfo(51);
        StringBuffer strb = new StringBuffer();
        for (int i2 = 0; i2 < DB2Constants.SQL_FN_SYS_MAPPING.length; ++i2) {
            if (DB2Constants.SQL_FN_SYS_MAPPING[i2].bitMask != (bitmask & DB2Constants.SQL_FN_SYS_MAPPING[i2].bitMask)) continue;
            strb.append(',');
            strb.append(DB2Constants.SQL_FN_SYS_MAPPING[i2].nameStr);
        }
        String str = strb.toString();
        if (',' == str.charAt(0)) {
            return str.substring(1);
        }
        return str;
    }

    public String getTimeDateFunctions() throws SQLException {
        int bitmask = this.SQLGetIntegerInfo(52);
        StringBuffer strb = new StringBuffer();
        for (int i2 = 0; i2 < DB2Constants.SQL_FN_TD_MAPPING.length; ++i2) {
            if (DB2Constants.SQL_FN_TD_MAPPING[i2].bitMask != (bitmask & DB2Constants.SQL_FN_TD_MAPPING[i2].bitMask)) continue;
            strb.append(',');
            strb.append(DB2Constants.SQL_FN_TD_MAPPING[i2].nameStr);
        }
        String str = strb.toString();
        if (',' == str.charAt(0)) {
            return str.substring(1);
        }
        return str;
    }

    public String getSearchStringEscape() throws SQLException {
        return this.SQLGetStringInfo(14);
    }

    public String getExtraNameCharacters() throws SQLException {
        return this.SQLGetStringInfo(94);
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return this.SQLGetBooleanInfo(86, 1);
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return this.SQLGetBooleanInfo(86, 2);
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return this.SQLGetBooleanInfo(87);
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return this.SQLCompShort(22, 0);
    }

    public boolean supportsConvert() throws SQLException {
        return this.SQLGetBooleanInfo(48, 1);
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        fromType = DB2Constants.mapJDBCTypeToCLIConvertType(fromType);
        toType = DB2Constants.mapJDBCTypeToCLIConvertBitMask(toType);
        return this.SQLGetBooleanInfo(fromType, toType);
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return !this.SQLCompShort(74, 0);
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return this.SQLCompShort(74, 1);
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return this.SQLGetBooleanInfo(27);
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return !this.SQLGetBooleanInfo(90);
    }

    public boolean supportsGroupBy() throws SQLException {
        return !this.SQLCompShort(88, 0);
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.SQLCompShort(88, 3);
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return this.SQLCompShort(88, 2);
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return this.SQLGetBooleanInfo(113);
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return this.SQLGetBooleanInfo(36);
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return this.SQLGetBooleanInfo(37);
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return this.SQLCompShort(75, 1);
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        short result = this.getShortInfo(15);
        return 0 == result || 1 == result || 2 == result;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        short result = this.getShortInfo(15);
        return 1 == result || 2 == result;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        short result = this.getShortInfo(15);
        return 2 == result;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        String driverver = this.getDriverVersion();
        int majorversion = new Integer(driverver.substring(0, 2));
        return majorversion >= 3;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return this.SQLGetBooleanInfo(73);
    }

    public boolean supportsOuterJoins() throws SQLException {
        return !this.SQLGetStringInfo(38).equals("N");
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return this.SQLGetBooleanInfo(115, 4);
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        String resval = this.SQLGetStringInfo(38);
        return resval.equals("P") || resval.equals("Y");
    }

    public String getSchemaTerm() throws SQLException {
        return this.SQLGetStringInfo(39);
    }

    public String getProcedureTerm() throws SQLException {
        return this.SQLGetStringInfo(40);
    }

    public String getCatalogTerm() throws SQLException {
        return this.SQLGetStringInfo(42);
    }

    public boolean isCatalogAtStart() throws SQLException {
        return this.SQLCompShort(114, 1);
    }

    public String getCatalogSeparator() throws SQLException {
        return this.SQLGetStringInfo(41);
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return this.SQLGetBooleanInfo(91, 1);
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return this.SQLGetBooleanInfo(91, 2);
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return this.SQLGetBooleanInfo(91, 4);
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return this.SQLGetBooleanInfo(91, 8);
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return this.SQLGetBooleanInfo(91, 16);
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return this.SQLGetBooleanInfo(92, 1);
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return this.SQLGetBooleanInfo(92, 2);
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return this.SQLGetBooleanInfo(92, 4);
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return this.SQLGetBooleanInfo(92, 8);
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return this.SQLGetBooleanInfo(92, 16);
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return this.SQLGetBooleanInfo(80, 1);
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return this.SQLGetBooleanInfo(80, 2);
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return this.SQLGetBooleanInfo(80, 4);
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return this.SQLGetBooleanInfo(21);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return this.SQLGetBooleanInfo(95, 1);
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return this.SQLGetBooleanInfo(95, 2);
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return this.SQLGetBooleanInfo(95, 4);
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return this.SQLGetBooleanInfo(95, 8);
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return this.SQLGetBooleanInfo(95, 16);
    }

    public boolean supportsUnion() throws SQLException {
        return this.SQLGetBooleanInfo(96, 1);
    }

    public boolean supportsUnionAll() throws SQLException {
        return this.SQLGetBooleanInfo(95, 2);
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return this.SQLCompShort(23, 2);
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return this.SQLCompShort(24, 2);
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        short result = this.getShortInfo(23);
        return result == 2 || result == 1;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        short result = this.getShortInfo(24);
        return result == 2 || result == 1;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.SQLGetIntegerInfo(112);
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return this.SQLGetIntegerInfo(108);
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.getShortInfo(30);
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.getShortInfo(97);
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return this.getShortInfo(98);
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.getShortInfo(99);
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return this.getShortInfo(100);
    }

    public int getMaxColumnsInTable() throws SQLException {
        return this.getShortInfo(101);
    }

    public int getMaxConnections() throws SQLException {
        return this.getShortInfo(0);
    }

    public int getMaxCursorNameLength() throws SQLException {
        return this.getShortInfo(31);
    }

    public int getMaxIndexLength() throws SQLException {
        return this.SQLGetIntegerInfo(102);
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.getShortInfo(32);
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.getShortInfo(33);
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return this.getShortInfo(34);
    }

    public int getMaxRowSize() throws SQLException {
        return this.SQLGetIntegerInfo(104);
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return this.SQLGetBooleanInfo(103);
    }

    public int getMaxStatementLength() throws SQLException {
        return this.SQLGetIntegerInfo(105);
    }

    public int getMaxStatements() throws SQLException {
        return this.getShortInfo(1);
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.getShortInfo(35);
    }

    public int getMaxTablesInSelect() throws SQLException {
        return this.getShortInfo(106);
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.getShortInfo(107);
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return this.SQLGetIntegerInfo(26);
    }

    public boolean supportsTransactions() throws SQLException {
        return !this.SQLCompShort(46, 0);
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return this.SQLGetBooleanInfo(72, level);
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return this.SQLCompShort(46, 2);
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.SQLCompShort(46, 1);
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.SQLCompShort(46, 3);
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return this.SQLCompShort(46, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        int rc2;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement stmt = (DB2Statement)this.connection.createStatement(true);
        if (!this.isCatalogValid(catalog) || schemaPattern != null && schemaPattern.length() == 0) {
            schemaPattern = bogusSchema;
        }
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            rc2 = this.SQLGetProcedures(stmt.statementHandle, null, schemaPattern, procedureNamePattern, this.connection.connectionHandle);
        }
        if (rc2 != 0) {
            this.connection.sqlExcptGen.check_return_code(stmt, rc2);
        }
        DB2ResultSet newRS = DB2Trace.TraceOn ? new DB2ResultSetTrace(stmt, 8) : new DB2ResultSet(stmt, 8);
        return newRS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        int rc2;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement stmt = (DB2Statement)this.connection.createStatement(true);
        if (!this.isCatalogValid(catalog) || schemaPattern != null && schemaPattern.length() == 0) {
            schemaPattern = bogusSchema;
        }
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            rc2 = this.SQLGetProcedureColumns(stmt.statementHandle, null, schemaPattern, procedureNamePattern, columnNamePattern, this.connection.connectionHandle);
        }
        if (rc2 != 0) {
            this.connection.sqlExcptGen.check_return_code(stmt, rc2);
        }
        int[] typeColumns = new int[]{6};
        String[] mappedColNames = new String[13];
        mappedColNames[7] = "PRECISION";
        mappedColNames[8] = "LENGTH";
        mappedColNames[9] = "SCALE";
        mappedColNames[10] = "RADIX";
        return new DB2SQLTypeMappingResultSet(stmt, typeColumns, 13, mappedColNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        int rc2;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement stmt = (DB2Statement)this.connection.createStatement(true);
        String typeString = null;
        if (types != null) {
            StringBuffer strb = new StringBuffer();
            for (int i2 = 0; i2 < types.length; ++i2) {
                if (types[i2] == null) continue;
                strb.append('\'');
                strb.append(types[i2]);
                strb.append('\'');
                if (i2 == types.length - 1) continue;
                strb.append(',');
            }
            typeString = strb.toString();
        } else {
            typeString = new String("");
        }
        if (!this.isCatalogValid(catalog) || schemaPattern != null && schemaPattern.length() == 0) {
            schemaPattern = bogusSchema;
        }
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            rc2 = this.SQLGetTables(stmt.statementHandle, null, schemaPattern, tableNamePattern, typeString, this.connection.connectionHandle);
        }
        if (rc2 != 0) {
            this.connection.sqlExcptGen.check_return_code(stmt, rc2);
        }
        DB2ResultSet newRS = DB2Trace.TraceOn ? new DB2ResultSetTrace(stmt, 5) : new DB2ResultSet(stmt, 5);
        return newRS;
    }

    public ResultSet getSchemas() throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement stmt = (DB2Statement)this.connection.createStatement(true);
        int rc2 = this.SQLGetSchemas(stmt.statementHandle);
        if (rc2 != 0) {
            this.connection.sqlExcptGen.check_return_code(stmt, rc2);
        }
        int[] map = new int[]{2};
        return new DB2ColumnMappingResultSet(stmt, map);
    }

    public ResultSet getCatalogs() throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement stmt = (DB2Statement)this.connection.createStatement(true);
        int rc2 = this.SQLGetCatalogs(stmt.statementHandle);
        if (rc2 != 0) {
            this.connection.sqlExcptGen.check_return_code(stmt, rc2);
        }
        DB2ResultSet newRS = DB2Trace.TraceOn ? new DB2ResultSetTrace(stmt, 1) : new DB2ResultSet(stmt, 1);
        return newRS;
    }

    public ResultSet getTableTypes() throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement stmt = (DB2Statement)this.connection.createStatement(true);
        int rc2 = this.SQLGetTableTypes(stmt.statementHandle);
        if (rc2 != 0) {
            this.connection.sqlExcptGen.check_return_code(stmt, rc2);
        }
        int[] map = new int[]{4};
        return new DB2ColumnMappingResultSet(stmt, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        int rc2;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement stmt = (DB2Statement)this.connection.createStatement(true);
        if (!this.isCatalogValid(catalog) || schemaPattern != null && schemaPattern.length() == 0) {
            schemaPattern = bogusSchema;
        }
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            rc2 = this.SQLGetColumns(stmt.statementHandle, null, schemaPattern, tableNamePattern, columnNamePattern, this.connection.connectionHandle);
        }
        if (rc2 != 0) {
            this.connection.sqlExcptGen.check_return_code(stmt, rc2);
        }
        int[] typeColumns = new int[]{5};
        return new DB2SQLTypeMappingResultSet(stmt, typeColumns, 18);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        int rc2;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement stmt = (DB2Statement)this.connection.createStatement(true);
        if (!this.isCatalogValid(catalog) || schema != null && schema.length() == 0) {
            schema = bogusSchema;
        }
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            rc2 = this.SQLGetColumnPrivileges(stmt.statementHandle, null, schema, table, columnNamePattern, this.connection.connectionHandle);
        }
        if (rc2 != 0) {
            this.connection.sqlExcptGen.check_return_code(stmt, rc2);
        }
        DB2ResultSet newRS = DB2Trace.TraceOn ? new DB2ResultSetTrace(stmt, 8) : new DB2ResultSet(stmt, 8);
        return newRS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        int rc2;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement stmt = (DB2Statement)this.connection.createStatement(true);
        if (!this.isCatalogValid(catalog) || schemaPattern != null && schemaPattern.length() == 0) {
            schemaPattern = bogusSchema;
        }
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            rc2 = this.SQLTablePrivileges(stmt.statementHandle, schemaPattern, tableNamePattern, this.connection.connectionHandle);
        }
        if (rc2 != 0) {
            this.connection.sqlExcptGen.check_return_code(stmt, rc2);
        }
        DB2ResultSet newRS = DB2Trace.TraceOn ? new DB2ResultSetTrace(stmt, 7) : new DB2ResultSet(stmt, 7);
        return newRS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        int rc2;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement stmt = (DB2Statement)this.connection.createStatement(true);
        int nulls = nullable ? 1 : 0;
        if (!this.isCatalogValid(catalog) || schema != null && schema.length() == 0) {
            schema = bogusSchema;
        }
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            rc2 = this.SQLSpecialColumns(stmt.statementHandle, 1, schema, table, scope, nulls, this.connection.connectionHandle);
        }
        if (rc2 != 0) {
            this.connection.sqlExcptGen.check_return_code(stmt, rc2);
        }
        int[] typeColumns = new int[]{3};
        return new DB2SQLTypeMappingResultSet(stmt, typeColumns, 8);
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        int rc2;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement stmt = (DB2Statement)this.connection.createStatement(true);
        if (!this.isCatalogValid(catalog) || schema != null && schema.length() == 0) {
            schema = bogusSchema;
        }
        if ((rc2 = this.SQLSpecialColumns(stmt.statementHandle, 2, schema, table, 0, 0, this.connection.connectionHandle)) != 0) {
            this.connection.sqlExcptGen.check_return_code(stmt, rc2);
        }
        int[] typeColumns = new int[]{3};
        return new DB2SQLTypeMappingResultSet(stmt, typeColumns, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        int rc2;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement stmt = (DB2Statement)this.connection.createStatement(true);
        if (!this.isCatalogValid(catalog) || schema != null && schema.length() == 0) {
            schema = bogusSchema;
        }
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            rc2 = this.SQLPrimaryKeys(stmt.statementHandle, schema, table, this.connection.connectionHandle);
        }
        if (rc2 != 0) {
            this.connection.sqlExcptGen.check_return_code(stmt, rc2);
        }
        DB2ResultSet newRS = DB2Trace.TraceOn ? new DB2ResultSetTrace(stmt, 6) : new DB2ResultSet(stmt, 6);
        return newRS;
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getCrossReference(catalog, null, null, catalog, schema, table);
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getCrossReference(catalog, schema, table, catalog, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        int rc2;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement stmt = (DB2Statement)this.connection.createStatement(true);
        if (!this.isCatalogValid(primaryCatalog) || primarySchema != null && primarySchema.length() == 0) {
            primarySchema = bogusSchema;
        }
        if (!this.isCatalogValid(foreignCatalog) || foreignSchema != null && foreignSchema.length() == 0) {
            foreignSchema = bogusSchema;
        }
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            rc2 = this.SQLForeignKeys(stmt.statementHandle, primarySchema, primaryTable, foreignSchema, foreignTable, this.connection.connectionHandle);
        }
        if (rc2 != 0) {
            this.connection.sqlExcptGen.check_return_code(stmt, rc2);
        }
        DB2ResultSet newRS = DB2Trace.TraceOn ? new DB2ResultSetTrace(stmt, 14) : new DB2ResultSet(stmt, 14);
        return newRS;
    }

    public ResultSet getTypeInfo() throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement stmt = (DB2Statement)this.connection.createStatement(true);
        int rc2 = this.SQLGetTypeInfo(stmt.statementHandle, 0);
        if (rc2 != 0) {
            this.connection.sqlExcptGen.check_return_code(stmt, rc2);
        }
        int[] typeColumns = new int[]{2};
        String[] mappedColNames = new String[18];
        mappedColNames[2] = "PRECISION";
        mappedColNames[11] = "AUTO_INCREMENT";
        return new DB2SQLTypeMappingResultSet(stmt, typeColumns, 18, mappedColNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        int rc2;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement stmt = (DB2Statement)this.connection.createStatement(true);
        int iUnique = unique ? 0 : 1;
        if (!this.isCatalogValid(catalog) || schema != null && schema.length() == 0) {
            schema = bogusSchema;
        }
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            rc2 = this.SQLStatistics(stmt.statementHandle, schema, table, iUnique, 0, this.connection.connectionHandle);
        }
        if (rc2 != 0) {
            this.connection.sqlExcptGen.check_return_code(stmt, rc2);
        }
        DB2ResultSet newRS = DB2Trace.TraceOn ? new DB2ResultSetTrace(stmt, 13) : new DB2ResultSet(stmt, 13);
        return newRS;
    }

    private boolean isCatalogValid(String catalog) {
        int l2;
        if (catalog == null || (l2 = catalog.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < l2; ++i2) {
            if (catalog.charAt(i2) == '%') continue;
            return false;
        }
        return true;
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return 1003 == type || 1004 == type;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return 1007 == concurrency && (1003 == type || 1004 == type);
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        String tableName = null;
        switch (this.connection.getHostType()) {
            case 1: 
            case 2: {
                tableName = "SYSIBM.SYSDUMMY1";
                break;
            }
            case 3: {
                tableName = "QSYS2.QSQPTABL";
                break;
            }
            case 4: {
                tableName = "SYSTEM.SYSOPTIONS";
            }
        }
        DB2Statement stmt = (DB2Statement)this.connection.createStatement(true);
        char[] c2 = new char[254];
        for (int i2 = 0; i2 < c2.length; ++i2) {
            c2[i2] = 97;
        }
        String s128 = new String(c2, 0, 128);
        String s254 = new String(c2, 0, 254);
        String query = "SELECT '" + s128 + "' as TYPE_CAT," + " '" + s128 + "' as TYPE_SCHEM," + " '" + s128 + "' as TYPE_NAME," + " '" + s254 + "' as CLASS_NAME," + " 'JAVA_OBJECT' as DATA_TYPE, " + " '" + s254 + "' as REMARKS " + " FROM " + tableName + " WHERE 1=0";
        ResultSet rs = stmt.executeQuery(query);
        return rs;
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public ResultSet getSuperTypes(String catalog, String schema, String typeName) throws SQLException {
        this.connection.sqlExcptGen.throwNotSupportedByDB2("getSuperTypes");
        return null;
    }

    public ResultSet getSuperTables(String catalog, String schema, String typeName) throws SQLException {
        this.connection.sqlExcptGen.throwNotSupportedByDB2("getSuperTables");
        return null;
    }

    public ResultSet getAttributes(String catalog, String schema, String typeName, String attribute) throws SQLException {
        this.connection.sqlExcptGen.throwNotSupportedByDB2("getAttributes");
        return null;
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        this.connection.sqlExcptGen.throwNotSupportedByDB2("getResultSetHoldability");
        return 0;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        this.connection.sqlExcptGen.throwNotSupportedByDB2("getDatabaseMajorVersion");
        return 0;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        this.connection.sqlExcptGen.throwNotSupportedByDB2("getDatabaseMinorVersion");
        return 0;
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 2;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 1;
    }

    public int getSQLStateType() throws SQLException {
        return 1;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        this.connection.sqlExcptGen.throwNotSupportedByDB2("locatorsUpdateCopy");
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }
}

