/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2CharReader;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2InputStream;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class DB2Clob
implements Clob {
    protected int locator;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected int lobType;
    protected boolean closed = false;
    protected long cachedLength = -1L;
    protected int[] retCode = new int[1];
    protected String data = null;
    protected final String freeMe = "FREE LOCATOR ?";

    protected native int SQLGetStrPosition(int var1, int var2, int var3, String var4, int var5, int var6, int[] var7);

    protected native int SQLGetClobPosition(int var1, int var2, int var3, int var4, int var5, int var6, int[] var7);

    protected native long SQLGetLength(int var1, int var2, int var3, int[] var4);

    protected native String SQLGetClobSubString(int var1, int var2, int var3, long var4, int var6, int[] var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DB2Clob(DB2Statement stmt, int loc, int type) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2Clob( stmt, " + loc + ", " + type + " )");
            }
            this.locator = loc;
            this.lobType = type;
            this.connection = (DB2Connection)stmt.getConnection();
            this.statement = this.connection.getInputStreamStmt();
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "DB2Clob()");
            }
        }
    }

    public DB2Clob(String s2) {
        this.data = null == s2 ? new String() : s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "close()");
            }
            this.closed = true;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "close()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "finalize()");
            }
            this.close();
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "finalize()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        this.retCode[0] = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "length()");
            }
            if (this.cachedLength < 0L) {
                if (this.data != null) {
                    this.cachedLength = this.data.length();
                } else {
                    this.cachedLength = this.SQLGetLength(this.statement.statementHandle, this.locator, this.lobType, this.retCode);
                    if (this.retCode[0] != 0) {
                        this.connection.sqlExcptGen.check_return_code(this.statement, this.retCode[0]);
                    }
                }
            }
            long l2 = this.cachedLength;
            return l2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "length()", this.cachedLength);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubString(long pos, int length) throws SQLException {
        String string;
        block12: {
            String retValue = null;
            this.retCode[0] = 0;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "getSubString( " + pos + ", " + length + " )");
                }
                if (this.data != null) {
                    if (pos < 1L) {
                        throw new SQLException("Index out of bounds", "-99999");
                    }
                    if (pos > (long)this.data.length() || 0 == length) {
                        retValue = new String();
                    } else if (1L == pos && length >= this.data.length()) {
                        retValue = this.data;
                    } else {
                        length = (int)Math.min((long)this.data.length() - pos + 1L, (long)length);
                        retValue = this.data.substring((int)(--pos), (int)pos + length);
                    }
                } else {
                    retValue = this.SQLGetClobSubString(this.statement.statementHandle, this.lobType, this.locator, pos, length, this.retCode);
                    if (this.retCode[0] != 0) {
                        this.connection.sqlExcptGen.check_return_code(this.statement, this.retCode[0]);
                    }
                }
                string = retValue;
                if (!DB2Trace.TraceOn) break block12;
            }
            catch (Throwable throwable) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit((Object)this, "getSubString()", retValue);
                }
                throw throwable;
            }
            DB2Trace.methodExit((Object)this, "getSubString()", retValue);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getCharacterStream()");
            }
            if (this.data != null) {
                StringReader stringReader = new StringReader(this.data);
                return stringReader;
            }
            DB2CharReader dB2CharReader = new DB2CharReader(this.statement, this.lobType, this.locator);
            return dB2CharReader;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getCharacterStream()", "Reader");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getAsciiStream()");
            }
            if (this.data != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data.getBytes());
                return byteArrayInputStream;
            }
            DB2InputStream dB2InputStream = new DB2InputStream(this.statement, this.locator, this.lobType);
            return dB2InputStream;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getAsciiStream()", "InputStream");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(String searchstr, long start) throws SQLException {
        int pos = -1;
        this.retCode[0] = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "position( " + searchstr + ", " + start + " )");
            }
            if (this.data != null) {
                pos = this.data.indexOf(searchstr, (int)start - 1);
                if (-1 != pos) {
                    ++pos;
                }
            } else {
                DB2Statement dB2Statement = this.statement;
                synchronized (dB2Statement) {
                    pos = this.SQLGetStrPosition(this.statement.statementHandle, this.lobType, this.locator, searchstr, (int)start, this.connection.connectionHandle, this.retCode);
                    if (this.retCode[0] != 0) {
                        this.connection.sqlExcptGen.check_return_code(this.statement, this.retCode[0]);
                    }
                }
            }
            long l2 = pos;
            return l2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "position()", pos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(Clob searchstr, long start) throws SQLException {
        long retValue = -1L;
        this.retCode[0] = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "position( pattern, " + start + " )");
            }
            if (searchstr instanceof DB2Clob && ((DB2Clob)searchstr).data == null && this.data == null) {
                int pos = 0;
                DB2Statement dB2Statement = this.statement;
                synchronized (dB2Statement) {
                    pos = this.SQLGetClobPosition(this.statement.statementHandle, this.lobType, this.locator, ((DB2Clob)searchstr).getLocator(), (int)start, this.connection.connectionHandle, this.retCode);
                    if (this.retCode[0] != 0) {
                        this.connection.sqlExcptGen.check_return_code(this.statement, this.retCode[0]);
                    }
                }
                retValue = pos;
            } else {
                String pattern = searchstr.getSubString(1L, (int)searchstr.length());
                retValue = this.position(pattern, start);
            }
            long l2 = retValue;
            return l2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "position()", retValue);
            }
        }
    }

    int getLocator() {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getLocator()");
            DB2Trace.methodExit((Object)this, "getLocator()", this.locator);
        }
        return this.locator;
    }

    public int setString(long pos, String str) throws SQLException {
        this.connection.sqlExcptGen.throwNotSupportedByDB2("setString()");
        return 0;
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.connection.sqlExcptGen.throwNotSupportedByDB2("setString()");
        return 0;
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.connection.sqlExcptGen.throwNotSupportedByDB2("setAsciiStream()");
        return null;
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        this.connection.sqlExcptGen.throwNotSupportedByDB2("setCharacterStream()");
        return null;
    }

    public void truncate(long len) throws SQLException {
        this.connection.sqlExcptGen.throwNotSupportedByDB2("truncate()");
    }
}

