/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobWithDB2Buffer
implements Clob {
    boolean closed = false;
    int bufferPtr;
    int bufferSize;
    int bufferUsedPtr;
    int bufferType;
    int bufferCodepage;

    public ClobWithDB2Buffer(int bp2, int bs, int bup, int bt, int bcp) {
        this.bufferPtr = bp2;
        this.bufferSize = bs;
        this.bufferUsedPtr = bup;
        this.bufferType = bt;
        this.bufferCodepage = bcp;
        this.closed = false;
    }

    public void close() throws IOException {
        this.bufferPtr = 0;
        this.closed = true;
    }

    public void finalize() throws IOException {
        this.close();
    }

    public String getSubString(long pos, int length) throws SQLException {
        char[] subChar = new char[length];
        ClobWithDB2Buffer.doSubstr((int)pos - 1, subChar, 0, length, this.bufferPtr, this.bufferType, this.bufferCodepage);
        String subString = new String(subChar);
        return subString;
    }

    public Reader getCharacterStream() throws SQLException {
        long streamLength = this.length();
        String data = this.getSubString(1L, (int)streamLength);
        StringReader rd2 = new StringReader(data);
        return rd2;
    }

    public InputStream getAsciiStream() throws SQLException {
        long streamLength = this.length();
        String data = this.getSubString(1L, (int)streamLength);
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());
        return is;
    }

    public long length() throws SQLException {
        int clobLength = ClobWithDB2Buffer.getSize(this.bufferUsedPtr, this.bufferType, this.bufferCodepage);
        return clobLength;
    }

    public long position(String searchstr, long start) throws SQLException {
        long streamLength = this.length();
        String bigString = this.getSubString(1L, (int)streamLength);
        int retValue = bigString.indexOf(searchstr, (int)start - 1);
        if (retValue == -1) {
            return -1L;
        }
        return (long)retValue + 1L;
    }

    public long position(Clob searchstr, long start) throws SQLException {
        long searchLength = searchstr.length();
        String searchString = searchstr.getSubString(1L, (int)searchLength);
        long retValue = this.position(searchString, start);
        return retValue;
    }

    public static void copyClob(Clob source, Clob dis) throws SQLException {
        long srcLength = source.length();
        String srcString = source.getSubString(1L, (int)srcLength);
        char[] srcChars = new char[(int)srcLength];
        srcString.getChars(0, (int)srcLength, srcChars, 0);
        ClobWithDB2Buffer cfr_ignored_0 = (ClobWithDB2Buffer)dis;
        ClobWithDB2Buffer.doAppend(srcChars, 0, srcChars.length, ((ClobWithDB2Buffer)dis).bufferPtr, ((ClobWithDB2Buffer)dis).bufferUsedPtr, ((ClobWithDB2Buffer)dis).bufferType, ((ClobWithDB2Buffer)dis).bufferCodepage);
    }

    static native int getSize(int var0, int var1, int var2);

    static native void doAppend(char[] var0, int var1, int var2, int var3, int var4, int var5, int var6);

    static native void doSubstr(int var0, char[] var1, int var2, int var3, int var4, int var5, int var6);

    public int setString(long pos, String str) throws SQLException {
        throw new SQLException("setString() is not supported by this version of DB2 JDBC 2.0 driver");
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        throw new SQLException("setString() is not supported by this version of DB2 JDBC 2.0 driver");
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new SQLException("setAsciiStream() is not supported by this version of DB2 JDBC 2.0 driver");
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        throw new SQLException("setCharacterStream() is not supported by this version of DB2 JDBC 2.0 driver");
    }

    public void truncate(long len) throws SQLException {
        throw new SQLException("truncate() is not supported by this version of DB2 JDBC 2.0 driver");
    }
}

