/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobWithByteBuffer
implements Clob {
    protected boolean closed = false;
    protected char[] data;
    protected long dataLength;

    public ClobWithByteBuffer(char[] init) {
        this.data = init;
        this.dataLength = init.length;
        this.closed = false;
    }

    public void close() throws IOException {
        this.data = null;
        this.dataLength = 0L;
        this.closed = true;
    }

    public void finalize() throws IOException {
        this.close();
    }

    public String getSubString(long pos, int length) throws SQLException {
        String bigString = new String(this.data);
        String subString = bigString.substring((int)pos - 1, (int)pos - 1 + length);
        return subString;
    }

    public Reader getCharacterStream() throws SQLException {
        CharArrayReader rd2 = new CharArrayReader(this.data);
        return rd2;
    }

    public InputStream getAsciiStream() throws SQLException {
        String bigString = new String(this.data);
        ByteArrayInputStream is = new ByteArrayInputStream(bigString.getBytes());
        return is;
    }

    public long length() throws SQLException {
        return this.dataLength;
    }

    public long position(String searchstr, long start) throws SQLException {
        String bigString = new String(this.data);
        int retValue = bigString.indexOf(searchstr, (int)start - 1);
        if (retValue == -1) {
            return -1L;
        }
        return (long)retValue + 1L;
    }

    public long position(Clob searchstr, long start) throws SQLException {
        String smallString = searchstr.getSubString(1L, (int)searchstr.length());
        return this.position(smallString, start);
    }

    public void copyClob(Clob source) throws SQLException {
        long srcLength = source.length();
        String srcString = source.getSubString(1L, (int)srcLength);
        char[] srcChars = new char[(int)srcLength];
        srcString.getChars(0, (int)srcLength, srcChars, 0);
        this.data = srcChars;
    }

    public int setString(long pos, String str) throws SQLException {
        throw new SQLException("setString() is not supported by this version of DB2 JDBC 2.0 driver");
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        throw new SQLException("setString() is not supported by this version of DB2 JDBC 2.0 driver");
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new SQLException("setAsciiStream() is not supported by this version of DB2 JDBC 2.0 driver");
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        throw new SQLException("setCharacterStream() is not supported by this version of DB2 JDBC 2.0 driver");
    }

    public void truncate(long len) throws SQLException {
        throw new SQLException("truncate() is not supported by this version of DB2 JDBC 2.0 driver");
    }
}

