/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BlobWithDB2Buffer
implements Blob {
    public boolean closed = false;
    public int bufferPtr;
    public int bufferSize;
    public int bufferUsedType;
    public int bufferUsedPtr;

    public BlobWithDB2Buffer(int fbyte, int mLength, int dLength, int aLength) {
        this.bufferPtr = fbyte;
        this.bufferSize = mLength;
        this.bufferUsedType = dLength;
        this.bufferUsedPtr = aLength;
        this.closed = false;
    }

    public String toString() {
        String plsWork = "BufferPtr: " + this.bufferPtr + "  " + "BufferSize: " + this.bufferSize + "  " + "BufferUsedType: " + this.bufferUsedType + "  " + "BufferUsedPtr: " + this.bufferUsedPtr;
        return plsWork;
    }

    public void close() throws IOException {
        this.bufferPtr = 0;
        this.closed = true;
    }

    public void finalize() throws IOException {
        this.close();
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        byte[] subByte = new byte[length];
        BlobWithDB2Buffer.doSubstr((int)pos - 1, subByte, 0, length, this.bufferPtr);
        return subByte;
    }

    public InputStream getBinaryStream() throws SQLException {
        long streamLength = this.length();
        byte[] data = this.getBytes(1L, (int)streamLength);
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        return is;
    }

    public long length() throws SQLException {
        int blobLength = BlobWithDB2Buffer.getSize(this.bufferUsedType, this.bufferUsedPtr);
        return blobLength;
    }

    public long position(byte[] pattern, long start) throws SQLException {
        String subString;
        long length = this.length();
        byte[] bigArray = this.getBytes(1L, (int)length);
        String bigString = new String(bigArray);
        int retValue = bigString.indexOf(subString = new String(pattern), (int)start - 1);
        if (retValue == -1) {
            return -1L;
        }
        return (long)retValue + 1L;
    }

    public long position(Blob pattern, long start) throws SQLException {
        long length = pattern.length();
        byte[] b2 = pattern.getBytes(1L, (int)length);
        long retValue = this.position(b2, start);
        return retValue;
    }

    public static void copyBlob(Blob source, Blob dis) throws SQLException {
        long srcLength = source.length();
        byte[] srcArray = source.getBytes(1L, (int)srcLength);
        BlobWithDB2Buffer cfr_ignored_0 = (BlobWithDB2Buffer)dis;
        BlobWithDB2Buffer.doAppend(srcArray, 0, srcArray.length, ((BlobWithDB2Buffer)dis).bufferPtr, ((BlobWithDB2Buffer)dis).bufferUsedType, ((BlobWithDB2Buffer)dis).bufferUsedPtr);
    }

    static native int getSize(int var0, int var1);

    static native void doAppend(byte[] var0, int var1, int var2, int var3, int var4, int var5);

    static native void doSubstr(int var0, byte[] var1, int var2, int var3, int var4);

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new SQLException("setBytes() is not supported by this version of DB2 JDBC 2.0 driver");
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new SQLException("setBytes() is not supported by this version of DB2 JDBC 2.0 driver");
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLException("setBinaryStream() is not supported by this version of DB2 JDBC 2.0 driver");
    }

    public void truncate(long len) throws SQLException {
        throw new SQLException("truncate() is not supported by this version of DB2 JDBC 2.0 driver");
    }
}

