/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BlobWithByteBuffer
implements Blob {
    protected boolean closed = false;
    protected byte[] data;
    protected long dataLength;

    public BlobWithByteBuffer(byte[] init) {
        this.data = init;
        this.dataLength = init.length;
        this.closed = false;
    }

    public void close() throws IOException {
        this.data = null;
        this.dataLength = 0L;
        this.closed = true;
    }

    public void finalize() throws IOException {
        this.close();
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        byte[] subString = new byte[length];
        System.arraycopy(this.data, (int)(pos - 1L), subString, 0, length);
        return subString;
    }

    public InputStream getBinaryStream() throws SQLException {
        ByteArrayInputStream is = new ByteArrayInputStream(this.data);
        return is;
    }

    public long length() throws SQLException {
        return this.dataLength;
    }

    public long position(byte[] pattern, long start) throws SQLException {
        String bigString = new String(this.data);
        String subString = new String(pattern);
        int retValue = bigString.indexOf(subString, (int)start - 1);
        if (retValue == -1) {
            return -1L;
        }
        return (long)retValue + 1L;
    }

    public long position(Blob pattern, long start) throws SQLException {
        long length = pattern.length();
        byte[] b2 = pattern.getBytes(1L, (int)length);
        long retValue = this.position(b2, start);
        return retValue;
    }

    public void copyBlob(Blob source) throws SQLException {
        long srcLength = source.length();
        byte[] srcArray = source.getBytes(1L, (int)srcLength);
        this.data = srcArray;
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new SQLException("setBytes() is not supported by this version of DB2 JDBC 2.0 driver");
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new SQLException("setBytes() is not supported by this version of DB2 JDBC 2.0 driver");
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLException("setBinaryStream() is not supported by this version of DB2 JDBC 2.0 driver");
    }

    public void truncate(long len) throws SQLException {
        throw new SQLException("truncate() is not supported by this version of DB2 JDBC 2.0 driver");
    }
}

