/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2ReusableConnection;
import COM.ibm.db2.jdbc.app.SQLExceptionGenerator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class DB2PooledConnection
implements PooledConnection {
    protected Vector listeners = null;
    protected int hdbc = 0;
    protected boolean fConnected = false;
    protected DB2ReusableConnection conApp = null;
    protected ResourceBundle errMsgClass = null;
    protected Object sqlExcptGen;
    protected int sqlSuccess = 0;
    private String databaseName;
    private String serverName;
    private int portNumber;
    Properties info;
    private boolean fXAConnection = false;
    private int id;

    DB2PooledConnection() throws SQLException {
    }

    public DB2PooledConnection(String databaseName, Properties info) throws SQLException {
        this.initialize(databaseName, info);
    }

    public void initialize(String databaseName, Properties info) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "initialize( " + databaseName + ", info )");
        }
        this.setup();
        this.databaseName = databaseName;
        this.info = info;
        this.sqlExcptGen = new SQLExceptionGenerator(this.errMsgClass);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "initialize()");
        }
    }

    public void setup() {
        this.listeners = new Vector();
        this.errMsgClass = ResourceBundle.getBundle("COM.ibm.db2.mri.DB2ErrorMessages");
    }

    public void setID(int id2) {
        this.id = id2;
    }

    public int getID() {
        return this.id;
    }

    public Connection getConnection() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getConnection()");
            DB2Trace.data(10, "hdbc = " + this.hdbc + "; fConnected = " + this.fConnected);
        }
        DB2ReusableConnection con = null;
        if (null == this.serverName || this.portNumber <= 0) {
            this.conApp = new DB2ReusableConnection(this.databaseName, this.info, this.hdbc, this, this.fConnected);
            if (this.hdbc == 0) {
                this.hdbc = this.conApp.getHandle();
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "hdbc", this.hdbc);
                }
            }
            con = this.conApp;
            this.fConnected = true;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "getConnection()");
        }
        return con;
    }

    public void close() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "close()");
            DB2Trace.data(10, "hdbc", this.hdbc);
        }
        if ((null == this.serverName || this.portNumber <= 0) && this.conApp != null) {
            this.conApp.realClose();
        }
        this.fConnected = false;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "close()");
        }
    }

    public void backToPool() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "backToPool()");
            DB2Trace.data(10, "hdbc", this.hdbc);
        }
        Enumeration e2 = this.listeners.elements();
        while (e2.hasMoreElements()) {
            ConnectionEventListener listener = (ConnectionEventListener)e2.nextElement();
            ConnectionEvent event = new ConnectionEvent(this);
            listener.connectionClosed(event);
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "backToPool()");
        }
    }

    public void exceptionThrown(SQLException ex) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "exceptionThrown()");
            DB2Trace.data(10, "ex.getMessage()", ex.getMessage());
        }
        Enumeration e2 = this.listeners.elements();
        while (e2.hasMoreElements()) {
            ConnectionEventListener listener = (ConnectionEventListener)e2.nextElement();
            ConnectionEvent event = new ConnectionEvent(this, ex);
            listener.connectionErrorOccurred(event);
            this.printToLog("connectionErrorOccured event sent to listener: " + listener);
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "exceptionThrown()");
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.removeElement(listener);
    }

    void printToLog(String msg) {
    }
}

