/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.DBMDMapping;

public class DB2BaseConstants {
    public static final int SQL_SUCCESS = 0;
    public static final int SQL_SUCCESS_WITH_INFO = 1;
    public static final int SQL_NO_DATA_FOUND = 100;
    public static final int SQL_NEED_DATA = 99;
    public static final int SQL_NO_DATA = 100;
    public static final int SQL_STILL_EXECUTING = 2;
    public static final int SQL_ERROR = -1;
    public static final int SQL_INVALID_HANDLE = -2;
    public static final int NOT_CACHED = -99;
    public static final int NOT_ENOUGH_MEMORY = -100;
    public static final int NOT_VALID_ID = -101;
    public static final int NOT_INITIALIZED = -99999;
    public static final int JDBC_UNMATCH_BLDLVL = -111;
    public static final int JDBC_MAJOR_VERSION = 2;
    public static final int JDBC_MINOR_VERSION = 1;
    public static final int SQLJ_INTERFACE_VERSION = 1;
    public static final String JDBC_AUTHORIZATION_STRING = "ValidDb2jdTokenFromTheClientSide";
    public static final String IGNORE_STREAM_LENGTH = "DB2.ignore.stream.length";
    public static final int IGNORE_COLUMN = Integer.MAX_VALUE;
    public static final int MAX_SP_NESTING = 64;
    public static final int NO_CONVERSIONTABLE = -200;
    public static final int CONVERSIONTABLE_NOTLOADED = -201;
    public static final int SQL_NULL_DATA = -1;
    public static final int SQL_DATA_AT_EXEC = -2;
    public static final int SQL_NTS = -3;
    public static final int SQL_BLOB_LOCATOR = 31;
    public static final int SQL_CLOB_LOCATOR = 41;
    public static final int SQL_DBCLOB_LOCATOR = -351;
    public static final int SQL_C_BLOB_LOCATOR = 31;
    public static final int SQL_C_CLOB_LOCATOR = 41;
    public static final int SQL_C_DBCLOB_LOCATOR = -351;
    public static final int SQL_UNKNOWN_TYPE = 0;
    public static final int SQL_CHAR = 1;
    public static final int SQL_NUMERIC = 2;
    public static final int SQL_DECIMAL = 3;
    public static final int SQL_INTEGER = 4;
    public static final int SQL_SMALLINT = 5;
    public static final int SQL_FLOAT = 6;
    public static final int SQL_REAL = 7;
    public static final int SQL_DOUBLE = 8;
    public static final int SQL_DATE = 9;
    public static final int SQL_TIME = 10;
    public static final int SQL_TIMESTAMP = 11;
    public static final int SQL_VARCHAR = 12;
    public static final int SQL_TYPE_DATE = 91;
    public static final int SQL_TYPE_TIME = 92;
    public static final int SQL_TYPE_TIMESTAMP = 93;
    public static final int SQL_LONGVARCHAR = -1;
    public static final int SQL_BINARY = -2;
    public static final int SQL_VARBINARY = -3;
    public static final int SQL_LONGVARBINARY = -4;
    public static final int SQL_BIGINT = -5;
    public static final int SQL_TINYINT = -6;
    public static final int SQL_BIT = -7;
    public static final int SQL_WCHAR = -8;
    public static final int SQL_WVARCHAR = -9;
    public static final int SQL_WLONGVARCHAR = -10;
    public static final int SQL_GRAPHIC = -95;
    public static final int SQL_VARGRAPHIC = -96;
    public static final int SQL_LONGVARGRAPHIC = -97;
    public static final int SQL_BLOB = -98;
    public static final int SQL_CLOB = -99;
    public static final int SQL_DBCLOB = -350;
    public static final int SQL_DATALINK = -400;
    public static final int SQL_USER_DEFINED_TYPE = -450;
    public static final int DATALINK = 70;
    public static final int SQL_DB2_XML = -370;
    public static final int SQL_TYPE_BASE = 0;
    public static final int SQL_TYPE_DISTINCT = 1;
    public static final int SQL_TYPE_STRUCTURED = 2;
    public static final int SQL_TYPE_REFERENCE = 3;
    public static final int SQL_SIGNED_OFFSET = -20;
    public static final int SQL_UNSIGNED_OFFSET = -22;
    public static final int SQL_C_CHAR = 1;
    public static final int SQL_C_WCHAR = -8;
    public static final int SQL_C_LONG = 4;
    public static final int SQL_C_SHORT = 5;
    public static final int SQL_C_FLOAT = 7;
    public static final int SQL_C_DOUBLE = 8;
    public static final int SQL_C_NUMERIC = 2;
    public static final int SQL_C_DATE = 9;
    public static final int SQL_C_TIME = 10;
    public static final int SQL_C_TIMESTAMP = 11;
    public static final int SQL_C_BINARY = -2;
    public static final int SQL_C_BIT = -7;
    public static final int SQL_C_TINYINT = -6;
    public static final int SQL_C_DBCHAR = -350;
    public static final int SQL_C_SBIGINT = -25;
    public static final int SQL_C_UBIGINT = -27;
    public static final int SQL_C_DATALINK = 1;
    public static final int SQL_PARAM_TYPE_UNKNOWN = 0;
    public static final int SQL_PARAM_INPUT = 1;
    public static final int SQL_PARAM_INPUT_OUTPUT = 2;
    public static final int SQL_RESULT_COL = 3;
    public static final int SQL_PARAM_OUTPUT = 4;
    public static final int SQL_RETURN_VALUE = 5;
    public static final int SQL_ACCESS_MODE = 101;
    public static final int SQL_AUTOCOMMIT = 102;
    public static final int SQL_LOGIN_TIMEOUT = 103;
    public static final int SQL_OPT_TRACE = 104;
    public static final int SQL_OPT_TRACEFILE = 105;
    public static final int SQL_TRANSLATE_DLL = 106;
    public static final int SQL_TRANSLATE_OPTION = 107;
    public static final int SQL_TXN_ISOLATION = 108;
    public static final int SQL_CURRENT_QUALIFIER = 109;
    public static final int SQL_ODBC_CURSORS = 110;
    public static final int SQL_QUIET_MODE = 111;
    public static final int SQL_PACKET_SIZE = 112;
    public static final int SQL_CONNECT_OPT_DRVR_START = 1000;
    public static final int SQL_LONGDATA_COMPAT = 1253;
    public static final int SQL_ATTR_INFO_USERID = 1281;
    public static final int SQL_ATTR_INFO_WRKSTNNAME = 1282;
    public static final int SQL_ATTR_INFO_APPLNAME = 1283;
    public static final int SQL_ATTR_INFO_ACCTSTR = 1284;
    public static final int SQL_ATTR_INFO_PROGRAMNAME = 2516;
    public static final int SQL_ATTR_SERVER_MSGTXT_SP = 2452;
    public static final int SQL_ATTR_AUTOCOMMIT_NOCOMMIT = 2462;
    public static final int SQL_ATTR_CHAINING_BEGIN = 2464;
    public static final int SQL_ATTR_CHAINING_END = 2465;
    public static final int SQL_ATTR_QUERY_PATROLLER = 2466;
    public static final int SQL_GATEWAY_CONNECTED = 2537;
    public static final int SQL_ATTR_PING_DB = 2545;
    public static final int SQL_LD_COMPAT_YES = 1;
    public static final int SQL_LD_COMPAT_NO = 0;
    public static final int SQL_LD_COMPAT_DEFAULT = 0;
    public static final int SQL_AUTOCOMMIT_OFF = 0;
    public static final int SQL_AUTOCOMMIT_ON = 1;
    public static final int SQL_AUTOCOMMIT_DEFAULT = 1;
    public static final int SQL_MODE_READ_WRITE = 0;
    public static final int SQL_MODE_READ_ONLY = 1;
    public static final int SQL_MODE_DEFAULT = 0;
    public static final int SQL_COLUMN_COUNT = 0;
    public static final int SQL_COLUMN_NAME = 1;
    public static final int SQL_COLUMN_TYPE = 2;
    public static final int SQL_COLUMN_LENGTH = 3;
    public static final int SQL_COLUMN_PRECISION = 4;
    public static final int SQL_COLUMN_SCALE = 5;
    public static final int SQL_COLUMN_DISPLAY_SIZE = 6;
    public static final int SQL_COLUMN_NULLABLE = 7;
    public static final int SQL_COLUMN_UNSIGNED = 8;
    public static final int SQL_COLUMN_MONEY = 9;
    public static final int SQL_COLUMN_UPDATABLE = 10;
    public static final int SQL_COLUMN_AUTO_INCREMENT = 11;
    public static final int SQL_COLUMN_CASE_SENSITIVE = 12;
    public static final int SQL_COLUMN_SEARCHABLE = 13;
    public static final int SQL_COLUMN_TYPE_NAME = 14;
    public static final int SQL_COLUMN_TABLE_NAME = 15;
    public static final int SQL_COLUMN_OWNER_NAME = 16;
    public static final int SQL_COLUMN_QUALIFIER_NAME = 17;
    public static final int SQL_COLUMN_LABEL = 18;
    public static final int SQL_COLUMN_SCHEMA_NAME = 16;
    public static final int SQL_COLUMN_CATALOG_NAME = 17;
    public static final int SQL_COLUMN_DISTINCT_TYPE = 1250;
    public static final int SQL_DESC_BASE_TYPE = 1254;
    public static final int SQL_DESC_USER_DEFINED_TYPE_CODE = 1098;
    public static final int SQL_FALSE = 0;
    public static final int SQL_TRUE = 1;
    public static final int SQL_ATTR_READONLY = 0;
    public static final int SQL_ATTR_WRITE = 1;
    public static final int SQL_ATTR_READWRITE_UNKNOWN = 2;
    public static final int SQL_UNSEARCHABLE = 0;
    public static final int SQL_LIKE_ONLY = 1;
    public static final int SQL_ALL_EXCEPT_LIKE = 2;
    public static final int SQL_SEARCHABLE = 3;
    public static final int SQL_NO_NULLS = 0;
    public static final int SQL_NULLABLE = 1;
    public static final int SQL_NULLABLE_UNKNOWN = 2;
    public static final int SQL_MAXLOB = Integer.MAX_VALUE;
    public static final int SQL_MAXDECIMAL = 31;
    public static final int SQL_MAXSMALLVAL = Short.MAX_VALUE;
    public static final int SQL_MINSMALLVAL = Short.MIN_VALUE;
    public static final int SQL_MAXINTVAL = Integer.MAX_VALUE;
    public static final int SQL_MININTVAL = Integer.MIN_VALUE;
    public static final int SQL_TIME_STRLEN = 8;
    public static final int SQL_DATE_STRLEN = 10;
    public static final int SQL_STAMP_STRLEN = 26;
    public static final int SQL_ACTIVE_CONNECTIONS = 0;
    public static final int SQL_ACTIVE_STATEMENTS = 1;
    public static final int SQL_DATA_SOURCE_NAME = 2;
    public static final int SQL_DRIVER_HDBC = 3;
    public static final int SQL_DRIVER_HENV = 4;
    public static final int SQL_DRIVER_HSTMT = 5;
    public static final int SQL_DRIVER_NAME = 6;
    public static final int SQL_DRIVER_VER = 7;
    public static final int SQL_FETCH_DIRECTION = 8;
    public static final int SQL_ODBC_API_CONFORMANCE = 9;
    public static final int SQL_ODBC_VER = 10;
    public static final int SQL_ROW_UPDATES = 11;
    public static final int SQL_ODBC_SAG_CLI_CONFORMANCE = 12;
    public static final int SQL_SERVER_NAME = 13;
    public static final int SQL_SEARCH_PATTERN_ESCAPE = 14;
    public static final int SQL_ODBC_SQL_CONFORMANCE = 15;
    public static final int SQL_DATABASE_NAME = 16;
    public static final int SQL_DBMS_NAME = 17;
    public static final int SQL_DBMS_VER = 18;
    public static final int SQL_ACCESSIBLE_TABLES = 19;
    public static final int SQL_ACCESSIBLE_PROCEDURES = 20;
    public static final int SQL_PROCEDURES = 21;
    public static final int SQL_CONCAT_NULL_BEHAVIOR = 22;
    public static final int SQL_CURSOR_COMMIT_BEHAVIOR = 23;
    public static final int SQL_CURSOR_ROLLBACK_BEHAVIOR = 24;
    public static final int SQL_DATA_SOURCE_READ_ONLY = 25;
    public static final int SQL_DEFAULT_TXN_ISOLATION = 26;
    public static final int SQL_EXPRESSIONS_IN_ORDERBY = 27;
    public static final int SQL_IDENTIFIER_CASE = 28;
    public static final int SQL_IDENTIFIER_QUOTE_CHAR = 29;
    public static final int SQL_MAX_COLUMN_NAME_LEN = 30;
    public static final int SQL_MAX_CURSOR_NAME_LEN = 31;
    public static final int SQL_MAX_OWNER_NAME_LEN = 32;
    public static final int SQL_MAX_PROCEDURE_NAME_LEN = 33;
    public static final int SQL_MAX_QUALIFIER_NAME_LEN = 34;
    public static final int SQL_MAX_TABLE_NAME_LEN = 35;
    public static final int SQL_MULT_RESULT_SETS = 36;
    public static final int SQL_MULTIPLE_ACTIVE_TXN = 37;
    public static final int SQL_OUTER_JOINS = 38;
    public static final int SQL_OWNER_TERM = 39;
    public static final int SQL_PROCEDURE_TERM = 40;
    public static final int SQL_QUALIFIER_NAME_SEPARATOR = 41;
    public static final int SQL_QUALIFIER_TERM = 42;
    public static final int SQL_SCROLL_CONCURRENCY = 43;
    public static final int SQL_SCROLL_OPTIONS = 44;
    public static final int SQL_TABLE_TERM = 45;
    public static final int SQL_TXN_CAPABLE = 46;
    public static final int SQL_USER_NAME = 47;
    public static final int SQL_CONVERT_FUNCTIONS = 48;
    public static final int SQL_NUMERIC_FUNCTIONS = 49;
    public static final int SQL_STRING_FUNCTIONS = 50;
    public static final int SQL_SYSTEM_FUNCTIONS = 51;
    public static final int SQL_TIMEDATE_FUNCTIONS = 52;
    public static final int SQL_CONVERT_BIGINT = 53;
    public static final int SQL_CONVERT_BINARY = 54;
    public static final int SQL_CONVERT_BIT = 55;
    public static final int SQL_CONVERT_CHAR = 56;
    public static final int SQL_CONVERT_DATE = 57;
    public static final int SQL_CONVERT_DECIMAL = 58;
    public static final int SQL_CONVERT_DOUBLE = 59;
    public static final int SQL_CONVERT_FLOAT = 60;
    public static final int SQL_CONVERT_INTEGER = 61;
    public static final int SQL_CONVERT_LONGVARCHAR = 62;
    public static final int SQL_CONVERT_NUMERIC = 63;
    public static final int SQL_CONVERT_REAL = 64;
    public static final int SQL_CONVERT_SMALLINT = 65;
    public static final int SQL_CONVERT_TIME = 66;
    public static final int SQL_CONVERT_TIMESTAMP = 67;
    public static final int SQL_CONVERT_TINYINT = 68;
    public static final int SQL_CONVERT_VARBINARY = 69;
    public static final int SQL_CONVERT_VARCHAR = 70;
    public static final int SQL_CONVERT_LONGVARBINARY = 71;
    public static final int SQL_TXN_ISOLATION_OPTION = 72;
    public static final int SQL_ODBC_SQL_OPT_IEF = 73;
    public static final int SQL_CORRELATION_NAME = 74;
    public static final int SQL_NON_NULLABLE_COLUMNS = 75;
    public static final int SQL_DRIVER_HLIB = 76;
    public static final int SQL_DRIVER_ODBC_VER = 77;
    public static final int SQL_LOCK_TYPES = 78;
    public static final int SQL_POS_OPERATIONS = 79;
    public static final int SQL_POSITIONED_STATEMENTS = 80;
    public static final int SQL_GETDATA_EXTENSIONS = 81;
    public static final int SQL_BOOKMARK_PERSISTENCE = 82;
    public static final int SQL_STATIC_SENSITIVITY = 83;
    public static final int SQL_FILE_USAGE = 84;
    public static final int SQL_NULL_COLLATION = 85;
    public static final int SQL_ALTER_TABLE = 86;
    public static final int SQL_COLUMN_ALIAS = 87;
    public static final int SQL_GROUP_BY = 88;
    public static final int SQL_KEYWORDS = 89;
    public static final int SQL_ORDER_BY_COLUMNS_IN_SELECT = 90;
    public static final int SQL_OWNER_USAGE = 91;
    public static final int SQL_QUALIFIER_USAGE = 92;
    public static final int SQL_QUOTED_IDENTIFIER_CASE = 93;
    public static final int SQL_SPECIAL_CHARACTERS = 94;
    public static final int SQL_SUBQUERIES = 95;
    public static final int SQL_UNION = 96;
    public static final int SQL_MAX_COLUMNS_IN_GROUP_BY = 97;
    public static final int SQL_MAX_COLUMNS_IN_INDEX = 98;
    public static final int SQL_MAX_COLUMNS_IN_ORDER_BY = 99;
    public static final int SQL_MAX_COLUMNS_IN_SELECT = 100;
    public static final int SQL_MAX_COLUMNS_IN_TABLE = 101;
    public static final int SQL_MAX_INDEX_SIZE = 102;
    public static final int SQL_MAX_ROW_SIZE_INCLUDES_LONG = 103;
    public static final int SQL_MAX_ROW_SIZE = 104;
    public static final int SQL_MAX_STATEMENT_LEN = 105;
    public static final int SQL_MAX_TABLES_IN_SELECT = 106;
    public static final int SQL_MAX_USER_NAME_LEN = 107;
    public static final int SQL_MAX_CHAR_LITERAL_LEN = 108;
    public static final int SQL_TIMEDATE_ADD_INTERVALS = 109;
    public static final int SQL_TIMEDATE_DIFF_INTERVALS = 110;
    public static final int SQL_NEED_LONG_DATA_LEN = 111;
    public static final int SQL_MAX_BINARY_LITERAL_LEN = 112;
    public static final int SQL_LIKE_ESCAPE_CLAUSE = 113;
    public static final int SQL_QUALIFIER_LOCATION = 114;
    public static final int SQL_MAX_SCHEMA_NAME_LEN = 32;
    public static final int SQL_MAX_CATALOG_NAME_LEN = 34;
    public static final int SQL_NC_HIGH = 0;
    public static final int SQL_NC_LOW = 1;
    public static final int SQL_NC_START = 2;
    public static final int SQL_NC_END = 4;
    public static final int SQL_FILE_QUALIFIER = 2;
    public static final int SQL_FILE_TABLE = 1;
    public static final int SQL_AT_ADD_COLUMN = 1;
    public static final int SQL_AT_DROP_COLUMN = 2;
    public static final int SQL_GB_NOT_SUPPORTED = 0;
    public static final int SQL_GB_NO_RELATION = 3;
    public static final int SQL_GB_CONTAINS_SELECT = 2;
    public static final int SQL_NNC_NULL = 0;
    public static final int SQL_NNC_NON_NULL = 1;
    public static final int SQL_OSC_MINIMUM = 0;
    public static final int SQL_OSC_CORE = 1;
    public static final int SQL_OSC_EXTENDED = 2;
    public static final int SQL_QL_START = 1;
    public static final int SQL_OU_DML_STATEMENTS = 1;
    public static final int SQL_OU_PROCEDURE_INVOCATION = 2;
    public static final int SQL_OU_TABLE_DEFINITION = 4;
    public static final int SQL_OU_INDEX_DEFINITION = 8;
    public static final int SQL_PS_POSITIONED_DELETE = 1;
    public static final int SQL_PS_POSITIONED_UPDATE = 2;
    public static final int SQL_PS_SELECT_FOR_UPDATE = 4;
    public static final int SQL_CB_NULL = 0;
    public static final int SQL_CB_NON_NULL = 1;
    public static final int SQL_CB_DELETE = 0;
    public static final int SQL_CB_CLOSE = 1;
    public static final int SQL_CB_PRESERVE = 2;
    public static final int SQL_TC_NONE = 0;
    public static final int SQL_TC_DML = 1;
    public static final int SQL_TC_ALL = 2;
    public static final int SQL_TC_DDL_COMMIT = 3;
    public static final int SQL_TC_DDL_IGNORE = 4;
    public static final int SQL_OU_PRIVILEGE_DEFINITION = 16;
    public static final int SQL_ALL_TYPES = 0;
    public static final int SQL_INDEX_UNIQUE = 0;
    public static final int SQL_INDEX_ALL = 1;
    public static final int SQL_QUICK = 0;
    public static final int SQL_ENSURE = 1;
    public static final int SQL_BEST_ROWID = 1;
    public static final int SQL_ROWVER = 2;
    public static final int SQL_QU_DML_STATEMENTS = 1;
    public static final int SQL_QU_PROCEDURE_INVOCATION = 2;
    public static final int SQL_QU_TABLE_DEFINITION = 4;
    public static final int SQL_QU_INDEX_DEFINITION = 8;
    public static final int SQL_QU_PRIVILEGE_DEFINITION = 16;
    public static final int SQL_SQ_COMPARISON = 1;
    public static final int SQL_SQ_EXISTS = 2;
    public static final int SQL_SQ_IN = 4;
    public static final int SQL_SQ_QUANTIFIED = 8;
    public static final int SQL_SQ_CORRELATED_SUBQUERIES = 16;
    public static final int SQL_U_UNION = 1;
    public static final int SQL_U_UNION_ALL = 2;
    public static final int SQL_IC_UPPER = 1;
    public static final int SQL_IC_LOWER = 2;
    public static final int SQL_IC_SENSITIVE = 3;
    public static final int SQL_IC_MIXED = 4;
    public static final int SQL_CN_NONE = 0;
    public static final int SQL_CN_DIFFERENT = 1;
    public static final int SQL_CN_ANY = 2;
    public static final int SQL_CVT_CHAR = 1;
    public static final int SQL_CVT_NUMERIC = 2;
    public static final int SQL_CVT_DECIMAL = 4;
    public static final int SQL_CVT_INTEGER = 8;
    public static final int SQL_CVT_SMALLINT = 16;
    public static final int SQL_CVT_FLOAT = 32;
    public static final int SQL_CVT_REAL = 64;
    public static final int SQL_CVT_DOUBLE = 128;
    public static final int SQL_CVT_VARCHAR = 256;
    public static final int SQL_CVT_LONGVARCHAR = 512;
    public static final int SQL_CVT_BINARY = 1024;
    public static final int SQL_CVT_VARBINARY = 2048;
    public static final int SQL_CVT_BIT = 4096;
    public static final int SQL_CVT_TINYINT = 8192;
    public static final int SQL_CVT_BIGINT = 16384;
    public static final int SQL_CVT_DATE = 32768;
    public static final int SQL_CVT_TIME = 65536;
    public static final int SQL_CVT_TIMESTAMP = 131072;
    public static final int SQL_CVT_LONGVARBINARY = 262144;
    public static final int SQL_FN_CVT_CONVERT = 1;
    public static final int SQL_FN_STR_CONCAT = 1;
    public static final int SQL_FN_STR_INSERT = 2;
    public static final int SQL_FN_STR_LEFT = 4;
    public static final int SQL_FN_STR_LTRIM = 8;
    public static final int SQL_FN_STR_LENGTH = 16;
    public static final int SQL_FN_STR_LOCATE = 32;
    public static final int SQL_FN_STR_LCASE = 64;
    public static final int SQL_FN_STR_REPEAT = 128;
    public static final int SQL_FN_STR_REPLACE = 256;
    public static final int SQL_FN_STR_RIGHT = 512;
    public static final int SQL_FN_STR_RTRIM = 1024;
    public static final int SQL_FN_STR_SUBSTRING = 2048;
    public static final int SQL_FN_STR_UCASE = 4096;
    public static final int SQL_FN_STR_ASCII = 8192;
    public static final int SQL_FN_STR_CHAR = 16384;
    public static final int SQL_FN_STR_DIFFERENCE = 32768;
    public static final int SQL_FN_STR_LOCATE_2 = 65536;
    public static final int SQL_FN_STR_SOUNDEX = 131072;
    public static final int SQL_FN_STR_SPACE = 262144;
    public static final DBMDMapping[] SQL_FN_STR_MAPPING = new DBMDMapping[]{new DBMDMapping(1, "CONCAT"), new DBMDMapping(2, "INSERT"), new DBMDMapping(4, "LEFT"), new DBMDMapping(8, "LTRIM"), new DBMDMapping(16, "LENGTH"), new DBMDMapping(32, "LOCATE"), new DBMDMapping(64, "LCASE"), new DBMDMapping(128, "REPEAT"), new DBMDMapping(256, "REPLACE"), new DBMDMapping(512, "RIGHT"), new DBMDMapping(1024, "RTRIM"), new DBMDMapping(2048, "SUBSTRING"), new DBMDMapping(4096, "UCASE"), new DBMDMapping(8192, "ASCII"), new DBMDMapping(16384, "CHAR"), new DBMDMapping(32768, "DIFFERENCE"), new DBMDMapping(65536, "LOCATE_2"), new DBMDMapping(131072, "SOUNDEX"), new DBMDMapping(262144, "SPACE")};
    public static final int SQL_FN_NUM_ABS = 1;
    public static final int SQL_FN_NUM_ACOS = 2;
    public static final int SQL_FN_NUM_ASIN = 4;
    public static final int SQL_FN_NUM_ATAN = 8;
    public static final int SQL_FN_NUM_ATAN2 = 16;
    public static final int SQL_FN_NUM_CEILING = 32;
    public static final int SQL_FN_NUM_COS = 64;
    public static final int SQL_FN_NUM_COT = 128;
    public static final int SQL_FN_NUM_EXP = 256;
    public static final int SQL_FN_NUM_FLOOR = 512;
    public static final int SQL_FN_NUM_LOG = 1024;
    public static final int SQL_FN_NUM_MOD = 2048;
    public static final int SQL_FN_NUM_SIGN = 4096;
    public static final int SQL_FN_NUM_SIN = 8192;
    public static final int SQL_FN_NUM_SQRT = 16384;
    public static final int SQL_FN_NUM_TAN = 32768;
    public static final int SQL_FN_NUM_PI = 65536;
    public static final int SQL_FN_NUM_RAND = 131072;
    public static final int SQL_FN_NUM_DEGREES = 262144;
    public static final int SQL_FN_NUM_LOG10 = 524288;
    public static final int SQL_FN_NUM_POWER = 0x100000;
    public static final int SQL_FN_NUM_RADIANS = 0x200000;
    public static final int SQL_FN_NUM_ROUND = 0x400000;
    public static final int SQL_FN_NUM_TRUNCATE = 0x800000;
    public static final DBMDMapping[] SQL_FN_NUM_MAPPING = new DBMDMapping[]{new DBMDMapping(1, "ABS"), new DBMDMapping(2, "ACOS"), new DBMDMapping(4, "ASIN"), new DBMDMapping(8, "ATAN"), new DBMDMapping(16, "ATAN2"), new DBMDMapping(32, "CEILING"), new DBMDMapping(64, "COS"), new DBMDMapping(128, "COT"), new DBMDMapping(256, "EXP"), new DBMDMapping(512, "FLOOR"), new DBMDMapping(1024, "LOG"), new DBMDMapping(2048, "MOD"), new DBMDMapping(4096, "SIGN"), new DBMDMapping(8192, "SIN"), new DBMDMapping(16384, "SQRT"), new DBMDMapping(32768, "TAN"), new DBMDMapping(65536, "PI"), new DBMDMapping(131072, "RAND"), new DBMDMapping(262144, "DEGREES"), new DBMDMapping(524288, "LOG10"), new DBMDMapping(0x100000, "POWER"), new DBMDMapping(0x200000, "RADIANS"), new DBMDMapping(0x400000, "ROUND"), new DBMDMapping(0x800000, "TRUNCATE")};
    public static final int SQL_FN_TD_NOW = 1;
    public static final int SQL_FN_TD_CURDATE = 2;
    public static final int SQL_FN_TD_DAYOFMONTH = 4;
    public static final int SQL_FN_TD_DAYOFWEEK = 8;
    public static final int SQL_FN_TD_DAYOFYEAR = 16;
    public static final int SQL_FN_TD_MONTH = 32;
    public static final int SQL_FN_TD_QUARTER = 64;
    public static final int SQL_FN_TD_WEEK = 128;
    public static final int SQL_FN_TD_YEAR = 256;
    public static final int SQL_FN_TD_CURTIME = 512;
    public static final int SQL_FN_TD_HOUR = 1024;
    public static final int SQL_FN_TD_MINUTE = 2048;
    public static final int SQL_FN_TD_SECOND = 4096;
    public static final int SQL_FN_TD_TIMESTAMPADD = 8192;
    public static final int SQL_FN_TD_TIMESTAMPDIFF = 16384;
    public static final int SQL_FN_TD_DAYNAME = 32768;
    public static final int SQL_FN_TD_MONTHNAME = 65536;
    public static final int SQL_FN_TD_SECONDS_SINCE_MIDNIGHT = 131072;
    public static final int SQL_FN_TD_JULIAN_DAY = 262144;
    public static final DBMDMapping[] SQL_FN_TD_MAPPING = new DBMDMapping[]{new DBMDMapping(1, "NOW"), new DBMDMapping(2, "CURDATE"), new DBMDMapping(4, "DAYOFMONTH"), new DBMDMapping(8, "DAYOFWEEK"), new DBMDMapping(16, "DAYOFYEAR"), new DBMDMapping(32, "MONTH"), new DBMDMapping(64, "QUARTER"), new DBMDMapping(128, "WEEK"), new DBMDMapping(256, "YEAR"), new DBMDMapping(512, "CURTIME"), new DBMDMapping(1024, "HOUR"), new DBMDMapping(2048, "MINUTE"), new DBMDMapping(4096, "SECOND"), new DBMDMapping(8192, "TIMESTAMPADD"), new DBMDMapping(16384, "TIMESTAMPDIFF"), new DBMDMapping(32768, "DAYNAME"), new DBMDMapping(65536, "MONTHNAME"), new DBMDMapping(131072, "SECOND_SINCE_MIDNIGHT"), new DBMDMapping(262144, "JULIAN_DAY")};
    public static final int SQL_FN_SYS_USERNAME = 1;
    public static final int SQL_FN_SYS_DATABASE = 2;
    public static final int SQL_FN_SYS_IFNULL = 4;
    public static final DBMDMapping[] SQL_FN_SYS_MAPPING = new DBMDMapping[]{new DBMDMapping(1, "USERNAME"), new DBMDMapping(2, "DATABASE"), new DBMDMapping(4, "IFNULL")};
    public static final int SQL_FN_TSI_FRAC_SECOND = 1;
    public static final int SQL_FN_TSI_SECOND = 2;
    public static final int SQL_FN_TSI_MINUTE = 4;
    public static final int SQL_FN_TSI_HOUR = 8;
    public static final int SQL_FN_TSI_DAY = 16;
    public static final int SQL_FN_TSI_WEEK = 32;
    public static final int SQL_FN_TSI_MONTH = 64;
    public static final int SQL_FN_TSI_QUARTER = 128;
    public static final int SQL_FN_TSI_YEAR = 256;
    public static final int SQL_OAC_NONE = 0;
    public static final int SQL_OAC_LEVEL1 = 1;
    public static final int SQL_OAC_LEVEL2 = 2;
    public static final int SQL_OSCC_NOT_COMPLIANT = 0;
    public static final int SQL_OSCC_COMPLIANT = 1;
    public static final String DEFAULT_HOST = "cerberus";
    public static final int DEFAULT_PORT = 6789;
    public static final int COLUMNLENGTH = 4;
    public static final int TYPELENGTH = 4;
    public static final int PRECISIONLENGTH = 2;
    public static final int SCALELENGTH = 2;
    public static final short SHORTBITMASK = 255;
    public static final int INTBITMASK = 255;
    public static final long LONGBITMASK = 255L;
    public static final short SQLCONNECT = 1;
    public static final short SQLDISCONNECT = 2;
    public static final short SQLSETCONNECTOPTION = 3;
    public static final short SQLGETCONNECTOPTION = 4;
    public static final short SQLCOMMIT = 5;
    public static final short SQLROLLBACK = 6;
    public static final short SQLNATIVESQL = 7;
    public static final short SQLSETCONNECTOPTIONSTRING = 8;
    public static final short SQLRECYCLECONNECT = 9;
    public static final short GETTIMEZONEOFFSET = 10;
    public static final short SQLALLOCSTMT = 11;
    public static final short SQLEXECDIRECT = 12;
    public static final short SQLFREESTMT = 13;
    public static final short SQLMORERESULTS = 15;
    public static final short SQLGETCOUNTS = 16;
    public static final short SQLMAXFIELDSIZE = 17;
    public static final short SQLMAXROWS = 18;
    public static final short SQLSCAN = 19;
    public static final short SQLSETQUERYTIMEOUT = 20;
    public static final short SQLGETQUERYTIMEOUT = 21;
    public static final short SQLSETCURSORNAME = 22;
    public static final short SQLCANCEL = 23;
    public static final short SQLGETTYPE = 31;
    public static final short SQLGETUNICODESTRINGDATA = 32;
    public static final short SQLGETASCIISTRINGDATA = 33;
    public static final short SQLFETCH = 34;
    public static final short SQLGETSMALLINTDATA = 35;
    public static final short SQLGETINTEGERDATA = 36;
    public static final short SQLGETFLOATDATA = 37;
    public static final short SQLGETDOUBLEDATA = 38;
    public static final short SQLGETSTRINGDATA = 39;
    public static final short SQLGETBINARYDATA = 40;
    public static final short SQLGETDATEDATA = 41;
    public static final short SQLGETTIMEDATA = 42;
    public static final short SQLGETTIMESTAMPDATA = 43;
    public static final short SQLGETCURSORNAME = 44;
    public static final short SQLGETLOCATOR = 45;
    public static final short SQLGETBIGINTDATA = 46;
    public static final short SQLFREESTMT_CLOSE = 48;
    public static final short SQLNUMRESULTCOLS = 49;
    public static final short GETORIGINALDATA = 50;
    public static final short SQLGETLENGTH = 51;
    public static final short SQLREADARRAYOFBYTE = 52;
    public static final short SQLCONNECTIONERROR = 55;
    public static final short SQLSTATEMENTERROR = 56;
    public static final short SQLPREPARE = 61;
    public static final short SQLEXECUTE = 62;
    public static final short SQLBINDNULL = 63;
    public static final short SQLBINDSMALLINT = 64;
    public static final short SQLBINDINTEGER = 65;
    public static final short SQLBINDREAL = 66;
    public static final short SQLBINDDOUBLE = 67;
    public static final short SQLBINDCHAR = 68;
    public static final short SQLBINDBINARY = 69;
    public static final short SQLBINDDATE = 70;
    public static final short SQLBINDTIME = 71;
    public static final short SQLBINDTIMESTAMP = 72;
    public static final short SQLBINDNUMERIC = 73;
    public static final short SQLBINDSTREAM = 74;
    public static final short SQLPUTDATA = 75;
    public static final short SQLPARAMDATA = 76;
    public static final short SQLFREESTMT_CLEARPARAMETERS = 77;
    public static final short FREEARRAYS = 78;
    public static final short SQLEXECUTEPREPARE = 79;
    public static final short SQLJPREPARE = 209;
    public static final short SQLEXECUTECALL = 80;
    public static final short SQLPARAMDATASP = 81;
    public static final short SQLRESULTSETMETADATA = 90;
    public static final short SQLCOLATTRIBUTE_STRING = 91;
    public static final short SQLCOLATTRIBUTE_INT = 92;
    public static final short SQLGETSTRINFO = 101;
    public static final short SQLGETINTINFO = 102;
    public static final short SQLGETPROCEDURES = 103;
    public static final short SQLGETPROCEDURECOLUMNS = 104;
    public static final short SQLGETTABLES = 105;
    public static final short SQLGETSCHEMAS = 106;
    public static final short SQLGETCATALOGS = 107;
    public static final short SQLGETTABLETYPES = 108;
    public static final short SQLGETCOLUMNS = 109;
    public static final short SQLGETCOLUMNPRIVILEGES = 110;
    public static final short SQLGETTABLEPRIVILEGES = 111;
    public static final short SQLGETSPECIALCOLUMNS = 112;
    public static final short SQLGETPRIMARYKEYS = 113;
    public static final short SQLGETTYPEINFO = 114;
    public static final short SQLGETSTATISTICS = 115;
    public static final short SQLGETFOREIGNKEYS = 116;
    public static final short SQLGETSHORTINFO = 117;
    public static final short SQLTRACEJDBC = 118;
    public static final short SQLEXECBATCH = 201;
    public static final short SQLPSTMTEXECBATCH = 202;
    public static final short SQLFETCHSCROLL = 203;
    public static final short SQLREADERGETLENGTH = 204;
    public static final short SQLREADERGETSTR = 205;
    public static final short SQLCLOBGETSTRPOSITION = 206;
    public static final short SQLBLOBGETBAPOSITION = 207;
    public static final short SQLLOBGETLOCATORPOSITION = 208;
    public static final char DELIMITER = ',';
    public static final String DELIMITERSTR = ",";
    public static final int NOTCACHED = -1;
    public static final int NULLVALUE = -2;
    public static final int NOTALLOCATED = -1;
    public static final int CRS_DATA_TRUNCATED = 1;
    public static final int CRS_DATETIME_INVALIDFMT = 2;
    public static final int CRS_INVALID_CONVERSION = 3;
    public static final int CRS_NUMERIC_OUTOFRANGE = 4;
    public static final int CRS_ERROR_ASSIGNMENT = 5;
    public static final int INPUTSTREAMBUFSIZE = 32800;
    public static final int MAXCHARACTERLENGTH = 4;
    public static final byte[] TOCHAR = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    public static final int SQL_OJ_CAPABILITIES = 115;
    public static final int SQL_OJ_FULL = 4;
    public static final int SQL_FETCH_NEXT = 1;
    public static final int SQL_FETCH_FIRST = 2;
    public static final int SQL_FETCH_LAST = 3;
    public static final int SQL_FETCH_PRIOR = 4;
    public static final int SQL_FETCH_ABSOLUTE = 5;
    public static final int SQL_FETCH_RELATIVE = 6;
    public static final int SQL_DEFAULT_FETCHSIZE = 1;
    public static final int SQL_CONCUR_READ_ONLY = 1;
    public static final int SQL_CONCUR_LOCK = 2;
    public static final int SQL_PARAM_SUCCESS = 0;
    public static final int SQL_PARAM_ERROR = 5;
    public static final int SQL_PARAM_SUCCESS_WITH_INFO = 6;
    public static final int SQL_PARAM_UNUSED = 7;
    public static final int HOST_TYPE_UNKNOWN = 0;
    public static final int HOST_TYPE_UNO = 1;
    public static final int HOST_TYPE_MVS = 2;
    public static final int HOST_TYPE_AS400 = 3;
    public static final int HOST_TYPE_VM = 4;
    public static final int SQL_ATTR_CURSOR_TYPE = 6;
    public static final int SQL_CURSOR_FORWARD_ONLY = 0;
    public static final int SQL_CURSOR_KEYSET_DRIVEN = 1;
    public static final int SQL_CURSOR_DYNAMIC = 2;
    public static final int SQL_CURSOR_STATIC = 3;
    public static final int SQL_ATTR_USE_BOOKMARKS = 12;
    public static final short CLI_STMT_UNDEFINED = 0;
    public static final short CLI_STMT_ALTER_TABLE = 1;
    public static final short CLI_STMT_COMMIT = 2;
    public static final short CLI_STMT_CONNECT = 3;
    public static final short CLI_STMT_DISCONNECT = 4;
    public static final short CLI_STMT_CREATE_INDEX = 5;
    public static final short CLI_STMT_CREATE_TABLE = 6;
    public static final short CLI_STMT_CREATE_VIEW = 7;
    public static final short CLI_STMT_DELETE_SEARCHED = 8;
    public static final short CLI_STMT_DELETE_POSITIONED = 9;
    public static final short CLI_STMT_DROP_PACKAGE = 10;
    public static final short CLI_STMT_DROP_INDEX = 11;
    public static final short CLI_STMT_DROP_TABLE = 12;
    public static final short CLI_STMT_DROP_VIEW = 13;
    public static final short CLI_STMT_GRANT = 14;
    public static final short CLI_STMT_INSERT = 15;
    public static final short CLI_STMT_REVOKE = 16;
    public static final short CLI_STMT_ROLLBACK = 17;
    public static final short CLI_STMT_SELECT = 18;
    public static final short CLI_STMT_UPDATE_SEARCHED = 19;
    public static final short CLI_STMT_UPDATE_POSITIONED = 20;
    public static final short CLI_STMT_SELECT_CATALOG = 21;
    public static final short CLI_STMT_FREE_LOCATOR = 22;
    public static final short CLI_STMT_FREE_LOCATOR2 = 23;
    public static final short CLI_STMT_CALL = 24;
    public static final short CLI_STMT_COMPOUND_BEGIN_NOT_ATOMIC = 25;
    public static final short CLI_STMT_COMPOUND_BEGIN_ATOMIC = 26;
    public static final short CLI_STMT_COMPOUND_END_COMMIT = 27;
    public static final short CLI_STMT_COMPOUND_END = 28;
    public static final short CLI_STMT_SELECT_FOR_UPDATE = 29;
    public static final short CLI_STMT_WITH = 30;
    public static final short CLI_STMT_SELECT_FOR_FETCH = 31;
    public static final short CLI_STMT_VALUES = 32;
    public static final short CLI_STMT_CREATE_TABLE_IN_DATABASE = 33;
    public static final short CLI_STMT_CREATE_TRIGGER = 34;
    public static final short CLI_STMT_EXPLAIN = 35;
    public static final short CLI_STMT_VALUES_INTO = 36;
    public static final short CLI_STMT_COMPOUND_BEGIN_ATOMIC_STOP_AFTER_FIRST = 37;
    public static final short CLI_STMT_COMPOUND_BEGIN_NOT_ATOMIC_STOP_AFTER_FIRST = 38;
    public static final short CLI_STMT_SELECT_OPTIMIZE_FOR_NROWS = 39;
    public static final short CLI_STMT_SELECT_INTO = 40;
    public static final short CLI_STMT_CREATE_PROCEDURE = 41;
    public static final short CLI_STMT_CREATE_FUNCTION = 42;
    public static final short CLI_STMT_FETCH_INTO = 43;
    public static final short CLI_STMT_FETCH_USING = 44;
    public static final short CLI_STMT_INSERT_VALUES = 45;
    public static final short CLI_STMT_SET_CURRENT_QUERY_OPT = 46;
    public static final short CLI_STMT_SELECT_FETCH_FIRST_NROWS = 47;
    public static final short CLI_STMT_SELECT_FETCH_FIRST_1_ROW = 48;
    public static final short CLI_STMT_SET_SCHEMA = 49;
    public static final short CLI_STMT_SET_SQLID = 50;
    public static final short CLI_STMT_ROLLBACK_TO_SAVEPOINT = 51;
    public static final short CLI_STMT_SAVEPOINT = 52;
    public static final short CLI_STMT_CREATE_METHOD = 53;
    public static final short CLI_STMT_BEGIN_ATOMIC = 54;
    private static final short SQL_TYP_NULINC = 1;
    private static final short SQL_TYP_DATE = 384;
    private static final short SQL_TYP_NDATE = 385;
    private static final short SQL_TYP_TIME = 388;
    private static final short SQL_TYP_NTIME = 389;
    private static final short SQL_TYP_STAMP = 392;
    private static final short SQL_TYP_NSTAMP = 393;
    private static final short SQL_TYP_DATALINK = 396;
    private static final short SQL_TYP_NDATALINK = 397;
    private static final short SQL_TYP_CGSTR = 400;
    private static final short SQL_TYP_NCGSTR = 401;
    private static final short SQL_TYP_BLOB = 404;
    private static final short SQL_TYP_NBLOB = 405;
    private static final short SQL_TYP_CLOB = 408;
    private static final short SQL_TYP_NCLOB = 409;
    private static final short SQL_TYP_DBCLOB = 412;
    private static final short SQL_TYP_NDBCLOB = 413;
    private static final short SQL_TYP_VARCHAR = 448;
    private static final short SQL_TYP_NVARCHAR = 449;
    private static final short SQL_TYP_CHAR = 452;
    private static final short SQL_TYP_NCHAR = 453;
    private static final short SQL_TYP_LONG = 456;
    private static final short SQL_TYP_NLONG = 457;
    private static final short SQL_TYP_CSTR = 460;
    private static final short SQL_TYP_NCSTR = 461;
    private static final short SQL_TYP_VARGRAPH = 464;
    private static final short SQL_TYP_NVARGRAPH = 465;
    private static final short SQL_TYP_GRAPHIC = 468;
    private static final short SQL_TYP_NGRAPHIC = 469;
    private static final short SQL_TYP_LONGRAPH = 472;
    private static final short SQL_TYP_NLONGRAPH = 473;
    private static final short SQL_TYP_LSTR = 476;
    private static final short SQL_TYP_NLSTR = 477;
    private static final short SQL_TYP_FLOAT = 480;
    private static final short SQL_TYP_NFLOAT = 481;
    private static final short SQL_TYP_DECIMAL = 484;
    private static final short SQL_TYP_NDECIMAL = 485;
    private static final short SQL_TYP_ZONED = 488;
    private static final short SQL_TYP_NZONED = 489;
    private static final short SQL_TYP_BIGINT = 492;
    private static final short SQL_TYP_NBIGINT = 493;
    private static final short SQL_TYP_INTEGER = 496;
    private static final short SQL_TYP_NINTEGER = 497;
    private static final short SQL_TYP_SMALL = 500;
    private static final short SQL_TYP_NSMALL = 501;
    private static final short SQL_TYP_NUMERIC = 504;
    private static final short SQL_TYP_NNUMERIC = 505;
    private static final short SQL_TYP_BLOB_FILE_OBSOLETE = 804;
    private static final short SQL_TYP_NBLOB_FILE_OBSOLETE = 805;
    private static final short SQL_TYP_CLOB_FILE_OBSOLETE = 808;
    private static final short SQL_TYP_NCLOB_FILE_OBSOLETE = 809;
    private static final short SQL_TYP_DBCLOB_FILE_OBSOLETE = 812;
    private static final short SQL_TYP_NDBCLOB_FILE_OBSOLETE = 813;
    private static final short SQL_TYP_BLOB_FILE = 916;
    private static final short SQL_TYP_NBLOB_FILE = 917;
    private static final short SQL_TYP_CLOB_FILE = 920;
    private static final short SQL_TYP_NCLOB_FILE = 921;
    private static final short SQL_TYP_DBCLOB_FILE = 924;
    private static final short SQL_TYP_NDBCLOB_FILE = 925;
    private static final short SQL_TYP_BLOB_LOCATOR = 960;
    private static final short SQL_TYP_NBLOB_LOCATOR = 961;
    private static final short SQL_TYP_CLOB_LOCATOR = 964;
    private static final short SQL_TYP_NCLOB_LOCATOR = 965;
    private static final short SQL_TYP_DBCLOB_LOCATOR = 968;
    private static final short SQL_TYP_NDBCLOB_LOCATOR = 969;
    public static final short NOT_DESCRIBED = 0;
    public static final short DESCRIBED = 1;
    public static final short DESCRIBE_FAILED = 2;

    public static final short mapSQLJRoleToStmtType(int SQLJRole, boolean dynamicExecution, boolean supportsSelectInto) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(new DB2BaseConstants(), "mapSQLJRoleToStmtType( " + SQLJRole + ", " + dynamicExecution + " )");
        }
        short stmtType = 0;
        switch (SQLJRole) {
            case 2: 
            case 7: 
            case 8: 
            case 19: {
                if (SQLJRole == 8 && supportsSelectInto) {
                    stmtType = 40;
                    break;
                }
                stmtType = 18;
                break;
            }
            case 4: {
                stmtType = 24;
                break;
            }
            case 5: {
                stmtType = 32;
                break;
            }
            case 6: {
                if (dynamicExecution) {
                    stmtType = 20;
                    break;
                }
                stmtType = 19;
                break;
            }
            case 11: {
                stmtType = 2;
                break;
            }
            case 12: {
                stmtType = 17;
                break;
            }
            case 3: {
                stmtType = 15;
                break;
            }
            default: {
                stmtType = 0;
            }
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)new DB2BaseConstants(), "mapSQLJRoleToStmtType()", stmtType);
        }
        return stmtType;
    }

    public static final int mapSQLDATypeToCLISQLType(int SQLDAType) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(new DB2BaseConstants(), "mapSQLDATypeToCLISQLType( " + SQLDAType + " )");
        }
        int CLIType = 0;
        switch (SQLDAType) {
            case 384: 
            case 385: {
                CLIType = 91;
                break;
            }
            case 388: 
            case 389: {
                CLIType = 92;
                break;
            }
            case 392: 
            case 393: {
                CLIType = 93;
                break;
            }
            case 396: 
            case 397: {
                CLIType = -400;
                break;
            }
            case 404: 
            case 405: {
                CLIType = -98;
                break;
            }
            case 408: 
            case 409: {
                CLIType = -99;
                break;
            }
            case 412: 
            case 413: {
                CLIType = -350;
                break;
            }
            case 448: 
            case 449: {
                CLIType = 12;
                break;
            }
            case 452: 
            case 453: {
                CLIType = 1;
                break;
            }
            case 456: 
            case 457: {
                CLIType = -1;
                break;
            }
            case 464: 
            case 465: {
                CLIType = -96;
                break;
            }
            case 468: 
            case 469: {
                CLIType = -95;
                break;
            }
            case 472: 
            case 473: {
                CLIType = -97;
                break;
            }
            case 480: 
            case 481: {
                CLIType = 6;
                break;
            }
            case 484: 
            case 485: 
            case 488: 
            case 489: {
                CLIType = 3;
                break;
            }
            case 492: 
            case 493: {
                CLIType = -5;
                break;
            }
            case 496: 
            case 497: {
                CLIType = 4;
                break;
            }
            case 500: 
            case 501: {
                CLIType = 5;
                break;
            }
            case 504: 
            case 505: {
                CLIType = 2;
                break;
            }
            case 960: 
            case 961: {
                CLIType = 31;
                break;
            }
            case 964: 
            case 965: {
                CLIType = 41;
                break;
            }
            case 968: 
            case 969: {
                CLIType = -351;
                break;
            }
            default: {
                CLIType = 0;
            }
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)new DB2BaseConstants(), "mapSQLDATypeToCLISQLType()", CLIType);
        }
        return CLIType;
    }

    public static final int mapJDBCTypeToCLIConvertType(int JDBCType) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(new DB2BaseConstants(), "mapJDBCTypeToCLIConvertType( " + JDBCType + " )");
        }
        int CLIConvertType = 0;
        switch (JDBCType) {
            case -7: {
                CLIConvertType = 55;
                break;
            }
            case -6: {
                CLIConvertType = 68;
                break;
            }
            case 5: {
                CLIConvertType = 65;
                break;
            }
            case 4: {
                CLIConvertType = 61;
                break;
            }
            case -5: {
                CLIConvertType = 53;
                break;
            }
            case 6: {
                CLIConvertType = 60;
                break;
            }
            case 7: {
                CLIConvertType = 64;
                break;
            }
            case 8: {
                CLIConvertType = 59;
                break;
            }
            case 2: {
                CLIConvertType = 63;
                break;
            }
            case 3: {
                CLIConvertType = 58;
                break;
            }
            case 1: {
                CLIConvertType = 56;
                break;
            }
            case 12: {
                CLIConvertType = 70;
                break;
            }
            case -1: {
                CLIConvertType = 62;
                break;
            }
            case 91: {
                CLIConvertType = 57;
                break;
            }
            case 92: {
                CLIConvertType = 66;
                break;
            }
            case 93: {
                CLIConvertType = 67;
                break;
            }
            case -2: {
                CLIConvertType = 54;
                break;
            }
            case -3: {
                CLIConvertType = 69;
                break;
            }
            case -4: {
                CLIConvertType = 71;
                break;
            }
            default: {
                CLIConvertType = 0;
            }
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)new DB2BaseConstants(), "mapJDBCTypeToCLIConvertType()", CLIConvertType);
        }
        return CLIConvertType;
    }

    public static final int mapJDBCTypeToCLIConvertBitMask(int JDBCType) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(new DB2BaseConstants(), "mapJDBCTypeToCLIConvertBitMask( " + JDBCType + " )");
        }
        int CLIConvertBitMask = 0;
        switch (JDBCType) {
            case -7: {
                CLIConvertBitMask = 4096;
                break;
            }
            case -6: {
                CLIConvertBitMask = 8192;
                break;
            }
            case 5: {
                CLIConvertBitMask = 16;
                break;
            }
            case 4: {
                CLIConvertBitMask = 8;
                break;
            }
            case -5: {
                CLIConvertBitMask = 16384;
                break;
            }
            case 6: {
                CLIConvertBitMask = 32;
                break;
            }
            case 7: {
                CLIConvertBitMask = 64;
                break;
            }
            case 8: {
                CLIConvertBitMask = 128;
                break;
            }
            case 2: {
                CLIConvertBitMask = 2;
                break;
            }
            case 3: {
                CLIConvertBitMask = 4;
                break;
            }
            case 1: {
                CLIConvertBitMask = 1;
                break;
            }
            case 12: {
                CLIConvertBitMask = 256;
                break;
            }
            case -1: {
                CLIConvertBitMask = 512;
                break;
            }
            case 91: {
                CLIConvertBitMask = 32768;
                break;
            }
            case 92: {
                CLIConvertBitMask = 65536;
                break;
            }
            case 93: {
                CLIConvertBitMask = 131072;
                break;
            }
            case -2: {
                CLIConvertBitMask = 1024;
                break;
            }
            case -3: {
                CLIConvertBitMask = 2048;
                break;
            }
            case -4: {
                CLIConvertBitMask = 262144;
                break;
            }
            default: {
                CLIConvertBitMask = 0;
            }
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)new DB2BaseConstants(), "mapJDBCTypeToCLIConvertBitMask()", CLIConvertBitMask);
        }
        return CLIConvertBitMask;
    }
}

