/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app.classloader;

import COM.ibm.db2.app.classloader.ClassLoaderTemplate;
import COM.ibm.db2.app.classloader.ClassLoaderTracer;
import COM.ibm.db2.app.classloader.ClassProvider;
import COM.ibm.db2.app.classloader.DynamicClassLoader;
import COM.ibm.db2.app.classloader.JarDirClassProvider;
import COM.ibm.db2.app.classloader.JarFileClassProvider;
import COM.ibm.db2.app.classloader.JarFilenameFilter;
import COM.ibm.db2.app.util.InvalidationException;
import COM.ibm.db2.app.util.Validatable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class PowerClassLoader
extends ClassLoaderTemplate
implements Validatable {
    private DynamicClassLoader loader;
    private Hashtable jarFileLoaders;
    ClassLoaderTracer tracer = ClassLoaderTracer.instance();
    private Object updateSynch = new Object();
    private static boolean resourceURLsEnabled = false;

    public PowerClassLoader() {
        if (this.tracer.isTracing) {
            this.tracer.trace("PowerClassLoader::PowerClassLoader(). Empty constructor.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class loadNonSystemClass(String string) throws ClassNotFoundException {
        if (this.tracer.isTracing) {
            this.tracer.trace("PowerClassLoader::loadNonSystemClass().");
        }
        int n2 = string.lastIndexOf(58);
        Class<?> clazz = null;
        if (n2 == -1) {
            string = string.replace('/', '.');
            clazz = this.loader.loadClass(string);
        } else {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1);
            DynamicClassLoader dynamicClassLoader = (DynamicClassLoader)this.jarFileLoaders.get(string2);
            if (null != dynamicClassLoader) {
                clazz = dynamicClassLoader.loadClass(string3);
            } else {
                PowerClassLoader powerClassLoader = this;
                synchronized (powerClassLoader) {
                    dynamicClassLoader = (DynamicClassLoader)this.jarFileLoaders.get(string2);
                    if (null == dynamicClassLoader) {
                        dynamicClassLoader = this.addClassLoader(string2);
                    }
                    if (null != dynamicClassLoader) {
                        clazz = dynamicClassLoader.loadClass(string3);
                    }
                }
            }
        }
        if (this.tracer.isTracing) {
            this.tracer.trace("PowerClassLoader::loadNonSystemClass(). Returning cls = " + clazz);
        }
        return clazz;
    }

    @Override
    protected InputStream getNonSystemResourceAsStream(String string) {
        return this.loader.getResourceAsStream(string);
    }

    @Override
    protected URL getNonSystemResource(String string) {
        return this.loader.getResource(string);
    }

    @Override
    protected Enumeration findNonSystemResources(String string) {
        return this.loader.findNonSystemResources(string);
    }

    public synchronized void reload() {
        String string = this.getClassPath();
        if (this.tracer.isTracing) {
            this.tracer.trace("PowerClassLoader::reload()");
        }
        this.reload(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reload(String string) {
        Object object = this.updateSynch;
        synchronized (object) {
            if (this.tracer.isTracing) {
                this.tracer.trace("PowerClassLoader::reload(classpath). classpath = " + string);
            }
            this.loader = new DynamicClassLoader();
            this.appendPathToClassPath(string);
            this.jarFileLoaders = new Hashtable();
            if (this.tracer.isTracing) {
                this.tracer.trace("*** " + this.getClass().getName() + " was reloaded ***", 1);
                this.tracer.trace("new reloadable classpath: " + this.getClassPath(), 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendPathToClassPath(String string) {
        Object object = this.updateSynch;
        synchronized (object) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                ClassProvider classProvider = this.getClassProvider(string2);
                if (classProvider != null) continue;
                classProvider = this.createClassProvider(string2);
                if (classProvider != null) {
                    this.addClassProvider(classProvider);
                    continue;
                }
                if (!this.tracer.isTracing) continue;
                this.tracer.trace("failed to add path [" + string2 + "] to the classpath", 1);
            }
        }
    }

    public String getClassPath() {
        return this.loader.getClassPath();
    }

    @Override
    public void validate() throws InvalidationException {
        this.loader.validate();
    }

    @Override
    public boolean isValid() {
        try {
            if (this.tracer.isTracing) {
                this.tracer.trace("PowerClassLoader::isValid()");
            }
            this.validate();
            return true;
        }
        catch (InvalidationException invalidationException) {
            return false;
        }
    }

    public String getAbsoluteResourcePath(String string) {
        return this.loader.getAbsoluteResourcePath(string);
    }

    public void finalize() {
        if (this.tracer.isTracing) {
            this.tracer.trace("PowerClassLoader::finalize()");
        }
    }

    private String convertResourceName(String string) {
        string.replace('\\', '/');
        if (!string.startsWith("/")) {
            string = string + "/" + string;
        }
        return string;
    }

    private String formatPath(String string) {
        String string2 = string;
        string2 = string2.trim();
        while (string2.endsWith("/") || string2.endsWith("\\")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    protected ClassProvider getClassProvider(String string) {
        ClassProvider classProvider;
        string = this.formatPath(string);
        String string2 = null;
        Enumeration enumeration = this.loader.getClassProviders();
        if (enumeration.hasMoreElements() && (string2 = (classProvider = (ClassProvider)enumeration.nextElement()).getClassPath()).indexOf(string) != -1) {
            return classProvider;
        }
        return null;
    }

    protected ClassProvider createClassProvider(String string) {
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                return new JarDirClassProvider(file);
            }
            String string2 = file.getAbsolutePath();
            if (JarFilenameFilter.instance().accept(string2)) {
                return new JarFileClassProvider(file);
            }
        }
        return null;
    }

    private void addClassProvider(ClassProvider classProvider) {
        if (this.tracer.isTracing) {
            this.tracer.trace("PowerClassLoader:addClassProvider. add ClassProvider for path: " + classProvider.getClassPath());
        }
        this.loader.addClassProvider(classProvider);
    }

    private DynamicClassLoader addClassLoader(String string) {
        DynamicClassLoader dynamicClassLoader = new DynamicClassLoader(this.loader);
        ClassProvider classProvider = this.createClassProvider(string);
        if (classProvider != null) {
            dynamicClassLoader.addClassProvider(classProvider);
            this.jarFileLoaders.put(string, dynamicClassLoader);
            if (this.tracer.isTracing) {
                this.tracer.trace("PowerClassLoader:addClassLoader. add ClassLoader for path: " + string);
            }
            return dynamicClassLoader;
        }
        if (this.tracer.isTracing) {
            this.tracer.trace("PowerClassLoader:addClassLoader. Can't add ClassLoader for path: " + string);
        }
        return null;
    }

    private static void enableResourceURLs() {
        resourceURLsEnabled = true;
    }

    public static boolean isResourceURLsEnabled() {
        return resourceURLsEnabled;
    }
}

