/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app.classloader;

import COM.ibm.db2.app.classloader.ClassLoaderResource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

class JarResource
implements ClassLoaderResource {
    String resourceName;
    File jarFile;

    JarResource(File file, String string) {
        this.resourceName = string;
        this.jarFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() {
        ByteArrayInputStream byteArrayInputStream = null;
        JarFile jarFile = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        InputStream inputStream = null;
        if (this.resourceName.startsWith("/")) {
            this.resourceName = this.resourceName.substring(1, this.resourceName.length());
        }
        try {
            jarFile = new JarFile(this.jarFile);
            ZipEntry zipEntry = jarFile.getEntry(this.resourceName);
            if (zipEntry == null) {
                jarFile.close();
                ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
                return byteArrayInputStream2;
            }
            inputStream = jarFile.getInputStream(zipEntry);
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n2 = inputStream.read(byArray);
            while (n2 != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        catch (Exception exception) {
            byteArrayInputStream = null;
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                    byteArrayOutputStream = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (jarFile != null) {
                    jarFile.close();
                    jarFile = null;
                }
            }
            catch (Exception exception) {}
        }
        return byteArrayInputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return null;
    }

    @Override
    public long getLastModified() {
        return this.jarFile.lastModified();
    }

    @Override
    public URL getResourceURL() {
        String string = this.resourceName;
        if (string.charAt(0) != '/') {
            string = "/" + string;
        }
        try {
            String string2 = "jar:" + this.jarFile.toURL().toString() + "!" + string;
            return new URL(string2);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

