/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app.classloader;

import COM.ibm.db2.app.classloader.ClassLoaderResource;
import COM.ibm.db2.app.classloader.ClassProvider;
import COM.ibm.db2.app.classloader.JarResource;
import COM.ibm.db2.app.util.InvalidationException;
import COM.ibm.db2.app.util.Validatable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarFileClassProvider
implements ClassProvider,
Validatable {
    File jarFile;
    long timeStamp;
    private static char jarSeparatorChar = (char)47;

    public JarFileClassProvider(File file) {
        if (!file.isFile()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is not a valid jar file");
        }
        this.jarFile = file;
        this.timeStamp = this.jarFile.lastModified();
    }

    @Override
    public String getClassPath() {
        return this.jarFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getClassBytes(String string) {
        byte[] byArray = null;
        JarFile jarFile = null;
        InputStream inputStream = null;
        try {
            ZipEntry zipEntry;
            jarFile = new JarFile(this.jarFile);
            string = string.replace('.', jarSeparatorChar) + ".class";
            if (string.startsWith("/")) {
                string = string.substring(1, string.length());
            }
            if ((zipEntry = jarFile.getEntry(string)) == null) {
                jarFile.close();
                jarFile = null;
                byte[] byArray2 = null;
                return byArray2;
            }
            int n2 = (int)zipEntry.getSize();
            int n3 = 0;
            int n4 = 0;
            inputStream = jarFile.getInputStream(zipEntry);
            if (n2 > -1) {
                byArray = new byte[n2];
                while (n2 - n3 > 0 && (n4 = inputStream.read(byArray, n3, n2 - n3)) != -1) {
                    n3 += n4;
                }
                if (n2 != n3) {
                    byArray = null;
                    throw new IOException("unexpected EOF reading class: " + string);
                }
            } else {
                int n5 = 1024;
                byte[] byArray3 = new byte[n5];
                do {
                    if ((n4 = inputStream.read(byArray3, n3, n5 - n3)) == n5 - n3) {
                        byte[] byArray4 = new byte[n5 * 2];
                        System.arraycopy(byArray3, 0, byArray4, 0, n5);
                        byArray3 = byArray4;
                        byArray4 = null;
                        n5 += n5;
                    }
                    if (n4 <= 0) continue;
                    n3 += n4;
                } while (n4 != -1);
                byArray = new byte[n3];
                System.arraycopy(byArray3, 0, byArray, 0, n3);
                byArray3 = null;
            }
        }
        catch (Exception exception) {
            byArray = null;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (jarFile != null) {
                    jarFile.close();
                    jarFile = null;
                }
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    @Override
    public ClassLoaderResource getResource(String string) {
        try {
            if (this.hasResource(string)) {
                return new JarResource(this.jarFile, string);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getAbsoluteResourcePath(String string) {
        if (this.hasResource(string)) {
            return this.jarFile.getAbsolutePath();
        }
        return null;
    }

    @Override
    public boolean hasResource(String string) {
        boolean bl2 = false;
        if (string.startsWith("/")) {
            string = string.substring(1, string.length());
        }
        try {
            JarFile jarFile = new JarFile(this.jarFile);
            ZipEntry zipEntry = jarFile.getEntry(string);
            if (zipEntry != null) {
                bl2 = true;
            }
            jarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl2;
    }

    public String toString() {
        return this.getClass().getName() + " " + this.jarFile.getAbsolutePath();
    }

    @Override
    public void validate() throws InvalidationException {
        if (!this.jarFile.exists()) {
            throw new InvalidationException("JarFileClassProvider is invalid", this.jarFile.getAbsolutePath() + " has been deleted");
        }
        if (this.timeStamp != this.jarFile.lastModified()) {
            throw new InvalidationException("JarFileClassProvider is invalid", this.jarFile.getAbsolutePath() + " has been updated");
        }
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (InvalidationException invalidationException) {
            return false;
        }
    }

    @Override
    public Enumeration findResources(String string) {
        URL uRL;
        ClassLoaderResource classLoaderResource = this.getResource(string);
        Vector<URL> vector = new Vector<URL>(1);
        if (classLoaderResource != null && (uRL = classLoaderResource.getResourceURL()) != null) {
            vector.add(classLoaderResource.getResourceURL());
        }
        return vector.elements();
    }
}

