/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app.classloader;

import COM.ibm.db2.app.classloader.ClassLoaderTemplate;
import COM.ibm.db2.app.classloader.ClassLoaderTracer;
import COM.ibm.db2.app.classloader.ClassProvider;
import COM.ibm.db2.app.classloader.JarFileClassProvider;
import COM.ibm.db2.app.classloader.JarFilenameFilter;
import COM.ibm.db2.app.util.InvalidationException;
import COM.ibm.db2.app.util.Validatable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JarFileClassLoader
extends ClassLoaderTemplate
implements Validatable {
    ClassLoaderTracer tracer = ClassLoaderTracer.instance();
    Hashtable providers = new Hashtable();
    Hashtable classes = new Hashtable();

    JarFileClassLoader() {
        if (this.tracer.isTracing) {
            this.tracer.trace("JarFileClassLoader::JarFileClassLoader()");
        }
    }

    protected void addClassProvider(String string, ClassProvider classProvider) {
        if (this.tracer.isTracing) {
            this.tracer.trace("JarFileClassLoader:addClassProvider. add ClassProvider for jar: " + classProvider.getClassPath(), 1);
        }
        this.providers.put(string, classProvider);
    }

    protected ClassProvider createClassProvider(String string) {
        File file = new File(string);
        if (file.exists() && !file.isDirectory()) {
            String string2 = file.getAbsolutePath();
            if (JarFilenameFilter.instance().accept(string2)) {
                return new JarFileClassProvider(file);
            }
        }
        return null;
    }

    @Override
    protected URL getNonSystemResource(String string) {
        if (this.tracer.isTracing) {
            this.tracer.trace("getNonSystemResource: not supported" + string, 3);
        }
        return null;
    }

    @Override
    protected Enumeration findNonSystemResources(String string) {
        if (this.tracer.isTracing) {
            this.tracer.trace("getNonSystemResources: not supported" + string, 3);
        }
        return new Vector(0).elements();
    }

    @Override
    protected InputStream getNonSystemResourceAsStream(String string) {
        if (this.tracer.isTracing) {
            this.tracer.trace("getNonSystemResourceAsStream: not supported" + string, 3);
        }
        return null;
    }

    @Override
    protected Class loadNonSystemClass(String string) throws ClassNotFoundException {
        int n2 = string.lastIndexOf(58);
        if (n2 == -1) {
            throw new ClassNotFoundException(string);
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        if (this.tracer.isTracing) {
            this.tracer.trace("JarFileClassLoader:: Loading class:" + string2 + ":" + string3);
        }
        Class clazz = this.loadNonSystemClass(string2, string3);
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadNonSystemClass(String string, String string2) throws ClassNotFoundException {
        Class<?> clazz = this.getClass(string, string2 = string2.replace('/', '.'));
        if (null != clazz) {
            return clazz;
        }
        JarFileClassLoader jarFileClassLoader = this;
        synchronized (jarFileClassLoader) {
            clazz = this.getClass(string, string2);
            if (null != clazz) {
                return clazz;
            }
            byte[] byArray = null;
            ClassProvider classProvider = (ClassProvider)this.providers.get(string);
            if (classProvider == null) {
                classProvider = this.createClassProvider(string);
                if (classProvider == null) {
                    if (this.tracer.isTracing) {
                        this.tracer.trace("non-system Jar not found: " + string, 4);
                    }
                    throw new ClassNotFoundException(string + ":" + string2);
                }
                this.addClassProvider(string, classProvider);
            }
            if ((byArray = classProvider.getClassBytes(string2)) == null) {
                if (this.tracer.isTracing) {
                    this.tracer.trace("non-system class not found: " + string2, 4);
                }
                throw new ClassNotFoundException(string + ":" + string2);
            }
            if (this.tracer.isTracing) {
                this.tracer.trace("JarFileClassLoader:loadNonSystemClass. defineClass: " + string + ":" + string2, 2);
            }
            if (null == clazz) {
                clazz = this.defineClass(string2, byArray, 0, byArray.length);
                this.cacheClass(string, string2, clazz);
            }
        }
        return clazz;
    }

    @Override
    public void validate() throws InvalidationException {
        Vector vector = (Vector)this.providers.values();
        int n2 = vector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ClassProvider classProvider = (ClassProvider)vector.elementAt(i2);
            try {
                classProvider.validate();
                continue;
            }
            catch (InvalidationException invalidationException) {
                throw new InvalidationException("JarFileClassLoader is invalid", invalidationException.getDetailedMessage());
            }
        }
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (InvalidationException invalidationException) {
            this.tracer.trace("ClassLoader is invalid", invalidationException);
            return false;
        }
        return true;
    }

    protected Class getClass(String string, String string2) {
        return (Class)this.classes.get(string + ":" + string2);
    }

    protected void cacheClass(String string, String string2, Class clazz) {
        this.classes.put(string + ":" + string2, clazz);
    }

    public void finalize() {
        if (this.tracer.isTracing) {
            this.tracer.trace("PowerClassLoader::finalize()");
        }
    }
}

