/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app.classloader;

import COM.ibm.db2.app.classloader.ClassLoaderResource;
import COM.ibm.db2.app.classloader.ClassLoaderTemplate;
import COM.ibm.db2.app.classloader.ClassLoaderTracer;
import COM.ibm.db2.app.classloader.ClassProvider;
import COM.ibm.db2.app.classloader.PowerClassLoader;
import COM.ibm.db2.app.util.InvalidationException;
import COM.ibm.db2.app.util.Validatable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DynamicClassLoader
extends ClassLoaderTemplate
implements Validatable {
    ClassLoaderTracer tracer = ClassLoaderTracer.instance();
    Vector providers;
    Vector loaderListeners;
    Hashtable classes = new Hashtable();

    DynamicClassLoader() {
        if (this.tracer.isTracing) {
            this.tracer.trace("DynamicClassLoader::DynamicClassLoader()");
        }
        this.providers = new Vector();
        this.loaderListeners = new Vector();
    }

    DynamicClassLoader(ClassLoader classLoader) {
        super(classLoader);
        if (this.tracer.isTracing) {
            this.tracer.trace("DynamicClassLoader::DynamicClassLoader(Classloader)");
        }
        this.providers = new Vector();
        this.loaderListeners = new Vector();
    }

    protected void addClassProvider(ClassProvider classProvider) {
        if (this.tracer.isTracing) {
            this.tracer.trace("DynamicClassLoader:addClassProvider. add ClassProvider for path: " + classProvider.getClassPath(), 1);
        }
        this.providers.addElement(classProvider);
        if (this.tracer.isTracing) {
            this.tracer.trace("DynamicClassLoader:addClassProvider. classpath: " + this.getClassPath(), 3);
        }
    }

    protected void removeClassProvider(ClassProvider classProvider) {
        if (this.tracer.isTracing) {
            this.tracer.trace("remove ClassProvider for path: " + classProvider.getClassPath(), 3);
        }
        this.providers.removeElement(classProvider);
        if (this.tracer.isTracing) {
            this.tracer.trace("classpath: " + this.getClassPath(), 3);
        }
    }

    @Override
    protected URL getNonSystemResource(String string) {
        if (PowerClassLoader.isResourceURLsEnabled()) {
            int n2 = this.providers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ClassProvider classProvider = (ClassProvider)this.providers.elementAt(i2);
                if (!classProvider.hasResource(string)) continue;
                ClassLoaderResource classLoaderResource = classProvider.getResource(string);
                if (this.tracer.isTracing) {
                    this.tracer.trace("getNonSystemResource: " + string + "[" + this.getAbsoluteResourcePath(string) + "]", 3);
                }
                return classLoaderResource.getResourceURL();
            }
            return null;
        }
        if (this.tracer.isTracing) {
            this.tracer.trace("getNonSystemResource: not supported" + string, 3);
        }
        return null;
    }

    @Override
    protected Enumeration findNonSystemResources(String string) {
        if (PowerClassLoader.isResourceURLsEnabled()) {
            int n2 = this.providers.size();
            Vector<URL> vector = new Vector<URL>();
            for (int i2 = 0; i2 < n2; ++i2) {
                ClassProvider classProvider = (ClassProvider)this.providers.elementAt(i2);
                Enumeration enumeration = classProvider.findResources(string);
                if (enumeration == null) continue;
                while (enumeration.hasMoreElements()) {
                    URL uRL = (URL)enumeration.nextElement();
                    if (uRL == null) continue;
                    vector.add(uRL);
                }
            }
            return vector.elements();
        }
        if (this.tracer.isTracing) {
            this.tracer.trace("findNonSystemResources: not supported" + string, 3);
        }
        return new Vector(0).elements();
    }

    @Override
    protected InputStream getNonSystemResourceAsStream(String string) {
        int n2 = this.providers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ClassProvider classProvider = (ClassProvider)this.providers.elementAt(i2);
            if (!classProvider.hasResource(string)) continue;
            ClassLoaderResource classLoaderResource = classProvider.getResource(string);
            if (this.tracer.isTracing) {
                this.tracer.trace("getNonSystemResourceAsStream: " + string + "[" + this.getAbsoluteResourcePath(string) + "]", 3);
            }
            return classLoaderResource.getInputStream();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class loadNonSystemClass(String string) throws ClassNotFoundException {
        Class<?> clazz = this.getClass(string = string.replace('/', '.'));
        if (null != clazz) {
            return clazz;
        }
        DynamicClassLoader dynamicClassLoader = this;
        synchronized (dynamicClassLoader) {
            clazz = this.getClass(string);
            if (null != clazz) {
                return clazz;
            }
            int n2 = this.providers.size();
            byte[] byArray = null;
            for (int i2 = 0; byArray == null && i2 < n2; ++i2) {
                ClassProvider classProvider = (ClassProvider)this.providers.elementAt(i2);
                byArray = classProvider.getClassBytes(string);
            }
            if (byArray == null) {
                ClassLoader classLoader;
                if (this.tracer.isTracing) {
                    this.tracer.trace("non-system class not found : " + string, 4);
                }
                if ((classLoader = this.getParent()) != null) {
                    if (this.tracer.isTracing) {
                        this.tracer.trace("Loading using parent loader : " + string, 5);
                    }
                    clazz = classLoader.loadClass(string);
                }
                if (clazz == null) {
                    throw new ClassNotFoundException(string);
                }
            }
            if (null == clazz) {
                if (this.tracer.isTracing) {
                    this.tracer.trace("DynamicClassLoader:loadNonSystemClass. defineClass: " + string, 2);
                }
                clazz = this.defineClass(string, byArray, 0, byArray.length);
                this.cacheClass(string, clazz);
            }
        }
        return clazz;
    }

    @Override
    public void validate() throws InvalidationException {
        int n2 = this.providers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ClassProvider classProvider = (ClassProvider)this.providers.elementAt(i2);
            try {
                classProvider.validate();
                continue;
            }
            catch (InvalidationException invalidationException) {
                throw new InvalidationException("DynamicClassLoader is invalid", invalidationException.getDetailedMessage());
            }
        }
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (InvalidationException invalidationException) {
            this.tracer.trace("ClassLoader is invalid", invalidationException);
            return false;
        }
        return true;
    }

    public String getAbsoluteResourcePath(String string) {
        int n2 = this.providers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ClassProvider classProvider = (ClassProvider)this.providers.elementAt(i2);
            String string2 = classProvider.getAbsoluteResourcePath(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    protected Enumeration getClassProviders() {
        return this.providers.elements();
    }

    public String getClassPath() {
        String string = null;
        Enumeration enumeration = this.getClassProviders();
        if (enumeration.hasMoreElements()) {
            string = ((ClassProvider)enumeration.nextElement()).getClassPath();
        }
        while (enumeration.hasMoreElements()) {
            string = string + File.pathSeparator + ((ClassProvider)enumeration.nextElement()).getClassPath();
        }
        return string;
    }

    protected Class getClass(String string) {
        return (Class)this.classes.get(string);
    }

    protected void cacheClass(String string, Class clazz) {
        this.classes.put(string, clazz);
    }

    public void finalize() {
        if (this.tracer.isTracing) {
            this.tracer.trace("PowerClassLoader::finalize()");
        }
    }
}

