/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.Blob;
import COM.ibm.db2.app.BlobWithByteBuffer;
import COM.ibm.db2.app.Clob;
import COM.ibm.db2.app.ClobWithCharBuffer;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class Lob {
    private static final int COPY_BUF_SIZE = 4096;

    protected Lob() throws Exception {
        Lob.assertContext();
    }

    public static Blob newBlob() throws Exception {
        Lob.assertContext();
        BlobWithByteBuffer blobWithByteBuffer = new BlobWithByteBuffer();
        if (blobWithByteBuffer != null) {
            return blobWithByteBuffer;
        }
        throw new Exception("Cannot create BLOB");
    }

    public static Clob newClob() throws Exception {
        Lob.assertContext();
        ClobWithCharBuffer clobWithCharBuffer = new ClobWithCharBuffer();
        if (clobWithCharBuffer != null) {
            return clobWithCharBuffer;
        }
        throw new Exception("Cannot create CLOB");
    }

    abstract void close();

    protected static void assertContext() throws Exception {
        Exception exception = null;
        try {
            if (Lob.checkContext() != 0) {
                exception = new Exception("Invalid context for Blob or Clob");
            }
        }
        catch (Throwable throwable) {
            throw new Exception("Invalid context for Blob or Clob: " + throwable);
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static void copyBlob(Blob blob, Blob blob2) throws Exception {
        int n2;
        byte[] byArray = new byte[4096];
        InputStream inputStream = blob.getInputStream();
        OutputStream outputStream = blob2.getOutputStream();
        while ((n2 = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n2);
        }
        inputStream.close();
        outputStream.close();
    }

    private static void copyClob(Clob clob, Clob clob2) throws Exception {
        int n2;
        char[] cArray = new char[4096];
        Reader reader = clob.getReader();
        Writer writer = clob2.getWriter();
        while ((n2 = reader.read(cArray)) >= 0) {
            writer.write(cArray, 0, n2);
        }
        reader.close();
        writer.close();
    }

    private static native int checkContext();

    abstract void assertOpen() throws Exception;
}

