/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.BlobInputStream;
import COM.ibm.db2.app.BlobOutputStream;
import COM.ibm.db2.app.BlobWithIO;
import COM.ibm.db2.app.Lob;
import java.io.InputStream;
import java.io.OutputStream;

class BlobWithByteBuffer
extends Lob
implements BlobWithIO {
    byte[] buffer;
    int capacity;
    int count;

    BlobWithByteBuffer(byte[] byArray) throws Exception {
        this.buffer = byArray;
        this.capacity = byArray.length;
        this.count = byArray.length;
    }

    BlobWithByteBuffer() throws Exception {
        this.capacity = 32;
        this.count = 0;
        this.buffer = new byte[this.capacity];
    }

    void close() {
        this.buffer = null;
        this.count = 0;
        this.capacity = 0;
    }

    void assertOpen() throws Exception {
        if (this.buffer == null) {
            throw new Exception("Blob is closed.");
        }
    }

    public long size() throws Exception {
        this.assertOpen();
        return this.count;
    }

    public InputStream getInputStream() throws Exception {
        return new BlobInputStream((BlobWithIO)this);
    }

    public OutputStream getOutputStream() throws Exception {
        return new BlobOutputStream((BlobWithIO)this);
    }

    public synchronized void append(byte[] byArray, int n2, int n3) throws Exception {
        this.assertOpen();
        if (this.count + n3 <= this.capacity) {
            System.arraycopy(byArray, n2, this.buffer, this.count, n3);
            this.count += n3;
        } else {
            int n4 = this.capacity + (int)((double)n3 * 1.2);
            byte[] byArray2 = new byte[n4];
            int n5 = this.count + n3;
            System.arraycopy(this.buffer, 0, byArray2, 0, this.count);
            System.arraycopy(byArray, n2, byArray2, this.count, n3);
            this.capacity = n4;
            this.buffer = byArray2;
            this.count = n5;
        }
    }

    public synchronized int substr(int n2, byte[] byArray, int n3, int n4) throws Exception {
        this.assertOpen();
        int n5 = n4;
        if (n2 >= this.count) {
            n5 = 0;
        } else if (n2 + n4 > this.count) {
            n5 = this.count - (n2 + n4);
        }
        System.arraycopy(this.buffer, n2, byArray, n3, n5);
        return n5;
    }
}

