/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags.tags;

import com.tridium.exporttags.BNiagaraExportTag;
import com.tridium.exporttags.util.ExportTagException;
import com.tridium.nd.history.BNiagaraHistoryImport;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.control.trigger.BDailyTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.history.BArchiveFolder;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.history.BCapacity;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nd.BINiagaraStation;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHistoryImportTag
extends BNiagaraExportTag {
    public static final Property stationSlotPath = BHistoryImportTag.newProperty((int)0, (BValue)BOrd.make((String)"slot:histories"), (BFacets)BHistoryImportTag.makeStationSlotPathFacets());
    public static final Property historyImportName = BHistoryImportTag.newProperty((int)0, (BValue)BFormat.make((String)"%defaultHistoryImportName%"), null);
    public static final Property executionTime = BHistoryImportTag.newProperty((int)0, (BValue)BDailyTriggerMode.make(), null);
    public static final Property configOverrides = BHistoryImportTag.newProperty((int)0, (BValue)new BComponent(), null);
    public static final Property onDemandPollEnabled = BHistoryImportTag.newProperty((int)0, (boolean)true, null);
    public static final Property onDemandPollFrequency = BHistoryImportTag.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property useCategoryMask = BHistoryImportTag.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE;
    private String cachedHistoryImportName;
    static /* synthetic */ Class class$com$tridium$exporttags$tags$BHistoryImportTag;
    static /* synthetic */ Class class$javax$baja$history$BHistoryConfig;

    public BFormat getHistoryImportName() {
        return (BFormat)this.get(historyImportName);
    }

    public void setHistoryImportName(BFormat bFormat) {
        this.set(historyImportName, (BValue)bFormat, null);
    }

    public BTriggerMode getExecutionTime() {
        return (BTriggerMode)this.get(executionTime);
    }

    public void setExecutionTime(BTriggerMode bTriggerMode) {
        this.set(executionTime, (BValue)bTriggerMode, null);
    }

    public BComponent getConfigOverrides() {
        return (BComponent)this.get(configOverrides);
    }

    public void setConfigOverrides(BComponent bComponent) {
        this.set(configOverrides, (BValue)bComponent, null);
    }

    public boolean getOnDemandPollEnabled() {
        return this.getBoolean(onDemandPollEnabled);
    }

    public void setOnDemandPollEnabled(boolean bl) {
        this.setBoolean(onDemandPollEnabled, bl, null);
    }

    public BPollFrequency getOnDemandPollFrequency() {
        return (BPollFrequency)this.get(onDemandPollFrequency);
    }

    public void setOnDemandPollFrequency(BPollFrequency bPollFrequency) {
        this.set(onDemandPollFrequency, (BValue)bPollFrequency, null);
    }

    public boolean getUseCategoryMask() {
        return this.getBoolean(useCategoryMask);
    }

    public void setUseCategoryMask(boolean bl) {
        this.setBoolean(useCategoryMask, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        BComponent bComponent = this.getConfigOverrides();
        if (bComponent.get("capacity") == null) {
            bComponent.add("capacity", (BValue)BCapacity.UNLIMITED);
        }
        if (bComponent.get("fullPolicy") == null) {
            bComponent.add("fullPolicy", BHistoryConfig.fullPolicy.getDefaultValue());
        }
    }

    protected Type getFolderType() {
        return BArchiveFolder.TYPE;
    }

    protected void doJoin(BINiagaraStation bINiagaraStation, BJob bJob, Subscriber subscriber, BCategoryMask bCategoryMask, Context context) throws Exception {
        BHistoryConfig[] bHistoryConfigArray;
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
        BComponent bComponent = (BComponent)this.getParent();
        subscriber.subscribe(bComponent);
        if (bComponent instanceof BHistoryConfig) {
            bHistoryConfigArray = new BHistoryConfig[]{(BHistoryConfig)bComponent};
        } else {
            Class clazz = class$javax$baja$history$BHistoryConfig;
            if (clazz == null) {
                clazz = class$javax$baja$history$BHistoryConfig = BHistoryImportTag.class("[Ljavax.baja.history.BHistoryConfig;", false);
            }
            bHistoryConfigArray = (BHistoryConfig[])bComponent.getChildren(clazz);
        }
        subscriber.subscribe((BComponent[])bHistoryConfigArray, 0, null);
        if (bHistoryConfigArray.length <= 0) {
            throw new ExportTagException("histImpExpTag.noHistoryConfigsFound");
        }
        BCategoryService bCategoryService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        int n = 0;
        while (n < bHistoryConfigArray.length) {
            BHistoryId bHistoryId = bHistoryConfigArray[n].getId();
            if (!bHistoryId.isValid()) {
                bJob.log().failed(this.getType().getModule().getModuleName(), "histImpExpTag.invalidHistoryConfig", bHistoryConfigArray[n].toPathString());
            } else {
                if (bHistoryId.getDeviceName().equals(bINiagaraStation.getStationName())) {
                    bHistoryId = BHistoryId.make((String)"^", (String)bHistoryId.getHistoryName());
                    this.cachedHistoryImportName = "Remote_" + bHistoryId.getHistoryName();
                } else {
                    this.cachedHistoryImportName = bHistoryId.getDeviceName() + '_' + bHistoryId.getHistoryName();
                }
                String string = this.getHistoryImportName().format((Object)this);
                if (!SlotPath.isValidName((String)string)) {
                    string = SlotPath.escape((String)string);
                }
                BNiagaraHistoryImport bNiagaraHistoryImport = (BNiagaraHistoryImport)BHistoryImportTag.findInstance(this.getTargetParent(), string, BNiagaraHistoryImport.TYPE);
                bNiagaraHistoryImport.set(BNiagaraHistoryImport.historyId, (BValue)bHistoryId, context);
                subscriber.subscribe(this.getConfigOverrides());
                this.configImport(bNiagaraHistoryImport, context);
                this.addTarget(string, (BComplex)bNiagaraHistoryImport, context);
                BHistoryConfig bHistoryConfig = bNiagaraHistoryImport.makeLocalConfig(bHistoryConfigArray[n]);
                if (bHistoryDatabase.getHistory(bHistoryConfigArray[n].getId()) == null) {
                    bHistoryDatabase.createHistory(bHistoryConfig);
                } else {
                    bHistoryDatabase.reconfigureHistory(bHistoryConfig);
                }
                if (this.getUseCategoryMask()) {
                    bCategoryService.setOrdMap(bCategoryService.getOrdMap().setCategoryMask(BOrd.make((String)("history:" + bHistoryConfig.getId())), bCategoryMask));
                }
                bNiagaraHistoryImport.invoke(BNiagaraHistoryImport.execute, null, context);
            }
            ++n;
        }
    }

    protected final void configImport(BNiagaraHistoryImport bNiagaraHistoryImport, Context context) {
        bNiagaraHistoryImport.getExecutionTime().set(BTimeTrigger.triggerMode, (BValue)this.getExecutionTime(), context);
        bNiagaraHistoryImport.setBoolean(BNiagaraHistoryImport.onDemandPollEnabled, this.getOnDemandPollEnabled(), context);
        bNiagaraHistoryImport.set(BNiagaraHistoryImport.onDemandPollFrequency, (BValue)this.getOnDemandPollFrequency(), context);
        BComponent bComponent = bNiagaraHistoryImport.getConfigOverrides();
        BComponent bComponent2 = this.getConfigOverrides();
        Property[] propertyArray = bComponent2.getPropertiesArray();
        int n = 0;
        while (n < propertyArray.length) {
            Property property = bComponent.getProperty(propertyArray[n].getName());
            if (property == null) {
                bComponent.add(propertyArray[n].getName(), bComponent2.get(propertyArray[n]).newCopy(true), context);
            } else {
                bComponent.set(property, bComponent2.get(propertyArray[n]).newCopy(true), context);
            }
            ++n;
        }
    }

    public String getDefaultHistoryImportName() {
        return this.cachedHistoryImportName;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.cachedHistoryImportName = "";
    }

    public BHistoryImportTag() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$exporttags$tags$BHistoryImportTag;
        if (clazz == null) {
            clazz = class$com$tridium$exporttags$tags$BHistoryImportTag = BHistoryImportTag.class("[Lcom.tridium.exporttags.tags.BHistoryImportTag;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

