/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags;

import com.tridium.exporttags.util.BSimplePairList;
import com.tridium.exporttags.util.ExportTagException;
import com.tridium.exporttags.util.ExportTagUtil;
import com.tridium.sys.schema.ComponentSlotMap;
import javax.baja.category.BCategoryMask;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nd.BINiagaraStation;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BFolder;
import javax.baja.util.BFormat;
import javax.baja.util.BNameList;
import javax.baja.util.BNameMap;
import javax.baja.util.BTypeSpec;
import javax.baja.util.IFilter;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BNiagaraExportTag
extends BComponent
implements BIStatus {
    public static final Property status = BNiagaraExportTag.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property enabled = BNiagaraExportTag.newProperty((int)0, (boolean)true, null);
    public static final Property supervisorStation = BNiagaraExportTag.newProperty((int)0, (BValue)BNameList.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"exportTags:MultiStationNamePickerFE"));
    public static final Property stationSlotPath = BNiagaraExportTag.newProperty((int)0, (BValue)BOrd.make((String)"slot:"), (BFacets)BNiagaraExportTag.makeStationSlotPathFacets());
    public static final Type TYPE;
    public static final String targetNameList = "targetSlotInfoList";
    private static final BIcon icon;
    private static final Type[] deviceFolderIncludeTypes;
    private static final Type[] networkFolderIncludeTypes;
    private Array targets;
    private BComponent targetParent;
    static /* synthetic */ Class class$com$tridium$exporttags$BNiagaraExportTag;
    static /* synthetic */ Class class$com$tridium$exporttags$BNiagaraExportTag$TargetInfo;
    static /* synthetic */ Class class$java$lang$String;

    protected static final BFacets makeStationSlotPathFacets() {
        return BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"exportTags:StationCompSelFE"));
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BNameList getSupervisorStation() {
        return (BNameList)this.get(supervisorStation);
    }

    public void setSupervisorStation(BNameList bNameList) {
        this.set(supervisorStation, (BValue)bNameList, null);
    }

    public BOrd getStationSlotPath() {
        return (BOrd)this.get(stationSlotPath);
    }

    public void setStationSlotPath(BOrd bOrd) {
        this.set(stationSlotPath, (BValue)bOrd, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 2: {
                this.fwChanged((Property)object, (Context)object2);
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private final void fwStarted() {
        this.updateStatus();
    }

    private final void fwChanged(Property property, Context context) {
        if (this.isRunning() && property == enabled) {
            this.updateStatus();
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (this.isMounted() && slot.getName().equals(stationSlotPath.getName())) {
            return BFacets.make((BFacets)super.getSlotFacets(slot), (String)"handleOrd", (BIDataValue)BString.make((String)this.getHandleOrd().toString()));
        }
        return super.getSlotFacets(slot);
    }

    private final void updateStatus() {
        this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)(this.getEnabled() ^ true)));
    }

    private final BComponent resolveStationSlotPath(BINiagaraStation bINiagaraStation, BJob bJob, Context context) throws Exception {
        OrdQuery[] ordQueryArray;
        BComponent bComponent = (BComponent)bINiagaraStation;
        BOrd bOrd = this.getStationSlotPath();
        Type type = this.getFolderType();
        if (type != null) {
            ordQueryArray = BFormat.format((String)bOrd.toString(), (Object)((Object)this));
            if (ordQueryArray.toLowerCase().indexOf("%err:") > -1) {
                throw new ExportTagException("expTag.couldNotFormatStationSlotPath", new String[]{ordQueryArray, this.toPathString()});
            }
            bOrd = BOrd.make((String)ExportTagUtil.filterInvalidSlashesFromPath((String)ordQueryArray));
            ExportTagUtil.createFolderPath(bComponent, this, bOrd, type, context);
        } else {
            bOrd = BOrd.make((String)ExportTagUtil.filterInvalidSlashesFromPath(bOrd.toString()));
        }
        ordQueryArray = bOrd.parse();
        if (ordQueryArray.length != 1) {
            throw new ExportTagException("expTag.shouldUseSlot", new String[]{bOrd.toString(), this.toPathString()});
        }
        if (!(ordQueryArray[0] instanceof SlotPath)) {
            throw new ExportTagException("expTag.shouldUseSlot", new String[]{bOrd.toString(), this.toPathString()});
        }
        BComponent bComponent2 = (BComponent)bOrd.get((BObject)bComponent);
        bJob.log().message(TYPE.getModule().getModuleName(), "expTag.resolvedStationSlotPath", new String[]{bOrd.toString(), this.toPathString()});
        return bComponent2;
    }

    protected Type getFolderType() {
        return null;
    }

    final long preJoin(BINiagaraStation bINiagaraStation, BJob bJob, Subscriber subscriber, BCategoryMask bCategoryMask, Context context) throws Exception {
        Class clazz = class$com$tridium$exporttags$BNiagaraExportTag$TargetInfo;
        if (clazz == null) {
            clazz = class$com$tridium$exporttags$BNiagaraExportTag$TargetInfo = BNiagaraExportTag.class("[Lcom.tridium.exporttags.BNiagaraExportTag$TargetInfo;", false);
        }
        this.targets = new Array(clazz);
        try {
            this.targetParent = this.resolveStationSlotPath(bINiagaraStation, bJob, context);
        }
        catch (ExportTagException exportTagException) {
            throw exportTagException;
        }
        catch (Exception exception) {
            throw new ExportTagException("expTag.noStationSlotPath", new String[]{this.getStationSlotPath().toString(), this.toPathString()}, (Throwable)exception);
        }
        long l = Clock.ticks();
        this.doPreJoin(bINiagaraStation, bJob, subscriber, bCategoryMask, context);
        return Clock.ticks() - l;
    }

    protected void doPreJoin(BINiagaraStation bINiagaraStation, BJob bJob, Subscriber subscriber, BCategoryMask bCategoryMask, Context context) throws Exception {
    }

    final long join(BINiagaraStation bINiagaraStation, BJob bJob, Subscriber subscriber, BCategoryMask bCategoryMask, Context context) throws Exception {
        long l = Clock.ticks();
        this.doJoin(bINiagaraStation, bJob, subscriber, bCategoryMask, context);
        return Clock.ticks() - l;
    }

    protected abstract void doJoin(BINiagaraStation var1, BJob var2, Subscriber var3, BCategoryMask var4, Context var5) throws Exception;

    final long postJoin(BINiagaraStation bINiagaraStation, BJob bJob, Subscriber subscriber, BCategoryMask bCategoryMask, Context context) throws Exception {
        long l = Clock.ticks();
        this.doPostJoin(bINiagaraStation, bJob, subscriber, bCategoryMask, context);
        return Clock.ticks() - l;
    }

    protected void doPostJoin(BINiagaraStation bINiagaraStation, BJob bJob, Subscriber subscriber, BCategoryMask bCategoryMask, Context context) throws Exception {
    }

    protected final BComponent getTargetParent() {
        return this.targetParent;
    }

    protected final void addTarget(String string, BComplex bComplex, Context context) {
        if (this.targetParent.get(string) == null) {
            this.targetParent.add(string, (BValue)bComplex, context);
        }
        this.registerTarget(bComplex);
    }

    protected final void addTarget(String string, BComplex bComplex, int n, Context context) {
        if (this.targetParent.get(string) == null) {
            this.targetParent.add(string, (BValue)bComplex, n, context);
        } else {
            int n2;
            Property property = bComplex.getPropertyInParent();
            if (property != null && (n2 = this.targetParent.getFlags((Slot)property)) != n) {
                this.targetParent.setFlags((Slot)property, n);
            }
        }
        this.registerTarget(bComplex);
    }

    protected final void addTarget(BComponent bComponent, String string, BComplex bComplex, Context context) {
        if (bComponent.get(string) == null) {
            bComponent.add(string, (BValue)bComplex, context);
        }
        this.registerTarget(bComponent, bComplex);
    }

    protected final void addTarget(BComponent bComponent, String string, BComplex bComplex, int n, Context context) {
        if (bComponent.get(string) == null) {
            bComponent.add(string, (BValue)bComplex, n, context);
        } else {
            int n2;
            Property property = bComplex.getPropertyInParent();
            if (property != null && (n2 = this.targetParent.getFlags((Slot)property)) != n) {
                this.targetParent.setFlags((Slot)property, n);
            }
        }
        this.registerTarget(bComponent, bComplex);
    }

    protected final void registerTarget(BComplex bComplex) {
        this.registerTarget(this.targetParent, bComplex);
    }

    protected final void unregisterTarget(BComplex bComplex) {
        this.unregisterTarget(this.targetParent, bComplex);
    }

    protected final void registerTarget(BComponent bComponent, BComplex bComplex) {
        String string = bComplex.getName();
        TargetInfo targetInfo = TargetInfo.make(bComponent, string, BTypeSpec.make((Type)this.getType()));
        BSimplePairList bSimplePairList = (BSimplePairList)bComponent.get(targetNameList);
        BSimplePairList bSimplePairList2 = BSimplePairList.make((BSimple)BString.make((String)string), (BSimple)BTypeSpec.make((Type)this.getType()));
        if (bSimplePairList == null) {
            bComponent.add(targetNameList, (BValue)bSimplePairList2, 69);
        } else {
            bComponent.set(targetNameList, (BValue)BSimplePairList.union(bSimplePairList, bSimplePairList2));
        }
        this.targets.add((Object)targetInfo);
    }

    protected final void unregisterTarget(BComponent bComponent, BComplex bComplex) {
        this.targets.remove((Object)TargetInfo.make(bComponent, bComplex.getName(), BTypeSpec.make((Type)this.getType())));
    }

    TargetInfo[] getRegisteredTargetInfos() {
        return (TargetInfo[])this.targets.trim();
    }

    protected static final BObject findInstance(BComponent bComponent, String string, Type type) throws ExportTagException {
        final String string2 = string;
        IFilter iFilter = new IFilter(){

            public final boolean accept(Object object) {
                if (object instanceof BComplex) {
                    BComplex bComplex = (BComplex)object;
                    return bComplex.getName().equals(string2);
                }
                return false;
            }
        };
        return BNiagaraExportTag.findInstance(bComponent, iFilter, type);
    }

    protected static final BObject findInstance(BComponent bComponent, IFilter iFilter, Type type) throws ExportTagException {
        Property[] propertyArray = bComponent.getDynamicPropertiesArray();
        int n = 0;
        while (n < propertyArray.length) {
            BValue bValue = bComponent.get(propertyArray[n]);
            if (iFilter.accept((Object)bValue)) {
                if (!bValue.getType().is(type)) {
                    bComponent.remove(propertyArray[n]);
                    return type.getInstance();
                }
                return bValue;
            }
            ++n;
        }
        return type.getInstance();
    }

    protected static final String getUniqueName(BComponent bComponent, String string) {
        return ((ComponentSlotMap)bComponent.fw(1)).generateUniqueSlotName(string);
    }

    protected static final void updateTargetDisplayName(BComponent bComponent, String string, BComplex bComplex) {
        BNameMap bNameMap;
        BComponent bComponent2 = (BComponent)bComplex.getParent();
        BNameMap bNameMap2 = (BNameMap)bComponent2.get("displayNames");
        BFormat bFormat = null;
        if (bNameMap2 != null) {
            bFormat = bNameMap2.get(bComplex.getName());
        }
        if ((bNameMap = (BNameMap)bComponent.get("displayNames")) != null) {
            bNameMap = bFormat != null ? BNameMap.make((BNameMap)bNameMap, (String)string, (BFormat)bFormat) : BNameMap.remove((BNameMap)bNameMap, (String)string);
            if (bNameMap.isNull()) {
                bComponent.remove("displayNames");
            } else {
                bComponent.set("displayNames", (BValue)bNameMap);
            }
        } else if (bFormat != null) {
            bComponent.add("displayNames", (BValue)BNameMap.make((BNameMap)BNameMap.DEFAULT, (String)string, (BFormat)bFormat), 261);
        }
    }

    public static BBoolean hasSupervisorStation(BObject bObject, BString bString) {
        BNiagaraExportTag bNiagaraExportTag = (BNiagaraExportTag)bObject;
        String[] stringArray = bNiagaraExportTag.getSupervisorStation().getNames();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(bString.getString())) {
                return BBoolean.TRUE;
            }
            ++n;
        }
        return BBoolean.FALSE;
    }

    public String getDeviceFolderPath() {
        return this.getFolderPath(BDevice.TYPE, deviceFolderIncludeTypes);
    }

    public String getNetworkFolderPath() {
        return this.getFolderPath(BDeviceNetwork.TYPE, networkFolderIncludeTypes);
    }

    private final String getFolderPath(Type type, Type[] typeArray) {
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = BNiagaraExportTag.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        if (this.createFolderPathToComp((BComponent)this.getParent(), array, type, typeArray)) {
            return TextUtil.join((String[])((String[])array.reverse().trim()), (char)'/');
        }
        return "";
    }

    private final boolean createFolderPathToComp(BComponent bComponent, Array array, Type type, Type[] typeArray) {
        if (bComponent == null) {
            return false;
        }
        Type type2 = bComponent.getType();
        if (type2.is(type)) {
            return true;
        }
        int n = 0;
        while (n < typeArray.length) {
            if (type2.is(typeArray[n])) {
                array.add((Object)bComponent.getName());
                break;
            }
            ++n;
        }
        return this.createFolderPathToComp((BComponent)bComponent.getParent(), array, type, typeArray);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$exporttags$BNiagaraExportTag;
        if (clazz == null) {
            clazz = class$com$tridium$exporttags$BNiagaraExportTag = BNiagaraExportTag.class("[Lcom.tridium.exporttags.BNiagaraExportTag;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"sync.png"), (BIcon)BIcon.std((String)"badges/export.png"));
        deviceFolderIncludeTypes = new Type[]{BFolder.TYPE};
        networkFolderIncludeTypes = new Type[]{BFolder.TYPE, BDevice.TYPE, BDeviceExt.TYPE};
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class TargetInfo {
        private BComponent targetComp;
        private String name;
        private BTypeSpec typeSpec;
        private int hashCode;

        static TargetInfo make(BComponent bComponent, String string, BTypeSpec bTypeSpec) {
            TargetInfo targetInfo = new TargetInfo();
            targetInfo.targetComp = bComponent;
            targetInfo.name = string;
            targetInfo.typeSpec = bTypeSpec;
            return targetInfo;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof TargetInfo)) {
                return false;
            }
            TargetInfo targetInfo = (TargetInfo)object;
            if (!targetInfo.targetComp.getSlotPathOrd().equals((Object)this.targetComp.getSlotPathOrd())) {
                return false;
            }
            if (!targetInfo.name.equals(this.name)) {
                return false;
            }
            return targetInfo.typeSpec.equals((Object)this.typeSpec);
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = new String(this.targetComp.getSlotPathOrd().toString() + this.name + this.typeSpec.getTypeInfo().toString()).hashCode();
            }
            return this.hashCode;
        }

        String toPathString() {
            return this.targetComp.toPathString() + '/' + this.name;
        }

        BComponent getTargetComp() {
            return this.targetComp;
        }

        String getName() {
            return this.name;
        }

        BTypeSpec getTypeSpec() {
            return this.typeSpec;
        }

        private final /* synthetic */ void this() {
            this.hashCode = -1;
        }

        TargetInfo() {
            this.this();
        }
    }
}

