/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfVideo.display;

import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddfVideo.BDdfVideoDevice;
import com.tridium.ddfVideo.DdfVideoLexicon;
import com.tridium.ddfVideo.camera.BDdfVideoCamera;
import com.tridium.ddfVideo.comm.req.BIDdfMakeActiveCameraReq;
import com.tridium.ddfVideo.comm.req.BIDdfPanTiltReq;
import com.tridium.ddfVideo.comm.req.BIDdfZoomReq;
import com.tridium.ddfVideo.display.BDdfDisplayDeviceExt;
import com.tridium.ddfVideo.display.BDdfVideoLocation;
import com.tridium.videoDriver.camera.control.BIVideoPanTiltControl;
import com.tridium.videoDriver.display.BIVideoDisplay;
import com.tridium.videoDriver.display.BIVideoDisplayDeviceExt;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BDdfVideoDisplay
extends BDdfVideoDevice
implements BIVideoPanTiltControl,
BIVideoDisplay {
    public static final String NO_MONITOR_FEED = "";
    public static final Property activeCamera = BDdfVideoDisplay.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Action move = BDdfVideoDisplay.newAction((int)0, (BValue)BVideoPanTiltEnum.none, null);
    public static final Action zoom = BDdfVideoDisplay.newAction((int)0, (BValue)BVideoZoomEnum.none, null);
    public static final Action makeActiveCamera = BDdfVideoDisplay.newAction((int)4, (BValue)BOrd.NULL, null);
    public static final Type TYPE;
    private static final BIcon icon;
    static /* synthetic */ Class class$com$tridium$ddfVideo$display$BDdfVideoDisplay;

    public BOrd getActiveCamera() {
        return (BOrd)this.get(activeCamera);
    }

    public void setActiveCamera(BOrd bOrd) {
        this.set(activeCamera, (BValue)bOrd, null);
    }

    public void move(BVideoPanTiltEnum bVideoPanTiltEnum) {
        this.invoke(move, (BValue)bVideoPanTiltEnum, null);
    }

    public void zoom(BVideoZoomEnum bVideoZoomEnum) {
        this.invoke(zoom, (BValue)bVideoZoomEnum, null);
    }

    public void makeActiveCamera(BOrd bOrd) {
        this.invoke(makeActiveCamera, (BValue)bOrd, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDdfVideoLocation getLocation() {
        BComplex bComplex = this.getParent();
        while (bComplex != null && !(bComplex instanceof BDdfVideoLocation)) {
            bComplex = bComplex.getParent();
        }
        return (BDdfVideoLocation)bComplex;
    }

    public BIVideoDisplayDeviceExt getDisplayDeviceExt() {
        BComplex bComplex = this.getParent();
        while (bComplex != null && !(bComplex instanceof BDdfDisplayDeviceExt)) {
            bComplex = bComplex.getParent();
        }
        return (BIVideoDisplayDeviceExt)bComplex;
    }

    protected abstract Type getPanTiltReqType();

    protected abstract Type getZoomReqType();

    protected Type getActiveCameraReqType() {
        return null;
    }

    public void doMove(BVideoPanTiltEnum bVideoPanTiltEnum) {
        Type type = this.getPanTiltReqType();
        if (type == null) {
            throw new BajaRuntimeException(DdfVideoLexicon.PanTilt.panTiltReqTypeCantBeNull);
        }
        if (!type.is(BIDdfPanTiltReq.TYPE)) {
            throw new BajaRuntimeException(DdfVideoLexicon.PanTilt.panTiltReqTypeMustImplementBIDdfPanTiltReq);
        }
        BIDdfPanTiltReq bIDdfPanTiltReq = this.makePanTiltReq(bVideoPanTiltEnum, type);
        this.getDdfCommunicator().communicate((BIDdfRequest)bIDdfPanTiltReq);
    }

    public void doZoom(BVideoZoomEnum bVideoZoomEnum) {
        Type type = this.getZoomReqType();
        if (type == null) {
            throw new BajaRuntimeException(DdfVideoLexicon.Zoom.zoomReqTypeCantBeNull);
        }
        if (!type.is(BIDdfZoomReq.TYPE)) {
            throw new BajaRuntimeException(DdfVideoLexicon.Zoom.zoomReqTypeMustImplementBIDdfZoomReq);
        }
        BIDdfZoomReq bIDdfZoomReq = this.makeZoomReq(bVideoZoomEnum, type);
        this.getDdfCommunicator().communicate((BIDdfRequest)bIDdfZoomReq);
    }

    public void doMakeActiveCamera(BOrd bOrd) {
        BObject bObject = bOrd.get();
        if (bObject != null && bObject instanceof BDdfVideoCamera) {
            BDdfVideoCamera bDdfVideoCamera = (BDdfVideoCamera)bObject;
            this.setActiveCamera(bDdfVideoCamera.getAbsoluteOrd());
            Type type = this.getActiveCameraReqType();
            if (type == null) {
                if (this.getDdfCommunicator().getLog().isTraceOn()) {
                    this.getDdfCommunicator().getLog().trace(DdfVideoLexicon.MakeActiveCamera.makeActiveCameraNotSupported(this.getType().getTypeSpec().getModuleName()));
                }
            } else if (type.is(BIDdfMakeActiveCameraReq.TYPE)) {
                BDdfIdParams bDdfIdParams = (BDdfIdParams)bDdfVideoCamera.getDeviceId().newCopy();
                BIDdfMakeActiveCameraReq bIDdfMakeActiveCameraReq = this.makeActiveCameraReq(bDdfIdParams, type);
                this.getDdfCommunicator().communicate((BIDdfRequest)bIDdfMakeActiveCameraReq);
            } else {
                throw new BajaRuntimeException(DdfVideoLexicon.MakeActiveCamera.makeActiveCameraReqTypeMustImplementBIDdfMakeActiveCameraReq);
            }
        }
    }

    protected BIDdfPanTiltReq makePanTiltReq(BVideoPanTiltEnum bVideoPanTiltEnum, Type type) {
        BIDdfPanTiltReq bIDdfPanTiltReq = (BIDdfPanTiltReq)type.getInstance();
        bIDdfPanTiltReq.setVideoComponent(this);
        bIDdfPanTiltReq.setPanTiltAction(bVideoPanTiltEnum);
        return bIDdfPanTiltReq;
    }

    protected BIDdfZoomReq makeZoomReq(BVideoZoomEnum bVideoZoomEnum, Type type) {
        BIDdfZoomReq bIDdfZoomReq = (BIDdfZoomReq)type.getInstance();
        bIDdfZoomReq.setVideoComponent(this);
        bIDdfZoomReq.setZoomAction(bVideoZoomEnum);
        return bIDdfZoomReq;
    }

    protected BIDdfMakeActiveCameraReq makeActiveCameraReq(BDdfIdParams bDdfIdParams, Type type) {
        BIDdfMakeActiveCameraReq bIDdfMakeActiveCameraReq = (BIDdfMakeActiveCameraReq)type.getInstance();
        bIDdfMakeActiveCameraReq.setVideoDisplay(this);
        bIDdfMakeActiveCameraReq.setActiveCameraId(bDdfIdParams);
        return bIDdfMakeActiveCameraReq;
    }

    public void gotoPlaybackTime(BAbsTime bAbsTime) {
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$ddfVideo$display$BDdfVideoDisplay;
        if (clazz == null) {
            clazz = class$com$tridium$ddfVideo$display$BDdfVideoDisplay = BDdfVideoDisplay.class("[Lcom.tridium.ddfVideo.display.BDdfVideoDisplay;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://videoDriver/icons/videoDisplay.png");
    }
}

