/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfVideo.camera;

import com.tridium.ddf.BDdfDevice;
import com.tridium.ddf.BDdfNetwork;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfPingRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.IDdfPingable;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddfVideo.BDdfVideoDevice;
import com.tridium.ddfVideo.DdfVideoLexicon;
import com.tridium.ddfVideo.comm.req.BIDdfCameraTimeReq;
import com.tridium.ddfVideo.comm.rsp.BIDdfCameraTimeRsp;
import com.tridium.videoDriver.BIVideoNetwork;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import javax.baja.license.LicenseException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDdfSimpleVideoCamera
extends BDdfVideoDevice
implements BIVideoCamera {
    public static final Type TYPE;
    private static final BIcon icon;
    static /* synthetic */ Class class$com$tridium$ddfVideo$camera$BDdfSimpleVideoCamera;
    static /* synthetic */ Class class$com$tridium$ddf$comm$req$IDdfPingable;

    public Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        try {
            Sys.getLicenseManager().checkFeature("tridium", "videoDriver");
            this.videoCameraStarted();
        }
        catch (LicenseException licenseException) {
            this.configFatal(licenseException.toString());
        }
        super.started();
    }

    public void videoCameraStarted() throws Exception {
    }

    public String getCameraDescription() {
        return this.toString();
    }

    public BIVideoDvr getDvr() {
        BComplex bComplex = this.getParent();
        while (bComplex != null && !(bComplex instanceof BIVideoDvr)) {
            bComplex = bComplex.getParent();
        }
        return (BIVideoDvr)bComplex;
    }

    public BIVideoNetwork getVideoNetwork() {
        BComplex bComplex = this.getParent();
        while (bComplex != null && !(bComplex instanceof BIVideoNetwork)) {
            bComplex = bComplex.getParent();
        }
        return (BIVideoNetwork)bComplex;
    }

    public void doPing() throws Exception {
        BIDdfPingRequest bIDdfPingRequest = this.makePingRequest();
        if (bIDdfPingRequest != null) {
            Class clazz = class$com$tridium$ddf$comm$req$IDdfPingable;
            if (clazz == null) {
                clazz = class$com$tridium$ddf$comm$req$IDdfPingable = BDdfSimpleVideoCamera.class("[Lcom.tridium.ddf.comm.req.IDdfPingable;", false);
            }
            Array array = new Array(clazz);
            BIVideoDvr bIVideoDvr = this.getDvr();
            Object[] objectArray = null;
            if (bIVideoDvr == null) {
                BDdfNetwork bDdfNetwork = (BDdfNetwork)this.getNetwork();
                objectArray = bDdfNetwork.getDevices();
            } else {
                objectArray = bIVideoDvr.getCameraExt().getAllCameras();
            }
            int n = 0;
            while (n < objectArray.length) {
                BDdfDevice bDdfDevice;
                if (objectArray[n] instanceof BDdfDevice && ((bDdfDevice = (BDdfDevice)objectArray[n]) == this || bDdfDevice.getDeviceId().equivalent((Object)this.getDeviceId())) && !array.contains((Object)bDdfDevice)) {
                    array.add((Object)bDdfDevice);
                }
                ++n;
            }
            bIDdfPingRequest.setPingableSource((IDdfPingable[])array.trim());
            DdfRequestUtil.communicateSync((BIDdfCommunicator)this.getDdfCommunicator(), (BIDdfRequest)bIDdfPingRequest);
        }
    }

    public BAbsTime getCameraTime() {
        BIDdfCameraTimeReq bIDdfCameraTimeReq = this.makeCameraTimeReq();
        if (bIDdfCameraTimeReq == null) {
            return null;
        }
        DdfRequestUtil.communicateSync((BIDdfCommunicator)this.getDdfCommunicator(), (BIDdfRequest)bIDdfCameraTimeReq);
        BIDdfCameraTimeRsp bIDdfCameraTimeRsp = bIDdfCameraTimeReq.getCameraTimeRsp();
        if (bIDdfCameraTimeRsp == null) {
            return null;
        }
        return bIDdfCameraTimeRsp.getCameraTime();
    }

    public BIDdfCameraTimeReq makeCameraTimeReq() {
        Type type = this.getCameraTimeReqType();
        if (type != null) {
            if (type.is(BIDdfCameraTimeReq.TYPE)) {
                BIDdfCameraTimeReq bIDdfCameraTimeReq = (BIDdfCameraTimeReq)type.getInstance();
                bIDdfCameraTimeReq.setDeviceId((BDdfIdParams)this.getDeviceId().newCopy());
                bIDdfCameraTimeReq.setVideoComponent(this);
                if (bIDdfCameraTimeReq instanceof BIDdfPingRequest) {
                    BIDdfPingRequest bIDdfPingRequest = (BIDdfPingRequest)bIDdfCameraTimeReq;
                    bIDdfPingRequest.setPingableSource(new IDdfPingable[]{this});
                }
                return bIDdfCameraTimeReq;
            }
            throw new BajaRuntimeException(DdfVideoLexicon.VideoCameraTime.getCameraTyeMustImplementProperInterface(type));
        }
        return null;
    }

    public Type getCameraTimeReqType() {
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$ddfVideo$camera$BDdfSimpleVideoCamera;
        if (clazz == null) {
            clazz = class$com$tridium$ddfVideo$camera$BDdfSimpleVideoCamera = BDdfSimpleVideoCamera.class("[Lcom.tridium.ddfVideo.camera.BDdfSimpleVideoCamera;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://videoDriver/icons/camera.png");
    }
}

