/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetws.datatypes;

import com.tridium.bacnet.datatypes.BPriorityFilter;
import com.tridium.bacnet.datatypes.BRequestConfig;
import com.tridium.bacnet.enums.BAcknowledgmentFilter;
import com.tridium.bacnet.enums.BEventStateFilter;
import com.tridium.bacnetws.BBacnetWsNetwork;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetRecipientProcess;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BGetESummConfig
extends BRequestConfig {
    public static final Property deviceAddress = BGetESummConfig.newProperty((int)4, (BValue)BBacnetAddress.DEFAULT, null);
    public static final Property acknowledgment = BGetESummConfig.newProperty((int)0, (BValue)BAcknowledgmentFilter.all, null);
    public static final Property enrollment = BGetESummConfig.newProperty((int)0, (BValue)new BBacnetRecipientProcess(), null);
    public static final Property eventState = BGetESummConfig.newProperty((int)0, (BValue)BEventStateFilter.all, null);
    public static final Property eventType = BGetESummConfig.newProperty((int)0, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((Type)BBacnetEventType.TYPE, (int[])new int[]{-1}, (String[])new String[]{"all"})), null);
    public static final Property priority = BGetESummConfig.newProperty((int)0, (BValue)new BPriorityFilter(), null);
    public static final Property notificationClass = BGetESummConfig.newProperty((int)0, (int)-1, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$bacnetws$datatypes$BGetESummConfig;

    public BBacnetAddress getDeviceAddress() {
        return (BBacnetAddress)this.get(deviceAddress);
    }

    public void setDeviceAddress(BBacnetAddress bBacnetAddress) {
        this.set(deviceAddress, (BValue)bBacnetAddress, null);
    }

    public BAcknowledgmentFilter getAcknowledgment() {
        return (BAcknowledgmentFilter)this.get(acknowledgment);
    }

    public void setAcknowledgment(BAcknowledgmentFilter bAcknowledgmentFilter) {
        this.set(acknowledgment, (BValue)bAcknowledgmentFilter, null);
    }

    public BBacnetRecipientProcess getEnrollment() {
        return (BBacnetRecipientProcess)this.get(enrollment);
    }

    public void setEnrollment(BBacnetRecipientProcess bBacnetRecipientProcess) {
        this.set(enrollment, (BValue)bBacnetRecipientProcess, null);
    }

    public BEventStateFilter getEventState() {
        return (BEventStateFilter)this.get(eventState);
    }

    public void setEventState(BEventStateFilter bEventStateFilter) {
        this.set(eventState, (BValue)bEventStateFilter, null);
    }

    public BEnum getEventType() {
        return (BEnum)this.get(eventType);
    }

    public void setEventType(BEnum bEnum) {
        this.set(eventType, (BValue)bEnum, null);
    }

    public BPriorityFilter getPriority() {
        return (BPriorityFilter)this.get(priority);
    }

    public void setPriority(BPriorityFilter bPriorityFilter) {
        this.set(priority, (BValue)bPriorityFilter, null);
    }

    public long getNotificationClass() {
        return this.getLong(notificationClass);
    }

    public void setNotificationClass(long l) {
        this.setLong(notificationClass, l, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        if (context == BBacnetWsNetwork.jobContext) {
            stringBuffer.append("ack:").append(this.getAcknowledgment());
            if (this.isEnrollmentUsed()) {
                stringBuffer.append("; enrollment:").append(this.getEnrollment());
            }
            if (this.isEventStateUsed()) {
                stringBuffer.append("; eventState:").append(this.getEventState());
            }
            if (this.isEventTypeUsed()) {
                stringBuffer.append("; eventTypeFilter:").append(this.getEventType());
            }
            if (this.isPriorityUsed()) {
                stringBuffer.append("; priorityFilter:").append(this.getPriority());
            }
            if (this.isNotificationClassUsed()) {
                stringBuffer.append("; notificationClassFilter:").append(this.getNotificationClass());
            }
        } else {
            stringBuffer.append("\n  ackFilter:" + this.getAcknowledgment());
            if (this.isEnrollmentUsed()) {
                stringBuffer.append("\n  enrollmentFilter:").append(this.getEnrollment());
            }
            if (this.isEventStateUsed()) {
                stringBuffer.append("\n  eventStateFilter:").append(this.getEventState());
            }
            if (this.isEventTypeUsed()) {
                stringBuffer.append("\n  eventTypeFilter:").append(this.getEventType());
            }
            if (this.isPriorityUsed()) {
                stringBuffer.append("\n  priorityFilter:").append(this.getPriority());
            }
            if (this.isNotificationClassUsed()) {
                stringBuffer.append("\n  notificationClassFilter:").append(this.getNotificationClass());
            }
        }
        return stringBuffer.toString();
    }

    public boolean isEnrollmentUsed() {
        return enrollment.isEquivalentToDefaultValue((BValue)this.getEnrollment()) ^ true;
    }

    public boolean isEventStateUsed() {
        return eventState.isEquivalentToDefaultValue((BValue)this.getEventState()) ^ true;
    }

    public boolean isEventTypeUsed() {
        return eventType.isEquivalentToDefaultValue((BValue)this.getEventType()) ^ true;
    }

    public boolean isPriorityUsed() {
        return priority.isEquivalentToDefaultValue((BValue)this.getPriority()) ^ true;
    }

    public boolean isNotificationClassUsed() {
        return notificationClass.isEquivalentToDefaultValue(this.get(notificationClass)) ^ true;
    }

    public BAcknowledgmentFilter getAcknowledgmentFilter() {
        return this.getAcknowledgment();
    }

    public BBacnetRecipientProcess getEnrollmentFilter() {
        return this.isEnrollmentUsed() ? this.getEnrollment() : null;
    }

    public BEventStateFilter getEventStateFilter() {
        return this.isEventStateUsed() ? this.getEventState() : null;
    }

    public BEnum getEventTypeFilter() {
        return this.isEventTypeUsed() ? this.getEventType() : null;
    }

    public BPriorityFilter getPriorityFilter() {
        return this.isPriorityUsed() ? this.getPriority() : null;
    }

    public long getNotificationClassFilter() {
        return this.isNotificationClassUsed() ? this.getNotificationClass() : (long)-1;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$bacnetws$datatypes$BGetESummConfig;
        if (clazz == null) {
            clazz = class$com$tridium$bacnetws$datatypes$BGetESummConfig = BGetESummConfig.class("[Lcom.tridium.bacnetws.datatypes.BGetESummConfig;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

