/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetws;

import com.tridium.bacnet.datatypes.BRequestConfig;
import com.tridium.bacnetws.BBacnetWsDevice;
import com.tridium.bacnetws.BBacnetWsDeviceFolder;
import com.tridium.bacnetws.BLocalBacnetWsDevice;
import com.tridium.bacnetws.datatypes.BBackupConfig;
import com.tridium.bacnetws.datatypes.BCommControlConfig;
import com.tridium.bacnetws.datatypes.BGetESummConfig;
import com.tridium.bacnetws.datatypes.BGetEventInfoConfig;
import com.tridium.bacnetws.datatypes.BReinitializeDeviceConfig;
import com.tridium.bacnetws.datatypes.BRestoreConfig;
import com.tridium.bacnetws.job.BBackupJob;
import com.tridium.bacnetws.job.BDeviceCommControlJob;
import com.tridium.bacnetws.job.BGetEnrollmentSummaryJob;
import com.tridium.bacnetws.job.BGetEventInformationJob;
import com.tridium.bacnetws.job.BReinitializeDeviceJob;
import com.tridium.bacnetws.job.BRestoreJob;
import com.tridium.bacnetws.stack.BBacnetWsStack;
import javax.baja.agent.AgentList;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetWsNetwork
extends BBacnetNetwork {
    public static final Property bacnetComm = BBacnetWsNetwork.newProperty((int)0, (BValue)new BBacnetWsStack(), null);
    public static final Property localDevice = BBacnetWsNetwork.newProperty((int)0, (BValue)new BLocalBacnetWsDevice(), null);
    public static final Type TYPE;
    public static final Context jobContext;
    private boolean licenseChecked;
    static /* synthetic */ Class class$com$tridium$bacnetws$BBacnetWsNetwork;

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.checkLicense();
    }

    public BOrd doSubmitDeviceManagerJob(BValue bValue, Context context) {
        this.checkLicense();
        if (this.isFatalFault()) {
            return null;
        }
        BRequestConfig bRequestConfig = (BRequestConfig)bValue;
        Type type = bRequestConfig.getType();
        if (type.is(BGetEventInfoConfig.TYPE)) {
            return new BGetEventInformationJob(this, (BGetEventInfoConfig)bRequestConfig).submit(context);
        }
        if (type.is(BGetESummConfig.TYPE)) {
            return new BGetEnrollmentSummaryJob(this, (BGetESummConfig)bRequestConfig).submit(context);
        }
        if (type.is(BCommControlConfig.TYPE)) {
            return new BDeviceCommControlJob(this, (BCommControlConfig)bRequestConfig).submit(context);
        }
        if (type.is(BReinitializeDeviceConfig.TYPE)) {
            return new BReinitializeDeviceJob(this, (BReinitializeDeviceConfig)bRequestConfig).submit(context);
        }
        if (type.is(BBackupConfig.TYPE)) {
            return new BBackupJob(this, (BBackupConfig)bRequestConfig).submit(context);
        }
        if (type.is(BRestoreConfig.TYPE)) {
            return new BRestoreJob(this, (BRestoreConfig)bRequestConfig).submit(context);
        }
        return super.doSubmitDeviceManagerJob(bValue, context);
    }

    public Type getDeviceFolderType() {
        return BBacnetWsDeviceFolder.TYPE;
    }

    protected Feature getWsLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "bacnetws");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void checkLicense() {
        if (this.licenseChecked) {
            return;
        }
        try {
            try {
                Feature feature = this.getWsLicenseFeature();
                if (feature == null) {
                    Object var2_3 = null;
                    this.licenseChecked = true;
                    return;
                }
                feature.check();
            }
            catch (Exception exception) {
                this.getLog().error("Unlicensed: " + this.toPathString(), (Throwable)exception);
                this.configFatal("Unlicensed: " + exception);
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.licenseChecked = true;
            throw throwable;
        }
        {
            Object var2_5 = null;
            this.licenseChecked = true;
            return;
        }
    }

    public BBacnetWsDevice lookupWsDevice(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        BBacnetDevice bBacnetDevice = this.doLookupDeviceById(bBacnetObjectIdentifier);
        if (bBacnetDevice == null) {
            return null;
        }
        return bBacnetDevice.getType().is(BBacnetWsDevice.TYPE) ? (BBacnetWsDevice)bBacnetDevice : null;
    }

    public BBacnetWsDevice lookupWsDevice(BBacnetAddress bBacnetAddress) {
        BBacnetDevice bBacnetDevice = this.doLookupDeviceByAddress(bBacnetAddress);
        if (bBacnetDevice == null) {
            return null;
        }
        return bBacnetDevice.getType().is(BBacnetWsDevice.TYPE) ? (BBacnetWsDevice)bBacnetDevice : null;
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.remove("bacnet:BacnetDeviceManager");
        return agentList;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.licenseChecked = false;
    }

    public BBacnetWsNetwork() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnetws$BBacnetWsNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$bacnetws$BBacnetWsNetwork = BBacnetWsNetwork.class("[Lcom.tridium.bacnetws.BBacnetWsNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        jobContext = new BasicContext(){

            public final boolean equals(Object object) {
                boolean bl = false;
                if (this == object) {
                    bl = true;
                }
                return bl;
            }

            public final String toString() {
                return "BacnetWs:jobContext";
            }
        };
    }
}

