/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.util;

import com.tridium.platform.tcpip.BPingArgs;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import com.vykon.vykonPro.util.BVykonProService;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BConnectionFailover
extends BComponent {
    public static final Property status = BConnectionFailover.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BConnectionFailover.newProperty((int)3, (String)"", null);
    public static final Property enabled = BConnectionFailover.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property restoreMode = BConnectionFailover.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"automatic", (String)"manual"));
    public static final Property pingFrequency = BConnectionFailover.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)5), null);
    public static final Property pingHost = BConnectionFailover.newProperty((int)264, (String)"enter host address here", null);
    public static final Property pingTimeout = BConnectionFailover.newProperty((int)0, (int)5, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"second"), (String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Property pingFailureLimit = BConnectionFailover.newProperty((int)0, (int)3, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property numberOfPingFails = BConnectionFailover.newProperty((int)1, (int)0, null);
    public static final Property pingStatus = BConnectionFailover.newProperty((int)9, (BValue)new BStatusString(), null);
    public static final Property pingFail = BConnectionFailover.newProperty((int)9, (BValue)new BStatusBoolean(), null);
    public static final Property lastPingTime = BConnectionFailover.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Action ping = BConnectionFailover.newAction((int)16, null);
    public static final Action resetFail = BConnectionFailover.newAction((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    Clock.Ticket ticket;
    static /* synthetic */ Class class$com$vykon$vykonPro$util$BConnectionFailover;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public boolean getRestoreMode() {
        return this.getBoolean(restoreMode);
    }

    public void setRestoreMode(boolean bl) {
        this.setBoolean(restoreMode, bl, null);
    }

    public BRelTime getPingFrequency() {
        return (BRelTime)this.get(pingFrequency);
    }

    public void setPingFrequency(BRelTime bRelTime) {
        this.set(pingFrequency, (BValue)bRelTime, null);
    }

    public String getPingHost() {
        return this.getString(pingHost);
    }

    public void setPingHost(String string) {
        this.setString(pingHost, string, null);
    }

    public int getPingTimeout() {
        return this.getInt(pingTimeout);
    }

    public void setPingTimeout(int n) {
        this.setInt(pingTimeout, n, null);
    }

    public int getPingFailureLimit() {
        return this.getInt(pingFailureLimit);
    }

    public void setPingFailureLimit(int n) {
        this.setInt(pingFailureLimit, n, null);
    }

    public int getNumberOfPingFails() {
        return this.getInt(numberOfPingFails);
    }

    public void setNumberOfPingFails(int n) {
        this.setInt(numberOfPingFails, n, null);
    }

    public BStatusString getPingStatus() {
        return (BStatusString)this.get(pingStatus);
    }

    public void setPingStatus(BStatusString bStatusString) {
        this.set(pingStatus, (BValue)bStatusString, null);
    }

    public BStatusBoolean getPingFail() {
        return (BStatusBoolean)this.get(pingFail);
    }

    public void setPingFail(BStatusBoolean bStatusBoolean) {
        this.set(pingFail, (BValue)bStatusBoolean, null);
    }

    public BAbsTime getLastPingTime() {
        return (BAbsTime)this.get(lastPingTime);
    }

    public void setLastPingTime(BAbsTime bAbsTime) {
        this.set(lastPingTime, (BValue)bAbsTime, null);
    }

    public void ping() {
        this.invoke(ping, null, null);
    }

    public void resetFail() {
        this.invoke(resetFail, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.checkForService();
        if (this.getEnabled()) {
            this.initClockTicket();
        }
    }

    public void stopped() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
    }

    private final void checkForService() {
        if (BVykonProService.getInstance() == null) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("This component requires the VykonPro service in the station");
        } else if (BVykonProService.getInstance().isDisabled()) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("The vykonPro service is disabled");
        } else {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        }
    }

    public void clockChanged(BRelTime bRelTime) {
        if (this.getEnabled()) {
            this.initClockTicket();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals((Object)pingFrequency) && this.getEnabled()) {
            this.initClockTicket();
        }
        if (property.equals((Object)enabled) && this.getEnabled()) {
            this.initClockTicket();
        }
    }

    void initClockTicket() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedule((BComponent)this, (BRelTime)this.getPingFrequency(), (Action)ping, null);
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == ping) {
            return BVykonProService.getInstance().getWorker().post((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public void doPing() throws Exception {
        block4: {
            this.initClockTicket();
            if (this.getPingHost().length() == 0) {
                this.getPingStatus().setValue("ping host not set");
                return;
            }
            BTcpIpPlatformService bTcpIpPlatformService = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
            try {
                BPingArgs bPingArgs = new BPingArgs();
                bPingArgs.setDestHost(this.getPingHost());
                bPingArgs.setTimeout(this.getPingTimeout());
                bTcpIpPlatformService.ping(bPingArgs);
                this.getPingStatus().setValue("ping successfull " + this.getPingHost());
                if (this.getPingFail().getValue() && this.getRestoreMode()) {
                    this.getPingFail().setValue(false);
                }
                this.setNumberOfPingFails(0);
            }
            catch (Exception exception) {
                this.getPingStatus().setValue("ping failed " + this.getPingHost());
                this.setNumberOfPingFails(this.getNumberOfPingFails() + 1);
                if (this.getNumberOfPingFails() <= this.getPingFailureLimit()) break block4;
                this.getPingFail().setValue(true);
            }
        }
        this.setLastPingTime(Clock.time());
    }

    public void doResetFail() {
        this.getPingFail().setValue(false);
        this.setNumberOfPingFails(0);
        this.getPingStatus().setValue("cleared ping fail state at time - " + Clock.time());
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$vykon$vykonPro$util$BConnectionFailover;
        if (clazz == null) {
            clazz = class$com$vykon$vykonPro$util$BConnectionFailover = BConnectionFailover.class("[Lcom.vykon.vykonPro.util.BConnectionFailover;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"gears.png");
    }
}

