/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.timer;

import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWeeklyTrigger
extends BComponent {
    public static final Property triggerTime = BWeeklyTrigger.newProperty((int)256, (BValue)BTime.DEFAULT, null);
    public static final Property triggerDayOfWeek = BWeeklyTrigger.newProperty((int)256, (BValue)BWeekday.make((int)1), null);
    public static final Property triggerWeekInterval = BWeeklyTrigger.newProperty((int)256, (int)1, null);
    public static final Property lastTrigger = BWeeklyTrigger.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property nextTrigger = BWeeklyTrigger.newProperty((int)1, (BValue)BAbsTime.END_OF_TIME, null);
    public static final Action presetNextTrigger = BWeeklyTrigger.newAction((int)256, (BValue)BAbsTime.make(), null);
    public static final Action ticketExpired = BWeeklyTrigger.newAction((int)4, null);
    public static final Topic trigger = BWeeklyTrigger.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    Clock.Ticket ticket;
    static /* synthetic */ Class class$com$vykon$vykonPro$timer$BWeeklyTrigger;

    public BTime getTriggerTime() {
        return (BTime)this.get(triggerTime);
    }

    public void setTriggerTime(BTime bTime) {
        this.set(triggerTime, (BValue)bTime, null);
    }

    public BWeekday getTriggerDayOfWeek() {
        return (BWeekday)this.get(triggerDayOfWeek);
    }

    public void setTriggerDayOfWeek(BWeekday bWeekday) {
        this.set(triggerDayOfWeek, (BValue)bWeekday, null);
    }

    public int getTriggerWeekInterval() {
        return this.getInt(triggerWeekInterval);
    }

    public void setTriggerWeekInterval(int n) {
        this.setInt(triggerWeekInterval, n, null);
    }

    public BAbsTime getLastTrigger() {
        return (BAbsTime)this.get(lastTrigger);
    }

    public void setLastTrigger(BAbsTime bAbsTime) {
        this.set(lastTrigger, (BValue)bAbsTime, null);
    }

    public BAbsTime getNextTrigger() {
        return (BAbsTime)this.get(nextTrigger);
    }

    public void setNextTrigger(BAbsTime bAbsTime) {
        this.set(nextTrigger, (BValue)bAbsTime, null);
    }

    public void presetNextTrigger(BAbsTime bAbsTime) {
        this.invoke(presetNextTrigger, (BValue)bAbsTime, null);
    }

    public void ticketExpired() {
        this.invoke(ticketExpired, null, null);
    }

    public void fireTrigger(BValue bValue) {
        this.fire(trigger, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void atSteadyState() {
        if (this.isRunning()) {
            this.init();
        }
    }

    public void started() {
        if (Sys.atSteadyState()) {
            this.init();
        }
    }

    public void stopped() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)triggerDayOfWeek) || property.equals((Object)triggerTime) || property.equals((Object)triggerWeekInterval)) {
            this.setNextTrigger(BAbsTime.NULL);
            this.init();
        }
    }

    public void clockChanged(BRelTime bRelTime) {
        this.init();
    }

    public void init() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        BAbsTime bAbsTime = Clock.time();
        int n = bAbsTime.getWeekday().getOrdinal();
        int n2 = this.getTriggerDayOfWeek().getOrdinal();
        if (this.getTriggerWeekInterval() < 1) {
            return;
        }
        if (this.getNextTrigger() == BAbsTime.NULL || this.getNextTrigger() == BAbsTime.END_OF_TIME) {
            if (this.getLastTrigger() == BAbsTime.NULL) {
                if (n == n2 && this.getTriggerTime().getTimeOfDayMillis() > bAbsTime.getTimeOfDayMillis()) {
                    this.setNextTrigger(BAbsTime.make((BAbsTime)bAbsTime, (BTime)this.getTriggerTime()));
                } else {
                    BAbsTime bAbsTime2 = bAbsTime;
                    int n3 = 0;
                    while (n3 < 7) {
                        if ((bAbsTime2 = bAbsTime2.nextDay()).getWeekday().getOrdinal() == n2) break;
                        ++n3;
                    }
                    this.setNextTrigger(BAbsTime.make((BAbsTime)bAbsTime2, (BTime)this.getTriggerTime()));
                }
            } else {
                BAbsTime bAbsTime3 = this.getLastTrigger();
                if (bAbsTime3.getWeekday().getOrdinal() != n2) {
                    int n4 = 0;
                    while (n4 < 7) {
                        if ((bAbsTime3 = bAbsTime3.nextDay()).getWeekday().getOrdinal() == n2) break;
                        ++n4;
                    }
                }
                bAbsTime3 = this.findNextWeek(bAbsTime3);
                while (bAbsTime3.isBefore(bAbsTime)) {
                    bAbsTime3 = this.findNextWeek(bAbsTime3);
                }
                this.setNextTrigger(BAbsTime.make((BAbsTime)bAbsTime3, (BTime)this.getTriggerTime()));
            }
        } else if (bAbsTime.isAfter(this.getNextTrigger())) {
            this.ticketExpired();
        } else {
            this.ticket = Clock.schedule((BComponent)this, (BAbsTime)this.getNextTrigger(), (Action)ticketExpired, null);
        }
    }

    private final BAbsTime findNextWeek(BAbsTime bAbsTime) {
        int n = 0;
        while (n < this.getTriggerWeekInterval()) {
            bAbsTime = bAbsTime.next(this.getTriggerDayOfWeek());
            ++n;
        }
        return bAbsTime;
    }

    public void doTicketExpired() {
        if (!this.isRunning()) {
            return;
        }
        BAbsTime bAbsTime = Clock.time();
        BAbsTime bAbsTime2 = this.getNextTrigger();
        if (bAbsTime.isAfter(this.getNextTrigger())) {
            this.fireTrigger(null);
            int n = 0;
            while (n < this.getTriggerWeekInterval()) {
                bAbsTime2 = bAbsTime2.next(this.getTriggerDayOfWeek());
                ++n;
            }
            this.setLastTrigger(this.getNextTrigger());
            this.setNextTrigger(bAbsTime2);
        }
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedule((BComponent)this, (BAbsTime)bAbsTime2, (Action)ticketExpired, null);
    }

    public void doPresetNextTrigger(BAbsTime bAbsTime) {
        this.setNextTrigger(bAbsTime);
        this.init();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ticket = null;
    }

    public BWeeklyTrigger() {
        this.this();
    }

    static {
        Class clazz = class$com$vykon$vykonPro$timer$BWeeklyTrigger;
        if (clazz == null) {
            clazz = class$com$vykon$vykonPro$timer$BWeeklyTrigger = BWeeklyTrigger.class("[Lcom.vykon.vykonPro.timer.BWeeklyTrigger;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"control/trigger.png");
    }
}

