/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.hvac;

import com.vykon.vykonPro.enums.BRuntimeBalancerOutputEnum;
import com.vykon.vykonPro.hvac.BManualBalancerCmd;
import com.vykon.vykonPro.util.BDisabledLoadsBitString;
import com.vykon.vykonPro.util.BRuntimeItem;
import com.vykon.vykonPro.util.RuntimeItemComparator;
import com.vykon.vykonPro.util.RuntimeItemComparatorDesc;
import java.util.Arrays;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BRuntimeBalancer
extends BComponent {
    public static final Property facets = BRuntimeBalancer.newProperty((int)256, (BValue)BFacets.makeBoolean(), null);
    public static final Property actionFacets = BRuntimeBalancer.newProperty((int)256, (BValue)BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BRuntimeBalancerOutputEnum.TYPE)), null);
    public static final Property schedule = BRuntimeBalancer.newProperty((int)264, (BValue)new BStatusBoolean(), null);
    public static final Property loadFailed = BRuntimeBalancer.newProperty((int)9, (BValue)new BStatusBoolean(), null);
    public static final Property numberOutputs = BRuntimeBalancer.newProperty((int)256, (int)2, (BFacets)BFacets.makeInt(null, (int)2, (int)10));
    public static final Property requiredLoads = BRuntimeBalancer.newProperty((int)256, (int)1, (BFacets)BFacets.makeInt(null, (int)0, (int)10));
    public static final Property lastRotateTime = BRuntimeBalancer.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Property runtimeRemainingUntilShift = BRuntimeBalancer.newProperty((int)1, (BValue)BRelTime.makeSeconds((int)0), null);
    public static final Property leadLoad = BRuntimeBalancer.newProperty((int)1, (BValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((Type)BRuntimeBalancerOutputEnum.TYPE))), null);
    public static final Property leadRuntimeAtStart = BRuntimeBalancer.newProperty((int)1, (BValue)BRelTime.makeSeconds((int)0), null);
    public static final Property nextLoad = BRuntimeBalancer.newProperty((int)1, (String)"", null);
    public static final Property nextLeadLoad = BRuntimeBalancer.newProperty((int)1, (BValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)2, (BEnumRange)BEnumRange.make((Type)BRuntimeBalancerOutputEnum.TYPE))), null);
    public static final Property rotateMode = BRuntimeBalancer.newProperty((int)256, (boolean)false, (BFacets)BFacets.makeBoolean((String)"manual", (String)"interval"));
    public static final Property rotateInterval = BRuntimeBalancer.newProperty((int)256, (BValue)BRelTime.makeHours((int)168), null);
    public static final Property feedbackDelay = BRuntimeBalancer.newProperty((int)256, (BValue)BRelTime.make((long)30000L), null);
    public static final Property outA = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outB = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outC = BRuntimeBalancer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outD = BRuntimeBalancer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outE = BRuntimeBalancer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outF = BRuntimeBalancer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outG = BRuntimeBalancer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outH = BRuntimeBalancer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outI = BRuntimeBalancer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outJ = BRuntimeBalancer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackA = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackB = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackC = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackD = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackE = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackF = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackG = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackH = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackI = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackJ = BRuntimeBalancer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property runtimeA = BRuntimeBalancer.newProperty((int)10, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeB = BRuntimeBalancer.newProperty((int)10, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeC = BRuntimeBalancer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeD = BRuntimeBalancer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeE = BRuntimeBalancer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeF = BRuntimeBalancer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeG = BRuntimeBalancer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeH = BRuntimeBalancer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeI = BRuntimeBalancer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeJ = BRuntimeBalancer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property disabledLoads = BRuntimeBalancer.newProperty((int)69, (BValue)new BDisabledLoadsBitString(0), null);
    public static final Action startupTimerExpired = BRuntimeBalancer.newAction((int)4, null);
    public static final Action rotateTimerExpired = BRuntimeBalancer.newAction((int)4, null);
    public static final Action countdownTimerExpired = BRuntimeBalancer.newAction((int)4, null);
    public static final Action feedbackTimerExpired = BRuntimeBalancer.newAction((int)4, null);
    public static final Action disableOutput = BRuntimeBalancer.newAction((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BRuntimeBalancerOutputEnum.TYPE)), null);
    public static final Action enableOutput = BRuntimeBalancer.newAction((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BRuntimeBalancerOutputEnum.TYPE)), null);
    public static final Action manualCmd = BRuntimeBalancer.newAction((int)0, (BValue)new BManualBalancerCmd(), null);
    public static final Action manualRotate = BRuntimeBalancer.newAction((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    int numOutputs;
    int lastNumberOutputs;
    int lastRequiredLoads;
    int startedLoads;
    int runningLoads;
    boolean feedbackTimerActive;
    boolean currentIn;
    boolean wasOn;
    BRuntimeItem[] rt;
    Clock.Ticket rotateTicket;
    Clock.Ticket feedbackTicket;
    Clock.Ticket startupTicket;
    Clock.Ticket countdownTicket;
    static /* synthetic */ Class class$com$vykon$vykonPro$hvac$BRuntimeBalancer;

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public BFacets getActionFacets() {
        return (BFacets)this.get(actionFacets);
    }

    public void setActionFacets(BFacets bFacets) {
        this.set(actionFacets, (BValue)bFacets, null);
    }

    public BStatusBoolean getSchedule() {
        return (BStatusBoolean)this.get(schedule);
    }

    public void setSchedule(BStatusBoolean bStatusBoolean) {
        this.set(schedule, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getLoadFailed() {
        return (BStatusBoolean)this.get(loadFailed);
    }

    public void setLoadFailed(BStatusBoolean bStatusBoolean) {
        this.set(loadFailed, (BValue)bStatusBoolean, null);
    }

    public int getNumberOutputs() {
        return this.getInt(numberOutputs);
    }

    public void setNumberOutputs(int n) {
        this.setInt(numberOutputs, n, null);
    }

    public int getRequiredLoads() {
        return this.getInt(requiredLoads);
    }

    public void setRequiredLoads(int n) {
        this.setInt(requiredLoads, n, null);
    }

    public BAbsTime getLastRotateTime() {
        return (BAbsTime)this.get(lastRotateTime);
    }

    public void setLastRotateTime(BAbsTime bAbsTime) {
        this.set(lastRotateTime, (BValue)bAbsTime, null);
    }

    public BRelTime getRuntimeRemainingUntilShift() {
        return (BRelTime)this.get(runtimeRemainingUntilShift);
    }

    public void setRuntimeRemainingUntilShift(BRelTime bRelTime) {
        this.set(runtimeRemainingUntilShift, (BValue)bRelTime, null);
    }

    public BStatusEnum getLeadLoad() {
        return (BStatusEnum)this.get(leadLoad);
    }

    public void setLeadLoad(BStatusEnum bStatusEnum) {
        this.set(leadLoad, (BValue)bStatusEnum, null);
    }

    public BRelTime getLeadRuntimeAtStart() {
        return (BRelTime)this.get(leadRuntimeAtStart);
    }

    public void setLeadRuntimeAtStart(BRelTime bRelTime) {
        this.set(leadRuntimeAtStart, (BValue)bRelTime, null);
    }

    public String getNextLoad() {
        return this.getString(nextLoad);
    }

    public void setNextLoad(String string) {
        this.setString(nextLoad, string, null);
    }

    public BStatusEnum getNextLeadLoad() {
        return (BStatusEnum)this.get(nextLeadLoad);
    }

    public void setNextLeadLoad(BStatusEnum bStatusEnum) {
        this.set(nextLeadLoad, (BValue)bStatusEnum, null);
    }

    public boolean getRotateMode() {
        return this.getBoolean(rotateMode);
    }

    public void setRotateMode(boolean bl) {
        this.setBoolean(rotateMode, bl, null);
    }

    public BRelTime getRotateInterval() {
        return (BRelTime)this.get(rotateInterval);
    }

    public void setRotateInterval(BRelTime bRelTime) {
        this.set(rotateInterval, (BValue)bRelTime, null);
    }

    public BRelTime getFeedbackDelay() {
        return (BRelTime)this.get(feedbackDelay);
    }

    public void setFeedbackDelay(BRelTime bRelTime) {
        this.set(feedbackDelay, (BValue)bRelTime, null);
    }

    public BStatusBoolean getOutA() {
        return (BStatusBoolean)this.get(outA);
    }

    public void setOutA(BStatusBoolean bStatusBoolean) {
        this.set(outA, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutB() {
        return (BStatusBoolean)this.get(outB);
    }

    public void setOutB(BStatusBoolean bStatusBoolean) {
        this.set(outB, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutC() {
        return (BStatusBoolean)this.get(outC);
    }

    public void setOutC(BStatusBoolean bStatusBoolean) {
        this.set(outC, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutD() {
        return (BStatusBoolean)this.get(outD);
    }

    public void setOutD(BStatusBoolean bStatusBoolean) {
        this.set(outD, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutE() {
        return (BStatusBoolean)this.get(outE);
    }

    public void setOutE(BStatusBoolean bStatusBoolean) {
        this.set(outE, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutF() {
        return (BStatusBoolean)this.get(outF);
    }

    public void setOutF(BStatusBoolean bStatusBoolean) {
        this.set(outF, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutG() {
        return (BStatusBoolean)this.get(outG);
    }

    public void setOutG(BStatusBoolean bStatusBoolean) {
        this.set(outG, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutH() {
        return (BStatusBoolean)this.get(outH);
    }

    public void setOutH(BStatusBoolean bStatusBoolean) {
        this.set(outH, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutI() {
        return (BStatusBoolean)this.get(outI);
    }

    public void setOutI(BStatusBoolean bStatusBoolean) {
        this.set(outI, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutJ() {
        return (BStatusBoolean)this.get(outJ);
    }

    public void setOutJ(BStatusBoolean bStatusBoolean) {
        this.set(outJ, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackA() {
        return (BStatusBoolean)this.get(feedbackA);
    }

    public void setFeedbackA(BStatusBoolean bStatusBoolean) {
        this.set(feedbackA, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackB() {
        return (BStatusBoolean)this.get(feedbackB);
    }

    public void setFeedbackB(BStatusBoolean bStatusBoolean) {
        this.set(feedbackB, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackC() {
        return (BStatusBoolean)this.get(feedbackC);
    }

    public void setFeedbackC(BStatusBoolean bStatusBoolean) {
        this.set(feedbackC, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackD() {
        return (BStatusBoolean)this.get(feedbackD);
    }

    public void setFeedbackD(BStatusBoolean bStatusBoolean) {
        this.set(feedbackD, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackE() {
        return (BStatusBoolean)this.get(feedbackE);
    }

    public void setFeedbackE(BStatusBoolean bStatusBoolean) {
        this.set(feedbackE, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackF() {
        return (BStatusBoolean)this.get(feedbackF);
    }

    public void setFeedbackF(BStatusBoolean bStatusBoolean) {
        this.set(feedbackF, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackG() {
        return (BStatusBoolean)this.get(feedbackG);
    }

    public void setFeedbackG(BStatusBoolean bStatusBoolean) {
        this.set(feedbackG, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackH() {
        return (BStatusBoolean)this.get(feedbackH);
    }

    public void setFeedbackH(BStatusBoolean bStatusBoolean) {
        this.set(feedbackH, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackI() {
        return (BStatusBoolean)this.get(feedbackI);
    }

    public void setFeedbackI(BStatusBoolean bStatusBoolean) {
        this.set(feedbackI, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackJ() {
        return (BStatusBoolean)this.get(feedbackJ);
    }

    public void setFeedbackJ(BStatusBoolean bStatusBoolean) {
        this.set(feedbackJ, (BValue)bStatusBoolean, null);
    }

    public BRelTime getRuntimeA() {
        return (BRelTime)this.get(runtimeA);
    }

    public void setRuntimeA(BRelTime bRelTime) {
        this.set(runtimeA, (BValue)bRelTime, null);
    }

    public BRelTime getRuntimeB() {
        return (BRelTime)this.get(runtimeB);
    }

    public void setRuntimeB(BRelTime bRelTime) {
        this.set(runtimeB, (BValue)bRelTime, null);
    }

    public BRelTime getRuntimeC() {
        return (BRelTime)this.get(runtimeC);
    }

    public void setRuntimeC(BRelTime bRelTime) {
        this.set(runtimeC, (BValue)bRelTime, null);
    }

    public BRelTime getRuntimeD() {
        return (BRelTime)this.get(runtimeD);
    }

    public void setRuntimeD(BRelTime bRelTime) {
        this.set(runtimeD, (BValue)bRelTime, null);
    }

    public BRelTime getRuntimeE() {
        return (BRelTime)this.get(runtimeE);
    }

    public void setRuntimeE(BRelTime bRelTime) {
        this.set(runtimeE, (BValue)bRelTime, null);
    }

    public BRelTime getRuntimeF() {
        return (BRelTime)this.get(runtimeF);
    }

    public void setRuntimeF(BRelTime bRelTime) {
        this.set(runtimeF, (BValue)bRelTime, null);
    }

    public BRelTime getRuntimeG() {
        return (BRelTime)this.get(runtimeG);
    }

    public void setRuntimeG(BRelTime bRelTime) {
        this.set(runtimeG, (BValue)bRelTime, null);
    }

    public BRelTime getRuntimeH() {
        return (BRelTime)this.get(runtimeH);
    }

    public void setRuntimeH(BRelTime bRelTime) {
        this.set(runtimeH, (BValue)bRelTime, null);
    }

    public BRelTime getRuntimeI() {
        return (BRelTime)this.get(runtimeI);
    }

    public void setRuntimeI(BRelTime bRelTime) {
        this.set(runtimeI, (BValue)bRelTime, null);
    }

    public BRelTime getRuntimeJ() {
        return (BRelTime)this.get(runtimeJ);
    }

    public void setRuntimeJ(BRelTime bRelTime) {
        this.set(runtimeJ, (BValue)bRelTime, null);
    }

    public BDisabledLoadsBitString getDisabledLoads() {
        return (BDisabledLoadsBitString)this.get(disabledLoads);
    }

    public void setDisabledLoads(BDisabledLoadsBitString bDisabledLoadsBitString) {
        this.set(disabledLoads, (BValue)bDisabledLoadsBitString, null);
    }

    public void startupTimerExpired() {
        this.invoke(startupTimerExpired, null, null);
    }

    public void rotateTimerExpired() {
        this.invoke(rotateTimerExpired, null, null);
    }

    public void countdownTimerExpired() {
        this.invoke(countdownTimerExpired, null, null);
    }

    public void feedbackTimerExpired() {
        this.invoke(feedbackTimerExpired, null, null);
    }

    public void disableOutput(BEnum bEnum) {
        this.invoke(disableOutput, (BValue)bEnum, null);
    }

    public void enableOutput(BEnum bEnum) {
        this.invoke(enableOutput, (BValue)bEnum, null);
    }

    public void manualCmd(BManualBalancerCmd bManualBalancerCmd) {
        this.invoke(manualCmd, (BValue)bManualBalancerCmd, null);
    }

    public void manualRotate() {
        this.invoke(manualRotate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.initNumberOutputs();
        this.checkNextLoad();
        this.startupTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)30), (Action)startupTimerExpired, null);
    }

    public void stopped() {
        if (this.feedbackTicket != null) {
            this.feedbackTicket.cancel();
        }
        if (this.rotateTicket != null) {
            this.rotateTicket.cancel();
        }
        if (this.startupTicket != null) {
            this.startupTicket.cancel();
        }
        if (this.countdownTicket != null) {
            this.countdownTicket.cancel();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property == numberOutputs) {
            this.initNumberOutputs();
        } else if (property == schedule) {
            this.calculate();
        } else if (property == requiredLoads) {
            if (this.getSchedule().getValue()) {
                this.updateRequiredLoads();
            }
        } else if (property == feedbackA || property == feedbackB || property == feedbackC || property == feedbackD || property == feedbackE || property == feedbackF || property == feedbackG || property == feedbackH || property == feedbackI || property == feedbackJ) {
            if (!this.currentIn) {
                return;
            }
            if (this.feedbackTimerActive) {
                return;
            }
            this.checkRunningStatus();
        } else if (property == rotateMode) {
            if (this.getRotateMode()) {
                if (this.rotateTicket != null) {
                    this.rotateTicket.cancel();
                }
            } else {
                this.startRotateTimer();
            }
        } else if (property == rotateInterval && !this.getRotateMode()) {
            this.startRotateTimer();
        }
    }

    public void initNumberOutputs() {
        this.numOutputs = this.getNumberOutputs();
        this.rt = new BRuntimeItem[this.numOutputs];
        int n = 0;
        while (n < 10) {
            int n2 = n >= this.numOutputs ? 6 : 10;
            switch (n) {
                case 0: {
                    this.initSlot("outA", n2 | 1);
                    this.initSlot("runtimeA", n2);
                    this.initSlot("feedbackA", n2);
                    break;
                }
                case 1: {
                    this.initSlot("outB", n2 | 1);
                    this.initSlot("runtimeB", n2);
                    this.initSlot("feedbackB", n2);
                    break;
                }
                case 2: {
                    this.initSlot("outC", n2 | 1);
                    this.initSlot("runtimeC", n2);
                    this.initSlot("feedbackC", n2);
                    break;
                }
                case 3: {
                    this.initSlot("outD", n2 | 1);
                    this.initSlot("runtimeD", n2);
                    this.initSlot("feedbackD", n2);
                    break;
                }
                case 4: {
                    this.initSlot("outE", n2 | 1);
                    this.initSlot("runtimeE", n2);
                    this.initSlot("feedbackE", n2);
                    break;
                }
                case 5: {
                    this.initSlot("outF", n2 | 1);
                    this.initSlot("runtimeF", n2);
                    this.initSlot("feedbackF", n2);
                    break;
                }
                case 6: {
                    this.initSlot("outG", n2 | 1);
                    this.initSlot("runtimeG", n2);
                    this.initSlot("feedbackG", n2);
                    break;
                }
                case 7: {
                    this.initSlot("outH", n2 | 1);
                    this.initSlot("runtimeH", n2);
                    this.initSlot("feedbackH", n2);
                    break;
                }
                case 8: {
                    this.initSlot("outI", n2 | 1);
                    this.initSlot("runtimeI", n2);
                    this.initSlot("feedbackI", n2);
                    break;
                }
                case 9: {
                    this.initSlot("outJ", n2 | 1);
                    this.initSlot("runtimeJ", n2);
                    this.initSlot("feedbackJ", n2);
                    break;
                }
            }
            int[] nArray = this.getDisabledLoads().getOrdinals();
            int n3 = 0;
            while (n3 < nArray.length) {
                if (this.getDisabledLoads().getBit(nArray[n3])) {
                    String string = this.getDisabledLoads().getTag(nArray[n3]);
                    ((BStatusBoolean)this.get(string)).setStatusDisabled(true);
                }
                ++n3;
            }
            ++n;
        }
    }

    void initSlot(String string, int n) {
        try {
            this.setFlags(this.getSlot(string), n, null);
        }
        catch (Exception exception) {}
    }

    public void doStartupTimerExpired() {
        this.calculate();
    }

    public void doRotateTimerExpired() {
        if (!this.currentIn) {
            return;
        }
        this.getRuntimes();
        this.startOutput();
        this.startRotateTimer();
    }

    public void doCountdownTimerExpired() {
        BAbsTime bAbsTime;
        BAbsTime bAbsTime2 = Clock.time();
        BRelTime bRelTime = bAbsTime2.delta(bAbsTime = this.getLastRotateTime().add(this.getRotateInterval()));
        if (bRelTime.getMillis() > 1000L) {
            this.setRuntimeRemainingUntilShift(bRelTime);
        } else {
            this.setRuntimeRemainingUntilShift(BRelTime.make((long)0L));
        }
    }

    public void doFeedbackTimerExpired() {
        this.feedbackTimerActive = false;
        if (!this.currentIn) {
            return;
        }
        this.checkRunningStatus();
    }

    public void doManualRotate() {
        if (!this.currentIn) {
            return;
        }
        this.getRuntimes();
        this.startOutput();
    }

    void calculate() {
        this.lastRequiredLoads = this.getRequiredLoads();
        this.currentIn = this.getSchedule().getValue();
        this.getRuntimes();
        if (this.currentIn) {
            if (!this.wasOn) {
                this.startOutput();
                if (!this.getRotateMode()) {
                    this.startRotateTimer();
                } else {
                    this.startCountdownTimer();
                }
                this.wasOn = true;
            }
        } else {
            if (this.wasOn) {
                if (this.rotateTicket != null) {
                    this.rotateTicket.cancel();
                }
                if (this.feedbackTicket != null) {
                    this.feedbackTicket.cancel();
                }
                if (this.countdownTicket != null) {
                    this.countdownTicket.cancel();
                }
                this.wasOn = false;
            }
            this.stopOutput();
        }
    }

    void getRuntimes() {
        int n = 0;
        while (n < this.numOutputs) {
            this.rt[n] = this.isRuntimeLinked(n) && !this.getStatusOutput(n).getStatus().isDisabled() ? new BRuntimeItem(n, this.getRuntime(n)) : new BRuntimeItem(n, Long.MAX_VALUE);
            ++n;
        }
    }

    void getOnRuntimes() {
        int n = 0;
        while (n < this.numOutputs) {
            this.rt[n] = this.isRuntimeLinked(n) && this.getOutValue(n) && !this.getStatusOutput(n).getStatus().isAlarm() ? new BRuntimeItem(n, this.getRuntime(n)) : new BRuntimeItem(n, Long.MIN_VALUE);
            ++n;
        }
    }

    void getOffRuntimes() {
        int n = 0;
        while (n < this.numOutputs) {
            this.rt[n] = this.isRuntimeLinked(n) && !this.getOutValue(n) && !this.getStatusOutput(n).getStatus().isDisabled() ? new BRuntimeItem(n, this.getRuntime(n)) : new BRuntimeItem(n, Long.MAX_VALUE);
            ++n;
        }
    }

    long getRuntime(int n) {
        switch (n) {
            case 0: {
                return this.getRuntimeA().getMillis();
            }
            case 1: {
                return this.getRuntimeB().getMillis();
            }
            case 2: {
                return this.getRuntimeC().getMillis();
            }
            case 3: {
                return this.getRuntimeD().getMillis();
            }
            case 4: {
                return this.getRuntimeE().getMillis();
            }
            case 5: {
                return this.getRuntimeF().getMillis();
            }
            case 6: {
                return this.getRuntimeG().getMillis();
            }
            case 7: {
                return this.getRuntimeH().getMillis();
            }
            case 8: {
                return this.getRuntimeI().getMillis();
            }
            case 9: {
                return this.getRuntimeJ().getMillis();
            }
        }
        return Long.MAX_VALUE;
    }

    boolean getOutValue(int n) {
        switch (n) {
            case 0: {
                return this.getOutA().getValue();
            }
            case 1: {
                return this.getOutB().getValue();
            }
            case 2: {
                return this.getOutC().getValue();
            }
            case 3: {
                return this.getOutD().getValue();
            }
            case 4: {
                return this.getOutE().getValue();
            }
            case 5: {
                return this.getOutF().getValue();
            }
            case 6: {
                return this.getOutG().getValue();
            }
            case 7: {
                return this.getOutH().getValue();
            }
            case 8: {
                return this.getOutI().getValue();
            }
            case 9: {
                return this.getOutJ().getValue();
            }
        }
        return false;
    }

    boolean getFeedbackValue(int n) {
        switch (n) {
            case 0: {
                return this.getFeedbackA().getValue();
            }
            case 1: {
                return this.getFeedbackB().getValue();
            }
            case 2: {
                return this.getFeedbackC().getValue();
            }
            case 3: {
                return this.getFeedbackD().getValue();
            }
            case 4: {
                return this.getFeedbackE().getValue();
            }
            case 5: {
                return this.getFeedbackF().getValue();
            }
            case 6: {
                return this.getFeedbackG().getValue();
            }
            case 7: {
                return this.getFeedbackH().getValue();
            }
            case 8: {
                return this.getFeedbackI().getValue();
            }
            case 9: {
                return this.getFeedbackJ().getValue();
            }
        }
        return false;
    }

    boolean isRuntimeLinked(int n) {
        BLink[] bLinkArray = null;
        switch (n) {
            case 0: {
                bLinkArray = this.getLinks((Slot)runtimeA);
                break;
            }
            case 1: {
                bLinkArray = this.getLinks((Slot)runtimeB);
                break;
            }
            case 2: {
                bLinkArray = this.getLinks((Slot)runtimeC);
                break;
            }
            case 3: {
                bLinkArray = this.getLinks((Slot)runtimeD);
                break;
            }
            case 4: {
                bLinkArray = this.getLinks((Slot)runtimeE);
                break;
            }
            case 5: {
                bLinkArray = this.getLinks((Slot)runtimeF);
                break;
            }
            case 6: {
                bLinkArray = this.getLinks((Slot)runtimeG);
                break;
            }
            case 7: {
                bLinkArray = this.getLinks((Slot)runtimeH);
                break;
            }
            case 8: {
                bLinkArray = this.getLinks((Slot)runtimeI);
                break;
            }
            case 9: {
                bLinkArray = this.getLinks((Slot)runtimeJ);
                break;
            }
        }
        if (bLinkArray == null) {
            return false;
        }
        boolean bl = false;
        if (bLinkArray.length != 0) {
            bl = true;
        }
        return bl;
    }

    void startOutput() {
        Arrays.sort(this.rt, new RuntimeItemComparator());
        boolean bl = false;
        int n = 0;
        while (n < this.numOutputs) {
            int n2 = this.rt[n].getOutSlot();
            if (n < this.getRequiredLoads()) {
                this.getStatusOutput(n2).setValue(true);
                if (!bl) {
                    this.getLeadLoad().setValue(BDynamicEnum.make((int)n2, (BEnumRange)BEnumRange.make((Type)BRuntimeBalancerOutputEnum.TYPE)));
                    bl = true;
                    this.setLastRotateTime(BAbsTime.now());
                    this.setRuntimeRemainingUntilShift(this.getRotateInterval());
                    this.setLeadRuntimeAtStart(BRelTime.make((long)this.getRuntime(n2)));
                    this.startCountdownTimer();
                }
            } else {
                this.getStatusOutput(n2).setValue(false);
            }
            ++n;
        }
        this.startFeedbackTimer();
        this.checkNextLoad();
    }

    void startLag(int n) {
        Arrays.sort(this.rt, new RuntimeItemComparator());
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.rt[n2].getOutSlot();
            this.getStatusOutput(n3).setValue(true);
            ++n2;
        }
        this.startFeedbackTimer();
        this.checkNextLoad();
    }

    void stopLag(int n) {
        Arrays.sort(this.rt, new RuntimeItemComparatorDesc());
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.rt[n2].getOutSlot();
            this.getStatusOutput(n3).setValue(false);
            ++n2;
        }
        this.checkNextLoad();
    }

    void updateRequiredLoads() {
        if (this.getRequiredLoads() > this.lastRequiredLoads) {
            this.getOffRuntimes();
            this.startLag(this.getRequiredLoads() - this.lastRequiredLoads);
        } else if (this.getRequiredLoads() < this.lastRequiredLoads) {
            this.getOnRuntimes();
            this.stopLag(this.lastRequiredLoads - this.getRequiredLoads());
        }
        this.lastRequiredLoads = this.getRequiredLoads();
    }

    BStatusBoolean getStatusOutput(int n) {
        switch (n) {
            case 0: {
                return this.getOutA();
            }
            case 1: {
                return this.getOutB();
            }
            case 2: {
                return this.getOutC();
            }
            case 3: {
                return this.getOutD();
            }
            case 4: {
                return this.getOutE();
            }
            case 5: {
                return this.getOutF();
            }
            case 6: {
                return this.getOutG();
            }
            case 7: {
                return this.getOutH();
            }
            case 8: {
                return this.getOutI();
            }
            case 9: {
                return this.getOutJ();
            }
        }
        if (n < 0) {
            return this.getOutA();
        }
        return this.getOutJ();
    }

    void stopOutput() {
        int n = 0;
        while (n < this.numOutputs) {
            this.getStatusOutput(n).setValue(false);
            ++n;
        }
        this.checkNextLoad();
        if (this.countdownTicket != null) {
            this.countdownTicket.cancel();
        }
        this.setRuntimeRemainingUntilShift(BRelTime.make((long)0L));
    }

    void checkNextLoad() {
        this.getOffRuntimes();
        Arrays.sort(this.rt, new RuntimeItemComparator());
        int n = this.rt[0].getOutSlot();
        this.setNextLoad(this.getStatusOutput(n).getDisplayName(null));
        this.getRuntimes();
        Arrays.sort(this.rt, new RuntimeItemComparator());
        int n2 = 0;
        if (n2 < this.rt.length) {
            long l;
            int n3 = this.rt[n2].getOutSlot();
            if (n3 == this.getLeadLoad().getEnum().getOrdinal() && (l = this.getRuntime(n3) + this.getRuntimeRemainingUntilShift().getMillis()) < this.getRuntime(this.rt[n2 + 1].getOutSlot())) {
                this.getNextLeadLoad().setValue(BDynamicEnum.make((int)n3, (BEnumRange)BEnumRange.make((Type)BRuntimeBalancerOutputEnum.TYPE)));
            } else {
                this.getNextLeadLoad().setValue(BDynamicEnum.make((int)n, (BEnumRange)BEnumRange.make((Type)BRuntimeBalancerOutputEnum.TYPE)));
            }
        }
    }

    void startRotateTimer() {
        if (this.rotateTicket != null) {
            this.rotateTicket.cancel();
        }
        this.rotateTicket = Clock.schedule((BComponent)this, (BRelTime)this.getRotateInterval(), (Action)rotateTimerExpired, null);
    }

    void startFeedbackTimer() {
        if (this.feedbackTicket != null) {
            this.feedbackTicket.cancel();
        }
        this.feedbackTimerActive = true;
        this.feedbackTicket = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackTimerExpired, null);
    }

    void startCountdownTimer() {
        if (this.countdownTicket != null) {
            this.countdownTicket.cancel();
        }
        this.countdownTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)countdownTimerExpired, null);
    }

    void checkRunningStatus() {
        this.startedLoads = 0;
        this.runningLoads = 0;
        boolean bl = false;
        int n = 0;
        while (n < this.numOutputs) {
            BStatusBoolean bStatusBoolean = this.getStatusOutput(n);
            boolean bl2 = this.getFeedbackValue(n);
            if (bStatusBoolean.getValue() && !bl2) {
                bStatusBoolean.setStatusInAlarm(true);
                bl = true;
                ++this.startedLoads;
            } else if (bStatusBoolean.getValue() && bl2) {
                bStatusBoolean.setStatusInAlarm(false);
                ++this.startedLoads;
                ++this.runningLoads;
            } else {
                bStatusBoolean.setStatusInAlarm(false);
            }
            ++n;
        }
        if (bl) {
            this.getLoadFailed().setValue(true);
        } else {
            this.getLoadFailed().setValue(false);
        }
        if (this.runningLoads < this.getRequiredLoads()) {
            this.getOffRuntimes();
            this.startLag(this.getRequiredLoads() - this.runningLoads);
        } else if (this.runningLoads > this.getRequiredLoads()) {
            this.getOnRuntimes();
            this.stopLag(this.runningLoads - this.getRequiredLoads());
        }
    }

    public void doDisableOutput(BEnum bEnum) {
        int n = bEnum.getEnum().getOrdinal();
        BStatusBoolean bStatusBoolean = this.getStatusOutput(n);
        bStatusBoolean.setStatusDisabled(true);
        int n2 = this.getLoadBit(n);
        this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() | n2));
    }

    public void doEnableOutput(BEnum bEnum) {
        int n = bEnum.getEnum().getOrdinal();
        BStatusBoolean bStatusBoolean = this.getStatusOutput(n);
        bStatusBoolean.setStatusDisabled(false);
        int n2 = this.getLoadBit(n);
        this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() & ~n2));
    }

    public void doManualCmd(BManualBalancerCmd bManualBalancerCmd) {
        int n = bManualBalancerCmd.getOutput().getOrdinal();
        BStatusBoolean bStatusBoolean = this.getStatusOutput(n);
        if (bManualBalancerCmd.getCommand()) {
            bStatusBoolean.setStatusDisabled(true);
            int n2 = this.getLoadBit(n);
            this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() | n2));
        } else {
            bStatusBoolean.setStatusDisabled(false);
            int n3 = this.getLoadBit(n);
            this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() & ~n3));
        }
    }

    private final int getLoadBit(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            case 3: {
                n2 = 8;
                break;
            }
            case 4: {
                n2 = 16;
                break;
            }
            case 5: {
                n2 = 32;
                break;
            }
            case 6: {
                n2 = 48;
                break;
            }
            case 7: {
                n2 = 64;
                break;
            }
            case 8: {
                n2 = 128;
                break;
            }
            case 9: {
                n2 = 512;
                break;
            }
        }
        return n2;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.getName().startsWith("out")) {
            return this.getFacets();
        }
        if (slot.getName() == "enableOutput" || slot.getName() == "disableOutput") {
            return this.getActionFacets();
        }
        return super.getSlotFacets(slot);
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.feedbackTimerActive = false;
        this.wasOn = false;
    }

    public BRuntimeBalancer() {
        this.this();
    }

    static {
        Class clazz = class$com$vykon$vykonPro$hvac$BRuntimeBalancer;
        if (clazz == null) {
            clazz = class$com$vykon$vykonPro$hvac$BRuntimeBalancer = BRuntimeBalancer.class("[Lcom.vykon.vykonPro.hvac.BRuntimeBalancer;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"scales.png");
    }
}

