/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.hvac;

import com.vykon.vykonPro.enums.BSequencerModeEnum;
import com.vykon.vykonPro.enums.BSequencerOutputEnum;
import com.vykon.vykonPro.hvac.BManualSequencerCmd;
import com.vykon.vykonPro.hvac.BRotationOrder;
import com.vykon.vykonPro.util.BDisabledLoadsBitString;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BRotationalLoadSequencer
extends BComponent {
    public static final Property status = BRotationalLoadSequencer.newProperty((int)65, (BValue)BStatus.ok, null);
    public static final Property faultCause = BRotationalLoadSequencer.newProperty((int)65, (String)"", null);
    public static final Property facets = BRotationalLoadSequencer.newProperty((int)256, (BValue)BFacets.makeBoolean(), null);
    public static final Property actionFacets = BRotationalLoadSequencer.newProperty((int)256, (BValue)BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)), null);
    public static final Property schedule = BRotationalLoadSequencer.newProperty((int)264, (BValue)new BStatusBoolean(), null);
    public static final Property loadFailed = BRotationalLoadSequencer.newProperty((int)9, (BValue)new BStatusBoolean(), null);
    public static final Property numberOutputs = BRotationalLoadSequencer.newProperty((int)256, (int)2, (BFacets)BFacets.makeInt(null, (int)2, (int)10));
    public static final Property requiredLoads = BRotationalLoadSequencer.newProperty((int)256, (int)1, (BFacets)BFacets.makeInt(null, (int)0, (int)10));
    public static final Property rotationOrder = BRotationalLoadSequencer.newProperty((int)257, (BValue)new BRotationOrder(), null);
    public static final Property rotateMode = BRotationalLoadSequencer.newProperty((int)256, (BValue)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((Type)BSequencerModeEnum.TYPE)), null);
    public static final Property rotateInterval = BRotationalLoadSequencer.newProperty((int)256, (BValue)BRelTime.makeHours((int)168), null);
    public static final Property feedbackDelay = BRotationalLoadSequencer.newProperty((int)256, (BValue)BRelTime.make((long)30000L), null);
    public static final Property lastRotateTime = BRotationalLoadSequencer.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Property runtimeRemainingUntilShift = BRotationalLoadSequencer.newProperty((int)1, (BValue)BRelTime.makeSeconds((int)0), null);
    public static final Property leadLoad = BRotationalLoadSequencer.newProperty((int)5, (BValue)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)), null);
    public static final Property leadLoadEnum = BRotationalLoadSequencer.newProperty((int)1, (BValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE))), null);
    public static final Property leadRuntimeAtStart = BRotationalLoadSequencer.newProperty((int)1, (BValue)BRelTime.makeSeconds((int)0), null);
    public static final Property nextLeadLoad = BRotationalLoadSequencer.newProperty((int)1, (BValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)2, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE))), null);
    public static final Property outA = BRotationalLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outB = BRotationalLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outC = BRotationalLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outD = BRotationalLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outE = BRotationalLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outF = BRotationalLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outG = BRotationalLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outH = BRotationalLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outI = BRotationalLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outJ = BRotationalLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackA = BRotationalLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackB = BRotationalLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackC = BRotationalLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackD = BRotationalLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackE = BRotationalLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackF = BRotationalLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackG = BRotationalLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackH = BRotationalLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackI = BRotationalLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackJ = BRotationalLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property runtimeA = BRotationalLoadSequencer.newProperty((int)10, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeB = BRotationalLoadSequencer.newProperty((int)10, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeC = BRotationalLoadSequencer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeD = BRotationalLoadSequencer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeE = BRotationalLoadSequencer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeF = BRotationalLoadSequencer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeG = BRotationalLoadSequencer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeH = BRotationalLoadSequencer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeI = BRotationalLoadSequencer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeJ = BRotationalLoadSequencer.newProperty((int)2, (BValue)BRelTime.make((long)0L), null);
    public static final Property disabledLoads = BRotationalLoadSequencer.newProperty((int)69, (BValue)new BDisabledLoadsBitString(0), null);
    public static final Property debug = BRotationalLoadSequencer.newProperty((int)4, (boolean)false, null);
    public static final Action startupTimerExpired = BRotationalLoadSequencer.newAction((int)4, null);
    public static final Action rotateTimerExpired = BRotationalLoadSequencer.newAction((int)4, null);
    public static final Action feedbackTimerExpired = BRotationalLoadSequencer.newAction((int)4, null);
    public static final Action runtimeTimerExpired = BRotationalLoadSequencer.newAction((int)4, null);
    public static final Action countdownTimerExpired = BRotationalLoadSequencer.newAction((int)4, null);
    public static final Action checkNext = BRotationalLoadSequencer.newAction((int)4, null);
    public static final Action disableOutput = BRotationalLoadSequencer.newAction((int)0, (BValue)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)), null);
    public static final Action enableOutput = BRotationalLoadSequencer.newAction((int)0, (BValue)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)), null);
    public static final Action manualCmd = BRotationalLoadSequencer.newAction((int)0, (BValue)new BManualSequencerCmd(), null);
    public static final Action manualRotate = BRotationalLoadSequencer.newAction((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    int numOutputs;
    int startedLoads;
    int runningLoads;
    boolean feedbackTimerActive;
    boolean currentIn;
    boolean wasOn;
    boolean isFirst;
    Clock.Ticket rotateTicket;
    Clock.Ticket feedbackTicket;
    Clock.Ticket startupTicket;
    Clock.Ticket runtimeTicket;
    Clock.Ticket countdownTicket;
    static /* synthetic */ Class class$com$vykon$vykonPro$hvac$BRotationalLoadSequencer;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public BFacets getActionFacets() {
        return (BFacets)this.get(actionFacets);
    }

    public void setActionFacets(BFacets bFacets) {
        this.set(actionFacets, (BValue)bFacets, null);
    }

    public BStatusBoolean getSchedule() {
        return (BStatusBoolean)this.get(schedule);
    }

    public void setSchedule(BStatusBoolean bStatusBoolean) {
        this.set(schedule, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getLoadFailed() {
        return (BStatusBoolean)this.get(loadFailed);
    }

    public void setLoadFailed(BStatusBoolean bStatusBoolean) {
        this.set(loadFailed, (BValue)bStatusBoolean, null);
    }

    public int getNumberOutputs() {
        return this.getInt(numberOutputs);
    }

    public void setNumberOutputs(int n) {
        this.setInt(numberOutputs, n, null);
    }

    public int getRequiredLoads() {
        return this.getInt(requiredLoads);
    }

    public void setRequiredLoads(int n) {
        this.setInt(requiredLoads, n, null);
    }

    public BRotationOrder getRotationOrder() {
        return (BRotationOrder)this.get(rotationOrder);
    }

    public void setRotationOrder(BRotationOrder bRotationOrder) {
        this.set(rotationOrder, (BValue)bRotationOrder, null);
    }

    public BEnum getRotateMode() {
        return (BEnum)this.get(rotateMode);
    }

    public void setRotateMode(BEnum bEnum) {
        this.set(rotateMode, (BValue)bEnum, null);
    }

    public BRelTime getRotateInterval() {
        return (BRelTime)this.get(rotateInterval);
    }

    public void setRotateInterval(BRelTime bRelTime) {
        this.set(rotateInterval, (BValue)bRelTime, null);
    }

    public BRelTime getFeedbackDelay() {
        return (BRelTime)this.get(feedbackDelay);
    }

    public void setFeedbackDelay(BRelTime bRelTime) {
        this.set(feedbackDelay, (BValue)bRelTime, null);
    }

    public BAbsTime getLastRotateTime() {
        return (BAbsTime)this.get(lastRotateTime);
    }

    public void setLastRotateTime(BAbsTime bAbsTime) {
        this.set(lastRotateTime, (BValue)bAbsTime, null);
    }

    public BRelTime getRuntimeRemainingUntilShift() {
        return (BRelTime)this.get(runtimeRemainingUntilShift);
    }

    public void setRuntimeRemainingUntilShift(BRelTime bRelTime) {
        this.set(runtimeRemainingUntilShift, (BValue)bRelTime, null);
    }

    public BEnum getLeadLoad() {
        return (BEnum)this.get(leadLoad);
    }

    public void setLeadLoad(BEnum bEnum) {
        this.set(leadLoad, (BValue)bEnum, null);
    }

    public BStatusEnum getLeadLoadEnum() {
        return (BStatusEnum)this.get(leadLoadEnum);
    }

    public void setLeadLoadEnum(BStatusEnum bStatusEnum) {
        this.set(leadLoadEnum, (BValue)bStatusEnum, null);
    }

    public BRelTime getLeadRuntimeAtStart() {
        return (BRelTime)this.get(leadRuntimeAtStart);
    }

    public void setLeadRuntimeAtStart(BRelTime bRelTime) {
        this.set(leadRuntimeAtStart, (BValue)bRelTime, null);
    }

    public BStatusEnum getNextLeadLoad() {
        return (BStatusEnum)this.get(nextLeadLoad);
    }

    public void setNextLeadLoad(BStatusEnum bStatusEnum) {
        this.set(nextLeadLoad, (BValue)bStatusEnum, null);
    }

    public BStatusBoolean getOutA() {
        return (BStatusBoolean)this.get(outA);
    }

    public void setOutA(BStatusBoolean bStatusBoolean) {
        this.set(outA, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutB() {
        return (BStatusBoolean)this.get(outB);
    }

    public void setOutB(BStatusBoolean bStatusBoolean) {
        this.set(outB, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutC() {
        return (BStatusBoolean)this.get(outC);
    }

    public void setOutC(BStatusBoolean bStatusBoolean) {
        this.set(outC, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutD() {
        return (BStatusBoolean)this.get(outD);
    }

    public void setOutD(BStatusBoolean bStatusBoolean) {
        this.set(outD, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutE() {
        return (BStatusBoolean)this.get(outE);
    }

    public void setOutE(BStatusBoolean bStatusBoolean) {
        this.set(outE, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutF() {
        return (BStatusBoolean)this.get(outF);
    }

    public void setOutF(BStatusBoolean bStatusBoolean) {
        this.set(outF, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutG() {
        return (BStatusBoolean)this.get(outG);
    }

    public void setOutG(BStatusBoolean bStatusBoolean) {
        this.set(outG, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutH() {
        return (BStatusBoolean)this.get(outH);
    }

    public void setOutH(BStatusBoolean bStatusBoolean) {
        this.set(outH, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutI() {
        return (BStatusBoolean)this.get(outI);
    }

    public void setOutI(BStatusBoolean bStatusBoolean) {
        this.set(outI, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutJ() {
        return (BStatusBoolean)this.get(outJ);
    }

    public void setOutJ(BStatusBoolean bStatusBoolean) {
        this.set(outJ, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackA() {
        return (BStatusBoolean)this.get(feedbackA);
    }

    public void setFeedbackA(BStatusBoolean bStatusBoolean) {
        this.set(feedbackA, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackB() {
        return (BStatusBoolean)this.get(feedbackB);
    }

    public void setFeedbackB(BStatusBoolean bStatusBoolean) {
        this.set(feedbackB, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackC() {
        return (BStatusBoolean)this.get(feedbackC);
    }

    public void setFeedbackC(BStatusBoolean bStatusBoolean) {
        this.set(feedbackC, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackD() {
        return (BStatusBoolean)this.get(feedbackD);
    }

    public void setFeedbackD(BStatusBoolean bStatusBoolean) {
        this.set(feedbackD, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackE() {
        return (BStatusBoolean)this.get(feedbackE);
    }

    public void setFeedbackE(BStatusBoolean bStatusBoolean) {
        this.set(feedbackE, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackF() {
        return (BStatusBoolean)this.get(feedbackF);
    }

    public void setFeedbackF(BStatusBoolean bStatusBoolean) {
        this.set(feedbackF, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackG() {
        return (BStatusBoolean)this.get(feedbackG);
    }

    public void setFeedbackG(BStatusBoolean bStatusBoolean) {
        this.set(feedbackG, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackH() {
        return (BStatusBoolean)this.get(feedbackH);
    }

    public void setFeedbackH(BStatusBoolean bStatusBoolean) {
        this.set(feedbackH, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackI() {
        return (BStatusBoolean)this.get(feedbackI);
    }

    public void setFeedbackI(BStatusBoolean bStatusBoolean) {
        this.set(feedbackI, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackJ() {
        return (BStatusBoolean)this.get(feedbackJ);
    }

    public void setFeedbackJ(BStatusBoolean bStatusBoolean) {
        this.set(feedbackJ, (BValue)bStatusBoolean, null);
    }

    public BRelTime getRuntimeA() {
        return (BRelTime)this.get(runtimeA);
    }

    public void setRuntimeA(BRelTime bRelTime) {
        this.set(runtimeA, (BValue)bRelTime, null);
    }

    public BRelTime getRuntimeB() {
        return (BRelTime)this.get(runtimeB);
    }

    public void setRuntimeB(BRelTime bRelTime) {
        this.set(runtimeB, (BValue)bRelTime, null);
    }

    public BRelTime getRuntimeC() {
        return (BRelTime)this.get(runtimeC);
    }

    public void setRuntimeC(BRelTime bRelTime) {
        this.set(runtimeC, (BValue)bRelTime, null);
    }

    public BRelTime getRuntimeD() {
        return (BRelTime)this.get(runtimeD);
    }

    public void setRuntimeD(BRelTime bRelTime) {
        this.set(runtimeD, (BValue)bRelTime, null);
    }

    public BRelTime getRuntimeE() {
        return (BRelTime)this.get(runtimeE);
    }

    public void setRuntimeE(BRelTime bRelTime) {
        this.set(runtimeE, (BValue)bRelTime, null);
    }

    public BRelTime getRuntimeF() {
        return (BRelTime)this.get(runtimeF);
    }

    public void setRuntimeF(BRelTime bRelTime) {
        this.set(runtimeF, (BValue)bRelTime, null);
    }

    public BRelTime getRuntimeG() {
        return (BRelTime)this.get(runtimeG);
    }

    public void setRuntimeG(BRelTime bRelTime) {
        this.set(runtimeG, (BValue)bRelTime, null);
    }

    public BRelTime getRuntimeH() {
        return (BRelTime)this.get(runtimeH);
    }

    public void setRuntimeH(BRelTime bRelTime) {
        this.set(runtimeH, (BValue)bRelTime, null);
    }

    public BRelTime getRuntimeI() {
        return (BRelTime)this.get(runtimeI);
    }

    public void setRuntimeI(BRelTime bRelTime) {
        this.set(runtimeI, (BValue)bRelTime, null);
    }

    public BRelTime getRuntimeJ() {
        return (BRelTime)this.get(runtimeJ);
    }

    public void setRuntimeJ(BRelTime bRelTime) {
        this.set(runtimeJ, (BValue)bRelTime, null);
    }

    public BDisabledLoadsBitString getDisabledLoads() {
        return (BDisabledLoadsBitString)this.get(disabledLoads);
    }

    public void setDisabledLoads(BDisabledLoadsBitString bDisabledLoadsBitString) {
        this.set(disabledLoads, (BValue)bDisabledLoadsBitString, null);
    }

    public boolean getDebug() {
        return this.getBoolean(debug);
    }

    public void setDebug(boolean bl) {
        this.setBoolean(debug, bl, null);
    }

    public void startupTimerExpired() {
        this.invoke(startupTimerExpired, null, null);
    }

    public void rotateTimerExpired() {
        this.invoke(rotateTimerExpired, null, null);
    }

    public void feedbackTimerExpired() {
        this.invoke(feedbackTimerExpired, null, null);
    }

    public void runtimeTimerExpired() {
        this.invoke(runtimeTimerExpired, null, null);
    }

    public void countdownTimerExpired() {
        this.invoke(countdownTimerExpired, null, null);
    }

    public void checkNext() {
        this.invoke(checkNext, null, null);
    }

    public void disableOutput(BEnum bEnum) {
        this.invoke(disableOutput, (BValue)bEnum, null);
    }

    public void enableOutput(BEnum bEnum) {
        this.invoke(enableOutput, (BValue)bEnum, null);
    }

    public void manualCmd(BManualSequencerCmd bManualSequencerCmd) {
        this.invoke(manualCmd, (BValue)bManualSequencerCmd, null);
    }

    public void manualRotate() {
        this.invoke(manualRotate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (this.startupTicket != null) {
            this.startupTicket.cancel();
        }
        this.startupTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)30), (Action)startupTimerExpired, null);
        this.numOutputs = this.getNumberOutputs();
        this.initNumberOutputs();
    }

    public void stopped() {
        if (this.feedbackTicket != null) {
            this.feedbackTicket.cancel();
        }
        if (this.rotateTicket != null) {
            this.rotateTicket.cancel();
        }
        if (this.startupTicket != null) {
            this.startupTicket.cancel();
        }
        if (this.runtimeTicket != null) {
            this.runtimeTicket.cancel();
        }
        if (this.countdownTicket != null) {
            this.countdownTicket.cancel();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property == numberOutputs) {
            this.initNumberOutputs();
        } else if (property == schedule) {
            this.calculate();
        } else if (property == requiredLoads) {
            if (this.getSchedule().getValue()) {
                this.startOutput();
            }
        } else if (property == feedbackA || property == feedbackB || property == feedbackC || property == feedbackD || property == feedbackE || property == feedbackF || property == feedbackG || property == feedbackH || property == feedbackI || property == feedbackJ) {
            if (!this.currentIn) {
                return;
            }
            if (this.feedbackTimerActive) {
                return;
            }
            this.checkRunningStatus();
        } else if (property == rotateMode) {
            int n = this.getRotateMode().getOrdinal();
            switch (n) {
                case 2: {
                    BRelTime bRelTime = BRelTime.make((long)this.getRuntime(this.getLeadLoad().getEnum().getOrdinal()));
                    this.setLeadRuntimeAtStart(bRelTime);
                    this.setRuntimeRemainingUntilShift(this.getRotateInterval());
                    this.startRuntimeTimer();
                    if (this.rotateTicket == null) break;
                    this.rotateTicket.cancel();
                    break;
                }
                case 1: {
                    this.startRotateTimer();
                    if (this.runtimeTicket == null) break;
                    this.runtimeTicket.cancel();
                    break;
                }
                case 0: {
                    this.startCountdownTimer();
                    if (this.rotateTicket != null) {
                        this.rotateTicket.cancel();
                    }
                    if (this.runtimeTicket == null) break;
                    this.runtimeTicket.cancel();
                    break;
                }
            }
        }
    }

    public void initNumberOutputs() {
        this.numOutputs = this.getNumberOutputs();
        boolean bl = false;
        int n = 0;
        while (n < 10) {
            int n2;
            if (n >= this.numOutputs) {
                n2 = 6;
                bl = false;
            } else {
                n2 = 10;
                bl = true;
            }
            switch (n) {
                case 0: {
                    this.initSlot("outA", n2 | 1);
                    this.initSlot("runtimeA", n2);
                    this.initSlot("feedbackA", n2);
                    this.initLoads("outA", bl, 1);
                    break;
                }
                case 1: {
                    this.initSlot("outB", n2 | 1);
                    this.initSlot("runtimeB", n2);
                    this.initSlot("feedbackB", n2);
                    this.initLoads("outB", bl, 2);
                    break;
                }
                case 2: {
                    this.initSlot("outC", n2 | 1);
                    this.initSlot("runtimeC", n2);
                    this.initSlot("feedbackC", n2);
                    this.initLoads("outC", bl, 3);
                    break;
                }
                case 3: {
                    this.initSlot("outD", n2 | 1);
                    this.initSlot("runtimeD", n2);
                    this.initSlot("feedbackD", n2);
                    this.initLoads("outD", bl, 4);
                    break;
                }
                case 4: {
                    this.initSlot("outE", n2 | 1);
                    this.initSlot("runtimeE", n2);
                    this.initSlot("feedbackE", n2);
                    this.initLoads("outE", bl, 5);
                    break;
                }
                case 5: {
                    this.initSlot("outF", n2 | 1);
                    this.initSlot("runtimeF", n2);
                    this.initSlot("feedbackF", n2);
                    this.initLoads("outF", bl, 6);
                    break;
                }
                case 6: {
                    this.initSlot("outG", n2 | 1);
                    this.initSlot("runtimeG", n2);
                    this.initSlot("feedbackG", n2);
                    this.initLoads("outG", bl, 7);
                    break;
                }
                case 7: {
                    this.initSlot("outH", n2 | 1);
                    this.initSlot("runtimeH", n2);
                    this.initSlot("feedbackH", n2);
                    this.initLoads("outH", bl, 8);
                    break;
                }
                case 8: {
                    this.initSlot("outI", n2 | 1);
                    this.initSlot("runtimeI", n2);
                    this.initSlot("feedbackI", n2);
                    this.initLoads("outI", bl, 9);
                    break;
                }
                case 9: {
                    this.initSlot("outJ", n2 | 1);
                    this.initSlot("runtimeJ", n2);
                    this.initSlot("feedbackJ", n2);
                    this.initLoads("outJ", bl, 10);
                    break;
                }
            }
            int[] nArray = this.getDisabledLoads().getOrdinals();
            int n3 = 0;
            while (n3 < nArray.length) {
                if (this.getDisabledLoads().getBit(nArray[n3])) {
                    String string = this.getDisabledLoads().getTag(nArray[n3]);
                    ((BStatusBoolean)this.get(string)).setStatusDisabled(true);
                }
                ++n3;
            }
            ++n;
        }
    }

    void initSlot(String string, int n) {
        try {
            this.setFlags(this.getSlot(string), n, null);
        }
        catch (Exception exception) {}
    }

    void initLoads(String string, boolean bl, int n) {
        int n2 = 5;
        BRotationOrder bRotationOrder = this.getRotationOrder();
        if (bl) {
            if (bRotationOrder.get(string) == null) {
                bRotationOrder.add(string, (BValue)BInteger.make((int)n));
                bRotationOrder.setFlags(bRotationOrder.getSlot(string), n2);
            }
        } else if (bRotationOrder.get(string) != null) {
            bRotationOrder.remove(string);
        }
    }

    public void doStartupTimerExpired() {
        if (this.startupTicket != null) {
            this.startupTicket.cancel();
        }
        this.calculate();
    }

    public void doCountdownTimerExpired() {
        BAbsTime bAbsTime;
        BAbsTime bAbsTime2 = Clock.time();
        BRelTime bRelTime = bAbsTime2.delta(bAbsTime = this.getLastRotateTime().add(this.getRotateInterval()));
        if (bRelTime.getMillis() > 1000L) {
            this.setRuntimeRemainingUntilShift(bRelTime);
        } else {
            this.setRuntimeRemainingUntilShift(BRelTime.make((long)0L));
        }
    }

    public void doRotateTimerExpired() {
        BAbsTime bAbsTime;
        BAbsTime bAbsTime2 = Clock.time();
        BRelTime bRelTime = bAbsTime2.delta(bAbsTime = this.getLastRotateTime().add(this.getRotateInterval()));
        if (bRelTime.getMillis() > 1000L) {
            this.setRuntimeRemainingUntilShift(bRelTime);
        } else {
            this.setRuntimeRemainingUntilShift(BRelTime.make((long)0L));
            this.rotateLead();
            this.startOutput();
        }
    }

    public void doFeedbackTimerExpired() {
        this.feedbackTimerActive = false;
        if (!this.currentIn) {
            return;
        }
        this.checkRunningStatus();
    }

    public void doRuntimeTimerExpired() {
        long l;
        long l2 = this.getRuntime(this.getLeadLoad().getEnum().getOrdinal());
        long l3 = l2 - (l = this.getLeadRuntimeAtStart().getMillis());
        if (l3 > 0L) {
            long l4 = this.getRotateInterval().getMillis() - l3;
            if (l4 > 1000L) {
                this.setRuntimeRemainingUntilShift(BRelTime.make((long)l4));
            } else {
                this.setRuntimeRemainingUntilShift(BRelTime.make((long)0L));
                this.rotateLead();
                this.startOutput();
            }
        }
    }

    public void doManualRotate() {
        this.rotateLead();
        if (this.currentIn) {
            this.startOutput();
        } else {
            this.checkNext();
        }
    }

    public void doDisableOutput(BEnum bEnum) {
        int n = bEnum.getEnum().getOrdinal();
        this.getStatusOutput(n).setStatusDisabled(true);
        int n2 = this.getLoadBit(n);
        this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() | n2));
        this.startOutput();
    }

    public void doEnableOutput(BEnum bEnum) {
        int n = bEnum.getEnum().getOrdinal();
        this.getStatusOutput(n).setStatusDisabled(false);
        int n2 = this.getLoadBit(n);
        this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() & ~n2));
        this.startOutput();
    }

    public void doManualCmd(BManualSequencerCmd bManualSequencerCmd) {
        int n = bManualSequencerCmd.getOutput().getOrdinal();
        if (bManualSequencerCmd.getCommand()) {
            this.getStatusOutput(n).setStatusDisabled(true);
            int n2 = this.getLoadBit(n);
            this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() | n2));
        } else {
            this.getStatusOutput(n).setStatusDisabled(false);
            int n3 = this.getLoadBit(n);
            this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() & ~n3));
        }
    }

    public void doCheckNext() {
        this.checkNextLoad();
    }

    void calculate() {
        this.currentIn = this.getSchedule().getValue();
        if (this.currentIn) {
            if (!this.wasOn) {
                this.startOutput();
                if (this.getRotateMode().getOrdinal() == 1) {
                    this.startRotateTimer();
                } else if (this.getRotateMode().getOrdinal() == 2) {
                    this.startRuntimeTimer();
                } else {
                    this.startCountdownTimer();
                }
                this.wasOn = true;
            }
        } else {
            if (this.wasOn) {
                if (this.rotateTicket != null) {
                    this.rotateTicket.cancel();
                }
                if (this.feedbackTicket != null) {
                    this.feedbackTicket.cancel();
                }
                if (this.countdownTicket != null) {
                    this.countdownTicket.cancel();
                }
                if (this.runtimeTicket != null) {
                    this.runtimeTicket.cancel();
                }
                this.wasOn = false;
            }
            this.stopOutput();
        }
    }

    private final void rotateLead() {
        int n;
        BRotationOrder bRotationOrder = this.getRotationOrder();
        String string = this.getLeadLoad().getTag();
        string = string.substring(string.length() - 1);
        String string2 = bRotationOrder.getOrder();
        String[] stringArray = TextUtil.splitAndTrim((String)string2, (char)',');
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (bl2 && this.getOutStatus(n = ((BInteger)bRotationOrder.get("out" + stringArray[n2])).getInt())) {
                this.setLeadLoad((BEnum)BDynamicEnum.make((int)n, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)));
                this.getLeadLoadEnum().setValue(BDynamicEnum.make((int)n, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)));
                bl = true;
                break;
            }
            if (string.equals(stringArray[n2])) {
                bl2 = true;
            }
            ++n2;
        }
        if (!bl && bl2) {
            n2 = 0;
            while (n2 < stringArray.length) {
                if (string.equals(stringArray[n2])) break;
                n = ((BInteger)bRotationOrder.get("out" + stringArray[n2])).getInt();
                if (this.getOutStatus(n)) {
                    this.setLeadLoad((BEnum)BDynamicEnum.make((int)n, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)));
                    this.getLeadLoadEnum().setValue(BDynamicEnum.make((int)n, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)));
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        if (bl) {
            this.startOutput();
            this.setLastRotateTime(Clock.time());
            BRelTime bRelTime = BRelTime.make((long)this.getRuntime(this.getLeadLoad().getEnum().getOrdinal()));
            this.setLeadRuntimeAtStart(bRelTime);
            this.setRuntimeRemainingUntilShift(this.getRotateInterval());
            if (this.getStatus().isFault()) {
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)2, (boolean)false));
                this.setFaultCause("");
            }
        } else {
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)2, (boolean)true));
            this.setFaultCause("There are no loads available to rotate the lead load at - " + Clock.time());
        }
    }

    private final void checkNextLoad() {
        int n;
        boolean bl = false;
        BRotationOrder bRotationOrder = this.getRotationOrder();
        String string = this.getLeadLoad().getTag();
        string = string.substring(string.length() - 1);
        String string2 = bRotationOrder.getOrder();
        String[] stringArray = TextUtil.splitAndTrim((String)string2, (char)',');
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (bl2 && this.getOutStatus(n = ((BInteger)bRotationOrder.get("out" + stringArray[n2])).getInt())) {
                this.getNextLeadLoad().setValue(BDynamicEnum.make((int)n, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)));
                bl = true;
                break;
            }
            if (string.equals(stringArray[n2])) {
                bl2 = true;
            }
            ++n2;
        }
        if (!bl && bl2) {
            n2 = 0;
            while (n2 < stringArray.length) {
                if (string.equals(stringArray[n2])) break;
                n = ((BInteger)bRotationOrder.get("out" + stringArray[n2])).getInt();
                if (this.getOutStatus(n)) {
                    this.getNextLeadLoad().setValue(BDynamicEnum.make((int)n, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)));
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
    }

    long getRuntime(int n) {
        switch (n) {
            case 1: {
                return this.getRuntimeA().getMillis();
            }
            case 2: {
                return this.getRuntimeB().getMillis();
            }
            case 3: {
                return this.getRuntimeC().getMillis();
            }
            case 4: {
                return this.getRuntimeD().getMillis();
            }
            case 5: {
                return this.getRuntimeE().getMillis();
            }
            case 6: {
                return this.getRuntimeF().getMillis();
            }
            case 7: {
                return this.getRuntimeG().getMillis();
            }
            case 8: {
                return this.getRuntimeH().getMillis();
            }
            case 9: {
                return this.getRuntimeI().getMillis();
            }
            case 10: {
                return this.getRuntimeJ().getMillis();
            }
        }
        return Long.MAX_VALUE;
    }

    boolean getOutValue(int n) {
        switch (n) {
            case 1: {
                return this.getOutA().getValue();
            }
            case 2: {
                return this.getOutB().getValue();
            }
            case 3: {
                return this.getOutC().getValue();
            }
            case 4: {
                return this.getOutD().getValue();
            }
            case 5: {
                return this.getOutE().getValue();
            }
            case 6: {
                return this.getOutF().getValue();
            }
            case 7: {
                return this.getOutG().getValue();
            }
            case 8: {
                return this.getOutH().getValue();
            }
            case 9: {
                return this.getOutI().getValue();
            }
            case 10: {
                return this.getOutJ().getValue();
            }
        }
        return false;
    }

    boolean getOutStatus(int n) {
        switch (n) {
            case 1: {
                return this.getOutA().getStatus().isOk();
            }
            case 2: {
                return this.getOutB().getStatus().isOk();
            }
            case 3: {
                return this.getOutC().getStatus().isOk();
            }
            case 4: {
                return this.getOutD().getStatus().isOk();
            }
            case 5: {
                return this.getOutE().getStatus().isOk();
            }
            case 6: {
                return this.getOutF().getStatus().isOk();
            }
            case 7: {
                return this.getOutG().getStatus().isOk();
            }
            case 8: {
                return this.getOutH().getStatus().isOk();
            }
            case 9: {
                return this.getOutI().getStatus().isOk();
            }
            case 10: {
                return this.getOutJ().getStatus().isOk();
            }
        }
        return false;
    }

    boolean getFeedbackValue(int n) {
        switch (n) {
            case 1: {
                return this.getFeedbackA().getValue();
            }
            case 2: {
                return this.getFeedbackB().getValue();
            }
            case 3: {
                return this.getFeedbackC().getValue();
            }
            case 4: {
                return this.getFeedbackD().getValue();
            }
            case 5: {
                return this.getFeedbackE().getValue();
            }
            case 6: {
                return this.getFeedbackF().getValue();
            }
            case 7: {
                return this.getFeedbackG().getValue();
            }
            case 8: {
                return this.getFeedbackH().getValue();
            }
            case 9: {
                return this.getFeedbackI().getValue();
            }
            case 10: {
                return this.getFeedbackJ().getValue();
            }
        }
        return false;
    }

    void startOutput() {
        int n;
        if (this.getDebug()) {
            System.out.println(this.getSlotPath() + " - running start output");
        }
        if (!this.getSchedule().getValue()) {
            return;
        }
        int n2 = this.getLeadLoad().getEnum().getOrdinal();
        int n3 = this.getRequiredLoads();
        int n4 = 0;
        boolean bl = false;
        BRotationOrder bRotationOrder = this.getRotationOrder();
        String string = bRotationOrder.getOrder();
        String[] stringArray = TextUtil.splitAndTrim((String)string, (char)',');
        boolean bl2 = false;
        if (this.getDebug()) {
            System.out.println("lead load is " + n2 + " , required loads " + n3);
        }
        int n5 = 0;
        while (n5 < stringArray.length) {
            if (bRotationOrder.get("out" + stringArray[n5]) != null) {
                n = ((BInteger)bRotationOrder.get("out" + stringArray[n5])).getInt();
                if (n == n2) {
                    bl2 = true;
                    if (n4 < n3 && this.getStatusOutput(n2).getStatus().isOk()) {
                        if (!this.getStatusOutput(n2).getValue()) {
                            this.getStatusOutput(n2).setValue(true);
                            bl = true;
                        }
                        ++n4;
                        if (this.getDebug()) {
                            System.out.println("checked lead load, started " + n4);
                        }
                    } else {
                        if (this.getRequiredLoads() == 0) {
                            this.getStatusOutput(n2).setValue(false);
                        }
                        if (this.getDebug()) {
                            System.out.println("checking " + stringArray[n5] + " , enough loads already started");
                        }
                    }
                } else if (n != n2 && bl2 && n4 < n3) {
                    if (this.getStatusOutput(n).getStatus().isOk()) {
                        if (!this.getStatusOutput(n).getValue()) {
                            this.getStatusOutput(n).setValue(true);
                            bl = true;
                        }
                        ++n4;
                        if (this.getDebug()) {
                            System.out.println("checked lead load, started " + n4);
                        }
                    }
                } else if (n4 == n3) {
                    this.getStatusOutput(n).setValue(false);
                    if (this.getDebug()) {
                        System.out.println("checking " + stringArray[n5] + " , enough loads already started");
                    }
                }
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < stringArray.length) {
            if (bRotationOrder.get("out" + stringArray[n5]) != null) {
                n = ((BInteger)bRotationOrder.get("out" + stringArray[n5])).getInt();
                if (n == n2) break;
                if (n4 < n3) {
                    if (this.getStatusOutput(n).getStatus().isOk()) {
                        if (!this.getStatusOutput(n).getValue()) {
                            this.getStatusOutput(n).setValue(true);
                            bl = true;
                        }
                        ++n4;
                        if (this.getDebug()) {
                            System.out.println("checked lead load, started " + n4);
                        }
                    }
                } else if (n4 == n3) {
                    this.getStatusOutput(n).setValue(false);
                    if (this.getDebug()) {
                        System.out.println("checking " + stringArray[n5] + " , enough loads already started");
                    }
                }
            }
            ++n5;
        }
        if (n4 < n3) {
            if (this.getDebug()) {
                System.out.println("didn't start the required number of loads");
            }
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)true));
            this.setFaultCause("Not enough loads available to start the required number!");
        } else {
            if (this.getDebug()) {
                System.out.println("started the required number of loads");
            }
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)false));
            if (!this.getStatus().isFault()) {
                this.setFaultCause("");
            }
        }
        if (bl) {
            this.startFeedbackTimer();
        }
        this.checkNextLoad();
    }

    BStatusBoolean getStatusOutput(int n) {
        switch (n) {
            case 1: {
                return this.getOutA();
            }
            case 2: {
                return this.getOutB();
            }
            case 3: {
                return this.getOutC();
            }
            case 4: {
                return this.getOutD();
            }
            case 5: {
                return this.getOutE();
            }
            case 6: {
                return this.getOutF();
            }
            case 7: {
                return this.getOutG();
            }
            case 8: {
                return this.getOutH();
            }
            case 9: {
                return this.getOutI();
            }
            case 10: {
                return this.getOutJ();
            }
        }
        if (n < 1) {
            return this.getOutA();
        }
        return this.getOutJ();
    }

    void stopOutput() {
        int n = 1;
        while (n <= this.numOutputs) {
            this.getStatusOutput(n).setValue(false);
            ++n;
        }
        this.checkRunningStatus();
    }

    void startCountdownTimer() {
        if (this.countdownTicket != null) {
            this.countdownTicket.cancel();
        }
        this.countdownTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)countdownTimerExpired, null);
    }

    void startRotateTimer() {
        if (this.rotateTicket != null) {
            this.rotateTicket.cancel();
        }
        this.rotateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)rotateTimerExpired, null);
    }

    void startFeedbackTimer() {
        if (this.feedbackTicket != null) {
            this.feedbackTicket.cancel();
        }
        this.feedbackTimerActive = true;
        this.feedbackTicket = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackTimerExpired, null);
    }

    void startRuntimeTimer() {
        if (this.runtimeTicket != null) {
            this.runtimeTicket.cancel();
        }
        this.runtimeTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)runtimeTimerExpired, null);
    }

    void checkRunningStatus() {
        if (this.getDebug()) {
            System.out.println(this.getSlotPath() + "checking running status");
        }
        this.startedLoads = 0;
        this.runningLoads = 0;
        boolean bl = false;
        int n = 1;
        while (n <= this.numOutputs) {
            BStatusBoolean bStatusBoolean = this.getStatusOutput(n);
            boolean bl2 = this.getFeedbackValue(n);
            if (this.getDebug()) {
                System.out.println("load " + n + " out - " + bStatusBoolean.getValue() + " | feedback - " + bl2);
            }
            if (bStatusBoolean.getValue() && !bl2) {
                bStatusBoolean.setStatusInAlarm(true);
                bl = true;
                ++this.startedLoads;
            } else if (bStatusBoolean.getValue() && bl2) {
                bStatusBoolean.setStatusInAlarm(false);
                ++this.startedLoads;
                ++this.runningLoads;
            } else if (bStatusBoolean.getValue() || !bl2) {
                bStatusBoolean.setStatusInAlarm(false);
            }
            ++n;
        }
        if (bl || this.startedLoads > this.getRequiredLoads()) {
            if (this.getDebug()) {
                System.out.println(this.startedLoads + " loads started, " + this.getRequiredLoads() + " loads required, or a load is failed");
            }
            this.getLoadFailed().setValue(true);
            this.startOutput();
        } else {
            this.getLoadFailed().setValue(false);
        }
    }

    private final int getLoadBit(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 8;
                break;
            }
            case 5: {
                n2 = 16;
                break;
            }
            case 6: {
                n2 = 32;
                break;
            }
            case 7: {
                n2 = 48;
                break;
            }
            case 8: {
                n2 = 64;
                break;
            }
            case 9: {
                n2 = 128;
                break;
            }
            case 10: {
                n2 = 512;
                break;
            }
        }
        return n2;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.getName().startsWith("out")) {
            return this.getFacets();
        }
        if (slot.getName() == "enableOutput" || slot.getName() == "disableOutput") {
            return this.getActionFacets();
        }
        return super.getSlotFacets(slot);
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.feedbackTimerActive = false;
        this.wasOn = false;
        this.isFirst = false;
    }

    public BRotationalLoadSequencer() {
        this.this();
    }

    static {
        Class clazz = class$com$vykon$vykonPro$hvac$BRotationalLoadSequencer;
        if (clazz == null) {
            clazz = class$com$vykon$vykonPro$hvac$BRotationalLoadSequencer = BRotationalLoadSequencer.class("[Lcom.vykon.vykonPro.hvac.BRotationalLoadSequencer;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"reorder.png");
    }
}

