/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.hvac;

import com.vykon.vykonPro.util.BVykonProService;
import javax.baja.collection.BIList;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BMinMaxAvgBql
extends BComponent {
    public static final Property status = BMinMaxAvgBql.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BMinMaxAvgBql.newProperty((int)3, (String)"", null);
    public static final Property enabled = BMinMaxAvgBql.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property pointQuery = BMinMaxAvgBql.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property numberOfPoints = BMinMaxAvgBql.newProperty((int)11, (int)0, null);
    public static final Property facets = BMinMaxAvgBql.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Property count = BMinMaxAvgBql.newProperty((int)11, (int)0, null);
    public static final Property avg = BMinMaxAvgBql.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property sum = BMinMaxAvgBql.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property min = BMinMaxAvgBql.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property minZoneIdentifier = BMinMaxAvgBql.newProperty((int)11, (BValue)new BStatusString(), null);
    public static final Property max = BMinMaxAvgBql.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property maxZoneIdentifier = BMinMaxAvgBql.newProperty((int)11, (BValue)new BStatusString(), null);
    public static final Property zoneIdentifierFormat = BMinMaxAvgBql.newProperty((int)0, (BValue)BFormat.make((String)"%name%"), null);
    public static final Property updateValuesInterval = BMinMaxAvgBql.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)15), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property refreshQueryInterval = BMinMaxAvgBql.newProperty((int)0, (BValue)BRelTime.makeHours((int)12), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)1)));
    public static final Property startDelay = BMinMaxAvgBql.newProperty((int)256, (BValue)BRelTime.makeMinutes((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property nextRefreshTime = BMinMaxAvgBql.newProperty((int)5, (BValue)BAbsTime.NULL, null);
    public static final Action calculate = BMinMaxAvgBql.newAction((int)4, null);
    public static final Action initializeList = BMinMaxAvgBql.newAction((int)0, null);
    public static final Action refreshQuery = BMinMaxAvgBql.newAction((int)20, null);
    public static final Type TYPE;
    private static final BIcon icon;
    Clock.Ticket ticket;
    Clock.Ticket calcTicket;
    Clock.Ticket startTicket;
    BIList result;
    BComponent[] comps;
    boolean refreshChanged;
    static /* synthetic */ Class class$com$vykon$vykonPro$hvac$BMinMaxAvgBql;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BOrd getPointQuery() {
        return (BOrd)this.get(pointQuery);
    }

    public void setPointQuery(BOrd bOrd) {
        this.set(pointQuery, (BValue)bOrd, null);
    }

    public int getNumberOfPoints() {
        return this.getInt(numberOfPoints);
    }

    public void setNumberOfPoints(int n) {
        this.setInt(numberOfPoints, n, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public int getCount() {
        return this.getInt(count);
    }

    public void setCount(int n) {
        this.setInt(count, n, null);
    }

    public BStatusNumeric getAvg() {
        return (BStatusNumeric)this.get(avg);
    }

    public void setAvg(BStatusNumeric bStatusNumeric) {
        this.set(avg, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getSum() {
        return (BStatusNumeric)this.get(sum);
    }

    public void setSum(BStatusNumeric bStatusNumeric) {
        this.set(sum, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getMin() {
        return (BStatusNumeric)this.get(min);
    }

    public void setMin(BStatusNumeric bStatusNumeric) {
        this.set(min, (BValue)bStatusNumeric, null);
    }

    public BStatusString getMinZoneIdentifier() {
        return (BStatusString)this.get(minZoneIdentifier);
    }

    public void setMinZoneIdentifier(BStatusString bStatusString) {
        this.set(minZoneIdentifier, (BValue)bStatusString, null);
    }

    public BStatusNumeric getMax() {
        return (BStatusNumeric)this.get(max);
    }

    public void setMax(BStatusNumeric bStatusNumeric) {
        this.set(max, (BValue)bStatusNumeric, null);
    }

    public BStatusString getMaxZoneIdentifier() {
        return (BStatusString)this.get(maxZoneIdentifier);
    }

    public void setMaxZoneIdentifier(BStatusString bStatusString) {
        this.set(maxZoneIdentifier, (BValue)bStatusString, null);
    }

    public BFormat getZoneIdentifierFormat() {
        return (BFormat)this.get(zoneIdentifierFormat);
    }

    public void setZoneIdentifierFormat(BFormat bFormat) {
        this.set(zoneIdentifierFormat, (BValue)bFormat, null);
    }

    public BRelTime getUpdateValuesInterval() {
        return (BRelTime)this.get(updateValuesInterval);
    }

    public void setUpdateValuesInterval(BRelTime bRelTime) {
        this.set(updateValuesInterval, (BValue)bRelTime, null);
    }

    public BRelTime getRefreshQueryInterval() {
        return (BRelTime)this.get(refreshQueryInterval);
    }

    public void setRefreshQueryInterval(BRelTime bRelTime) {
        this.set(refreshQueryInterval, (BValue)bRelTime, null);
    }

    public BRelTime getStartDelay() {
        return (BRelTime)this.get(startDelay);
    }

    public void setStartDelay(BRelTime bRelTime) {
        this.set(startDelay, (BValue)bRelTime, null);
    }

    public BAbsTime getNextRefreshTime() {
        return (BAbsTime)this.get(nextRefreshTime);
    }

    public void setNextRefreshTime(BAbsTime bAbsTime) {
        this.set(nextRefreshTime, (BValue)bAbsTime, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public void initializeList() {
        this.invoke(initializeList, null, null);
    }

    public void refreshQuery() {
        this.invoke(refreshQuery, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.checkForService();
        if (this.getEnabled()) {
            this.initStartTicket();
            this.initCalcTicket();
            this.initClockTicket();
        }
    }

    public void stopped() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if (this.calcTicket != null) {
            this.calcTicket.cancel();
        }
        if (this.startTicket != null) {
            this.startTicket.cancel();
        }
    }

    protected final void checkForService() {
        if (BVykonProService.getInstance() == null) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("This component requires the VykonPro service in the station");
        } else if (BVykonProService.getInstance().isDisabled()) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("The vykonPro service is disabled");
        } else {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)avg) || slot.equals((Object)min) || slot.equals((Object)max) || slot.equals((Object)sum)) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void clockChanged(BRelTime bRelTime) {
        if (this.getEnabled()) {
            this.initClockTicket();
            this.initCalcTicket();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (this.getEnabled()) {
            if (property.equals((Object)refreshQueryInterval)) {
                this.refreshChanged = true;
                this.initClockTicket();
            } else if (property.equals((Object)updateValuesInterval)) {
                this.initCalcTicket();
            }
        }
        if (property.equals((Object)zoneIdentifierFormat)) {
            this.calculate();
        } else if (property.equals((Object)pointQuery)) {
            this.initializeList();
        } else if (property.equals((Object)enabled)) {
            if (this.getEnabled()) {
                this.doInitializeList();
                this.initCalcTicket();
                this.initClockTicket();
            } else {
                if (this.ticket != null) {
                    this.ticket.cancel();
                }
                if (this.calcTicket != null) {
                    this.calcTicket.cancel();
                }
            }
        }
    }

    private final void initStartTicket() {
        if (this.startTicket != null) {
            this.startTicket.cancel();
        }
        this.startTicket = Clock.schedule((BComponent)this, (BRelTime)this.getStartDelay(), (Action)initializeList, null);
    }

    void initClockTicket() {
        BAbsTime bAbsTime = this.getNextRefreshTime();
        if (this.refreshChanged) {
            this.refreshChanged = false;
            bAbsTime = BAbsTime.NULL;
        }
        BAbsTime bAbsTime2 = Clock.time();
        if (bAbsTime == BAbsTime.NULL) {
            this.setNextRefreshTime(bAbsTime2.add(this.getRefreshQueryInterval()));
            bAbsTime = this.getNextRefreshTime();
        } else if (bAbsTime2.isAfter(bAbsTime)) {
            while (bAbsTime.isBefore(bAbsTime2)) {
                bAbsTime = bAbsTime.add(this.getRefreshQueryInterval());
            }
            this.setNextRefreshTime(bAbsTime);
        } else if (bAbsTime2.add(this.getRefreshQueryInterval()).isBefore(this.getNextRefreshTime())) {
            this.setNextRefreshTime(bAbsTime2.add(this.getRefreshQueryInterval()));
        }
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)bAbsTime, (BRelTime)this.getRefreshQueryInterval(), (Action)refreshQuery, null);
    }

    void initCalcTicket() {
        if (this.calcTicket != null) {
            this.calcTicket.cancel();
        }
        this.calcTicket = Clock.schedule((BComponent)this, (BRelTime)this.getUpdateValuesInterval(), (Action)calculate, null);
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == refreshQuery) {
            return BVykonProService.getInstance().getWorker().post((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public void doInitializeList() {
        if (!this.getEnabled()) {
            return;
        }
        if (!this.getStatus().isOk()) {
            this.checkForService();
            if (!this.getStatus().isOk()) {
                return;
            }
        }
        if (this.startTicket != null) {
            this.startTicket.cancel();
        }
        if (this.getPointQuery().isNull()) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("must specify a point query");
            return;
        }
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        this.refreshQuery();
    }

    public void doCalculate() throws Exception {
        if (!this.getEnabled()) {
            return;
        }
        if (!this.getStatus().isOk()) {
            this.checkForService();
            if (!this.getStatus().isOk()) {
                return;
            }
        }
        if (this.getPointQuery().isNull()) {
            this.initCalcTicket();
            return;
        }
        if (this.result == null) {
            this.initCalcTicket();
            return;
        }
        long l = Clock.ticks();
        int n = 0;
        double d = 0.0;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        String string = "";
        String string2 = "";
        this.initCalcTicket();
        BComponent.lease((BComponent[])this.comps, (int)0, (long)(this.getUpdateValuesInterval().getMillis() + 1000L));
        int n2 = 0;
        while (n2 < this.result.size()) {
            BStatusNumeric bStatusNumeric;
            if (this.comps[n2].get("out") != null && this.comps[n2].get("out").getType().is(BStatusNumeric.TYPE) && (bStatusNumeric = (BStatusNumeric)this.comps[n2].get("out")).getStatus().isValid() && BDouble.make((double)bStatusNumeric.getValue()) != BDouble.NaN) {
                double d4 = bStatusNumeric.getValue();
                if (d4 < d2) {
                    d2 = d4;
                    string = this.getZoneIdentifierFormat().format((Object)this.comps[n2]);
                }
                if (d4 > d3) {
                    d3 = d4;
                    string2 = this.getZoneIdentifierFormat().format((Object)this.comps[n2]);
                }
                d += d4;
                ++n;
            }
            ++n2;
        }
        this.getMinZoneIdentifier().setValue(string);
        this.getMaxZoneIdentifier().setValue(string2);
        if (d2 == Double.POSITIVE_INFINITY) {
            d2 = Double.NaN;
        }
        if (d3 == Double.NEGATIVE_INFINITY) {
            d2 = Double.NaN;
        }
        if (n != 0) {
            this.getSum().setValue(d);
            this.getAvg().setValue(d / (double)n);
            if (this.getAvg().getStatus().isNull()) {
                this.getAvg().setStatus(BStatus.ok);
            }
            if (this.getSum().getStatus().isNull()) {
                this.getSum().setStatus(BStatus.ok);
            }
        } else {
            this.getSum().setStatus(64);
            this.getAvg().setStatus(64);
        }
        this.setCount(n);
        this.getMin().setValue(d2);
        this.getMax().setValue(d3);
    }

    public void doRefreshQuery() {
        this.result = (BIList)this.getPointQuery().get();
        this.comps = new BComponent[this.result.size()];
        this.result.list((BObject[])this.comps);
        this.setNumberOfPoints(this.result.size());
        this.setNextRefreshTime(this.getNextRefreshTime().add(this.getRefreshQueryInterval()));
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.result = null;
        this.refreshChanged = false;
    }

    public BMinMaxAvgBql() {
        this.this();
    }

    static {
        Class clazz = class$com$vykon$vykonPro$hvac$BMinMaxAvgBql;
        if (clazz == null) {
            clazz = class$com$vykon$vykonPro$hvac$BMinMaxAvgBql = BMinMaxAvgBql.class("[Lcom.vykon.vykonPro.hvac.BMinMaxAvgBql;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"control/numericPoint.png");
    }
}

