/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.hvac;

import com.vykon.vykonPro.enums.BSequencerOutputEnum;
import com.vykon.vykonPro.hvac.BManualSequencerCmd;
import com.vykon.vykonPro.hvac.BRotationOrder;
import com.vykon.vykonPro.util.BDisabledLoadsBitString;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLoadSequencer
extends BComponent {
    public static final Property status = BLoadSequencer.newProperty((int)65, (BValue)BStatus.ok, null);
    public static final Property faultCause = BLoadSequencer.newProperty((int)65, (String)"", null);
    public static final Property facets = BLoadSequencer.newProperty((int)256, (BValue)BFacets.makeBoolean(), null);
    public static final Property actionFacets = BLoadSequencer.newProperty((int)256, (BValue)BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)), null);
    public static final Property schedule = BLoadSequencer.newProperty((int)264, (BValue)new BStatusBoolean(), null);
    public static final Property loadFailed = BLoadSequencer.newProperty((int)9, (BValue)new BStatusBoolean(), null);
    public static final Property numberOutputs = BLoadSequencer.newProperty((int)256, (int)2, (BFacets)BFacets.makeInt(null, (int)2, (int)10));
    public static final Property requiredLoads = BLoadSequencer.newProperty((int)256, (int)1, (BFacets)BFacets.makeInt(null, (int)0, (int)10));
    public static final Property rotationOrder = BLoadSequencer.newProperty((int)257, (BValue)new BRotationOrder(), null);
    public static final Property lastActiveLoad = BLoadSequencer.newProperty((int)3, (String)"", null);
    public static final Property feedbackDelay = BLoadSequencer.newProperty((int)256, (BValue)BRelTime.make((long)30000L), null);
    public static final Property outA = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outB = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outC = BLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outD = BLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outE = BLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outF = BLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outG = BLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outH = BLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outI = BLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outJ = BLoadSequencer.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackA = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackB = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackC = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackD = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackE = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackF = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackG = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackH = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackI = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackJ = BLoadSequencer.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property disabledLoads = BLoadSequencer.newProperty((int)69, (BValue)new BDisabledLoadsBitString(0), null);
    public static final Property debug = BLoadSequencer.newProperty((int)4, (boolean)false, null);
    public static final Action startupTimerExpired = BLoadSequencer.newAction((int)4, null);
    public static final Action feedbackTimerExpired = BLoadSequencer.newAction((int)4, null);
    public static final Action disableOutput = BLoadSequencer.newAction((int)0, (BValue)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)), null);
    public static final Action enableOutput = BLoadSequencer.newAction((int)0, (BValue)BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((Type)BSequencerOutputEnum.TYPE)), null);
    public static final Action manualCmd = BLoadSequencer.newAction((int)0, (BValue)new BManualSequencerCmd(), null);
    public static final Action loadsChanged = BLoadSequencer.newAction((int)4, null);
    public static final Type TYPE;
    private static final BIcon icon;
    int numOutputs;
    int startedLoads;
    int runningLoads;
    boolean feedbackTimerActive;
    boolean currentIn;
    boolean wasOn;
    boolean isFirst;
    Clock.Ticket feedbackTicket;
    Clock.Ticket startupTicket;
    static /* synthetic */ Class class$com$vykon$vykonPro$hvac$BLoadSequencer;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public BFacets getActionFacets() {
        return (BFacets)this.get(actionFacets);
    }

    public void setActionFacets(BFacets bFacets) {
        this.set(actionFacets, (BValue)bFacets, null);
    }

    public BStatusBoolean getSchedule() {
        return (BStatusBoolean)this.get(schedule);
    }

    public void setSchedule(BStatusBoolean bStatusBoolean) {
        this.set(schedule, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getLoadFailed() {
        return (BStatusBoolean)this.get(loadFailed);
    }

    public void setLoadFailed(BStatusBoolean bStatusBoolean) {
        this.set(loadFailed, (BValue)bStatusBoolean, null);
    }

    public int getNumberOutputs() {
        return this.getInt(numberOutputs);
    }

    public void setNumberOutputs(int n) {
        this.setInt(numberOutputs, n, null);
    }

    public int getRequiredLoads() {
        return this.getInt(requiredLoads);
    }

    public void setRequiredLoads(int n) {
        this.setInt(requiredLoads, n, null);
    }

    public BRotationOrder getRotationOrder() {
        return (BRotationOrder)this.get(rotationOrder);
    }

    public void setRotationOrder(BRotationOrder bRotationOrder) {
        this.set(rotationOrder, (BValue)bRotationOrder, null);
    }

    public String getLastActiveLoad() {
        return this.getString(lastActiveLoad);
    }

    public void setLastActiveLoad(String string) {
        this.setString(lastActiveLoad, string, null);
    }

    public BRelTime getFeedbackDelay() {
        return (BRelTime)this.get(feedbackDelay);
    }

    public void setFeedbackDelay(BRelTime bRelTime) {
        this.set(feedbackDelay, (BValue)bRelTime, null);
    }

    public BStatusBoolean getOutA() {
        return (BStatusBoolean)this.get(outA);
    }

    public void setOutA(BStatusBoolean bStatusBoolean) {
        this.set(outA, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutB() {
        return (BStatusBoolean)this.get(outB);
    }

    public void setOutB(BStatusBoolean bStatusBoolean) {
        this.set(outB, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutC() {
        return (BStatusBoolean)this.get(outC);
    }

    public void setOutC(BStatusBoolean bStatusBoolean) {
        this.set(outC, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutD() {
        return (BStatusBoolean)this.get(outD);
    }

    public void setOutD(BStatusBoolean bStatusBoolean) {
        this.set(outD, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutE() {
        return (BStatusBoolean)this.get(outE);
    }

    public void setOutE(BStatusBoolean bStatusBoolean) {
        this.set(outE, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutF() {
        return (BStatusBoolean)this.get(outF);
    }

    public void setOutF(BStatusBoolean bStatusBoolean) {
        this.set(outF, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutG() {
        return (BStatusBoolean)this.get(outG);
    }

    public void setOutG(BStatusBoolean bStatusBoolean) {
        this.set(outG, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutH() {
        return (BStatusBoolean)this.get(outH);
    }

    public void setOutH(BStatusBoolean bStatusBoolean) {
        this.set(outH, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutI() {
        return (BStatusBoolean)this.get(outI);
    }

    public void setOutI(BStatusBoolean bStatusBoolean) {
        this.set(outI, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getOutJ() {
        return (BStatusBoolean)this.get(outJ);
    }

    public void setOutJ(BStatusBoolean bStatusBoolean) {
        this.set(outJ, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackA() {
        return (BStatusBoolean)this.get(feedbackA);
    }

    public void setFeedbackA(BStatusBoolean bStatusBoolean) {
        this.set(feedbackA, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackB() {
        return (BStatusBoolean)this.get(feedbackB);
    }

    public void setFeedbackB(BStatusBoolean bStatusBoolean) {
        this.set(feedbackB, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackC() {
        return (BStatusBoolean)this.get(feedbackC);
    }

    public void setFeedbackC(BStatusBoolean bStatusBoolean) {
        this.set(feedbackC, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackD() {
        return (BStatusBoolean)this.get(feedbackD);
    }

    public void setFeedbackD(BStatusBoolean bStatusBoolean) {
        this.set(feedbackD, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackE() {
        return (BStatusBoolean)this.get(feedbackE);
    }

    public void setFeedbackE(BStatusBoolean bStatusBoolean) {
        this.set(feedbackE, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackF() {
        return (BStatusBoolean)this.get(feedbackF);
    }

    public void setFeedbackF(BStatusBoolean bStatusBoolean) {
        this.set(feedbackF, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackG() {
        return (BStatusBoolean)this.get(feedbackG);
    }

    public void setFeedbackG(BStatusBoolean bStatusBoolean) {
        this.set(feedbackG, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackH() {
        return (BStatusBoolean)this.get(feedbackH);
    }

    public void setFeedbackH(BStatusBoolean bStatusBoolean) {
        this.set(feedbackH, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackI() {
        return (BStatusBoolean)this.get(feedbackI);
    }

    public void setFeedbackI(BStatusBoolean bStatusBoolean) {
        this.set(feedbackI, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getFeedbackJ() {
        return (BStatusBoolean)this.get(feedbackJ);
    }

    public void setFeedbackJ(BStatusBoolean bStatusBoolean) {
        this.set(feedbackJ, (BValue)bStatusBoolean, null);
    }

    public BDisabledLoadsBitString getDisabledLoads() {
        return (BDisabledLoadsBitString)this.get(disabledLoads);
    }

    public void setDisabledLoads(BDisabledLoadsBitString bDisabledLoadsBitString) {
        this.set(disabledLoads, (BValue)bDisabledLoadsBitString, null);
    }

    public boolean getDebug() {
        return this.getBoolean(debug);
    }

    public void setDebug(boolean bl) {
        this.setBoolean(debug, bl, null);
    }

    public void startupTimerExpired() {
        this.invoke(startupTimerExpired, null, null);
    }

    public void feedbackTimerExpired() {
        this.invoke(feedbackTimerExpired, null, null);
    }

    public void disableOutput(BEnum bEnum) {
        this.invoke(disableOutput, (BValue)bEnum, null);
    }

    public void enableOutput(BEnum bEnum) {
        this.invoke(enableOutput, (BValue)bEnum, null);
    }

    public void manualCmd(BManualSequencerCmd bManualSequencerCmd) {
        this.invoke(manualCmd, (BValue)bManualSequencerCmd, null);
    }

    public void loadsChanged() {
        this.invoke(loadsChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (this.startupTicket != null) {
            this.startupTicket.cancel();
        }
        this.startupTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)30), (Action)startupTimerExpired, null);
        this.numOutputs = this.getNumberOutputs();
        this.initNumberOutputs();
    }

    public void stopped() {
        if (this.feedbackTicket != null) {
            this.feedbackTicket.cancel();
        }
        if (this.startupTicket != null) {
            this.startupTicket.cancel();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property == numberOutputs) {
            this.initNumberOutputs();
        } else if (property == schedule) {
            this.calculate();
        } else if (property == requiredLoads) {
            if (this.getSchedule().getValue()) {
                this.startOutput();
            }
        } else if (property == feedbackA || property == feedbackB || property == feedbackC || property == feedbackD || property == feedbackE || property == feedbackF || property == feedbackG || property == feedbackH || property == feedbackI || property == feedbackJ) {
            if (!this.currentIn) {
                return;
            }
            if (this.feedbackTimerActive) {
                return;
            }
            this.checkRunningStatus();
        }
    }

    public void initNumberOutputs() {
        this.numOutputs = this.getNumberOutputs();
        boolean bl = false;
        int n = 0;
        while (n < 10) {
            int n2;
            if (n >= this.numOutputs) {
                n2 = 6;
                bl = false;
            } else {
                n2 = 10;
                bl = true;
            }
            switch (n) {
                case 0: {
                    this.initSlot("outA", n2 | 1);
                    this.initSlot("feedbackA", n2);
                    this.initLoads("outA", bl, 1);
                    break;
                }
                case 1: {
                    this.initSlot("outB", n2 | 1);
                    this.initSlot("feedbackB", n2);
                    this.initLoads("outB", bl, 2);
                    break;
                }
                case 2: {
                    this.initSlot("outC", n2 | 1);
                    this.initSlot("feedbackC", n2);
                    this.initLoads("outC", bl, 3);
                    break;
                }
                case 3: {
                    this.initSlot("outD", n2 | 1);
                    this.initSlot("feedbackD", n2);
                    this.initLoads("outD", bl, 4);
                    break;
                }
                case 4: {
                    this.initSlot("outE", n2 | 1);
                    this.initSlot("feedbackE", n2);
                    this.initLoads("outE", bl, 5);
                    break;
                }
                case 5: {
                    this.initSlot("outF", n2 | 1);
                    this.initSlot("feedbackF", n2);
                    this.initLoads("outF", bl, 6);
                    break;
                }
                case 6: {
                    this.initSlot("outG", n2 | 1);
                    this.initSlot("feedbackG", n2);
                    this.initLoads("outG", bl, 7);
                    break;
                }
                case 7: {
                    this.initSlot("outH", n2 | 1);
                    this.initSlot("feedbackH", n2);
                    this.initLoads("outH", bl, 8);
                    break;
                }
                case 8: {
                    this.initSlot("outI", n2 | 1);
                    this.initSlot("feedbackI", n2);
                    this.initLoads("outI", bl, 9);
                    break;
                }
                case 9: {
                    this.initSlot("outJ", n2 | 1);
                    this.initSlot("feedbackJ", n2);
                    this.initLoads("outJ", bl, 10);
                    break;
                }
            }
            int[] nArray = this.getDisabledLoads().getOrdinals();
            int n3 = 0;
            while (n3 < nArray.length) {
                if (this.getDisabledLoads().getBit(nArray[n3])) {
                    String string = this.getDisabledLoads().getTag(nArray[n3]);
                    ((BStatusBoolean)this.get(string)).setStatusDisabled(true);
                }
                ++n3;
            }
            ++n;
        }
    }

    void initSlot(String string, int n) {
        try {
            this.setFlags(this.getSlot(string), n, null);
        }
        catch (Exception exception) {}
    }

    void initLoads(String string, boolean bl, int n) {
        int n2 = 5;
        BRotationOrder bRotationOrder = this.getRotationOrder();
        if (bl) {
            if (bRotationOrder.get(string) == null) {
                bRotationOrder.add(string, (BValue)BInteger.make((int)n));
                bRotationOrder.setFlags(bRotationOrder.getSlot(string), n2);
            }
        } else if (bRotationOrder.get(string) != null) {
            bRotationOrder.remove(string);
        }
    }

    public void doStartupTimerExpired() {
        if (this.startupTicket != null) {
            this.startupTicket.cancel();
        }
        this.calculate();
    }

    public void doFeedbackTimerExpired() {
        this.feedbackTimerActive = false;
        if (!this.currentIn) {
            return;
        }
        this.checkRunningStatus();
    }

    public void doDisableOutput(BEnum bEnum) {
        int n = bEnum.getEnum().getOrdinal();
        this.getStatusOutput(n).setStatusDisabled(true);
        int n2 = this.getLoadBit(n);
        this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() | n2));
        this.startOutput();
    }

    public void doEnableOutput(BEnum bEnum) {
        int n = bEnum.getEnum().getOrdinal();
        this.getStatusOutput(n).setStatusDisabled(false);
        int n2 = this.getLoadBit(n);
        this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() & ~n2));
        this.startOutput();
    }

    public void doManualCmd(BManualSequencerCmd bManualSequencerCmd) {
        int n = bManualSequencerCmd.getOutput().getOrdinal();
        if (bManualSequencerCmd.getCommand()) {
            this.getStatusOutput(n).setStatusDisabled(true);
            int n2 = this.getLoadBit(n);
            this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() | n2));
        } else {
            this.getStatusOutput(n).setStatusDisabled(false);
            int n3 = this.getLoadBit(n);
            this.setDisabledLoads(BDisabledLoadsBitString.make(this.getDisabledLoads().getBits() & ~n3));
        }
    }

    public void doLoadsChanged() {
        this.startOutput();
    }

    void calculate() {
        this.currentIn = this.getSchedule().getValue();
        if (this.currentIn) {
            if (!this.wasOn) {
                this.startOutput();
                this.wasOn = true;
            }
        } else {
            if (this.wasOn) {
                if (this.feedbackTicket != null) {
                    this.feedbackTicket.cancel();
                }
                this.wasOn = false;
            }
            this.stopOutput();
        }
    }

    boolean getOutValue(int n) {
        switch (n) {
            case 1: {
                return this.getOutA().getValue();
            }
            case 2: {
                return this.getOutB().getValue();
            }
            case 3: {
                return this.getOutC().getValue();
            }
            case 4: {
                return this.getOutD().getValue();
            }
            case 5: {
                return this.getOutE().getValue();
            }
            case 6: {
                return this.getOutF().getValue();
            }
            case 7: {
                return this.getOutG().getValue();
            }
            case 8: {
                return this.getOutH().getValue();
            }
            case 9: {
                return this.getOutI().getValue();
            }
            case 10: {
                return this.getOutJ().getValue();
            }
        }
        return false;
    }

    boolean getOutStatus(int n) {
        switch (n) {
            case 1: {
                return this.getOutA().getStatus().isOk();
            }
            case 2: {
                return this.getOutB().getStatus().isOk();
            }
            case 3: {
                return this.getOutC().getStatus().isOk();
            }
            case 4: {
                return this.getOutD().getStatus().isOk();
            }
            case 5: {
                return this.getOutE().getStatus().isOk();
            }
            case 6: {
                return this.getOutF().getStatus().isOk();
            }
            case 7: {
                return this.getOutG().getStatus().isOk();
            }
            case 8: {
                return this.getOutH().getStatus().isOk();
            }
            case 9: {
                return this.getOutI().getStatus().isOk();
            }
            case 10: {
                return this.getOutJ().getStatus().isOk();
            }
        }
        return false;
    }

    boolean getFeedbackValue(int n) {
        switch (n) {
            case 1: {
                return this.getFeedbackA().getValue();
            }
            case 2: {
                return this.getFeedbackB().getValue();
            }
            case 3: {
                return this.getFeedbackC().getValue();
            }
            case 4: {
                return this.getFeedbackD().getValue();
            }
            case 5: {
                return this.getFeedbackE().getValue();
            }
            case 6: {
                return this.getFeedbackF().getValue();
            }
            case 7: {
                return this.getFeedbackG().getValue();
            }
            case 8: {
                return this.getFeedbackH().getValue();
            }
            case 9: {
                return this.getFeedbackI().getValue();
            }
            case 10: {
                return this.getFeedbackJ().getValue();
            }
        }
        return false;
    }

    void startOutput() {
        if (this.getDebug()) {
            System.out.println(this.getSlotPath() + " - running start output");
        }
        if (!this.getSchedule().getValue()) {
            return;
        }
        String string = "";
        int n = this.getRequiredLoads();
        int n2 = 0;
        boolean bl = false;
        BRotationOrder bRotationOrder = this.getRotationOrder();
        String string2 = bRotationOrder.getOrder();
        String[] stringArray = TextUtil.splitAndTrim((String)string2, (char)',');
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (bRotationOrder.get("out" + stringArray[n3]) != null) {
                int n4 = ((BInteger)bRotationOrder.get("out" + stringArray[n3])).getInt();
                if (n2 < n && this.getStatusOutput(n4).getStatus().isOk()) {
                    if (!this.getStatusOutput(n4).getValue()) {
                        this.getStatusOutput(n4).setValue(true);
                        bl = true;
                    }
                    ++n2;
                    string = "out" + stringArray[n3];
                    if (this.getDebug()) {
                        System.out.println("checked load " + n4 + " , started " + n2);
                    }
                } else if (n2 == n) {
                    this.getStatusOutput(n4).setValue(false);
                    if (this.getDebug()) {
                        System.out.println("checking " + stringArray[n3] + " , enough loads already started");
                    }
                }
            }
            ++n3;
        }
        if (n2 < n) {
            if (this.getDebug()) {
                System.out.println("didn't start the required number of loads");
            }
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)true));
            this.setFaultCause("Not enough loads available to start the required number!");
        } else {
            if (this.getDebug()) {
                System.out.println("started the required number of loads");
            }
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)false));
            if (!this.getStatus().isFault()) {
                this.setFaultCause("");
            }
        }
        if (bl) {
            this.startFeedbackTimer();
        }
        this.setLastActiveLoad(string);
    }

    BStatusBoolean getStatusOutput(int n) {
        switch (n) {
            case 1: {
                return this.getOutA();
            }
            case 2: {
                return this.getOutB();
            }
            case 3: {
                return this.getOutC();
            }
            case 4: {
                return this.getOutD();
            }
            case 5: {
                return this.getOutE();
            }
            case 6: {
                return this.getOutF();
            }
            case 7: {
                return this.getOutG();
            }
            case 8: {
                return this.getOutH();
            }
            case 9: {
                return this.getOutI();
            }
            case 10: {
                return this.getOutJ();
            }
        }
        if (n < 1) {
            return this.getOutA();
        }
        return this.getOutJ();
    }

    void stopOutput() {
        int n = 1;
        while (n <= this.numOutputs) {
            this.getStatusOutput(n).setValue(false);
            ++n;
        }
        this.checkRunningStatus();
        this.setLastActiveLoad("");
    }

    void startFeedbackTimer() {
        if (this.feedbackTicket != null) {
            this.feedbackTicket.cancel();
        }
        this.feedbackTimerActive = true;
        this.feedbackTicket = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackTimerExpired, null);
    }

    void checkRunningStatus() {
        if (this.getDebug()) {
            System.out.println(this.getSlotPath() + "checking running status");
        }
        this.startedLoads = 0;
        this.runningLoads = 0;
        boolean bl = false;
        int n = 1;
        while (n <= this.numOutputs) {
            BStatusBoolean bStatusBoolean = this.getStatusOutput(n);
            boolean bl2 = this.getFeedbackValue(n);
            if (this.getDebug()) {
                System.out.println("load " + n + " out - " + bStatusBoolean.getValue() + " | feedback - " + bl2);
            }
            if (bStatusBoolean.getValue() && !bl2) {
                bStatusBoolean.setStatusInAlarm(true);
                bl = true;
                ++this.startedLoads;
            } else if (bStatusBoolean.getValue() && bl2) {
                bStatusBoolean.setStatusInAlarm(false);
                ++this.startedLoads;
                ++this.runningLoads;
            } else if (bStatusBoolean.getValue() || !bl2) {
                bStatusBoolean.setStatusInAlarm(false);
            }
            ++n;
        }
        if (bl || this.startedLoads > this.getRequiredLoads()) {
            if (this.getDebug()) {
                System.out.println(this.startedLoads + " loads started, " + this.getRequiredLoads() + " loads required, or a load is failed");
            }
            this.getLoadFailed().setValue(true);
            this.startOutput();
        } else {
            this.getLoadFailed().setValue(false);
        }
    }

    private final int getLoadBit(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 8;
                break;
            }
            case 5: {
                n2 = 16;
                break;
            }
            case 6: {
                n2 = 32;
                break;
            }
            case 7: {
                n2 = 48;
                break;
            }
            case 8: {
                n2 = 64;
                break;
            }
            case 9: {
                n2 = 128;
                break;
            }
            case 10: {
                n2 = 512;
                break;
            }
        }
        return n2;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.getName().startsWith("out")) {
            return this.getFacets();
        }
        if (slot.getName() == "enableOutput" || slot.getName() == "disableOutput") {
            return this.getActionFacets();
        }
        return super.getSlotFacets(slot);
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.feedbackTimerActive = false;
        this.wasOn = false;
        this.isFirst = false;
    }

    public BLoadSequencer() {
        this.this();
    }

    static {
        Class clazz = class$com$vykon$vykonPro$hvac$BLoadSequencer;
        if (clazz == null) {
            clazz = class$com$vykon$vykonPro$hvac$BLoadSequencer = BLoadSequencer.class("[Lcom.vykon.vykonPro.hvac.BLoadSequencer;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"reorder.png");
    }
}

