/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.hvac;

import com.vykon.vykonPro.util.BVykonProService;
import javax.baja.collection.BIList;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBooleanBql
extends BComponent {
    public static final Property status = BBooleanBql.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BBooleanBql.newProperty((int)3, (String)"", null);
    public static final Property enabled = BBooleanBql.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property pointQuery = BBooleanBql.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property numberOfPoints = BBooleanBql.newProperty((int)11, (int)0, null);
    public static final Property count = BBooleanBql.newProperty((int)11, (int)0, null);
    public static final Property numberOfPointsTrue = BBooleanBql.newProperty((int)11, (int)0, null);
    public static final Property facets = BBooleanBql.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Property orOut = BBooleanBql.newProperty((int)11, (BValue)new BStatusBoolean(false), null);
    public static final Property andOut = BBooleanBql.newProperty((int)11, (BValue)new BStatusBoolean(false), null);
    public static final Property updateValuesInterval = BBooleanBql.newProperty((int)256, (BValue)BRelTime.makeSeconds((int)15), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property refreshQueryInterval = BBooleanBql.newProperty((int)256, (BValue)BRelTime.makeHours((int)12), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)1)));
    public static final Property startDelay = BBooleanBql.newProperty((int)256, (BValue)BRelTime.makeMinutes((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property nextRefreshTime = BBooleanBql.newProperty((int)5, (BValue)BAbsTime.NULL, null);
    public static final Action calculate = BBooleanBql.newAction((int)4, null);
    public static final Action initializeList = BBooleanBql.newAction((int)0, null);
    public static final Action refreshQuery = BBooleanBql.newAction((int)20, null);
    public static final Type TYPE;
    private static final BIcon icon;
    Clock.Ticket ticket;
    Clock.Ticket calcTicket;
    Clock.Ticket startTicket;
    BIList result;
    BComponent[] comps;
    boolean refreshChanged;
    static /* synthetic */ Class class$com$vykon$vykonPro$hvac$BBooleanBql;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BOrd getPointQuery() {
        return (BOrd)this.get(pointQuery);
    }

    public void setPointQuery(BOrd bOrd) {
        this.set(pointQuery, (BValue)bOrd, null);
    }

    public int getNumberOfPoints() {
        return this.getInt(numberOfPoints);
    }

    public void setNumberOfPoints(int n) {
        this.setInt(numberOfPoints, n, null);
    }

    public int getCount() {
        return this.getInt(count);
    }

    public void setCount(int n) {
        this.setInt(count, n, null);
    }

    public int getNumberOfPointsTrue() {
        return this.getInt(numberOfPointsTrue);
    }

    public void setNumberOfPointsTrue(int n) {
        this.setInt(numberOfPointsTrue, n, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public BStatusBoolean getOrOut() {
        return (BStatusBoolean)this.get(orOut);
    }

    public void setOrOut(BStatusBoolean bStatusBoolean) {
        this.set(orOut, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getAndOut() {
        return (BStatusBoolean)this.get(andOut);
    }

    public void setAndOut(BStatusBoolean bStatusBoolean) {
        this.set(andOut, (BValue)bStatusBoolean, null);
    }

    public BRelTime getUpdateValuesInterval() {
        return (BRelTime)this.get(updateValuesInterval);
    }

    public void setUpdateValuesInterval(BRelTime bRelTime) {
        this.set(updateValuesInterval, (BValue)bRelTime, null);
    }

    public BRelTime getRefreshQueryInterval() {
        return (BRelTime)this.get(refreshQueryInterval);
    }

    public void setRefreshQueryInterval(BRelTime bRelTime) {
        this.set(refreshQueryInterval, (BValue)bRelTime, null);
    }

    public BRelTime getStartDelay() {
        return (BRelTime)this.get(startDelay);
    }

    public void setStartDelay(BRelTime bRelTime) {
        this.set(startDelay, (BValue)bRelTime, null);
    }

    public BAbsTime getNextRefreshTime() {
        return (BAbsTime)this.get(nextRefreshTime);
    }

    public void setNextRefreshTime(BAbsTime bAbsTime) {
        this.set(nextRefreshTime, (BValue)bAbsTime, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public void initializeList() {
        this.invoke(initializeList, null, null);
    }

    public void refreshQuery() {
        this.invoke(refreshQuery, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.checkForService();
        if (this.getEnabled() && this.getStatus().isOk()) {
            this.initStartTicket();
            this.initClockTicket();
            this.initCalcTicket();
        }
    }

    public void stopped() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if (this.calcTicket != null) {
            this.calcTicket.cancel();
        }
        if (this.startTicket != null) {
            this.startTicket.cancel();
        }
    }

    private final void checkForService() {
        if (BVykonProService.getInstance() == null) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("This component requires the VykonPro service in the station");
        } else if (BVykonProService.getInstance().isDisabled()) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("The vykonPro service is disabled");
        } else {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)orOut) || slot.equals((Object)andOut)) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void clockChanged(BRelTime bRelTime) {
        if (this.getEnabled()) {
            this.initClockTicket();
            this.initCalcTicket();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals((Object)pointQuery)) {
            this.initializeList();
        }
        if (this.getEnabled()) {
            if (property.equals((Object)refreshQueryInterval)) {
                this.refreshChanged = true;
                this.initClockTicket();
            } else if (property.equals((Object)updateValuesInterval)) {
                this.initCalcTicket();
            }
        }
        if (property.equals((Object)enabled)) {
            if (this.getEnabled()) {
                this.initializeList();
                this.calculate();
                this.initClockTicket();
            } else {
                if (this.ticket != null) {
                    this.ticket.cancel();
                }
                if (this.calcTicket != null) {
                    this.calcTicket.cancel();
                }
            }
        }
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == refreshQuery) {
            return BVykonProService.getInstance().getWorker().post((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public void doInitializeList() {
        if (!this.getEnabled()) {
            return;
        }
        if (!this.getStatus().isOk()) {
            this.checkForService();
            if (!this.getStatus().isOk()) {
                return;
            }
        }
        if (this.startTicket != null) {
            this.startTicket.cancel();
        }
        if (this.getPointQuery().isNull()) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("must specify a point query");
            return;
        }
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        this.refreshQuery();
    }

    private final void initStartTicket() {
        if (this.startTicket != null) {
            this.startTicket.cancel();
        }
        this.startTicket = Clock.schedule((BComponent)this, (BRelTime)this.getStartDelay(), (Action)initializeList, null);
    }

    void initClockTicket() {
        BAbsTime bAbsTime = this.getNextRefreshTime();
        if (this.refreshChanged) {
            this.refreshChanged = false;
            bAbsTime = BAbsTime.NULL;
        }
        BAbsTime bAbsTime2 = Clock.time();
        if (bAbsTime == BAbsTime.NULL) {
            this.setNextRefreshTime(bAbsTime2.add(this.getRefreshQueryInterval()));
            bAbsTime = this.getNextRefreshTime();
        } else if (bAbsTime2.isAfter(bAbsTime)) {
            while (bAbsTime.isBefore(bAbsTime2)) {
                bAbsTime = bAbsTime.add(this.getRefreshQueryInterval());
            }
            this.setNextRefreshTime(bAbsTime);
        } else if (bAbsTime2.add(this.getRefreshQueryInterval()).isBefore(this.getNextRefreshTime())) {
            this.setNextRefreshTime(bAbsTime2.add(this.getRefreshQueryInterval()));
        }
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)bAbsTime, (BRelTime)this.getRefreshQueryInterval(), (Action)refreshQuery, null);
    }

    void initCalcTicket() {
        if (this.calcTicket != null) {
            this.calcTicket.cancel();
        }
        this.calcTicket = Clock.schedule((BComponent)this, (BRelTime)this.getUpdateValuesInterval(), (Action)calculate, null);
    }

    public void doCalculate() throws Exception {
        if (!this.getEnabled()) {
            return;
        }
        if (!this.getStatus().isOk()) {
            this.checkForService();
            if (!this.getStatus().isOk()) {
                return;
            }
        }
        if (this.getPointQuery().isNull()) {
            this.initCalcTicket();
            return;
        }
        if (this.result == null) {
            this.initCalcTicket();
            return;
        }
        int n = 0;
        int n2 = 0;
        this.initCalcTicket();
        this.result.list((BObject[])this.comps);
        BComponent.lease((BComponent[])this.comps, (int)0, (long)(this.getUpdateValuesInterval().getMillis() + 1000L));
        int n3 = 0;
        while (n3 < this.result.size()) {
            BStatusBoolean bStatusBoolean;
            if (this.comps[n3].get("out") != null && this.comps[n3].get("out").getType().is(BStatusBoolean.TYPE) && (bStatusBoolean = (BStatusBoolean)this.comps[n3].get("out")).getStatus().isValid()) {
                ++n2;
                if (bStatusBoolean.getValue()) {
                    ++n;
                }
            }
            ++n3;
        }
        this.setNumberOfPointsTrue(n);
        this.setCount(n2);
        if (n > 0) {
            this.getOrOut().setValue(true);
        } else {
            this.getOrOut().setValue(false);
        }
        if (n == this.getNumberOfPoints()) {
            this.getAndOut().setValue(true);
        } else {
            this.getAndOut().setValue(false);
        }
    }

    public void doRefreshQuery() {
        this.result = (BIList)this.getPointQuery().get();
        this.comps = new BComponent[this.result.size()];
        this.setNumberOfPoints(this.result.size());
        this.setNextRefreshTime(this.getNextRefreshTime().add(this.getRefreshQueryInterval()));
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.result = null;
        this.refreshChanged = false;
    }

    public BBooleanBql() {
        this.this();
    }

    static {
        Class clazz = class$com$vykon$vykonPro$hvac$BBooleanBql;
        if (clazz == null) {
            clazz = class$com$vykon$vykonPro$hvac$BBooleanBql = BBooleanBql.class("[Lcom.vykon.vykonPro.hvac.BBooleanBql;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"control/booleanPoint.png");
    }
}

