/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.history;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.BNumeric64BitTrendRecord;
import com.vykon.vykonPro.util.BTimeOfDay;
import com.vykon.vykonPro.util.BVykonProService;
import java.io.IOException;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BTrendFlags;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BTimeRange;
import javax.baja.util.BTypeSpec;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNumericHistoryCalc
extends BComponent {
    public static final Property status = BNumericHistoryCalc.newProperty((int)65, (BValue)BStatus.ok, null);
    public static final Property faultCause = BNumericHistoryCalc.newProperty((int)65, (String)"", null);
    public static final Property historyName = BNumericHistoryCalc.newProperty((int)256, (BValue)BFormat.make((String)"%componentSpace.rootComponent.stationName%/%parent.name%"), null);
    public static final Property history = BNumericHistoryCalc.newProperty((int)1, (BValue)BOrd.make((String)"history:/"), null);
    public static final Property deltaLogged = BNumericHistoryCalc.newProperty((int)320, (boolean)true, null);
    public static final Property excludeInvalidValues = BNumericHistoryCalc.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"exclude", (String)"include"));
    public static final Property excludeHiddenValues = BNumericHistoryCalc.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"exclude", (String)"include"));
    public static final Property includeTimeOfDay = BNumericHistoryCalc.newProperty((int)256, (BValue)new BTimeOfDay(), null);
    public static final Property timeRange = BNumericHistoryCalc.newProperty((int)256, (BValue)BDynamicTimeRange.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:DynamicTimeRangeFE"));
    public static final Property facets = BNumericHistoryCalc.newProperty((int)0, (BValue)BFacets.makeNumeric(), null);
    public static final Property total = BNumericHistoryCalc.newProperty((int)73, (BValue)new BStatusNumeric(), null);
    public static final Property average = BNumericHistoryCalc.newProperty((int)73, (BValue)new BStatusNumeric(), null);
    public static final Property maximum = BNumericHistoryCalc.newProperty((int)65, (BValue)new BStatusNumeric(), null);
    public static final Property minimum = BNumericHistoryCalc.newProperty((int)65, (BValue)new BStatusNumeric(), null);
    public static final Property count = BNumericHistoryCalc.newProperty((int)65, (int)0, null);
    public static final Property calculating = BNumericHistoryCalc.newProperty((int)1, (boolean)false, null);
    public static final Property lastUpdateTime = BNumericHistoryCalc.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Action calculate = BNumericHistoryCalc.newAction((int)16, null);
    public static final Action reset = BNumericHistoryCalc.newAction((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    String deltaSyntax;
    String timeQuery;
    static /* synthetic */ Class class$com$vykon$vykonPro$history$BNumericHistoryCalc;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BFormat getHistoryName() {
        return (BFormat)this.get(historyName);
    }

    public void setHistoryName(BFormat bFormat) {
        this.set(historyName, (BValue)bFormat, null);
    }

    public BOrd getHistory() {
        return (BOrd)this.get(history);
    }

    public void setHistory(BOrd bOrd) {
        this.set(history, (BValue)bOrd, null);
    }

    public boolean getDeltaLogged() {
        return this.getBoolean(deltaLogged);
    }

    public void setDeltaLogged(boolean bl) {
        this.setBoolean(deltaLogged, bl, null);
    }

    public boolean getExcludeInvalidValues() {
        return this.getBoolean(excludeInvalidValues);
    }

    public void setExcludeInvalidValues(boolean bl) {
        this.setBoolean(excludeInvalidValues, bl, null);
    }

    public boolean getExcludeHiddenValues() {
        return this.getBoolean(excludeHiddenValues);
    }

    public void setExcludeHiddenValues(boolean bl) {
        this.setBoolean(excludeHiddenValues, bl, null);
    }

    public BTimeOfDay getIncludeTimeOfDay() {
        return (BTimeOfDay)this.get(includeTimeOfDay);
    }

    public void setIncludeTimeOfDay(BTimeOfDay bTimeOfDay) {
        this.set(includeTimeOfDay, (BValue)bTimeOfDay, null);
    }

    public BDynamicTimeRange getTimeRange() {
        return (BDynamicTimeRange)this.get(timeRange);
    }

    public void setTimeRange(BDynamicTimeRange bDynamicTimeRange) {
        this.set(timeRange, (BValue)bDynamicTimeRange, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public BStatusNumeric getTotal() {
        return (BStatusNumeric)this.get(total);
    }

    public void setTotal(BStatusNumeric bStatusNumeric) {
        this.set(total, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getAverage() {
        return (BStatusNumeric)this.get(average);
    }

    public void setAverage(BStatusNumeric bStatusNumeric) {
        this.set(average, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getMaximum() {
        return (BStatusNumeric)this.get(maximum);
    }

    public void setMaximum(BStatusNumeric bStatusNumeric) {
        this.set(maximum, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getMinimum() {
        return (BStatusNumeric)this.get(minimum);
    }

    public void setMinimum(BStatusNumeric bStatusNumeric) {
        this.set(minimum, (BValue)bStatusNumeric, null);
    }

    public int getCount() {
        return this.getInt(count);
    }

    public void setCount(int n) {
        this.setInt(count, n, null);
    }

    public boolean getCalculating() {
        return this.getBoolean(calculating);
    }

    public void setCalculating(boolean bl) {
        this.setBoolean(calculating, bl, null);
    }

    public BAbsTime getLastUpdateTime() {
        return (BAbsTime)this.get(lastUpdateTime);
    }

    public void setLastUpdateTime(BAbsTime bAbsTime) {
        this.set(lastUpdateTime, (BValue)bAbsTime, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.checkForService();
    }

    private final void checkForService() {
        if (BVykonProService.getInstance() == null) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("This component requires the VykonPro service in the station");
        } else if (BVykonProService.getInstance().isDisabled()) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("The vykonPro service is disabled");
        } else {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals((Object)historyName) || property.equals((Object)timeRange)) {
            this.reset();
            this.calculate();
        }
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == calculate) {
            return BVykonProService.getInstance().getWorker().post((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)maximum) || slot.equals((Object)minimum) || slot.equals((Object)average) || slot.equals((Object)total)) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void doCalculate() {
        if (!this.isRunning()) {
            return;
        }
        try {
            BOrd bOrd = BOrd.make((String)("history:/" + this.resolveHistoryName()));
            this.setHistory(bOrd);
            BIHistory bIHistory = (BIHistory)bOrd.resolve((BObject)this).get();
            BHistoryConfig bHistoryConfig = bIHistory.getConfig();
            if (!bHistoryConfig.getRecordType().equals((Object)BTypeSpec.make((Type)BNumericTrendRecord.TYPE)) && !bHistoryConfig.getRecordType().equals((Object)BTypeSpec.make((Type)BNumeric64BitTrendRecord.TYPE))) {
                this.setStatus(BStatus.fault);
                this.setFaultCause("Must specify a valid numeric type history.");
                this.reset();
                return;
            }
            this.deltaSyntax = this.getDeltaLogged() ? ";delta=false;" : ";delta=true;";
            this.timeQuery = this.getTimeRange().toOrdParams();
            BOrd bOrd2 = BOrd.make((String)(bOrd + '?' + this.timeQuery + this.deltaSyntax + "|bql:select *"));
            BITable bITable = (BITable)bOrd2.resolve((BObject)this).get();
            this.setCalculating(true);
            ColumnList columnList = bITable.getColumns();
            Column column = columnList.get(3);
            Column column2 = columnList.get(2);
            Column column3 = columnList.get(1);
            Column column4 = columnList.get(0);
            boolean bl = this.getExcludeInvalidValues();
            boolean bl2 = this.getExcludeHiddenValues();
            BAbsTime bAbsTime = BAbsTime.NULL;
            BStatus bStatus = BStatus.nullStatus;
            BTrendFlags bTrendFlags = null;
            TableCursor tableCursor = (TableCursor)bITable.cursor();
            BTimeRange bTimeRange = this.getIncludeTimeOfDay().getTimeRange();
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            double d3 = 0.0;
            int n = 0;
            double d4 = 0.0;
            boolean bl3 = false;
            if (bITable.size() == 1) {
                bl3 = true;
            }
            if (bl3 & (this.getDeltaLogged() ^ true)) {
                tableCursor.next();
                d4 = ((BINumeric)tableCursor.get(column)).getNumeric();
                bStatus = ((BStatus)tableCursor.get(column2)).getStatus();
                bTrendFlags = (BTrendFlags)tableCursor.get(column3);
                if (!(bl & (bStatus.isValid() ^ true)) && !(bl2 & bTrendFlags.getBit("hidden")) && BDouble.make((double)d4) != BDouble.NaN) {
                    ++n;
                    d = d4;
                    d2 = d4;
                    d3 += d4;
                }
            }
            while (tableCursor.next()) {
                bAbsTime = (BAbsTime)tableCursor.get(column4);
                d4 = ((BINumeric)tableCursor.get(column)).getNumeric();
                bStatus = ((BStatus)tableCursor.get(column2)).getStatus();
                bTrendFlags = (BTrendFlags)tableCursor.get(column3);
                if (bl & (bStatus.isValid() ^ true) || bl2 & bTrendFlags.getBit("hidden") || BDouble.make((double)d4) == BDouble.NaN || !bTimeRange.includes(bAbsTime)) continue;
                if (d4 < d) {
                    d = d4;
                }
                if (d4 > d2) {
                    d2 = d4;
                }
                d3 += d4;
                ++n;
            }
            if (n > 0) {
                this.getMinimum().setValue(d);
                this.getMaximum().setValue(d2);
                this.getTotal().setValue(d3);
                this.getAverage().setValue(d3 / (double)n);
                this.setCount(n);
                this.setCalculating(false);
                this.setLastUpdateTime(Clock.time());
                this.setStatus(BStatus.ok);
                this.setFaultCause("");
            } else {
                this.reset();
                this.setCalculating(false);
                this.setStatus(BStatus.fault);
                this.setFaultCause("No records found for " + this.getHistory() + " for the configured timeOfDay");
            }
        }
        catch (Exception exception) {
            this.reset();
            System.out.println(this.getSlotPath() + " - " + exception);
            this.setCalculating(false);
            this.setStatus(BStatus.fault);
            this.setFaultCause("Failed to calcualte values. " + exception.getMessage());
        }
    }

    public void doReset() {
        this.getMinimum().setValue(Double.POSITIVE_INFINITY);
        this.getMaximum().setValue(Double.NEGATIVE_INFINITY);
        this.getTotal().setValue(Double.NaN);
        this.getAverage().setValue(Double.NaN);
        this.setCount(0);
    }

    private final String resolveHistoryName() {
        BFormat bFormat = this.getHistoryName();
        try {
            String string = bFormat.encodeToString();
            if (string.indexOf("/") > -1) {
                int n = string.indexOf("/");
                BFormat bFormat2 = BFormat.make((String)string.substring(0, n));
                BFormat bFormat3 = BFormat.make((String)string.substring(n + 1));
                String string2 = SlotPath.escape((String)SlotPath.unescape((String)bFormat2.format((Object)this)));
                String string3 = SlotPath.escape((String)SlotPath.unescape((String)bFormat3.format((Object)this)));
                return string2 + '/' + string3;
            }
            return string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "couldn't resolve the historyName";
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$vykon$vykonPro$history$BNumericHistoryCalc;
        if (clazz == null) {
            clazz = class$com$vykon$vykonPro$history$BNumericHistoryCalc = BNumericHistoryCalc.class("[Lcom.vykon.vykonPro.history.BNumericHistoryCalc;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"historyDatabase.png");
    }
}

