/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.history;

import com.vykon.vykonPro.enums.BDateModeEnum;
import com.vykon.vykonPro.util.BVykonProService;
import java.io.IOException;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendFlags;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNumericHistoryAnalysis
extends BComponent {
    public static final Property status = BNumericHistoryAnalysis.newProperty((int)65, (BValue)BStatus.ok, null);
    public static final Property faultCause = BNumericHistoryAnalysis.newProperty((int)65, (String)"", null);
    public static final Property historyName = BNumericHistoryAnalysis.newProperty((int)0, (BValue)BFormat.make((String)"%componentSpace.rootComponent.stationName%/%parent.name%"), null);
    public static final Property historyOrd = BNumericHistoryAnalysis.newProperty((int)65, (BValue)BOrd.DEFAULT, null);
    public static final Property historyInterval = BNumericHistoryAnalysis.newProperty((int)69, (BValue)BRelTime.DEFAULT, null);
    public static final Property facets = BNumericHistoryAnalysis.newProperty((int)0, (BValue)BFacets.makeNumeric(), null);
    public static final Property deltaLogged = BNumericHistoryAnalysis.newProperty((int)0, (boolean)false, null);
    public static final Property excludeInvalidValues = BNumericHistoryAnalysis.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"exclude", (String)"include"));
    public static final Property excludeHiddenValues = BNumericHistoryAnalysis.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"exclude", (String)"include"));
    public static final Property dateMode = BNumericHistoryAnalysis.newProperty((int)256, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BDateModeEnum.TYPE)), null);
    public static final Property billingCycleStartDay = BNumericHistoryAnalysis.newProperty((int)256, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)28));
    public static final Property executePeriod = BNumericHistoryAnalysis.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), null);
    public static final Property calculating = BNumericHistoryAnalysis.newProperty((int)65, (boolean)false, null);
    public static final Property nextUpdateTime = BNumericHistoryAnalysis.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Property lastUpdateTime = BNumericHistoryAnalysis.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Property currentHourTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentHourAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentHourMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentHourMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastHourTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastHourAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastHourMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastHourMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentDayTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentDayAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentDayMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentDayMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property yesterdayTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property yesterdayAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property yesterdayMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property yesterdayMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentWeekTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentWeekAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentWeekMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentWeekMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastWeekTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastWeekAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastWeekMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastWeekMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentMonthTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentMonthAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentMonthMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentMonthMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastMonthTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastMonthAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastMonthMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastMonthMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentYearTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentYearAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentYearMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property currentYearMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastYearTotal = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastYearAvg = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastYearMin = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Property lastYearMax = BNumericHistoryAnalysis.newProperty((int)75, (BValue)new BStatusNumeric(), null);
    public static final Action calculate = BNumericHistoryAnalysis.newAction((int)0, null);
    public static final Action reset = BNumericHistoryAnalysis.newAction((int)0, null);
    public static final Action query = BNumericHistoryAnalysis.newAction((int)20, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private boolean serviceFound;
    private String serviceFault;
    private boolean ordOkay;
    private String ordFault;
    Clock.Ticket ticket;
    BAbsTime now;
    BAbsTime firstOfMonth;
    BAbsTime firstOfYear;
    BOrd lastOrd;
    double min;
    double max;
    double total;
    double records;
    double avg;
    int day;
    int currentHour;
    int lastHour;
    int currentDay;
    int lastDay;
    int month;
    int previousMonth;
    int year;
    int previousYear;
    int billDay;
    BWeekday resetDay;
    String deviceName;
    boolean latch;
    boolean resetLatch;
    boolean serviceExists;
    String deltaSyntax;
    boolean ch;
    static /* synthetic */ Class class$com$vykon$vykonPro$history$BNumericHistoryAnalysis;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BFormat getHistoryName() {
        return (BFormat)this.get(historyName);
    }

    public void setHistoryName(BFormat bFormat) {
        this.set(historyName, (BValue)bFormat, null);
    }

    public BOrd getHistoryOrd() {
        return (BOrd)this.get(historyOrd);
    }

    public void setHistoryOrd(BOrd bOrd) {
        this.set(historyOrd, (BValue)bOrd, null);
    }

    public BRelTime getHistoryInterval() {
        return (BRelTime)this.get(historyInterval);
    }

    public void setHistoryInterval(BRelTime bRelTime) {
        this.set(historyInterval, (BValue)bRelTime, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public boolean getDeltaLogged() {
        return this.getBoolean(deltaLogged);
    }

    public void setDeltaLogged(boolean bl) {
        this.setBoolean(deltaLogged, bl, null);
    }

    public boolean getExcludeInvalidValues() {
        return this.getBoolean(excludeInvalidValues);
    }

    public void setExcludeInvalidValues(boolean bl) {
        this.setBoolean(excludeInvalidValues, bl, null);
    }

    public boolean getExcludeHiddenValues() {
        return this.getBoolean(excludeHiddenValues);
    }

    public void setExcludeHiddenValues(boolean bl) {
        this.setBoolean(excludeHiddenValues, bl, null);
    }

    public BEnum getDateMode() {
        return (BEnum)this.get(dateMode);
    }

    public void setDateMode(BEnum bEnum) {
        this.set(dateMode, (BValue)bEnum, null);
    }

    public int getBillingCycleStartDay() {
        return this.getInt(billingCycleStartDay);
    }

    public void setBillingCycleStartDay(int n) {
        this.setInt(billingCycleStartDay, n, null);
    }

    public BRelTime getExecutePeriod() {
        return (BRelTime)this.get(executePeriod);
    }

    public void setExecutePeriod(BRelTime bRelTime) {
        this.set(executePeriod, (BValue)bRelTime, null);
    }

    public boolean getCalculating() {
        return this.getBoolean(calculating);
    }

    public void setCalculating(boolean bl) {
        this.setBoolean(calculating, bl, null);
    }

    public BAbsTime getNextUpdateTime() {
        return (BAbsTime)this.get(nextUpdateTime);
    }

    public void setNextUpdateTime(BAbsTime bAbsTime) {
        this.set(nextUpdateTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastUpdateTime() {
        return (BAbsTime)this.get(lastUpdateTime);
    }

    public void setLastUpdateTime(BAbsTime bAbsTime) {
        this.set(lastUpdateTime, (BValue)bAbsTime, null);
    }

    public BStatusNumeric getCurrentHourTotal() {
        return (BStatusNumeric)this.get(currentHourTotal);
    }

    public void setCurrentHourTotal(BStatusNumeric bStatusNumeric) {
        this.set(currentHourTotal, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentHourAvg() {
        return (BStatusNumeric)this.get(currentHourAvg);
    }

    public void setCurrentHourAvg(BStatusNumeric bStatusNumeric) {
        this.set(currentHourAvg, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentHourMin() {
        return (BStatusNumeric)this.get(currentHourMin);
    }

    public void setCurrentHourMin(BStatusNumeric bStatusNumeric) {
        this.set(currentHourMin, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentHourMax() {
        return (BStatusNumeric)this.get(currentHourMax);
    }

    public void setCurrentHourMax(BStatusNumeric bStatusNumeric) {
        this.set(currentHourMax, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getLastHourTotal() {
        return (BStatusNumeric)this.get(lastHourTotal);
    }

    public void setLastHourTotal(BStatusNumeric bStatusNumeric) {
        this.set(lastHourTotal, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getLastHourAvg() {
        return (BStatusNumeric)this.get(lastHourAvg);
    }

    public void setLastHourAvg(BStatusNumeric bStatusNumeric) {
        this.set(lastHourAvg, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getLastHourMin() {
        return (BStatusNumeric)this.get(lastHourMin);
    }

    public void setLastHourMin(BStatusNumeric bStatusNumeric) {
        this.set(lastHourMin, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getLastHourMax() {
        return (BStatusNumeric)this.get(lastHourMax);
    }

    public void setLastHourMax(BStatusNumeric bStatusNumeric) {
        this.set(lastHourMax, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentDayTotal() {
        return (BStatusNumeric)this.get(currentDayTotal);
    }

    public void setCurrentDayTotal(BStatusNumeric bStatusNumeric) {
        this.set(currentDayTotal, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentDayAvg() {
        return (BStatusNumeric)this.get(currentDayAvg);
    }

    public void setCurrentDayAvg(BStatusNumeric bStatusNumeric) {
        this.set(currentDayAvg, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentDayMin() {
        return (BStatusNumeric)this.get(currentDayMin);
    }

    public void setCurrentDayMin(BStatusNumeric bStatusNumeric) {
        this.set(currentDayMin, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentDayMax() {
        return (BStatusNumeric)this.get(currentDayMax);
    }

    public void setCurrentDayMax(BStatusNumeric bStatusNumeric) {
        this.set(currentDayMax, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getYesterdayTotal() {
        return (BStatusNumeric)this.get(yesterdayTotal);
    }

    public void setYesterdayTotal(BStatusNumeric bStatusNumeric) {
        this.set(yesterdayTotal, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getYesterdayAvg() {
        return (BStatusNumeric)this.get(yesterdayAvg);
    }

    public void setYesterdayAvg(BStatusNumeric bStatusNumeric) {
        this.set(yesterdayAvg, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getYesterdayMin() {
        return (BStatusNumeric)this.get(yesterdayMin);
    }

    public void setYesterdayMin(BStatusNumeric bStatusNumeric) {
        this.set(yesterdayMin, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getYesterdayMax() {
        return (BStatusNumeric)this.get(yesterdayMax);
    }

    public void setYesterdayMax(BStatusNumeric bStatusNumeric) {
        this.set(yesterdayMax, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentWeekTotal() {
        return (BStatusNumeric)this.get(currentWeekTotal);
    }

    public void setCurrentWeekTotal(BStatusNumeric bStatusNumeric) {
        this.set(currentWeekTotal, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentWeekAvg() {
        return (BStatusNumeric)this.get(currentWeekAvg);
    }

    public void setCurrentWeekAvg(BStatusNumeric bStatusNumeric) {
        this.set(currentWeekAvg, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentWeekMin() {
        return (BStatusNumeric)this.get(currentWeekMin);
    }

    public void setCurrentWeekMin(BStatusNumeric bStatusNumeric) {
        this.set(currentWeekMin, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentWeekMax() {
        return (BStatusNumeric)this.get(currentWeekMax);
    }

    public void setCurrentWeekMax(BStatusNumeric bStatusNumeric) {
        this.set(currentWeekMax, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getLastWeekTotal() {
        return (BStatusNumeric)this.get(lastWeekTotal);
    }

    public void setLastWeekTotal(BStatusNumeric bStatusNumeric) {
        this.set(lastWeekTotal, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getLastWeekAvg() {
        return (BStatusNumeric)this.get(lastWeekAvg);
    }

    public void setLastWeekAvg(BStatusNumeric bStatusNumeric) {
        this.set(lastWeekAvg, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getLastWeekMin() {
        return (BStatusNumeric)this.get(lastWeekMin);
    }

    public void setLastWeekMin(BStatusNumeric bStatusNumeric) {
        this.set(lastWeekMin, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getLastWeekMax() {
        return (BStatusNumeric)this.get(lastWeekMax);
    }

    public void setLastWeekMax(BStatusNumeric bStatusNumeric) {
        this.set(lastWeekMax, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentMonthTotal() {
        return (BStatusNumeric)this.get(currentMonthTotal);
    }

    public void setCurrentMonthTotal(BStatusNumeric bStatusNumeric) {
        this.set(currentMonthTotal, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentMonthAvg() {
        return (BStatusNumeric)this.get(currentMonthAvg);
    }

    public void setCurrentMonthAvg(BStatusNumeric bStatusNumeric) {
        this.set(currentMonthAvg, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentMonthMin() {
        return (BStatusNumeric)this.get(currentMonthMin);
    }

    public void setCurrentMonthMin(BStatusNumeric bStatusNumeric) {
        this.set(currentMonthMin, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentMonthMax() {
        return (BStatusNumeric)this.get(currentMonthMax);
    }

    public void setCurrentMonthMax(BStatusNumeric bStatusNumeric) {
        this.set(currentMonthMax, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getLastMonthTotal() {
        return (BStatusNumeric)this.get(lastMonthTotal);
    }

    public void setLastMonthTotal(BStatusNumeric bStatusNumeric) {
        this.set(lastMonthTotal, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getLastMonthAvg() {
        return (BStatusNumeric)this.get(lastMonthAvg);
    }

    public void setLastMonthAvg(BStatusNumeric bStatusNumeric) {
        this.set(lastMonthAvg, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getLastMonthMin() {
        return (BStatusNumeric)this.get(lastMonthMin);
    }

    public void setLastMonthMin(BStatusNumeric bStatusNumeric) {
        this.set(lastMonthMin, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getLastMonthMax() {
        return (BStatusNumeric)this.get(lastMonthMax);
    }

    public void setLastMonthMax(BStatusNumeric bStatusNumeric) {
        this.set(lastMonthMax, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentYearTotal() {
        return (BStatusNumeric)this.get(currentYearTotal);
    }

    public void setCurrentYearTotal(BStatusNumeric bStatusNumeric) {
        this.set(currentYearTotal, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentYearAvg() {
        return (BStatusNumeric)this.get(currentYearAvg);
    }

    public void setCurrentYearAvg(BStatusNumeric bStatusNumeric) {
        this.set(currentYearAvg, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentYearMin() {
        return (BStatusNumeric)this.get(currentYearMin);
    }

    public void setCurrentYearMin(BStatusNumeric bStatusNumeric) {
        this.set(currentYearMin, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getCurrentYearMax() {
        return (BStatusNumeric)this.get(currentYearMax);
    }

    public void setCurrentYearMax(BStatusNumeric bStatusNumeric) {
        this.set(currentYearMax, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getLastYearTotal() {
        return (BStatusNumeric)this.get(lastYearTotal);
    }

    public void setLastYearTotal(BStatusNumeric bStatusNumeric) {
        this.set(lastYearTotal, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getLastYearAvg() {
        return (BStatusNumeric)this.get(lastYearAvg);
    }

    public void setLastYearAvg(BStatusNumeric bStatusNumeric) {
        this.set(lastYearAvg, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getLastYearMin() {
        return (BStatusNumeric)this.get(lastYearMin);
    }

    public void setLastYearMin(BStatusNumeric bStatusNumeric) {
        this.set(lastYearMin, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getLastYearMax() {
        return (BStatusNumeric)this.get(lastYearMax);
    }

    public void setLastYearMax(BStatusNumeric bStatusNumeric) {
        this.set(lastYearMax, (BValue)bStatusNumeric, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public void query() {
        this.invoke(query, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.billDay = this.getBillingCycleStartDay();
        this.lastOrd = this.getHistoryOrd();
        if (!this.isRunning()) {
            return;
        }
        this.checkForService();
        this.updateHistory();
        this.initClockTicket();
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        super.stopped();
    }

    public void atSteadyState() {
        this.calculate();
    }

    private final void checkForService() {
        this.serviceFound = false;
        if (BVykonProService.getInstance() == null) {
            this.serviceFault = "This component requires the VykonPro service in the station";
        } else if (BVykonProService.getInstance().isDisabled()) {
            this.serviceFault = "The vykonPro service is disabled";
        } else {
            this.serviceFound = true;
            this.serviceFault = "";
        }
        this.updateStatus();
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.getName().startsWith("current") || slot.getName().startsWith("last") || slot.getName().startsWith("yesterday")) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void clockChanged(BRelTime bRelTime) {
        this.initClockTicket();
    }

    private final void initClockTicket() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        BAbsTime bAbsTime = Clock.time();
        BAbsTime bAbsTime2 = BAbsTime.make((BAbsTime)bAbsTime, (BTime)BTime.make((int)0, (int)0, (int)0));
        while (!bAbsTime2.isAfter(bAbsTime)) {
            bAbsTime2 = bAbsTime2.add(this.getExecutePeriod());
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)bAbsTime2, (BRelTime)this.getExecutePeriod(), (Action)calculate, null);
        this.setNextUpdateTime(bAbsTime2.add(this.getExecutePeriod()));
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals((Object)executePeriod)) {
            this.calculate();
        } else if (property.equals((Object)historyName)) {
            this.updateHistory();
        } else if (property.equals((Object)billingCycleStartDay)) {
            this.billDay = this.getBillingCycleStartDay();
        }
    }

    private final String resolveHistoryName() {
        BFormat bFormat = this.getHistoryName();
        try {
            String string = bFormat.encodeToString();
            if (string.indexOf("/") > -1) {
                int n = string.indexOf("/");
                BFormat bFormat2 = BFormat.make((String)string.substring(0, n));
                BFormat bFormat3 = BFormat.make((String)string.substring(n + 1));
                String string2 = SlotPath.escape((String)SlotPath.unescape((String)bFormat2.format((Object)this)));
                String string3 = SlotPath.escape((String)SlotPath.unescape((String)bFormat3.format((Object)this)));
                return string2 + '/' + string3;
            }
            return "";
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "couldn't resolve the historyName";
        }
    }

    private final void updateHistory() {
        block8: {
            this.ordOkay = false;
            String string = this.resolveHistoryName();
            if (string.length() > 0) {
                BOrd bOrd = BOrd.make((String)("history:/" + string));
                try {
                    if (bOrd.resolve((BObject)this).get() != null) {
                        BHistoryConfig bHistoryConfig;
                        BCollectionInterval bCollectionInterval;
                        this.ordOkay = true;
                        this.ordFault = "";
                        this.setHistoryOrd(bOrd);
                        if (!this.getHistoryOrd().equals((Object)this.lastOrd)) {
                            this.lastOrd = BOrd.make((String)this.getHistoryOrd().toString());
                            this.reset();
                        }
                        if ((bCollectionInterval = (bHistoryConfig = ((BIHistory)bOrd.resolve((BObject)this).get()).getConfig()).getInterval()).isIrregular()) {
                            this.setHistoryInterval(BRelTime.DEFAULT);
                        } else {
                            this.setHistoryInterval(bCollectionInterval.getInterval());
                        }
                        break block8;
                    }
                    this.ordFault = "history:/" + string + " | History Ord does not resolve to an actual history";
                }
                catch (Exception exception) {
                    System.out.println(this.getSlotPath() + " - exception resolving history");
                    System.out.println(exception);
                    this.ordFault = "history:/" + string + " | History Ord does not resolve to an actual history";
                }
            } else {
                this.ordFault = "History Name was blank";
            }
        }
        this.updateStatus();
    }

    private final void updateStatus() {
        if (this.serviceFound && this.ordOkay) {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        } else {
            this.setStatus(BStatus.fault);
            if (!this.serviceFound) {
                this.setFaultCause(this.serviceFault);
            } else if (!this.ordOkay) {
                this.setFaultCause(this.ordFault);
            } else {
                this.setFaultCause("unknown fault");
            }
        }
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == query) {
            return BVykonProService.getInstance().getWorker().post((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public void doCalculate() throws Exception {
        this.setNextUpdateTime(Clock.time().add(this.getExecutePeriod()));
        if (this.getHistoryOrd().equals((Object)BOrd.NULL)) {
            this.updateHistory();
        } else if (!BOrd.make((String)("history:/" + this.resolveHistoryName())).equals((Object)this.getHistoryOrd())) {
            this.updateHistory();
        }
        if (!this.getStatus().isOk()) {
            this.checkForService();
            if (!this.getStatus().isOk()) {
                this.updateHistory();
                if (!this.getStatus().isOk()) {
                    return;
                }
            }
        }
        this.query();
    }

    public void doQuery() throws Exception {
        if (!this.getStatus().isOk()) {
            return;
        }
        this.setCalculating(true);
        this.now = Clock.time();
        this.currentHour = this.now.getHour();
        this.day = this.now.getDayOfYear();
        this.currentDay = this.now.getDay();
        this.month = this.now.getMonth().getMonthOfYear();
        this.year = this.now.getYear();
        if (this.getDateMode().getOrdinal() == 1) {
            this.firstOfMonth = BAbsTime.make((int)this.year, (BMonth)this.now.getMonth(), (int)this.getBillingCycleStartDay(), (int)0, (int)0, (int)0, (int)0);
            this.firstOfYear = BAbsTime.make((int)this.year, (BMonth)BMonth.make((int)0), (int)this.getBillingCycleStartDay(), (int)0, (int)0, (int)0, (int)0);
            if (this.currentDay < this.billDay) {
                this.firstOfMonth = this.firstOfMonth.prevMonth();
            }
        }
        this.deltaSyntax = this.getDeltaLogged() ? ";delta=false" : ";delta=true";
        this.currentHourQuery();
        this.currentDayQuery();
        this.currentWeekQuery();
        this.currentMonthQuery();
        this.currentYearQuery();
        if (this.currentHour != this.lastHour) {
            this.lastHourQuery();
            this.lastHour = this.currentHour;
        }
        if (this.day != this.lastDay) {
            this.yesterdayQuery();
            this.lastDay = this.day;
        }
        if (this.resetLatch || this.now.getWeekday().equals((Object)this.resetDay) && !this.latch) {
            this.lastWeekQuery();
            this.latch = true;
            this.resetLatch = false;
        }
        if (!this.now.getWeekday().equals((Object)this.resetDay)) {
            this.latch = false;
        }
        if (this.now.getMonth().getMonthOfYear() != this.previousMonth) {
            this.lastMonthQuery();
            this.previousMonth = this.month;
        }
        if (this.now.getYear() != this.previousYear) {
            this.lastYearQuery();
            this.previousYear = this.year;
        }
        this.setCalculating(false);
        this.setLastUpdateTime(Clock.time());
    }

    public void doReset() throws Exception {
        this.getCurrentHourTotal().setValue(0.0);
        this.getCurrentHourAvg().setValue(0.0);
        this.getCurrentHourMin().setValue(0.0);
        this.getCurrentHourMax().setValue(0.0);
        this.getLastHourTotal().setValue(0.0);
        this.getLastHourAvg().setValue(0.0);
        this.getLastHourMin().setValue(0.0);
        this.getLastHourMax().setValue(0.0);
        this.lastHour = 0;
        this.getCurrentDayTotal().setValue(0.0);
        this.getCurrentDayAvg().setValue(0.0);
        this.getCurrentDayMin().setValue(0.0);
        this.getCurrentDayMax().setValue(0.0);
        this.getYesterdayTotal().setValue(0.0);
        this.getYesterdayAvg().setValue(0.0);
        this.getYesterdayMin().setValue(0.0);
        this.getYesterdayMax().setValue(0.0);
        this.lastDay = 0;
        this.getCurrentWeekTotal().setValue(0.0);
        this.getCurrentWeekAvg().setValue(0.0);
        this.getCurrentWeekMin().setValue(0.0);
        this.getCurrentWeekMax().setValue(0.0);
        this.getLastWeekTotal().setValue(0.0);
        this.getLastWeekAvg().setValue(0.0);
        this.getLastWeekMin().setValue(0.0);
        this.getLastWeekMax().setValue(0.0);
        this.getCurrentMonthTotal().setValue(0.0);
        this.getCurrentMonthAvg().setValue(0.0);
        this.getCurrentMonthMin().setValue(0.0);
        this.getCurrentMonthMax().setValue(0.0);
        this.getLastMonthTotal().setValue(0.0);
        this.getLastMonthAvg().setValue(0.0);
        this.getLastMonthMin().setValue(0.0);
        this.getLastMonthMax().setValue(0.0);
        this.previousMonth = 0;
        this.getCurrentYearTotal().setValue(0.0);
        this.getCurrentYearAvg().setValue(0.0);
        this.getCurrentYearMin().setValue(0.0);
        this.getCurrentYearMax().setValue(0.0);
        this.getLastYearTotal().setValue(0.0);
        this.getLastYearAvg().setValue(0.0);
        this.getLastYearMin().setValue(0.0);
        this.getLastYearMax().setValue(0.0);
        this.previousYear = 0;
        this.resetLatch = true;
        this.calculate();
    }

    public void currentHourQuery() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("?period=timeRange;start=");
        BAbsTime bAbsTime = Clock.time();
        BAbsTime bAbsTime2 = null;
        bAbsTime2 = BAbsTime.make((BAbsTime)bAbsTime, (BTime)BTime.make((int)bAbsTime.getHour(), (int)0, (int)0));
        if (!this.getDeltaLogged() && this.getHistoryInterval().getMinutes() <= 60) {
            bAbsTime2 = bAbsTime2.subtract(this.getHistoryInterval());
            this.ch = true;
        }
        stringBuffer.append(bAbsTime2.encodeToString());
        stringBuffer.append(";end=");
        stringBuffer.append(bAbsTime.encodeToString());
        this.runQuery(stringBuffer.toString());
        this.getCurrentHourTotal().setValue(this.total);
        this.getCurrentHourMin().setValue(this.min);
        this.getCurrentHourMax().setValue(this.max);
        this.getCurrentHourAvg().setValue(this.avg);
    }

    public void lastHourQuery() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("?period=timeRange;start=");
        BAbsTime bAbsTime = Clock.time();
        BAbsTime bAbsTime2 = null;
        BAbsTime bAbsTime3 = null;
        bAbsTime3 = BAbsTime.make((BAbsTime)bAbsTime, (BTime)BTime.make((int)bAbsTime.getHour(), (int)0, (int)0));
        bAbsTime2 = bAbsTime3.subtract(BRelTime.makeHours((int)1));
        bAbsTime3 = bAbsTime3.subtract(BRelTime.makeSeconds((int)1));
        if (!this.getDeltaLogged() && this.getHistoryInterval().getMinutes() <= 60) {
            bAbsTime2 = bAbsTime2.subtract(this.getHistoryInterval());
            this.ch = true;
        }
        stringBuffer.append(bAbsTime2.encodeToString());
        stringBuffer.append(";end=");
        stringBuffer.append(bAbsTime3.encodeToString());
        this.runQuery(stringBuffer.toString());
        this.getLastHourTotal().setValue(this.total);
        this.getLastHourMin().setValue(this.min);
        this.getLastHourMax().setValue(this.max);
        this.getLastHourAvg().setValue(this.avg);
    }

    public void currentDayQuery() throws Exception {
        this.runQuery("?period=today");
        this.getCurrentDayTotal().setValue(this.total);
        this.getCurrentDayMin().setValue(this.min);
        this.getCurrentDayMax().setValue(this.max);
        this.getCurrentDayAvg().setValue(this.avg);
    }

    public void yesterdayQuery() throws Exception {
        this.runQuery("?period=yesterday");
        this.getYesterdayTotal().setValue(this.total);
        this.getYesterdayMin().setValue(this.min);
        this.getYesterdayMax().setValue(this.max);
        this.getYesterdayAvg().setValue(this.avg);
    }

    public void currentWeekQuery() throws Exception {
        this.runQuery("?period=weekToDate");
        this.getCurrentWeekTotal().setValue(this.total);
        this.getCurrentWeekMin().setValue(this.min);
        this.getCurrentWeekMax().setValue(this.max);
        this.getCurrentWeekAvg().setValue(this.avg);
    }

    public void lastWeekQuery() throws Exception {
        this.runQuery("?period=lastWeek");
        this.getLastWeekTotal().setValue(this.total);
        this.getLastWeekMin().setValue(this.min);
        this.getLastWeekMax().setValue(this.max);
        this.getLastWeekAvg().setValue(this.avg);
    }

    public void currentMonthQuery() throws Exception {
        if (this.getDateMode().getOrdinal() == 0) {
            this.runQuery("?period=monthToDate");
        } else {
            String string = "?period=timeRange;start=" + this.firstOfMonth.encodeToString();
            this.runQuery(string);
        }
        this.getCurrentMonthTotal().setValue(this.total);
        this.getCurrentMonthMin().setValue(this.min);
        this.getCurrentMonthMax().setValue(this.max);
        this.getCurrentMonthAvg().setValue(this.avg);
    }

    public void lastMonthQuery() throws Exception {
        if (this.getDateMode().getOrdinal() == 0) {
            this.runQuery("?period=lastMonth");
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("?period=timeRange;start=");
            stringBuffer.append(this.firstOfMonth.prevMonth().encodeToString());
            stringBuffer.append(";end=");
            stringBuffer.append(this.firstOfMonth.encodeToString());
            this.runQuery(stringBuffer.toString());
        }
        this.getLastMonthTotal().setValue(this.total);
        this.getLastMonthMin().setValue(this.min);
        this.getLastMonthMax().setValue(this.max);
        this.getLastMonthAvg().setValue(this.avg);
    }

    public void currentYearQuery() throws Exception {
        if (this.getDateMode().getOrdinal() == 0) {
            this.runQuery("?period=yearToDate");
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("?period=timeRange;start=");
            stringBuffer.append(this.firstOfYear.encodeToString());
            this.runQuery(stringBuffer.toString());
        }
        this.getCurrentYearTotal().setValue(this.total);
        this.getCurrentYearMin().setValue(this.min);
        this.getCurrentYearMax().setValue(this.max);
        this.getCurrentYearAvg().setValue(this.avg);
    }

    public void lastYearQuery() throws Exception {
        if (this.getDateMode().getOrdinal() == 0) {
            this.runQuery("?period=lastYear");
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("?period=timeRange;start=");
            stringBuffer.append(this.firstOfYear.prevYear().encodeToString());
            stringBuffer.append(";end=");
            stringBuffer.append(this.firstOfYear.encodeToString());
            this.runQuery(stringBuffer.toString());
        }
        this.getLastYearTotal().setValue(this.total);
        this.getLastYearMin().setValue(this.min);
        this.getLastYearMax().setValue(this.max);
        this.getLastYearAvg().setValue(this.avg);
    }

    private final void runQuery(String string) {
        BOrd bOrd = BOrd.make((String)(this.getHistoryOrd().toString() + string + this.deltaSyntax + "|bql:select *"));
        BITable bITable = (BITable)bOrd.resolve().get();
        ColumnList columnList = bITable.getColumns();
        Column column = columnList.get(3);
        Column column2 = columnList.get(2);
        Column column3 = columnList.get(1);
        TableCursor tableCursor = (TableCursor)bITable.cursor();
        this.total = 0.0;
        this.min = 0.0;
        this.max = 0.0;
        this.records = 0.0;
        this.avg = 0.0;
        boolean bl = true;
        boolean bl2 = this.getExcludeInvalidValues();
        boolean bl3 = this.getExcludeHiddenValues();
        double d = 0.0;
        BStatus bStatus = BStatus.nullStatus;
        BTrendFlags bTrendFlags = null;
        boolean bl4 = false;
        if (bITable.size() == 1) {
            bl4 = true;
        }
        if (bl4 & (this.getDeltaLogged() ^ true)) {
            tableCursor.next();
            d = ((BINumeric)tableCursor.get(column)).getNumeric();
            bStatus = ((BStatus)tableCursor.get(column2)).getStatus();
            bTrendFlags = (BTrendFlags)tableCursor.get(column3);
            if (!(bl2 & (bStatus.isValid() ^ true)) && !(bl3 & bTrendFlags.getBit("hidden")) && BDouble.make((double)d) != BDouble.NaN) {
                this.records += 1.0;
                this.min = d;
                this.max = d;
                this.total += d;
            }
        }
        while (tableCursor.next()) {
            d = ((BINumeric)tableCursor.get(column)).getNumeric();
            bStatus = ((BStatus)tableCursor.get(column2)).getStatus();
            bTrendFlags = (BTrendFlags)tableCursor.get(column3);
            if (bl2 & (bStatus.isValid() ^ true) || bl3 & bTrendFlags.getBit("hidden") || BDouble.make((double)d) == BDouble.NaN) continue;
            if (!this.ch) {
                this.records += 1.0;
            }
            if (bl) {
                this.min = d;
                this.max = d;
                this.total = d;
                if (!this.ch) {
                    bl = false;
                    continue;
                }
                this.ch = false;
                continue;
            }
            if (d < this.min) {
                this.min = d;
            }
            if (d > this.max) {
                this.max = d;
            }
            this.total += d;
        }
        if (this.records > 0.0) {
            this.avg = this.total / this.records;
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.serviceFound = false;
        this.serviceFault = "vykonPro service fault";
        this.ordOkay = false;
        this.ordFault = "historyOrd fault";
        this.ticket = null;
        this.now = null;
        this.firstOfMonth = null;
        this.firstOfYear = null;
        this.lastOrd = null;
        this.min = 0.0;
        this.max = 0.0;
        this.total = 0.0;
        this.records = 0.0;
        this.avg = 0.0;
        this.day = 0;
        this.currentHour = 0;
        this.lastHour = 0;
        this.currentDay = 0;
        this.lastDay = 0;
        this.month = 0;
        this.previousMonth = 0;
        this.year = 0;
        this.previousYear = 0;
        this.billDay = 0;
        this.resetDay = BWeekday.make((String)"sunday");
        this.latch = false;
        this.resetLatch = true;
        this.serviceExists = false;
        this.deltaSyntax = "";
        this.ch = false;
    }

    public BNumericHistoryAnalysis() {
        this.this();
    }

    static {
        Class clazz = class$com$vykon$vykonPro$history$BNumericHistoryAnalysis;
        if (clazz == null) {
            clazz = class$com$vykon$vykonPro$history$BNumericHistoryAnalysis = BNumericHistoryAnalysis.class("[Lcom.vykon.vykonPro.history.BNumericHistoryAnalysis;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"historyDatabase.png");
    }
}

