/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.history;

import com.vykon.vykonPro.history.BBypassTimeRecord;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.ext.BActivePeriod;
import javax.baja.history.ext.BBasicActivePeriod;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBypassLogger
extends BComponent {
    public static final Property status = BBypassLogger.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BBypassLogger.newProperty((int)3, (String)"", null);
    public static final Property enabled = BBypassLogger.newProperty((int)64, (boolean)false, null);
    public static final Property activePeriod = BBypassLogger.newProperty((int)0, (BValue)new BBasicActivePeriod(), null);
    public static final Property active = BBypassLogger.newProperty((int)3, (boolean)false, null);
    public static final Property historyName = BBypassLogger.newProperty((int)0, (BValue)BFormat.make((String)"%name%"), null);
    public static final Property historyConfig = BBypassLogger.newProperty((int)0, (BValue)new BHistoryConfig(), null);
    public static final Property elapsedTimeFacets = BBypassLogger.newProperty((int)64, (BValue)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.FALSE), null);
    public static final Property timestampFacets = BBypassLogger.newProperty((int)64, (BValue)BFacets.NULL, null);
    public static final Property bypassInput = BBypassLogger.newProperty((int)8, (BValue)new BStatusBoolean(), null);
    public static final Property startTime = BBypassLogger.newProperty((int)5, (BValue)BAbsTime.NULL, null);
    public static final Property timestamp = BBypassLogger.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property timestampEnd = BBypassLogger.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property elapsedTime = BBypassLogger.newProperty((int)1, (BValue)BRelTime.make((long)0L), null);
    public static final Action appendRecord = BBypassLogger.newAction((int)4, null);
    public static final Action syncConfig = BBypassLogger.newAction((int)20, null);
    public static final Type TYPE;
    private static final String ELAPSED_TIME_FACETS = "elapsedTimeFacets";
    private static final String TIMESTAMP_END_FACETS = "timestampEndFacets";
    private static final String TIMESTAMP_FACETS = "timestampFacets";
    long elapsedMillis;
    BRelTime elapTime;
    static /* synthetic */ Class class$com$vykon$vykonPro$history$BBypassLogger;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BActivePeriod getActivePeriod() {
        return (BActivePeriod)this.get(activePeriod);
    }

    public void setActivePeriod(BActivePeriod bActivePeriod) {
        this.set(activePeriod, (BValue)bActivePeriod, null);
    }

    public boolean getActive() {
        return this.getBoolean(active);
    }

    public void setActive(boolean bl) {
        this.setBoolean(active, bl, null);
    }

    public BFormat getHistoryName() {
        return (BFormat)this.get(historyName);
    }

    public void setHistoryName(BFormat bFormat) {
        this.set(historyName, (BValue)bFormat, null);
    }

    public BHistoryConfig getHistoryConfig() {
        return (BHistoryConfig)this.get(historyConfig);
    }

    public void setHistoryConfig(BHistoryConfig bHistoryConfig) {
        this.set(historyConfig, (BValue)bHistoryConfig, null);
    }

    public BFacets getElapsedTimeFacets() {
        return (BFacets)this.get(elapsedTimeFacets);
    }

    public void setElapsedTimeFacets(BFacets bFacets) {
        this.set(elapsedTimeFacets, (BValue)bFacets, null);
    }

    public BFacets getTimestampFacets() {
        return (BFacets)this.get(timestampFacets);
    }

    public void setTimestampFacets(BFacets bFacets) {
        this.set(timestampFacets, (BValue)bFacets, null);
    }

    public BStatusBoolean getBypassInput() {
        return (BStatusBoolean)this.get(bypassInput);
    }

    public void setBypassInput(BStatusBoolean bStatusBoolean) {
        this.set(bypassInput, (BValue)bStatusBoolean, null);
    }

    public BAbsTime getStartTime() {
        return (BAbsTime)this.get(startTime);
    }

    public void setStartTime(BAbsTime bAbsTime) {
        this.set(startTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    public void setTimestamp(BAbsTime bAbsTime) {
        this.set(timestamp, (BValue)bAbsTime, null);
    }

    public BAbsTime getTimestampEnd() {
        return (BAbsTime)this.get(timestampEnd);
    }

    public void setTimestampEnd(BAbsTime bAbsTime) {
        this.set(timestampEnd, (BValue)bAbsTime, null);
    }

    public BRelTime getElapsedTime() {
        return (BRelTime)this.get(elapsedTime);
    }

    public void setElapsedTime(BRelTime bRelTime) {
        this.set(elapsedTime, (BValue)bRelTime, null);
    }

    public void appendRecord() {
        this.invoke(appendRecord, null, null);
    }

    public void syncConfig() {
        this.invoke(syncConfig, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.setActive(this.getActivePeriod().isActive(BAbsTime.make()));
    }

    public BOrd getSourceOrd() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace == null) {
            return null;
        }
        BOrd bOrd = bComponentSpace.getOrdInSession();
        if (bOrd == null) {
            return null;
        }
        return BOrd.make((BOrd)bOrd, (BOrd)this.getSlotPathOrd());
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)elapsedTime)) {
            return this.getElapsedTimeFacets();
        }
        if (slot.equals((Object)timestamp) || slot.equals((Object)timestampEnd)) {
            return this.getTimestampFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void changed(Property property, Context context) {
        if (context == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)enabled)) {
            if (this.getEnabled()) {
                BHistoryService bHistoryService = null;
                try {
                    bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                }
                catch (ServiceNotFoundException serviceNotFoundException) {
                    return;
                }
                BHistoryId bHistoryId = BHistoryId.make((String)Sys.getStation().getStationName(), (String)this.resolveHistoryName());
                BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
                if (bHistoryDatabase == null) {
                    System.out.println("Local history database not available.");
                    return;
                }
                if (!bHistoryDatabase.exists(bHistoryId)) {
                    try {
                        this.createHistory();
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
                this.updateStatus();
            }
        } else if (property.equals((Object)bypassInput)) {
            if (this.getBypassInput().getValue()) {
                this.setStartTime(BAbsTime.make());
            } else {
                this.appendRecord();
            }
        } else if (property.equals((Object)activePeriod)) {
            this.setActive(this.getActivePeriod().isActive(BAbsTime.make()));
        } else if (property.equals((Object)elapsedTimeFacets) || property.equals((Object)timestampFacets)) {
            this.syncConfig();
        } else if (!property.equals((Object)status) && !property.equals((Object)faultCause)) {
            this.updateStatus();
        }
    }

    public void historyConfigChanged(BHistoryConfig bHistoryConfig, Property property) {
        if (!this.isRunning()) {
            return;
        }
        if (bHistoryConfig != this.getHistoryConfig()) {
            return;
        }
        this.syncConfig();
    }

    public synchronized void doSyncConfig() {
        if (this.getEnabled()) {
            BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
            BHistoryConfig bHistoryConfig = this.getHistoryConfig();
            bHistoryConfig.setTimeZone(BTimeZone.getLocal());
            BFacets bFacets = (BFacets)bHistoryConfig.get(ELAPSED_TIME_FACETS);
            if (bFacets != null) {
                bHistoryConfig.set(ELAPSED_TIME_FACETS, (BValue)BFacets.make((BFacets)this.getElapsedTimeFacets()));
            } else {
                bHistoryConfig.add(ELAPSED_TIME_FACETS, (BValue)BFacets.make((BFacets)this.getElapsedTimeFacets()));
            }
            BFacets bFacets2 = (BFacets)bHistoryConfig.get(TIMESTAMP_END_FACETS);
            if (bFacets2 != null) {
                bHistoryConfig.set(TIMESTAMP_END_FACETS, (BValue)BFacets.make((BFacets)this.getTimestampFacets()));
            } else {
                bHistoryConfig.add(TIMESTAMP_END_FACETS, (BValue)BFacets.make((BFacets)this.getTimestampFacets()));
            }
            BFacets bFacets3 = (BFacets)bHistoryConfig.get(TIMESTAMP_FACETS);
            if (bFacets3 != null) {
                bHistoryConfig.set(TIMESTAMP_FACETS, (BValue)BFacets.make((BFacets)this.getTimestampFacets()));
            } else {
                bHistoryConfig.add(TIMESTAMP_FACETS, (BValue)BFacets.make((BFacets)this.getTimestampFacets()));
            }
            bHistoryDatabase.reconfigureHistory(this.getHistoryConfig());
        }
    }

    public void updateStatus() {
        if (!this.getEnabled()) {
            this.setStatus(BStatus.disabled);
            this.setFaultCause("");
        } else {
            boolean bl = this.getHistoryConfig().getId().isValid();
            if (!bl) {
                this.setStatus(BStatus.fault);
                this.setFaultCause("Invalid history name.");
            } else {
                this.setStatus(BStatus.ok);
                this.setFaultCause("");
            }
        }
    }

    public void createHistory() throws Exception {
        try {
            this.getHistoryConfig().setRecordType(BTypeSpec.make((String)"vykonPro", (String)"BypassTimeRecord"));
            BOrdList bOrdList = BOrdList.make((BOrd)this.getSourceOrd());
            this.getHistoryConfig().setSource(bOrdList);
            this.getHistoryConfig().setId(BHistoryId.make((String)Sys.getStation().getStationName(), (String)this.resolveHistoryName()));
            BHistoryConfig bHistoryConfig = this.getHistoryConfig();
            bHistoryConfig.add(ELAPSED_TIME_FACETS, (BValue)BFacets.make((BFacets)this.getElapsedTimeFacets()));
            bHistoryConfig.add(TIMESTAMP_END_FACETS, (BValue)BFacets.make((BFacets)this.getTimestampFacets()));
            bHistoryConfig.add(TIMESTAMP_FACETS, (BValue)BFacets.make((BFacets)this.getTimestampFacets()));
            BHistoryDatabase bHistoryDatabase = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
            if (bHistoryDatabase == null) {
                System.out.println("Local history database not available.");
                return;
            }
            bHistoryDatabase.createHistory(bHistoryConfig);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doAppendRecord() throws Exception {
        if (this.getActivePeriod().isActive(BAbsTime.make()) && this.getEnabled()) {
            try {
                BHistoryDatabase bHistoryDatabase = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
                if (bHistoryDatabase == null) {
                    System.out.println("Local history database not available.");
                    return;
                }
                BHistoryId bHistoryId = BHistoryId.make((String)Sys.getStation().getStationName(), (String)this.resolveHistoryName());
                if (!bHistoryDatabase.exists(bHistoryId)) {
                    this.createHistory();
                }
                BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
                BAbsTime bAbsTime = BAbsTime.make();
                this.elapsedMillis = bAbsTime.getMillis() - this.getStartTime().getMillis();
                if (this.elapsedMillis < 0L) {
                    this.elapsedMillis = 0L;
                }
                this.elapTime = BRelTime.make((long)this.elapsedMillis);
                BAbsTime bAbsTime2 = bIHistory.getLastTimestamp();
                if (Clock.time().isAfter(bAbsTime2)) {
                    BBypassTimeRecord bBypassTimeRecord = new BBypassTimeRecord(this.getStartTime(), bAbsTime, this.elapTime);
                    bIHistory.append((BIHistoryRecordSet)bBypassTimeRecord);
                    this.setTimestamp(this.getStartTime());
                    this.setTimestampEnd(bAbsTime);
                    this.setElapsedTime(this.elapTime);
                }
            }
            catch (Exception exception) {
                System.out.println("Error creating the history...");
                exception.printStackTrace();
            }
        }
    }

    public String resolveHistoryName() {
        BFormat bFormat = this.getHistoryName();
        return SlotPath.escape((String)SlotPath.unescape((String)bFormat.format((Object)this)));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$vykon$vykonPro$history$BBypassLogger;
        if (clazz == null) {
            clazz = class$com$vykon$vykonPro$history$BBypassLogger = BBypassLogger.class("[Lcom.vykon.vykonPro.history.BBypassLogger;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

