/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.energy;

import com.vykon.vykonPro.energy.BConsumptionProperties;
import com.vykon.vykonPro.energy.BDemandProperties;
import com.vykon.vykonPro.enums.BPeakIntervalEnum;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBlockDemandCalc
extends BComponent {
    public static final Property status = BBlockDemandCalc.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property lastFaultCause = BBlockDemandCalc.newProperty((int)65, (String)"", null);
    public static final Property lastFaultTime = BBlockDemandCalc.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Property consumptionFacets = BBlockDemandCalc.newProperty((int)256, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"kilowatt hour"), (int)1), null);
    public static final Property demandFacets = BBlockDemandCalc.newProperty((int)256, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"kilowatt"), (int)1), null);
    public static final Property currentPulseCount = BBlockDemandCalc.newProperty((int)328, (BValue)new BStatusNumeric(), null);
    public static final Property kwhPerPulse = BBlockDemandCalc.newProperty((int)256, (double)1.0, null);
    public static final Property kwhPerPulseFacets = BBlockDemandCalc.newProperty((int)256, (BValue)BFacets.make((String)"precision", (int)3), null);
    public static final Property checkFrequency = BBlockDemandCalc.newProperty((int)256, (boolean)true, null);
    public static final Property maxPulseFrequency = BBlockDemandCalc.newProperty((int)256, (int)10, (BFacets)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"hertz"), (int)1, (double)1.0, (double)100.0));
    public static final Property actualPulseFrequency = BBlockDemandCalc.newProperty((int)3, (int)0, (BFacets)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"hertz"), (int)1));
    public static final Property meterRollover = BBlockDemandCalc.newProperty((int)256, (long)65535L, null);
    public static final Property peakMode = BBlockDemandCalc.newProperty((int)264, (BValue)new BStatusBoolean(), (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)"onPeak"), (BFacets)BFacets.make((String)"falseText", (String)"offPeak")));
    public static final Property kwhTotal = BBlockDemandCalc.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property kwhOffPeakTotal = BBlockDemandCalc.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property kwhOnPeakTotal = BBlockDemandCalc.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property monthlyKwh = BBlockDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property monthlyKwhOffPeak = BBlockDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property monthlyKwhOnPeak = BBlockDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property kwh5 = BBlockDemandCalc.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property kwh15 = BBlockDemandCalc.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property kwh30 = BBlockDemandCalc.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property maxKw = BBlockDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property maxKwTimestamp = BBlockDemandCalc.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property maxKwOffPeak = BBlockDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property maxKwOffPeakTimestamp = BBlockDemandCalc.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property maxKwOnPeak = BBlockDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property maxKwOnPeakTimestamp = BBlockDemandCalc.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property peakKwInterval = BBlockDemandCalc.newProperty((int)256, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BPeakIntervalEnum.TYPE)), null);
    public static final Property kw5 = BBlockDemandCalc.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property kw15 = BBlockDemandCalc.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property kw30 = BBlockDemandCalc.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Action presetKwh = BBlockDemandCalc.newAction((int)256, (BValue)new BConsumptionProperties(), null);
    public static final Action presetKw = BBlockDemandCalc.newAction((int)256, (BValue)new BDemandProperties(), null);
    public static final Action monthlyReset = BBlockDemandCalc.newAction((int)0, null);
    public static final Action reset = BBlockDemandCalc.newAction((int)0, null);
    public static final Action timerExpired5 = BBlockDemandCalc.newAction((int)4, null);
    public static final Type TYPE;
    Clock.Ticket ticket5;
    double lastPulseCount;
    double currentCount;
    double pulseCountDiff;
    double kwhNew;
    double intervalKwh;
    double lastPulseCount5;
    double lastPulseCount15;
    double lastPulseCount30;
    int elapsedSeconds;
    long lastTicks;
    long lastTicks5;
    long lastTicks15;
    long lastTicks30;
    boolean checkFreq;
    boolean validFreq;
    static /* synthetic */ Class class$com$vykon$vykonPro$energy$BBlockDemandCalc;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getLastFaultCause() {
        return this.getString(lastFaultCause);
    }

    public void setLastFaultCause(String string) {
        this.setString(lastFaultCause, string, null);
    }

    public BAbsTime getLastFaultTime() {
        return (BAbsTime)this.get(lastFaultTime);
    }

    public void setLastFaultTime(BAbsTime bAbsTime) {
        this.set(lastFaultTime, (BValue)bAbsTime, null);
    }

    public BFacets getConsumptionFacets() {
        return (BFacets)this.get(consumptionFacets);
    }

    public void setConsumptionFacets(BFacets bFacets) {
        this.set(consumptionFacets, (BValue)bFacets, null);
    }

    public BFacets getDemandFacets() {
        return (BFacets)this.get(demandFacets);
    }

    public void setDemandFacets(BFacets bFacets) {
        this.set(demandFacets, (BValue)bFacets, null);
    }

    public BStatusNumeric getCurrentPulseCount() {
        return (BStatusNumeric)this.get(currentPulseCount);
    }

    public void setCurrentPulseCount(BStatusNumeric bStatusNumeric) {
        this.set(currentPulseCount, (BValue)bStatusNumeric, null);
    }

    public double getKwhPerPulse() {
        return this.getDouble(kwhPerPulse);
    }

    public void setKwhPerPulse(double d) {
        this.setDouble(kwhPerPulse, d, null);
    }

    public BFacets getKwhPerPulseFacets() {
        return (BFacets)this.get(kwhPerPulseFacets);
    }

    public void setKwhPerPulseFacets(BFacets bFacets) {
        this.set(kwhPerPulseFacets, (BValue)bFacets, null);
    }

    public boolean getCheckFrequency() {
        return this.getBoolean(checkFrequency);
    }

    public void setCheckFrequency(boolean bl) {
        this.setBoolean(checkFrequency, bl, null);
    }

    public double getMaxPulseFrequency() {
        return this.getDouble(maxPulseFrequency);
    }

    public void setMaxPulseFrequency(double d) {
        this.setDouble(maxPulseFrequency, d, null);
    }

    public double getActualPulseFrequency() {
        return this.getDouble(actualPulseFrequency);
    }

    public void setActualPulseFrequency(double d) {
        this.setDouble(actualPulseFrequency, d, null);
    }

    public long getMeterRollover() {
        return this.getLong(meterRollover);
    }

    public void setMeterRollover(long l) {
        this.setLong(meterRollover, l, null);
    }

    public BStatusBoolean getPeakMode() {
        return (BStatusBoolean)this.get(peakMode);
    }

    public void setPeakMode(BStatusBoolean bStatusBoolean) {
        this.set(peakMode, (BValue)bStatusBoolean, null);
    }

    public BStatusNumeric getKwhTotal() {
        return (BStatusNumeric)this.get(kwhTotal);
    }

    public void setKwhTotal(BStatusNumeric bStatusNumeric) {
        this.set(kwhTotal, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getKwhOffPeakTotal() {
        return (BStatusNumeric)this.get(kwhOffPeakTotal);
    }

    public void setKwhOffPeakTotal(BStatusNumeric bStatusNumeric) {
        this.set(kwhOffPeakTotal, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getKwhOnPeakTotal() {
        return (BStatusNumeric)this.get(kwhOnPeakTotal);
    }

    public void setKwhOnPeakTotal(BStatusNumeric bStatusNumeric) {
        this.set(kwhOnPeakTotal, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getMonthlyKwh() {
        return (BStatusNumeric)this.get(monthlyKwh);
    }

    public void setMonthlyKwh(BStatusNumeric bStatusNumeric) {
        this.set(monthlyKwh, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getMonthlyKwhOffPeak() {
        return (BStatusNumeric)this.get(monthlyKwhOffPeak);
    }

    public void setMonthlyKwhOffPeak(BStatusNumeric bStatusNumeric) {
        this.set(monthlyKwhOffPeak, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getMonthlyKwhOnPeak() {
        return (BStatusNumeric)this.get(monthlyKwhOnPeak);
    }

    public void setMonthlyKwhOnPeak(BStatusNumeric bStatusNumeric) {
        this.set(monthlyKwhOnPeak, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getKwh5() {
        return (BStatusNumeric)this.get(kwh5);
    }

    public void setKwh5(BStatusNumeric bStatusNumeric) {
        this.set(kwh5, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getKwh15() {
        return (BStatusNumeric)this.get(kwh15);
    }

    public void setKwh15(BStatusNumeric bStatusNumeric) {
        this.set(kwh15, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getKwh30() {
        return (BStatusNumeric)this.get(kwh30);
    }

    public void setKwh30(BStatusNumeric bStatusNumeric) {
        this.set(kwh30, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getMaxKw() {
        return (BStatusNumeric)this.get(maxKw);
    }

    public void setMaxKw(BStatusNumeric bStatusNumeric) {
        this.set(maxKw, (BValue)bStatusNumeric, null);
    }

    public BAbsTime getMaxKwTimestamp() {
        return (BAbsTime)this.get(maxKwTimestamp);
    }

    public void setMaxKwTimestamp(BAbsTime bAbsTime) {
        this.set(maxKwTimestamp, (BValue)bAbsTime, null);
    }

    public BStatusNumeric getMaxKwOffPeak() {
        return (BStatusNumeric)this.get(maxKwOffPeak);
    }

    public void setMaxKwOffPeak(BStatusNumeric bStatusNumeric) {
        this.set(maxKwOffPeak, (BValue)bStatusNumeric, null);
    }

    public BAbsTime getMaxKwOffPeakTimestamp() {
        return (BAbsTime)this.get(maxKwOffPeakTimestamp);
    }

    public void setMaxKwOffPeakTimestamp(BAbsTime bAbsTime) {
        this.set(maxKwOffPeakTimestamp, (BValue)bAbsTime, null);
    }

    public BStatusNumeric getMaxKwOnPeak() {
        return (BStatusNumeric)this.get(maxKwOnPeak);
    }

    public void setMaxKwOnPeak(BStatusNumeric bStatusNumeric) {
        this.set(maxKwOnPeak, (BValue)bStatusNumeric, null);
    }

    public BAbsTime getMaxKwOnPeakTimestamp() {
        return (BAbsTime)this.get(maxKwOnPeakTimestamp);
    }

    public void setMaxKwOnPeakTimestamp(BAbsTime bAbsTime) {
        this.set(maxKwOnPeakTimestamp, (BValue)bAbsTime, null);
    }

    public BEnum getPeakKwInterval() {
        return (BEnum)this.get(peakKwInterval);
    }

    public void setPeakKwInterval(BEnum bEnum) {
        this.set(peakKwInterval, (BValue)bEnum, null);
    }

    public BStatusNumeric getKw5() {
        return (BStatusNumeric)this.get(kw5);
    }

    public void setKw5(BStatusNumeric bStatusNumeric) {
        this.set(kw5, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getKw15() {
        return (BStatusNumeric)this.get(kw15);
    }

    public void setKw15(BStatusNumeric bStatusNumeric) {
        this.set(kw15, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getKw30() {
        return (BStatusNumeric)this.get(kw30);
    }

    public void setKw30(BStatusNumeric bStatusNumeric) {
        this.set(kw30, (BValue)bStatusNumeric, null);
    }

    public void presetKwh(BConsumptionProperties bConsumptionProperties) {
        this.invoke(presetKwh, (BValue)bConsumptionProperties, null);
    }

    public void presetKw(BDemandProperties bDemandProperties) {
        this.invoke(presetKw, (BValue)bDemandProperties, null);
    }

    public void monthlyReset() {
        this.invoke(monthlyReset, null, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public void timerExpired5() {
        this.invoke(timerExpired5, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        this.initTicket5();
        this.lastTicks = Clock.ticks();
        this.lastTicks5 = Clock.ticks();
        this.lastTicks15 = Clock.ticks();
        this.lastTicks30 = Clock.ticks();
        this.lastPulseCount = this.getCurrentPulseCount().getValue();
        this.lastPulseCount5 = this.getCurrentPulseCount().getValue();
        this.lastPulseCount15 = this.getCurrentPulseCount().getValue();
        this.lastPulseCount30 = this.getCurrentPulseCount().getValue();
        super.started();
    }

    public void stopped() throws Exception {
        if (this.ticket5 != null) {
            this.ticket5.cancel();
        }
        super.stopped();
    }

    public void clockChanged(BRelTime bRelTime) {
        this.initTicket5();
    }

    private final void initTicket5() {
        BAbsTime bAbsTime = Clock.time();
        if (this.ticket5 != null) {
            this.ticket5.cancel();
        }
        BAbsTime bAbsTime2 = BAbsTime.make((BAbsTime)bAbsTime, (BTime)BTime.make((int)0, (int)4, (int)55));
        while (!bAbsTime2.isAfter(bAbsTime)) {
            bAbsTime2 = bAbsTime2.add(BRelTime.makeMinutes((int)5));
        }
        this.ticket5 = Clock.schedulePeriodically((BComponent)this, (BAbsTime)bAbsTime2, (BRelTime)BRelTime.makeMinutes((int)5), (Action)timerExpired5, null);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)kwhOffPeakTotal) || slot.equals((Object)kwhOnPeakTotal) || slot.equals((Object)kwh15) || slot.equals((Object)kwh30) || slot.equals((Object)monthlyKwhOnPeak) || slot.equals((Object)monthlyKwhOffPeak)) {
            return this.getConsumptionFacets();
        }
        if (slot.equals((Object)kw15) || slot.equals((Object)kw30) || slot.equals((Object)kw5) || slot.equals((Object)maxKwOffPeak) || slot.equals((Object)maxKwOnPeak)) {
            return this.getDemandFacets();
        }
        if (slot.equals((Object)kwhPerPulse)) {
            return this.getKwhPerPulseFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void changed(Property property, Context context) {
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals((Object)currentPulseCount)) {
            this.calculateTotalKwh();
        }
        super.changed(property, context);
    }

    private final int calculateDiffTime(long l) {
        long l2 = Clock.ticks();
        long l3 = l2 - l;
        if (l3 <= 0L) {
            this.setStatus(BStatus.fault);
            this.setLastFaultCause("Elapsed ticks indicate a negative change.");
            this.setLastFaultTime(Clock.time());
            return 0;
        }
        return (int)(l3 / 1000L);
    }

    private final void calculateKw5() {
        this.elapsedSeconds = this.calculateDiffTime(this.lastTicks5);
        this.checkFreq = true;
        this.intervalKwh = this.calculateKwh(this.lastPulseCount5, this.elapsedSeconds);
        this.getKwh5().setValue(this.intervalKwh);
        if (this.validFreq) {
            this.getKw5().setValue(this.intervalKwh / (double)this.elapsedSeconds * 3600.0);
        } else {
            this.getKw5().setValue(0.0);
        }
        this.lastTicks5 = Clock.ticks();
        this.lastPulseCount5 = this.getCurrentPulseCount().getValue();
    }

    private final void calculateKw15() {
        this.elapsedSeconds = this.calculateDiffTime(this.lastTicks15);
        this.intervalKwh = this.calculateKwh(this.lastPulseCount15, this.elapsedSeconds);
        this.getKwh15().setValue(this.intervalKwh);
        if (this.validFreq) {
            this.getKw15().setValue(this.intervalKwh / (double)this.elapsedSeconds * 3600.0);
            if (this.getPeakKwInterval().getOrdinal() == 0) {
                this.checkPeakKw(this.getKw15().getValue());
            }
        } else {
            this.getKw15().setValue(0.0);
        }
        this.lastTicks15 = Clock.ticks();
        this.lastPulseCount15 = this.getCurrentPulseCount().getValue();
    }

    private final void calculateKw30() {
        this.elapsedSeconds = this.calculateDiffTime(this.lastTicks30);
        this.intervalKwh = this.calculateKwh(this.lastPulseCount30, this.elapsedSeconds);
        this.getKwh30().setValue(this.intervalKwh);
        if (this.validFreq) {
            this.getKw30().setValue(this.intervalKwh / (double)this.elapsedSeconds * 3600.0);
            if (this.getPeakKwInterval().getOrdinal() == 1) {
                this.checkPeakKw(this.getKw30().getValue());
            }
        } else {
            this.getKw30().setValue(0.0);
        }
        this.lastTicks30 = Clock.ticks();
        this.lastPulseCount30 = this.getCurrentPulseCount().getValue();
    }

    private final void checkPeakKw(double d) {
        BTime bTime = BTime.make((BRelTime)BRelTime.make((long)(Clock.time().getTimeOfDayMillis() + 6000L)));
        if (d > this.getMaxKw().getValue()) {
            this.getMaxKw().setValue(d);
            this.setMaxKwTimestamp(BAbsTime.make((BAbsTime)Clock.time(), (BTime)bTime));
        }
        if (this.getPeakMode().getValue()) {
            if (d > this.getMaxKwOnPeak().getValue()) {
                this.getMaxKwOnPeak().setValue(d);
                this.setMaxKwOnPeakTimestamp(BAbsTime.make((BAbsTime)Clock.time(), (BTime)bTime));
            }
        } else if (d > this.getMaxKwOffPeak().getValue()) {
            this.getMaxKwOffPeak().setValue(d);
            this.setMaxKwOffPeakTimestamp(BAbsTime.make((BAbsTime)Clock.time(), (BTime)bTime));
        }
    }

    private final double calculateKwh(double d, int n) {
        if (!this.getCurrentPulseCount().getStatus().isValid() || Double.isNaN(this.getCurrentPulseCount().getValue()) || this.getCurrentPulseCount().getValue() < 0.0) {
            this.setStatus(BStatus.fault);
            this.setLastFaultCause("Current pulse counts are not valid.");
            this.setLastFaultTime(Clock.time());
            return 0.0;
        }
        this.currentCount = this.getCurrentPulseCount().getValue();
        this.pulseCountDiff = this.currentCount >= d ? this.currentCount - d : (double)this.getMeterRollover() - d + 1.0 + this.currentCount;
        if (this.pulseCountDiff < 0.0) {
            this.setStatus(BStatus.fault);
            this.setLastFaultCause("Calculated a negative number of pulses. Consumption value not calculated.");
            this.setLastFaultTime(Clock.time());
            return 0.0;
        }
        int n2 = (int)this.getMaxPulseFrequency();
        double d2 = this.pulseCountDiff / (double)n;
        this.validFreq = false;
        if (d2 != Double.NaN && d2 != Double.POSITIVE_INFINITY && d2 != Double.NEGATIVE_INFINITY && d2 <= (double)n2) {
            this.validFreq = true;
        }
        if (this.checkFreq) {
            if (this.validFreq) {
                this.setActualPulseFrequency(d2);
            } else {
                this.setActualPulseFrequency(0.0);
            }
            this.checkFreq = false;
        }
        if (this.getCheckFrequency() && !this.validFreq) {
            this.setStatus(BStatus.fault);
            this.setLastFaultCause("Pulse frequency is " + d2 + " which exceeds maxPulseFrequency of " + n2 + ". Demand value not calculated.");
            this.setLastFaultTime(Clock.time());
            return 0.0;
        }
        this.kwhNew = this.pulseCountDiff * this.getKwhPerPulse();
        this.setStatus(BStatus.ok);
        return this.kwhNew;
    }

    private final void calculateTotalKwh() {
        this.elapsedSeconds = this.calculateDiffTime(this.lastTicks);
        this.intervalKwh = this.calculateKwh(this.lastPulseCount, this.elapsedSeconds);
        this.lastPulseCount = this.currentCount;
        this.lastTicks = Clock.ticks();
        this.getKwhTotal().setValue(this.getKwhTotal().getValue() + this.intervalKwh);
        this.getMonthlyKwh().setValue(this.getMonthlyKwh().getValue() + this.intervalKwh);
        if (this.getPeakMode().getValue()) {
            this.getKwhOnPeakTotal().setValue(this.getKwhOnPeakTotal().getValue() + this.intervalKwh);
            this.getMonthlyKwhOnPeak().setValue(this.getMonthlyKwhOnPeak().getValue() + this.intervalKwh);
        } else {
            this.getKwhOffPeakTotal().setValue(this.getKwhOffPeakTotal().getValue() + this.intervalKwh);
            this.getMonthlyKwhOffPeak().setValue(this.getMonthlyKwhOffPeak().getValue() + this.intervalKwh);
        }
    }

    public void doPresetKwh(BConsumptionProperties bConsumptionProperties) {
        this.getKwhTotal().setValue(bConsumptionProperties.getKwhTotal());
        this.getKwhOffPeakTotal().setValue(bConsumptionProperties.getKwhOffPeakTotal());
        this.getKwhOnPeakTotal().setValue(bConsumptionProperties.getKwhOnPeakTotal());
        this.getMonthlyKwh().setValue(bConsumptionProperties.getMonthlyKwh());
        this.getMonthlyKwhOffPeak().setValue(bConsumptionProperties.getMonthlyKwhOffPeak());
        this.getMonthlyKwhOnPeak().setValue(bConsumptionProperties.getMonthlyKwhOnPeak());
    }

    public void doPresetKw(BDemandProperties bDemandProperties) {
        this.getMaxKw().setValue(bDemandProperties.getMaxKw());
        this.setMaxKwTimestamp(bDemandProperties.getMaxKwTimestamp());
        this.getMaxKwOffPeak().setValue(bDemandProperties.getMaxKwOffPeak());
        this.setMaxKwOffPeakTimestamp(bDemandProperties.getMaxKwOffPeakTimestamp());
        this.getMaxKwOnPeak().setValue(bDemandProperties.getMaxKwOnPeak());
        this.setMaxKwOnPeakTimestamp(bDemandProperties.getMaxKwOnPeakTimestamp());
    }

    public BValue getActionParameterDefault(Action action) {
        if (action == presetKwh) {
            return new BConsumptionProperties();
        }
        if (action == presetKw) {
            return new BDemandProperties();
        }
        return super.getActionParameterDefault(action);
    }

    public void doMonthlyReset() {
        this.getMonthlyKwh().setValue(0.0);
        this.getMonthlyKwhOffPeak().setValue(0.0);
        this.getMonthlyKwhOnPeak().setValue(0.0);
        this.getMaxKw().setValue(0.0);
        this.setMaxKwTimestamp(BAbsTime.NULL);
        this.getMaxKwOffPeak().setValue(0.0);
        this.setMaxKwOffPeakTimestamp(BAbsTime.NULL);
        this.getMaxKwOnPeak().setValue(0.0);
        this.setMaxKwOnPeakTimestamp(BAbsTime.NULL);
    }

    public void doReset() {
        this.getMonthlyKwh().setValue(0.0);
        this.getMonthlyKwhOffPeak().setValue(0.0);
        this.getMonthlyKwhOnPeak().setValue(0.0);
        this.getKwhTotal().setValue(0.0);
        this.getKwhOffPeakTotal().setValue(0.0);
        this.getKwhOnPeakTotal().setValue(0.0);
        this.setActualPulseFrequency(0.0);
        this.getKwh5().setValue(0.0);
        this.getKwh15().setValue(0.0);
        this.getKwh30().setValue(0.0);
        this.getMaxKw().setValue(0.0);
        this.setMaxKwTimestamp(BAbsTime.NULL);
        this.getMaxKwOffPeak().setValue(0.0);
        this.setMaxKwOffPeakTimestamp(BAbsTime.NULL);
        this.getMaxKwOnPeak().setValue(0.0);
        this.setMaxKwOnPeakTimestamp(BAbsTime.NULL);
        this.getKw5().setValue(0.0);
        this.getKw15().setValue(0.0);
        this.getKw30().setValue(0.0);
        this.lastPulseCount5 = this.getCurrentPulseCount().getValue();
        this.lastPulseCount15 = this.getCurrentPulseCount().getValue();
        this.lastPulseCount30 = this.getCurrentPulseCount().getValue();
        this.lastTicks = Clock.ticks();
        this.lastTicks5 = Clock.ticks();
        this.lastTicks15 = Clock.ticks();
        this.lastTicks30 = Clock.ticks();
    }

    public void doTimerExpired5() {
        int n = Clock.time().getMinute();
        switch (n) {
            case 4: 
            case 9: 
            case 19: 
            case 24: 
            case 34: 
            case 39: 
            case 49: 
            case 54: {
                this.calculateKw5();
                break;
            }
            case 14: 
            case 44: {
                this.calculateKw15();
                this.calculateKw5();
                break;
            }
            case 29: 
            case 59: {
                this.calculateKw30();
                this.calculateKw15();
                this.calculateKw5();
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ticket5 = null;
        this.elapsedSeconds = 0;
        this.lastTicks = 0L;
        this.lastTicks5 = 0L;
        this.lastTicks15 = 0L;
        this.lastTicks30 = 0L;
        this.checkFreq = false;
        this.validFreq = false;
    }

    public BBlockDemandCalc() {
        this.this();
    }

    static {
        Class clazz = class$com$vykon$vykonPro$energy$BBlockDemandCalc;
        if (clazz == null) {
            clazz = class$com$vykon$vykonPro$energy$BBlockDemandCalc = BBlockDemandCalc.class("[Lcom.vykon.vykonPro.energy.BBlockDemandCalc;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

