/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.net;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BInternetAddress
extends BSimple {
    public static final BInternetAddress NULL;
    public static final BInternetAddress DEFAULT;
    public static final Type TYPE;
    private String authority;
    private String host;
    private int port;
    static /* synthetic */ Class class$javax$baja$net$BInternetAddress;

    public final String getAuthority() {
        return this.authority;
    }

    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public final InetAddress getAddress() throws UnknownHostException {
        return InetAddress.getByName(this.host);
    }

    public final URL getURL(String string, String string2) {
        try {
            return new URL(string, this.host, this.port, string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException.toString());
        }
    }

    public final boolean equivalent(InetAddress inetAddress, int n) {
        if (this.port != n) {
            return false;
        }
        if (this.host.equalsIgnoreCase(inetAddress.getHostName())) {
            return true;
        }
        try {
            return inetAddress.equals(this.getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public final boolean equivalent(BInternetAddress bInternetAddress) {
        if (this.port != bInternetAddress.port) {
            return false;
        }
        if (this.host.equalsIgnoreCase(bInternetAddress.host)) {
            return true;
        }
        try {
            return this.equivalent(bInternetAddress.getAddress(), bInternetAddress.port);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this.host == null) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        return this.authority.hashCode();
    }

    public final boolean equals(Object object) {
        if (object instanceof BInternetAddress) {
            BInternetAddress bInternetAddress = (BInternetAddress)((Object)object);
            if (this.host == null) {
                boolean bl = false;
                if (bInternetAddress.host == null) {
                    bl = true;
                }
                return bl;
            }
            if (bInternetAddress.host == null) {
                return false;
            }
            if (this.port != bInternetAddress.port) {
                return false;
            }
            return this.host.equals(bInternetAddress.host);
        }
        return false;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final String encodeToString() {
        return this.authority;
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            return new BInternetAddress(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.getMessage());
        }
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BInternetAddress(String string, int n) {
        if (string.indexOf(58) != -1 && !string.startsWith("[") && !string.endsWith("]")) {
            string = "[" + string + ']';
        }
        this.host = TextUtil.toLowerCase((String)string);
        this.port = n;
        this.authority = n == -1 ? string : string + ':' + n;
    }

    public BInternetAddress(String string) {
        try {
            this.authority = string;
            if (string.equals("null")) {
                this.host = null;
                this.port = -1;
            } else {
                int n = string.lastIndexOf(58);
                int n2 = string.indexOf(58);
                if (n2 < 0) {
                    this.host = TextUtil.toLowerCase((String)string);
                    this.port = -1;
                } else if (n2 != n) {
                    int n3 = string.indexOf(91);
                    int n4 = string.lastIndexOf(93);
                    if (n3 < 0 || n4 < 0) {
                        throw new IllegalArgumentException("Can't determine host from port for " + string + ", IPv6 Numeric Hosts need to be wrapped by '[' ']' ");
                    }
                    this.host = TextUtil.toLowerCase((String)string.substring(0, n4 + 1));
                    if (n > n4) {
                        this.port = Integer.parseInt(string.substring(n + 1));
                    } else {
                        if (n4 < string.length() - 1) {
                            throw new IllegalArgumentException("Can't determine host from port for " + string + ", IPv6 Numeric Hosts need ':' after ']' to specify port");
                        }
                        this.port = -1;
                    }
                } else {
                    this.host = TextUtil.toLowerCase((String)string.substring(0, n2));
                    this.port = Integer.parseInt(string.substring(n2 + 1));
                }
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid BInternetAddress: " + string);
        }
    }

    static {
        DEFAULT = NULL = new BInternetAddress("null");
        Class clazz = class$javax$baja$net$BInternetAddress;
        if (clazz == null) {
            clazz = class$javax$baja$net$BInternetAddress = BInternetAddress.class("[Ljavax.baja.net.BInternetAddress;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

