/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.net;

import com.tridium.net.BProxyAuthenticationType;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.InvalidParameterException;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.Base64;
import javax.baja.nre.util.IFilter;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHttpProxyService
extends BAbstractService {
    public static final Property enabled = BHttpProxyService.newProperty((int)0, (boolean)false, null);
    public static final Property server = BHttpProxyService.newProperty((int)0, (String)"", null);
    public static final Property port = BHttpProxyService.newProperty((int)0, (int)0, null);
    public static final Property exclusions = BHttpProxyService.newProperty((int)0, (String)"10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16", null);
    public static final Property authenticationScheme = BHttpProxyService.newProperty((int)0, (BValue)BProxyAuthenticationType.none, null);
    public static final Property user = BHttpProxyService.newProperty((int)0, (String)"", null);
    public static final Property password = BHttpProxyService.newProperty((int)0, (BValue)BPassword.make((String)""), null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static final Log log;
    private IFilter[] exclusionList;
    static /* synthetic */ Class class$javax$baja$net$BHttpProxyService;
    static /* synthetic */ Class class$javax$baja$nre$util$IFilter;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public String getServer() {
        return this.getString(server);
    }

    public void setServer(String string) {
        this.setString(server, string, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int n) {
        this.setInt(port, n, null);
    }

    public String getExclusions() {
        return this.getString(exclusions);
    }

    public void setExclusions(String string) {
        this.setString(exclusions, string, null);
    }

    public BProxyAuthenticationType getAuthenticationScheme() {
        return (BProxyAuthenticationType)this.get(authenticationScheme);
    }

    public void setAuthenticationScheme(BProxyAuthenticationType bProxyAuthenticationType) {
        this.set(authenticationScheme, (BValue)bProxyAuthenticationType, null);
    }

    public String getUser() {
        return this.getString(user);
    }

    public void setUser(String string) {
        this.setString(user, string, null);
    }

    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    public void setPassword(BPassword bPassword) {
        this.set(password, (BValue)bPassword, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public static BHttpProxyService get(BHost bHost) {
        BComponent[] bComponentArray;
        if (bHost == null || !(bHost instanceof BIpHost)) {
            return null;
        }
        try {
            bComponentArray = Sys.getServices((Type)TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return null;
        }
        int n = 0;
        while (n < bComponentArray.length) {
            BHttpProxyService bHttpProxyService = (BHttpProxyService)bComponentArray[n];
            if (bHttpProxyService.getEnabled((BIpHost)bHost)) {
                if (log.isTraceOn()) {
                    log.trace("Connecting to " + bHost.toString(null) + " through proxy " + bHttpProxyService.getServer());
                }
                return bHttpProxyService;
            }
            ++n;
        }
        return null;
    }

    private final boolean getEnabled(BIpHost bIpHost) {
        if (!this.getEnabled()) {
            return false;
        }
        if (this.exclusionList == null) {
            this.loadExclusionList();
        }
        int n = 0;
        while (n < this.exclusionList.length) {
            if (this.exclusionList[n].accept((Object)bIpHost)) {
                if (log.isTraceOn()) {
                    log.trace("Host " + bIpHost.toString(null) + " matches exclusion '" + this.exclusionList[n].toString() + "' for proxy " + this.getServer());
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    public Socket openSocket() throws IOException {
        try {
            return new BIpHost(this.getServer()).openSocket(this.getPort());
        }
        catch (ConnectException connectException) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("Unable to connect to proxy server.");
            log.error("Unable to connect to proxy server at " + this.getServer(), (Throwable)connectException);
            throw connectException;
        }
        catch (UnknownHostException unknownHostException) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("Unknown host: " + unknownHostException.getMessage());
            log.error("Unable to resolve proxy server " + this.getServer(), (Throwable)unknownHostException);
            throw unknownHostException;
        }
        catch (IOException iOException) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause(iOException.getMessage());
            log.error("Unable to connect to proxy server.", (Throwable)iOException);
            throw iOException;
        }
    }

    public Socket openSocket(int n) throws IOException {
        try {
            return new BIpHost(this.getServer()).openSocket(this.getPort(), n);
        }
        catch (ConnectException connectException) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("Unable to connect to proxy server.");
            log.error("Unable to connect to proxy server at " + this.getServer(), (Throwable)connectException);
            throw connectException;
        }
        catch (UnknownHostException unknownHostException) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("Unknown host: " + unknownHostException.getMessage());
            log.error("Unable to resolve proxy server " + this.getServer(), (Throwable)unknownHostException);
            throw unknownHostException;
        }
        catch (IOException iOException) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause(iOException.getMessage());
            log.error("Unable to connect to proxy server.", (Throwable)iOException);
            throw iOException;
        }
    }

    public String getAuthentication() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.getAuthenticationScheme().getOrdinal()) {
            case 1: {
                stringBuffer.append("Basic ");
                stringBuffer.append(new String(Base64.encode((String)(this.getUser() + ':' + this.getPassword().getValue()))));
                return stringBuffer.toString();
            }
        }
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }

    public void started() throws Exception {
        this.loadExclusionList();
        super.started();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)exclusions)) {
            this.loadExclusionList();
        }
    }

    private final void loadExclusionList() {
        Class clazz = class$javax$baja$nre$util$IFilter;
        if (clazz == null) {
            clazz = class$javax$baja$nre$util$IFilter = BHttpProxyService.class("[Ljavax.baja.nre.util.IFilter;", false);
        }
        Array array = new Array(clazz);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        while (n < this.getExclusions().length()) {
            char c = this.getExclusions().charAt(n);
            if (c != ' ' && c != ',' && c != ';') {
                stringBuffer.append(c);
                if (!(bl || c == '.' || c == '/' || c == '\\' || c >= '0' && c <= '9')) {
                    bl = true;
                }
            }
            if ((c == ' ' || c == ',' || c == ';' || n == this.getExclusions().length() - 1) && stringBuffer.length() > 1) {
                if (bl) {
                    try {
                        array.add((Object)new HostNameFilter(stringBuffer.toString()));
                    }
                    catch (InvalidParameterException invalidParameterException) {
                        this.setFaultCause(invalidParameterException.getMessage());
                        this.setStatus(BStatus.fault);
                        log.error("Invalid exclusion", (Throwable)invalidParameterException);
                    }
                } else {
                    try {
                        array.add((Object)new Ip4Filter(stringBuffer.toString()));
                    }
                    catch (InvalidParameterException invalidParameterException) {
                        this.setFaultCause(invalidParameterException.getMessage());
                        this.setStatus(BStatus.fault);
                        log.error("Invalid exclusion", (Throwable)invalidParameterException);
                    }
                }
                stringBuffer = new StringBuffer();
                bl = false;
            }
            ++n;
        }
        array.add((Object)new HostNameFilter("localhost"));
        array.add((Object)new Ip4Filter("127.0.0.1/8"));
        this.exclusionList = (IFilter[])array.trim();
    }

    public static void main(String[] stringArray) throws Exception {
        Object object = new HostNameFilter("cnn.com");
        BHttpProxyService.verify(object.accept(new BIpHost("www.cnn.com")), false);
        BHttpProxyService.verify(object.accept(new BIpHost("ccnn.com")), false);
        BHttpProxyService.verify(object.accept(new BIpHost("cnn.com")), true);
        BHttpProxyService.verify(object.accept(new BIpHost("nn.com")), false);
        HostNameFilter hostNameFilter = new HostNameFilter(".cnn.com");
        BHttpProxyService.verify(hostNameFilter.accept(new BIpHost("www.ccnn.com")), false);
        BHttpProxyService.verify(hostNameFilter.accept(new BIpHost("www.cnn.com")), true);
        BHttpProxyService.verify(hostNameFilter.accept(new BIpHost("ccnn.com")), false);
        BHttpProxyService.verify(hostNameFilter.accept(new BIpHost("cnn.com")), true);
        BHttpProxyService.verify(hostNameFilter.accept(new BIpHost("xnn.com")), false);
        BHttpProxyService.verify(hostNameFilter.accept(new BIpHost("nn.com")), false);
        BHttpProxyService.verify(hostNameFilter.accept(new BIpHost("64.236.24.12")), true);
        object = new Ip4Filter("111.222.333.123");
        BHttpProxyService.verify(object.accept(new BIpHost("111.222.333.124")), false);
        BHttpProxyService.verify(object.accept(new BIpHost("111.222.333.123")), true);
        BHttpProxyService.verify(object.accept(new BIpHost("111.222.333.122")), false);
        BHttpProxyService.verify(object.accept(new BIpHost("111.222.333.0")), false);
        int n = 1;
        while (n < 32) {
            Ip4Filter ip4Filter = new Ip4Filter("192.168.1.1/" + n);
            try {
                BHttpProxyService.verify(ip4Filter.accept(new BIpHost("192.168.1.1")), true);
                boolean bl = ip4Filter.accept(new BIpHost("192.168.1.0"));
                boolean bl2 = false;
                if (n <= 31) {
                    bl2 = true;
                }
                BHttpProxyService.verify(bl, bl2);
                boolean bl3 = ip4Filter.accept(new BIpHost("192.168.1.2"));
                boolean bl4 = false;
                if (n <= 30) {
                    bl4 = true;
                }
                BHttpProxyService.verify(bl3, bl4);
                boolean bl5 = ip4Filter.accept(new BIpHost("192.168.1.7"));
                boolean bl6 = false;
                if (n <= 29) {
                    bl6 = true;
                }
                BHttpProxyService.verify(bl5, bl6);
                boolean bl7 = ip4Filter.accept(new BIpHost("192.168.1.15"));
                boolean bl8 = false;
                if (n <= 28) {
                    bl8 = true;
                }
                BHttpProxyService.verify(bl7, bl8);
                boolean bl9 = ip4Filter.accept(new BIpHost("192.168.1.31"));
                boolean bl10 = false;
                if (n <= 27) {
                    bl10 = true;
                }
                BHttpProxyService.verify(bl9, bl10);
                boolean bl11 = ip4Filter.accept(new BIpHost("192.168.1.63"));
                boolean bl12 = false;
                if (n <= 26) {
                    bl12 = true;
                }
                BHttpProxyService.verify(bl11, bl12);
                boolean bl13 = ip4Filter.accept(new BIpHost("192.168.1.127"));
                boolean bl14 = false;
                if (n <= 25) {
                    bl14 = true;
                }
                BHttpProxyService.verify(bl13, bl14);
                boolean bl15 = ip4Filter.accept(new BIpHost("192.168.1.255"));
                boolean bl16 = false;
                if (n <= 24) {
                    bl16 = true;
                }
                BHttpProxyService.verify(bl15, bl16);
                boolean bl17 = ip4Filter.accept(new BIpHost("192.168.0.0"));
                boolean bl18 = false;
                if (n <= 23) {
                    bl18 = true;
                }
                BHttpProxyService.verify(bl17, bl18);
                boolean bl19 = ip4Filter.accept(new BIpHost("192.168.3.255"));
                boolean bl20 = false;
                if (n <= 22) {
                    bl20 = true;
                }
                BHttpProxyService.verify(bl19, bl20);
                boolean bl21 = ip4Filter.accept(new BIpHost("192.168.7.255"));
                boolean bl22 = false;
                if (n <= 21) {
                    bl22 = true;
                }
                BHttpProxyService.verify(bl21, bl22);
                boolean bl23 = ip4Filter.accept(new BIpHost("192.168.15.255"));
                boolean bl24 = false;
                if (n <= 20) {
                    bl24 = true;
                }
                BHttpProxyService.verify(bl23, bl24);
                boolean bl25 = ip4Filter.accept(new BIpHost("192.168.31.255"));
                boolean bl26 = false;
                if (n <= 19) {
                    bl26 = true;
                }
                BHttpProxyService.verify(bl25, bl26);
                boolean bl27 = ip4Filter.accept(new BIpHost("192.168.63.255"));
                boolean bl28 = false;
                if (n <= 18) {
                    bl28 = true;
                }
                BHttpProxyService.verify(bl27, bl28);
                boolean bl29 = ip4Filter.accept(new BIpHost("192.168.127.255"));
                boolean bl30 = false;
                if (n <= 17) {
                    bl30 = true;
                }
                BHttpProxyService.verify(bl29, bl30);
                boolean bl31 = ip4Filter.accept(new BIpHost("192.168.255.255"));
                boolean bl32 = false;
                if (n <= 16) {
                    bl32 = true;
                }
                BHttpProxyService.verify(bl31, bl32);
                boolean bl33 = ip4Filter.accept(new BIpHost("192.169.255.255"));
                boolean bl34 = false;
                if (n <= 15) {
                    bl34 = true;
                }
                BHttpProxyService.verify(bl33, bl34);
                boolean bl35 = ip4Filter.accept(new BIpHost("192.171.255.255"));
                boolean bl36 = false;
                if (n <= 14) {
                    bl36 = true;
                }
                BHttpProxyService.verify(bl35, bl36);
                boolean bl37 = ip4Filter.accept(new BIpHost("192.175.255.255"));
                boolean bl38 = false;
                if (n <= 13) {
                    bl38 = true;
                }
                BHttpProxyService.verify(bl37, bl38);
                boolean bl39 = ip4Filter.accept(new BIpHost("192.160.0.0"));
                boolean bl40 = false;
                if (n <= 12) {
                    bl40 = true;
                }
                BHttpProxyService.verify(bl39, bl40);
                boolean bl41 = ip4Filter.accept(new BIpHost("192.191.255.255"));
                boolean bl42 = false;
                if (n <= 11) {
                    bl42 = true;
                }
                BHttpProxyService.verify(bl41, bl42);
                boolean bl43 = ip4Filter.accept(new BIpHost("192.128.0.0"));
                boolean bl44 = false;
                if (n <= 10) {
                    bl44 = true;
                }
                BHttpProxyService.verify(bl43, bl44);
                boolean bl45 = ip4Filter.accept(new BIpHost("192.255.255.255"));
                boolean bl46 = false;
                if (n <= 9) {
                    bl46 = true;
                }
                BHttpProxyService.verify(bl45, bl46);
                boolean bl47 = ip4Filter.accept(new BIpHost("192.0.0.0"));
                boolean bl48 = false;
                if (n <= 8) {
                    bl48 = true;
                }
                BHttpProxyService.verify(bl47, bl48);
                boolean bl49 = ip4Filter.accept(new BIpHost("193.255.255.255"));
                boolean bl50 = false;
                if (n <= 7) {
                    bl50 = true;
                }
                BHttpProxyService.verify(bl49, bl50);
                boolean bl51 = ip4Filter.accept(new BIpHost("195.255.255.255"));
                boolean bl52 = false;
                if (n <= 6) {
                    bl52 = true;
                }
                BHttpProxyService.verify(bl51, bl52);
                boolean bl53 = ip4Filter.accept(new BIpHost("199.255.255.255"));
                boolean bl54 = false;
                if (n <= 5) {
                    bl54 = true;
                }
                BHttpProxyService.verify(bl53, bl54);
                boolean bl55 = ip4Filter.accept(new BIpHost("207.255.255.255"));
                boolean bl56 = false;
                if (n <= 4) {
                    bl56 = true;
                }
                BHttpProxyService.verify(bl55, bl56);
                boolean bl57 = ip4Filter.accept(new BIpHost("223.255.255.255"));
                boolean bl58 = false;
                if (n <= 3) {
                    bl58 = true;
                }
                BHttpProxyService.verify(bl57, bl58);
                boolean bl59 = ip4Filter.accept(new BIpHost("255.255.255.255"));
                boolean bl60 = false;
                if (n <= 2) {
                    bl60 = true;
                }
                BHttpProxyService.verify(bl59, bl60);
                boolean bl61 = ip4Filter.accept(new BIpHost("128.0.0.0"));
                boolean bl62 = false;
                if (n <= 1) {
                    bl62 = true;
                }
                BHttpProxyService.verify(bl61, bl62);
            }
            catch (Exception exception) {
                throw new Exception("Subnet mask /" + n + " failed.", exception);
            }
            ++n;
        }
    }

    private static final void verify(boolean bl, boolean bl2) {
        if (bl != bl2) {
            throw new TestException("Failed verify, expected " + bl2);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$net$BHttpProxyService;
        if (clazz == null) {
            clazz = class$javax$baja$net$BHttpProxyService = BHttpProxyService.class("[Ljavax.baja.net.BHttpProxyService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://net/icons/proxy.png");
        log = Log.getLog((String)"http.proxy");
    }

    private static class HostNameFilter
    implements IFilter {
        String filter;

        public boolean accept(Object object) {
            BIpHost bIpHost = (BIpHost)object;
            if (bIpHost.isNumericAddress()) {
                try {
                    InetAddress inetAddress = bIpHost.getInetAddress();
                    bIpHost = new BIpHost(inetAddress.getHostName());
                }
                catch (Exception exception) {
                    log.error("Error resolving " + bIpHost.toString(), (Throwable)exception);
                }
            }
            if (this.filter.charAt(0) == '.') {
                if (bIpHost.getHostname().endsWith(this.filter)) {
                    return true;
                }
                return bIpHost.getHostname().endsWith(this.filter.substring(1)) && bIpHost.getHostname().length() == this.filter.length() - 1;
            }
            return bIpHost.getHostname().equalsIgnoreCase(this.filter);
        }

        public String toString() {
            return this.filter;
        }

        public HostNameFilter(String string) {
            this.filter = string.toLowerCase();
        }
    }

    private static class Ip4Filter
    implements IFilter {
        byte[] filterAddr;
        int subnet;
        String ip;

        /*
         * Exception decompiling
         */
        public boolean accept(Object var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[WHILELOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public String toString() {
            return this.ip;
        }

        public Ip4Filter(String string) throws InvalidParameterException {
            this.ip = string;
            try {
                if (string.indexOf(47) > -1) {
                    this.filterAddr = InetAddress.getByName(string.substring(0, string.indexOf(47))).getAddress();
                    this.subnet = Integer.parseInt(string.substring(string.indexOf(47) + 1, string.length()));
                } else if (string.indexOf(92) > -1) {
                    this.filterAddr = InetAddress.getByName(string.substring(0, string.indexOf(92))).getAddress();
                    this.subnet = Integer.parseInt(string.substring(string.indexOf(92) + 1, string.length()));
                } else {
                    this.filterAddr = InetAddress.getByName(string).getAddress();
                    this.subnet = 32;
                }
                if (this.subnet > 32 || this.subnet < 1) {
                    throw new InvalidParameterException("Invalid number of bits in subnet: " + this.subnet);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidParameterException("Incorrect subnet format.");
            }
            catch (UnknownHostException unknownHostException) {
                throw new InvalidParameterException("Host could not be resolved.");
            }
        }
    }

    private static class TestException
    extends RuntimeException {
        public TestException(String string) {
            super(string);
        }
    }
}

