/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.net;

import com.tridium.net.ChunkedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HttpInputStream
extends InputStream {
    private InputStream in;
    private boolean finiteLength;
    private int maxBytes;
    private int bytesRead;

    public int read() throws IOException {
        if (this.finiteLength && this.bytesRead == this.maxBytes) {
            return -1;
        }
        int n = this.in.read();
        if (this.finiteLength) {
            ++this.bytesRead;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.finiteLength && this.bytesRead == this.maxBytes) {
            return -1;
        }
        int n3 = n2;
        if (this.finiteLength) {
            n3 = Math.min(this.maxBytes - this.bytesRead, n3);
        }
        int n4 = this.in.read(byArray, n, n3);
        if (this.finiteLength) {
            this.bytesRead += n4;
        }
        return n4;
    }

    public void close() {
        this.finiteLength = true;
        this.bytesRead = this.maxBytes;
    }

    public HttpInputStream(InputStream inputStream) {
        this(inputStream, false);
    }

    public HttpInputStream(InputStream inputStream, int n) {
        this.in = inputStream;
        this.maxBytes = n;
        boolean bl = false;
        if (n >= 0) {
            bl = true;
        }
        this.finiteLength = bl;
    }

    public HttpInputStream(InputStream inputStream, boolean bl) {
        this.finiteLength = false;
        this.in = bl ? new ChunkedInputStream(inputStream) : inputStream;
    }
}

