/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.net;

import com.tridium.net.HttpHeader;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private InputStream in;
    private byte[] chunk;
    private int chunkOffset;
    private HttpHeader entityHeaders;

    public int read() throws IOException {
        return this.chunkRead();
    }

    private final int consumeChunk(byte[] byArray, int n, int n2) {
        int n3 = this.chunk.length - this.chunkOffset;
        if (n3 >= n2) {
            System.arraycopy(this.chunk, this.chunkOffset, byArray, n, n2);
            if (n3 == n2) {
                this.chunk = null;
                this.chunkOffset = 0;
            } else {
                this.chunkOffset += n2;
            }
            return n2;
        }
        System.arraycopy(this.chunk, this.chunkOffset, byArray, n, n3);
        this.chunk = null;
        this.chunkOffset = 0;
        return n3;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 0) {
            if (this.chunk != null) {
                return this.consumeChunk(byArray, n, n2);
            }
            int n3 = this.chunkRead();
            if (n3 == -1) {
                return -1;
            }
            byArray[n] = (byte)n3;
            if (this.chunk == null || this.chunk.length == 1 || n2 == 1) {
                return 1;
            }
            return 1 + this.consumeChunk(byArray, n + 1, n2 - 1);
        }
        return 0;
    }

    protected int chunkRead() throws IOException {
        if (this.chunk == null) {
            StringBuffer stringBuffer = new StringBuffer(8);
            int n = this.in.read();
            while (n != -1 && n != 13 && n != 32) {
                stringBuffer.append((char)n);
                n = this.in.read();
            }
            while (n == 32) {
                n = this.in.read();
            }
            n = this.match(n, 13);
            this.check(n, 10);
            int n2 = Integer.parseInt(stringBuffer.toString(), 16);
            this.chunk = new byte[n2];
            this.chunkOffset = 0;
            if (n2 != 0) {
                int n3 = 0;
                int n4 = 0;
                do {
                    if ((n4 = this.in.read(this.chunk, n3, this.chunk.length - n3)) == -1) continue;
                    n3 += n4;
                } while (n4 != -1 && n3 < this.chunk.length);
                n = this.in.read();
                n = this.match(n, 13);
                this.check(n, 10);
            } else {
                this.readFooter();
            }
        }
        if (this.chunkOffset == this.chunk.length) {
            return -1;
        }
        int n = this.chunk[this.chunkOffset++] & 0xFF;
        if (this.chunk.length != 0 && this.chunkOffset == this.chunk.length) {
            this.chunk = null;
        }
        return n;
    }

    protected void readFooter() throws IOException {
        this.entityHeaders = new HttpHeader();
        this.entityHeaders.read(this.in);
    }

    protected int match(int n, int n2) throws IOException {
        if (n != n2) {
            throw new IOException("Expecting " + this.charToString(n2) + '.');
        }
        return this.in.read();
    }

    protected void check(int n, int n2) throws IOException {
        if (n != n2) {
            throw new IOException("Expecting " + this.charToString(n2) + '.');
        }
    }

    private final String charToString(int n) {
        if (n == 13) {
            return "\\n";
        }
        if (n == 10) {
            return "\\r";
        }
        return "" + (char)n;
    }

    public HttpHeader getEntityHeaders() {
        return this.entityHeaders;
    }

    public ChunkedInputStream(InputStream inputStream) {
        this.in = inputStream;
    }
}

