/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.timesync;

import com.tridium.platform.ntp.BNtpPlatformService;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Date;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.log.Log;
import javax.baja.security.AuditEvent;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.timesync.BTimeSyncClient;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTimeSyncService
extends BAbstractService
implements BIStatus {
    public static final Property serverEnabled = BTimeSyncService.newProperty((int)0, (boolean)false, null);
    public static final Property serverPort = BTimeSyncService.newProperty((int)0, (int)37, null);
    public static final Property clientSchedule = BTimeSyncService.newProperty((int)0, (BValue)new BTimeTrigger(), null);
    public static final Property clientMaxDelta = BTimeSyncService.newProperty((int)0, (BValue)BRelTime.make((long)0x6DDD00L), null);
    public static final Property clientMinDelta = BTimeSyncService.newProperty((int)0, (BValue)BRelTime.make((long)5000L), null);
    public static final Property lastSync = BTimeSyncService.newProperty((int)4, (BValue)BAbsTime.NULL, null);
    public static final Action forceSync = BTimeSyncService.newAction((int)16, null);
    public static final Action sync = BTimeSyncService.newAction((int)16, null);
    public static final Topic clockModified = BTimeSyncService.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static final long EPOCH_DELTA = 2208988800L;
    static final Log log;
    private boolean clientFault;
    private String clientFaultString;
    private boolean syncing;
    private Server server;
    private boolean serverFault;
    private String serverFaultString;
    static /* synthetic */ Class class$javax$baja$timesync$BTimeSyncService;
    static /* synthetic */ Class class$javax$baja$timesync$BTimeSyncClient;

    public boolean getServerEnabled() {
        return this.getBoolean(serverEnabled);
    }

    public void setServerEnabled(boolean bl) {
        this.setBoolean(serverEnabled, bl, null);
    }

    public int getServerPort() {
        return this.getInt(serverPort);
    }

    public void setServerPort(int n) {
        this.setInt(serverPort, n, null);
    }

    public BTimeTrigger getClientSchedule() {
        return (BTimeTrigger)this.get(clientSchedule);
    }

    public void setClientSchedule(BTimeTrigger bTimeTrigger) {
        this.set(clientSchedule, (BValue)bTimeTrigger, null);
    }

    public BRelTime getClientMaxDelta() {
        return (BRelTime)this.get(clientMaxDelta);
    }

    public void setClientMaxDelta(BRelTime bRelTime) {
        this.set(clientMaxDelta, (BValue)bRelTime, null);
    }

    public BRelTime getClientMinDelta() {
        return (BRelTime)this.get(clientMinDelta);
    }

    public void setClientMinDelta(BRelTime bRelTime) {
        this.set(clientMinDelta, (BValue)bRelTime, null);
    }

    public BAbsTime getLastSync() {
        return (BAbsTime)this.get(lastSync);
    }

    public void setLastSync(BAbsTime bAbsTime) {
        this.set(lastSync, (BValue)bAbsTime, null);
    }

    public void forceSync() {
        this.invoke(forceSync, null, null);
    }

    public void sync() {
        this.invoke(sync, null, null);
    }

    public void fireClockModified(BValue bValue) {
        this.fire(clockModified, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doForceSync() {
        this.sync(true);
    }

    public void doSync() {
        this.sync(false);
    }

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (context != Context.decoding) {
            if (property == enabled) {
                boolean bl = this.getEnabled() ^ true;
                BTimeSyncClient[] bTimeSyncClientArray = this.clients();
                int n = bTimeSyncClientArray.length;
                while (--n >= 0) {
                    bTimeSyncClientArray[n].serviceDisabled(bl);
                }
            }
            if (property == serverEnabled || property == serverPort || property == enabled) {
                this.restartServer();
            }
        }
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        BTimeTrigger bTimeTrigger = this.getClientSchedule();
        this.linkTo("clientScheduleLink", (BComponent)bTimeTrigger, (Slot)BTimeTrigger.fireTrigger, (Slot)sync);
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
        this.stopServer();
    }

    public void enabled() {
        this.restartServer();
    }

    public void disabled() {
        this.restartServer();
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        Invocation invocation = new Invocation((BComponent)this, action, bValue, context);
        Thread thread = new Thread((Runnable)invocation);
        thread.start();
        return null;
    }

    public void restartServer() {
        this.stopServer();
        this.startServer();
    }

    public void started() throws Exception {
        super.started();
        this.startServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sync(boolean var1_1) {
        if (this.isDisabled()) {
            return;
        }
        try {
            block33: {
                var4_2 = this;
                synchronized (var4_2) {
                    if (!this.syncing) ** break block32
                }
                var3_3 = null;
                this.syncing = false;
                return;
                {
                    this.syncing = true;
                }
                var6_9 = (BTimeSyncClient[])Sys.getService((Type)BNtpPlatformService.TYPE);
                var6_9.poll();
                if (!var6_9.getEnabled()) break block33;
                this.clientFault("NTP is in use, RFC 868 clients ignored");
                {
                    catch (ServiceNotFoundException v1) {}
                }
                var3_4 = null;
                this.syncing = false;
                return;
            }
            ** try [egrp 4[TRYBLOCK] [7 : 76->590)] { 
            {
lbl31:
                // 2 sources

                BTimeSyncService.log.trace("Beginning client sync");
                var6_9 = this.clients();
                var7_10 = var6_9.length;
                if (var7_10 == 0) {
                    this.clientFault("TimeSyncService has no clients");
                    var3_5 = null;
                    this.syncing = false;
                    return;
                }
                var8_11 = new BTimeSyncClient.Report[var7_10];
                var9_12 = 0L;
                var11_13 = 0;
                var12_14 = 0L;
                var14_15 = 0;
                var15_16 = this.getClientMaxDelta().getMillis();
                var17_17 = 0;
                while (var17_17 < var7_10) {
                    var8_11[var17_17] = this.executePoll(var6_9[var17_17]);
                    if (var8_11[var17_17] != null) {
                        if (Math.abs(var8_11[var17_17].delta) < var15_16) {
                            ++var14_15;
                            var12_14 += var8_11[var17_17].delta;
                        } else {
                            BTimeSyncService.log.trace(var6_9[var17_17].toPathString() + " exceeded maxClientDelta: " + var8_11[var17_17].delta / 1000L + 's');
                        }
                        var9_12 += var8_11[var17_17].delta;
                        ++var11_13;
                    }
                    ++var17_17;
                }
                if (var11_13 == 0) {
                    this.clientFault("No clients received a response");
                    var3_6 = null;
                    this.syncing = false;
                    return;
                }
                if (var14_15 > 0) {
                    if (var12_14 != 0L) {
                        var12_14 /= (long)var14_15;
                    }
                    this.clientOk();
                    if (Math.abs(var12_14) > this.getClientMinDelta().getMillis()) {
                        this.adjustTime(var12_14);
                    }
                } else if (var1_1) {
                    if (var9_12 != 0L) {
                        var9_12 /= (long)var11_13;
                    }
                    this.clientOk();
                    this.adjustTime(var9_12);
                } else {
                    block34: {
                        var17_17 = 0;
                        try {
                            var18_18 = Clock.time();
                            if (var6_9.length <= 0 || var6_9.length != var11_13 || !this.getLastSync().isAfter(var18_18) || !var18_18.isBefore(BAbsTime.make((int)2000, (BMonth)BMonth.january, (int)1))) break block34;
                            var19_19 = this.getClientMinDelta().getMillis();
                            var21_20 = var8_11.length;
                            block13: while (true) {
                                if (--var21_20 <= 0) {
                                    var17_17 = 1;
                                    break block34;
                                }
                                var22_21 = var21_20;
                                do {
                                    if (--var22_21 < 0) continue block13;
                                } while (Math.abs(var8_11[var21_20].delta - var8_11[var22_21].delta) <= var19_19);
                                break;
                            }
                            throw new Exception();
                        }
                        catch (Exception v2) {}
                    }
                    if (var17_17 != 0) {
                        if (var9_12 != 0L) {
                            var9_12 /= (long)var11_13;
                        }
                        this.clientOk();
                        this.adjustTime(var9_12);
                    } else {
                        this.clientFault("Sync delta (" + var9_12 / (long)var11_13 / 1000L + "s) exceeds clientMaxDelta");
                    }
                }
                this.setLastSync(Clock.time());
            }
        }
lbl103:
        // 3 sources

        catch (Throwable var2_22) {
            var3_7 = null;
            this.syncing = false;
            throw var2_22;
        }
        var3_8 = null;
        this.syncing = false;
    }

    private final void adjustTime(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l;
        Clock.setTime((BAbsTime)BAbsTime.make((long)l3));
        String string = new Date(l2).toString();
        String string2 = new Date(l3).toString();
        Sys.getAuditor().audit(new AuditEvent("Changed", this.toPathString(), "systemTime", string, string2, "admin"));
        log.warning("Timesync changed time from " + string + " to " + string2);
        this.fireClockModified(null);
    }

    private final void clientFault(String string) {
        if (!this.clientFault) {
            log.warning(string);
        } else if (string == null || this.clientFaultString == null) {
            log.warning(string);
        } else if (!string.equals(this.clientFaultString)) {
            log.warning(string);
        }
        this.clientFault = true;
        this.clientFaultString = string;
        this.updateServiceStatus();
    }

    private final void clientOk() {
        this.clientFault = false;
        this.clientFaultString = null;
        this.updateServiceStatus();
    }

    private final BTimeSyncClient[] clients() {
        Class clazz = class$javax$baja$timesync$BTimeSyncClient;
        if (clazz == null) {
            clazz = class$javax$baja$timesync$BTimeSyncClient = BTimeSyncService.class("[Ljavax.baja.timesync.BTimeSyncClient;", false);
        }
        return (BTimeSyncClient[])this.getChildren(clazz);
    }

    private final BTimeSyncClient.Report executePoll(BTimeSyncClient bTimeSyncClient) {
        try {
            return bTimeSyncClient.poll();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void startServer() {
        try {
            try {
                block8: {
                    block7: {
                        this.serverFault = false;
                        this.serverFaultString = null;
                        if (this.isDisabled() || this.isFatalFault() || !this.getServerEnabled()) break block7;
                        if (this.isRunning()) break block8;
                    }
                    Object var2_1 = null;
                    this.updateServiceStatus();
                    return;
                }
                this.server = new Server(this.getServerPort());
                this.server.start();
            }
            catch (Exception exception) {
                this.serverFault = true;
                this.serverFaultString = "Failed to start local server: " + exception.getMessage();
                log.error("Failed to start local Server on port " + this.getServerPort(), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.updateServiceStatus();
            throw throwable;
        }
        {
            Object var2_3 = null;
            this.updateServiceStatus();
            return;
        }
    }

    private final void stopServer() {
        if (this.server == null) {
            return;
        }
        this.server.kill();
        this.server = null;
    }

    private final void updateServiceStatus() {
        if (this.isFatalFault()) {
            return;
        }
        int n = 0;
        if (!this.getEnabled()) {
            n |= 1;
        }
        if (this.clientFault | this.serverFault) {
            n |= 2;
        }
        this.setStatus(BStatus.make((int)n));
        StringBuffer stringBuffer = new StringBuffer();
        if (this.clientFault) {
            stringBuffer.append(this.clientFaultString);
        }
        if (this.clientFault && this.serverFault) {
            stringBuffer.append("; ");
        }
        if (this.serverFault) {
            stringBuffer.append(this.serverFaultString);
        }
        this.setFaultCause(stringBuffer.toString());
    }

    static /* synthetic */ boolean access$0(BTimeSyncService bTimeSyncService) {
        return bTimeSyncService.serverFault;
    }

    static /* synthetic */ String access$2(BTimeSyncService bTimeSyncService) {
        return bTimeSyncService.serverFaultString;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.clientFault = false;
        this.syncing = false;
        this.serverFault = false;
    }

    public BTimeSyncService() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$timesync$BTimeSyncService;
        if (clazz == null) {
            clazz = class$javax$baja$timesync$BTimeSyncService = BTimeSyncService.class("[Ljavax.baja.timesync.BTimeSyncService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"clock.png");
        log = Log.getLog((String)"timesync");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Server
    extends Thread {
        private boolean alive;
        private DatagramSocket socket;

        public void kill() {
            this.alive = false;
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
        }

        public void run() {
            log.message("TimeSyncService server started on port " + this.socket.getLocalPort());
            this.alive = true;
            byte[] byArray = new byte[4];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            while (this.alive) {
                try {
                    this.socket.receive(datagramPacket);
                    long l = System.currentTimeMillis();
                    l = l / 1000L + 2208988800L;
                    byArray[0] = (byte)(l >>> 24 & 0xFFL);
                    byArray[1] = (byte)(l >>> 16 & 0xFFL);
                    byArray[2] = (byte)(l >>> 8 & 0xFFL);
                    byArray[3] = (byte)(l & 0xFFL);
                    datagramPacket.setData(byArray);
                    datagramPacket.setLength(4);
                    this.socket.send(datagramPacket);
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (Exception exception) {
                    if (!this.alive) continue;
                    this.alive = false;
                    BTimeSyncService.this.serverFault = true;
                    BTimeSyncService.this.serverFaultString = "Server - " + exception.toString();
                    BTimeSyncService.this.updateStatus();
                    log.error("TimeSyncService server", (Throwable)exception);
                }
            }
            log.message("TimeSyncService server stopped on port " + this.socket.getLocalPort());
        }

        private final /* synthetic */ void this() {
            this.alive = false;
        }

        public Server(int n) throws IOException {
            super("TimeSync Server");
            this.this();
            this.socket = new DatagramSocket(n);
            this.socket.setSoTimeout(500);
        }
    }
}

