/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.timesync;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Date;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timesync.BTimeSyncService;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTimeSyncClient
extends BComponent
implements BIStatus {
    public static final Property serverName = BTimeSyncClient.newProperty((int)8, (String)"localhost", null);
    public static final Property serverPort = BTimeSyncClient.newProperty((int)0, (int)37, null);
    public static final Property retries = BTimeSyncClient.newProperty((int)0, (int)5, null);
    public static final Property timeout = BTimeSyncClient.newProperty((int)0, (int)250, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property status = BTimeSyncClient.newProperty((int)11, (BValue)BStatus.ok, null);
    public static final Property faultCause = BTimeSyncClient.newProperty((int)11, (String)"", null);
    public static final Property pollDelta = BTimeSyncClient.newProperty((int)11, (BValue)BRelTime.DEFAULT, null);
    public static final Property pollLocalTime = BTimeSyncClient.newProperty((int)11, (BValue)BAbsTime.NULL, null);
    public static final Property pollServerTime = BTimeSyncClient.newProperty((int)11, (BValue)BAbsTime.NULL, null);
    public static final Property pollRoundtrip = BTimeSyncClient.newProperty((int)11, (BValue)BRelTime.DEFAULT, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static Log log;
    static /* synthetic */ Class class$javax$baja$timesync$BTimeSyncClient;

    public String getServerName() {
        return this.getString(serverName);
    }

    public void setServerName(String string) {
        this.setString(serverName, string, null);
    }

    public int getServerPort() {
        return this.getInt(serverPort);
    }

    public void setServerPort(int n) {
        this.setInt(serverPort, n, null);
    }

    public int getRetries() {
        return this.getInt(retries);
    }

    public void setRetries(int n) {
        this.setInt(retries, n, null);
    }

    public int getTimeout() {
        return this.getInt(timeout);
    }

    public void setTimeout(int n) {
        this.setInt(timeout, n, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BRelTime getPollDelta() {
        return (BRelTime)this.get(pollDelta);
    }

    public void setPollDelta(BRelTime bRelTime) {
        this.set(pollDelta, (BValue)bRelTime, null);
    }

    public BAbsTime getPollLocalTime() {
        return (BAbsTime)this.get(pollLocalTime);
    }

    public void setPollLocalTime(BAbsTime bAbsTime) {
        this.set(pollLocalTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getPollServerTime() {
        return (BAbsTime)this.get(pollServerTime);
    }

    public void setPollServerTime(BAbsTime bAbsTime) {
        this.set(pollServerTime, (BValue)bAbsTime, null);
    }

    public BRelTime getPollRoundtrip() {
        return (BRelTime)this.get(pollRoundtrip);
    }

    public void setPollRoundtrip(BRelTime bRelTime) {
        this.set(pollRoundtrip, (BValue)bRelTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BTimeSyncService;
    }

    public Report poll() throws IOException {
        BStatus bStatus = this.getStatus();
        try {
            byte[] byArray = new byte[1];
            InetAddress inetAddress = InetAddress.getByName(this.getServerName());
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, this.getServerPort());
            DatagramSocket datagramSocket = new DatagramSocket();
            datagramSocket.setSoTimeout(this.getTimeout());
            int n = this.getRetries();
            int n2 = 0;
            while (n2 < n) {
                try {
                    byte[] byArray2 = new byte[4];
                    DatagramPacket datagramPacket2 = new DatagramPacket(byArray2, byArray2.length);
                    long l = System.currentTimeMillis();
                    datagramSocket.send(datagramPacket);
                    datagramSocket.receive(datagramPacket2);
                    long l2 = System.currentTimeMillis();
                    int n3 = 0xFF & byArray2[0];
                    int n4 = 0xFF & byArray2[1];
                    int n5 = 0xFF & byArray2[2];
                    int n6 = 0xFF & byArray2[3];
                    long l3 = 0xFFFFFFFFL & (long)((n3 << 24) + (n4 << 16) + (n5 << 8) + n6);
                    l3 = (l3 - 2208988800L) * 1000L;
                    Report report = new Report();
                    report.roundTrip = l2 - l;
                    this.setPollRoundtrip(BRelTime.make((long)report.roundTrip));
                    report.oneWayTrip = report.roundTrip / (long)2;
                    report.serverTime = l3 + report.oneWayTrip;
                    BAbsTime bAbsTime = BAbsTime.make((long)report.serverTime);
                    this.setPollServerTime(bAbsTime);
                    report.myTime = l2;
                    this.setPollLocalTime(BAbsTime.make((long)l2));
                    report.delta = report.serverTime - report.myTime;
                    this.setPollDelta(BRelTime.make((long)report.delta));
                    this.setStatus(BStatus.makeFault((BStatus)bStatus, (boolean)false));
                    this.setFaultCause("");
                    return report;
                }
                catch (InterruptedIOException interruptedIOException) {
                    log.message(this.toPathString(), (Throwable)interruptedIOException);
                    ++n2;
                }
            }
            this.setStatus(BStatus.makeFault((BStatus)bStatus, (boolean)true));
            this.setFaultCause("No response from server.");
            datagramSocket.close();
            return null;
        }
        catch (IOException iOException) {
            log.error(this.toPathString(), (Throwable)iOException);
            this.setStatus(BStatus.makeFault((BStatus)bStatus, (boolean)true));
            this.setFaultCause(iOException.toString());
            throw iOException;
        }
    }

    protected void serviceDisabled(boolean bl) {
        BStatus bStatus = this.getStatus();
        if (bStatus.isDisabled() == bl) {
            return;
        }
        this.setStatus(BStatus.makeDisabled((BStatus)bStatus, (boolean)bl));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$timesync$BTimeSyncClient;
        if (clazz == null) {
            clazz = class$javax$baja$timesync$BTimeSyncClient = BTimeSyncClient.class("[Ljavax.baja.timesync.BTimeSyncClient;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"connection.png");
        log = BTimeSyncService.log;
    }

    public static class Report {
        public long roundTrip;
        public long oneWayTrip;
        public long myTime;
        public long serverTime;
        public long delta;

        public void dump() {
            System.out.println("TimeReport");
            System.out.println("  roundTrip:  " + this.roundTrip + "ms");
            System.out.println("  oneWayTrip: " + this.oneWayTrip + "ms");
            System.out.println("  myTime:     " + new Date(this.myTime));
            System.out.println("  serverTime: " + new Date(this.serverTime));
            System.out.println("  delta:      " + this.delta + "ms");
        }
    }
}

