/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.seriestransform.graph;

import com.tridium.history.BHistory;
import com.tridium.seriestransform.SeriesColumn;
import java.util.LinkedList;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.naming.SlotPath;
import javax.baja.seriestransform.exceptions.SchemaException;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BSeriesSchema
extends BComponent {
    public static final Type TYPE;
    public static final String PRIMARY_KEY = "primaryKeyField";
    private static final Lexicon lex;
    private static final String ERR_DUPLICATE_KEY = "fault.msg.schema.duplicatePrimaryKey";
    private static final String ERR_INVALID_SCHEMA_VALUE = "fault.msg.schema.invalidfieldvalue";
    private static final String ERR_INVALID_SCHEMA_SRC = "fault.msg.schema.invalidschemasrc";
    static /* synthetic */ Class class$javax$baja$seriestransform$graph$BSeriesSchema;

    public final Type getType() {
        return TYPE;
    }

    public final BTypeSpec getFieldType(String string) {
        BValue bValue;
        if (string != null && (bValue = this.get(string)) != null && bValue instanceof BTypeSpec) {
            return (BTypeSpec)bValue;
        }
        return null;
    }

    public final BFacets getFieldFacets(String string) {
        BFacets bFacets;
        if (string != null && this.getSlot(string) != null && (bFacets = this.getSlotFacets(this.getSlot(string))) != null) {
            return bFacets;
        }
        return null;
    }

    public final String[] getFieldNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        this.lease(1);
        Property[] propertyArray = this.getDynamicPropertiesArray();
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            String string = property.getName();
            linkedList.add(string);
            ++n;
        }
        return linkedList.toArray(new String[0]);
    }

    public final String getKeyField() {
        String[] stringArray = this.getFieldNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            BFacets bFacets = this.getFieldFacets(string);
            if (bFacets.get(PRIMARY_KEY) != null && bFacets.getb(PRIMARY_KEY, false)) {
                return string;
            }
            ++n;
        }
        return SeriesColumn.COL_TIMESTAMP;
    }

    public final void mergeFieldFacets(String string, BFacets bFacets) {
        if (string == null || bFacets == null) {
            return;
        }
        Slot slot = this.getSlot(string);
        if (slot != null) {
            BFacets bFacets2 = slot.getFacets();
            BFacets bFacets3 = BFacets.make((BFacets)bFacets2, (BFacets)bFacets);
            this.setFacets(slot, bFacets3);
        }
    }

    public final boolean addField(String string, BTypeSpec bTypeSpec, BFacets bFacets) {
        if (string != null && this.get(string) == null && bTypeSpec != null) {
            if (!SlotPath.isValidName((String)string)) {
                return false;
            }
            if (bFacets == null) {
                bFacets = BFacets.NULL;
            }
            Property property = this.add(string, (BValue)bTypeSpec, 0, bFacets, null);
            boolean bl = false;
            if (property != null) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final void removeField(String string) {
        if (string != null && this.get(string) != null) {
            this.remove(string);
        }
    }

    public final boolean hasField(String string) {
        boolean bl = false;
        if (string != null && this.get(string) != null) {
            bl = true;
        }
        return bl;
    }

    public final void loadSchema(BObject bObject) throws SchemaException {
        if (bObject != null) {
            this.removeAll();
            if (bObject instanceof BHistory) {
                this.processHistorySchema((BHistory)bObject);
            } else if (bObject instanceof BITable) {
                this.processTableSchema((BITable)bObject);
            } else {
                throw new SchemaException(lex.getText(ERR_INVALID_SCHEMA_SRC, new Object[]{bObject.toString()}));
            }
        }
    }

    private final void processTableSchema(BITable bITable) {
        ColumnList columnList = bITable.getColumns();
        int n = columnList.size();
        int n2 = 0;
        while (n2 < n) {
            Column column = columnList.get(n2);
            String string = column.getName();
            Type type = column.getType();
            BFacets bFacets = column.getFacets();
            int n3 = column.getFlags();
            BTypeSpec bTypeSpec = type.getTypeSpec();
            this.add(string, (BValue)bTypeSpec, n3, bFacets, null);
            ++n2;
        }
    }

    private final void processHistorySchema(BHistory bHistory) {
        BITable bITable;
        BHistoryConfig bHistoryConfig = bHistory.getConfig();
        ColumnList columnList = null;
        try {
            bITable = bHistory.toTable();
            columnList = bITable.getColumns();
        }
        catch (Exception exception) {}
        bITable = bHistoryConfig.getSchema();
        int n = bITable.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            Column column;
            String string = bITable.getColumnName(n2);
            BTypeSpec bTypeSpec = bITable.getColumnType(n2);
            BFacets bFacets = BFacets.NULL;
            int n3 = 0;
            if (columnList != null && (column = columnList.get(string)) != null) {
                bFacets = column.getFacets();
                n3 = column.getFlags();
            }
            if (string.equals(BHistoryRecord.timestamp.getName())) {
                bFacets = BFacets.make((BFacets)bFacets, (BFacets)BFacets.make((String)PRIMARY_KEY, (boolean)true));
            }
            this.add(string, (BValue)bTypeSpec, n3, bFacets, null);
            ++n2;
        }
    }

    public final synchronized boolean equivalent(Object object) {
        if (object != null && object instanceof BSeriesSchema) {
            String[] stringArray;
            BSeriesSchema bSeriesSchema = (BSeriesSchema)((Object)object);
            String[] stringArray2 = bSeriesSchema.getFieldNames();
            if (stringArray2.length != (stringArray = this.getFieldNames()).length) {
                return false;
            }
            int n = 0;
            while (n < stringArray2.length) {
                String string = stringArray2[n];
                BTypeSpec bTypeSpec = bSeriesSchema.getFieldType(string);
                BTypeSpec bTypeSpec2 = this.getFieldType(string);
                if (bTypeSpec2 == null || bTypeSpec == null) {
                    return false;
                }
                if (!bTypeSpec.equals((Object)bTypeSpec2)) {
                    return false;
                }
                BFacets bFacets = bSeriesSchema.getFieldFacets(string);
                BFacets bFacets2 = this.getFieldFacets(string);
                if (!bFacets2.equals((Object)bFacets)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public final String toString(Context context) {
        String string = "";
        Property[] propertyArray = this.getDynamicPropertiesArray();
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            String string2 = property.getName();
            BValue bValue = this.get(property);
            string = string + string2 + '=' + bValue;
            if (propertyArray.length > n + 1) {
                string = string + ',';
            }
            ++n;
        }
        return string;
    }

    public final void checkAdd(String string, BValue bValue, int n, BFacets bFacets, Context context) {
        if (!bValue.getType().is(BTypeSpec.TYPE)) {
            throw new BajaRuntimeException(lex.getText(ERR_INVALID_SCHEMA_VALUE, new Object[]{string}));
        }
    }

    public final void added(Property property, Context context) {
        this.removeDuplicateKeyFacet(property);
    }

    public final void changed(Property property, Context context) {
        this.removeDuplicateKeyFacet(property);
    }

    private final void removeDuplicateKeyFacet(Property property) {
        BFacets bFacets = this.getSlotFacets((Slot)property);
        if (bFacets.get(PRIMARY_KEY) != null) {
            Property[] propertyArray = this.getDynamicPropertiesArray();
            int n = 0;
            while (n < propertyArray.length) {
                BFacets bFacets2;
                Property property2 = propertyArray[n];
                if (property2 != property && (bFacets2 = property2.getFacets()) != null && bFacets2.get(PRIMARY_KEY) != null) {
                    BGraphNode.log.warning(lex.getText(ERR_DUPLICATE_KEY, new Object[]{property.getName()}));
                    bFacets = BFacets.makeRemove((BFacets)bFacets, (String)PRIMARY_KEY);
                    this.setFacets((Slot)property, bFacets);
                    return;
                }
                ++n;
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$seriestransform$graph$BSeriesSchema;
        if (clazz == null) {
            clazz = class$javax$baja$seriestransform$graph$BSeriesSchema = BSeriesSchema.class("[Ljavax.baja.seriestransform.graph.BSeriesSchema;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$javax$baja$seriestransform$graph$BSeriesSchema;
        if (clazz2 == null) {
            clazz2 = class$javax$baja$seriestransform$graph$BSeriesSchema = BSeriesSchema.class("[Ljavax.baja.seriestransform.graph.BSeriesSchema;", false);
        }
        lex = Lexicon.make((Class)clazz2);
    }
}

