/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.source;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.seriestransform.interval.BSeriesInterval;
import com.tridium.seriestransform.interval.BSeriesIntervalEnum;
import com.tridium.seriestransform.quantize.BNonQuantizedTable;
import com.tridium.seriestransform.quantize.BQuantizationTable;
import java.util.LinkedList;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryQuery;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.exceptions.ConfigException;
import javax.baja.seriestransform.exceptions.SourceException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.GraphNodeParams;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHistorySourceNode
extends BGraphNode {
    public static final Property dataSource = BHistorySourceNode.newProperty((int)8, (BValue)BFormat.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"seriesTransform:FormatOrdFE")));
    public static final Property dateRange = BHistorySourceNode.newProperty((int)0, (BValue)BDynamicTimeRange.DEFAULT, null);
    public static final Property srcSchema = BHistorySourceNode.newProperty((int)0, (BValue)new BSeriesSchema(), null);
    public static final Property quantInterval = BHistorySourceNode.newProperty((int)8, (BValue)new BSeriesInterval(), null);
    public static final Topic intervalModified = BHistorySourceNode.newTopic((int)4, null);
    public static final Type TYPE;
    private static final Lexicon lex;
    private static final String INVALID_DATA_SRC;
    private static final String INVALID_PERMISSIONS_KEY = "fault.msg.invalidPermissions";
    static /* synthetic */ Class class$com$tridium$seriestransform$source$BHistorySourceNode;

    public BFormat getDataSource() {
        return (BFormat)this.get(dataSource);
    }

    public void setDataSource(BFormat bFormat) {
        this.set(dataSource, (BValue)bFormat, null);
    }

    public BDynamicTimeRange getDateRange() {
        return (BDynamicTimeRange)this.get(dateRange);
    }

    public void setDateRange(BDynamicTimeRange bDynamicTimeRange) {
        this.set(dateRange, (BValue)bDynamicTimeRange, null);
    }

    public BSeriesSchema getSrcSchema() {
        return (BSeriesSchema)this.get(srcSchema);
    }

    public void setSrcSchema(BSeriesSchema bSeriesSchema) {
        this.set(srcSchema, (BValue)bSeriesSchema, null);
    }

    public BSeriesInterval getQuantInterval() {
        return (BSeriesInterval)this.get(quantInterval);
    }

    public void setQuantInterval(BSeriesInterval bSeriesInterval) {
        this.set(quantInterval, (BValue)bSeriesInterval, null);
    }

    public void fireIntervalModified(BSeriesInterval bSeriesInterval) {
        this.fire(intervalModified, (BValue)bSeriesInterval, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected BSeriesTransformTable[] doResolve(BSeriesTransformTable[] bSeriesTransformTableArray, GraphNodeParams graphNodeParams, BOrd bOrd, Context context) throws TransformException {
        OrdQuery[] ordQueryArray;
        BObject bObject;
        if (bSeriesTransformTableArray.length > 0) {
            return bSeriesTransformTableArray;
        }
        BOrd bOrd2 = BOrd.NULL;
        BFormat bFormat = (BFormat)graphNodeParams.get(dataSource.getName(), (BValue)this.getDataSource());
        BDynamicTimeRange bDynamicTimeRange = (BDynamicTimeRange)graphNodeParams.get(dateRange.getName(), (BValue)this.getDateRange());
        String string = this.getHistoryOrdParams(bDynamicTimeRange);
        String string2 = bFormat.getFormat();
        if (string2 != null && string2.length() > 0) {
            bObject = bOrd.get();
            ordQueryArray = bFormat.format((Object)bObject);
            if (ordQueryArray.indexOf(63) != -1 && string.length() > 0) {
                string = string.replace('?', ';');
            }
            try {
                bOrd2 = BOrd.make((String)((String)ordQueryArray + string));
            }
            catch (RuntimeException runtimeException) {}
        }
        bObject = new LinkedList();
        if (bOrd2 != BOrd.DEFAULT) {
            Object object;
            HistoryQuery historyQuery;
            OrdQuery ordQuery;
            ordQueryArray = bOrd2.parse();
            int n = 0;
            while (n < ordQueryArray.length) {
                ordQuery = ordQueryArray[n];
                if (ordQuery instanceof HistoryQuery) {
                    BPermissions bPermissions;
                    historyQuery = (HistoryQuery)ordQuery;
                    object = historyQuery.getHistoryId();
                    BHistoryDatabase bHistoryDatabase = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
                    BIHistory bIHistory = bHistoryDatabase.getHistory((BHistoryId)object);
                    if (context != null && context.getUser() != null && !(bPermissions = context.getUser().getPermissionsFor((BIProtected)bIHistory)).hasOperatorRead()) {
                        String string3 = lex.getText(INVALID_PERMISSIONS_KEY, new Object[]{historyQuery.toString()});
                        throw new SourceException(string3);
                    }
                }
                ++n;
            }
            BObject bObject2 = bOrd2.get(bOrd.get());
            if (bObject2 instanceof BICollection) {
                ordQuery = (BICollection)bObject2;
                this.setStatus(BStatus.ok);
                historyQuery = ordQuery.toTable();
                object = this.getQuantInterval();
                if (((BSeriesInterval)((Object)object)).getDesc() == BSeriesIntervalEnum.none) {
                    bObject.add(new BNonQuantizedTable(this.getName(), this.getSchema(), (BITable)historyQuery));
                } else {
                    bObject.add(new BQuantizationTable(this.getName(), this.getSchema(), (BSeriesInterval)((Object)object), (BITable)historyQuery));
                }
                return bObject.toArray(new BSeriesTransformTable[0]);
            }
        }
        throw new SourceException(INVALID_DATA_SRC);
    }

    public BSeriesSchema getSchema() {
        BSeriesSchema bSeriesSchema = this.getSrcSchema();
        bSeriesSchema.lease();
        return bSeriesSchema;
    }

    public void doCheckSchema() throws ConfigException {
    }

    private final String getHistoryOrdParams(BDynamicTimeRange bDynamicTimeRange) {
        if (bDynamicTimeRange == BDynamicTimeRange.DEFAULT) {
            return "";
        }
        BAbsTime bAbsTime = BAbsTime.now();
        BAbsTime bAbsTime2 = bDynamicTimeRange.getStartTime(bAbsTime);
        BAbsTime bAbsTime3 = bDynamicTimeRange.getEndTime(bAbsTime);
        String string = "?start=" + bAbsTime2.encodeToString() + ';';
        string = string + "end=" + bAbsTime3.encodeToString() + ';';
        return string;
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property == srcSchema) {
            this.fireSchemaModified(this.getSchema());
        }
        if (this.isRunning() && property == quantInterval) {
            this.fireIntervalModified(this.getQuantInterval());
        }
        super.changed(property, context);
    }

    public BIcon getIcon() {
        String string = lex.getText("source.icon");
        BOrdList bOrdList = BOrdList.make((String)string);
        return BIcon.make((BOrdList)bOrdList);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$seriestransform$source$BHistorySourceNode;
        if (clazz == null) {
            clazz = class$com$tridium$seriestransform$source$BHistorySourceNode = BHistorySourceNode.class("[Lcom.tridium.seriestransform.source.BHistorySourceNode;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$seriestransform$source$BHistorySourceNode;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$seriestransform$source$BHistorySourceNode = BHistorySourceNode.class("[Lcom.tridium.seriestransform.source.BHistorySourceNode;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        INVALID_DATA_SRC = lex.getText("fault.msg.invalidHistorySource");
    }
}

