/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.rollup;

import com.tridium.collection.BGenericTable;
import com.tridium.seriestransform.functions.BFunctionMapping;
import com.tridium.seriestransform.functions.FunctionCursor;
import com.tridium.seriestransform.rollup.BRollupInterval;
import com.tridium.seriestransform.rollup.BRollupIntervalEnum;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.baja.collection.BITable;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.IFilter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RollupCursor
extends FunctionCursor {
    private BComponent record;
    protected BComplex prevRecord;
    private BAbsTime prevIntervalEndtime;
    private String seriesName;
    private BRollupInterval interval;
    private Cursor innerCursor;
    private List seriesRecords;
    private Map rollupMap;

    protected void initTimes(BITable bITable) {
        BRelTime bRelTime;
        super.initTimes(bITable);
        this.intervalDefined = false;
        if (this.interval != null && (bRelTime = this.interval.getTime()).getMillis() >= 1000L) {
            this.intervalDefined = true;
        }
        if (!this.intervalDefined) {
            throw new BajaRuntimeException("Rollup Cursor: interval not defined.");
        }
    }

    private final void initInterval(BAbsTime bAbsTime) {
        this.intervalStartTime = this.makeBaselineTimestamp(bAbsTime);
        BRelTime bRelTime = this.interval.getTime();
        BRollupIntervalEnum bRollupIntervalEnum = this.interval.getDesc();
        switch (bRollupIntervalEnum.getOrdinal()) {
            case 0: {
                this.intervalEndTime = this.intervalStartTime.add(bRelTime);
                break;
            }
            case 1: {
                this.intervalEndTime = this.intervalStartTime.add(BRelTime.makeMinutes((int)5));
                break;
            }
            case 2: {
                this.intervalEndTime = this.intervalStartTime.add(BRelTime.makeMinutes((int)15));
                break;
            }
            case 3: {
                this.intervalEndTime = this.intervalStartTime.add(BRelTime.makeMinutes((int)30));
                break;
            }
            case 4: {
                this.intervalEndTime = this.intervalStartTime.add(BRelTime.HOUR);
                break;
            }
            case 5: {
                this.intervalEndTime = this.intervalStartTime.nextDay();
                break;
            }
            case 6: {
                this.intervalEndTime = this.intervalStartTime.nextMonth();
                break;
            }
            case 7: {
                this.intervalEndTime = this.intervalStartTime.nextYear();
                break;
            }
        }
    }

    private final BAbsTime makeBaselineTimestamp(BAbsTime bAbsTime) {
        BRelTime bRelTime = this.interval.getTime();
        BRollupIntervalEnum bRollupIntervalEnum = this.interval.getDesc();
        if (bRollupIntervalEnum == BRollupIntervalEnum.yearly) {
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)BMonth.january, (int)1);
        }
        if (bRollupIntervalEnum == BRollupIntervalEnum.monthly) {
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)1);
        }
        if (bRollupIntervalEnum == BRollupIntervalEnum.daily || bRelTime.getDays() > 0) {
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay());
        }
        if (bRollupIntervalEnum == BRollupIntervalEnum.hourly || bRelTime.getHours() > 0) {
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime.getHour(), (int)0);
        }
        if (bRollupIntervalEnum == BRollupIntervalEnum.thirtyMin) {
            int n = this.getBaseQuantum(bAbsTime.getMinute(), 30);
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime.getHour(), (int)n);
        }
        if (bRollupIntervalEnum == BRollupIntervalEnum.fifteenMin) {
            int n = this.getBaseQuantum(bAbsTime.getMinute(), 15);
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime.getHour(), (int)n);
        }
        if (bRollupIntervalEnum == BRollupIntervalEnum.fiveMin) {
            int n = this.getBaseQuantum(bAbsTime.getMinute(), 5);
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime.getHour(), (int)n);
        }
        if (bRelTime.getMinutes() > 0) {
            int n = this.getBaseQuantum(bAbsTime.getMinute(), bRelTime.getMinutes());
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime.getHour(), (int)n);
        }
        if (bRelTime.getSeconds() > 0) {
            int n = this.getBaseQuantum(bAbsTime.getSecond(), bRelTime.getSeconds());
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime.getHour(), (int)bAbsTime.getMinute(), (int)n, (int)0);
        }
        if (bRelTime.getMillis() > 0L) {
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime.getHour(), (int)bAbsTime.getMinute(), (int)bAbsTime.getSecond(), (int)0);
        }
        return bAbsTime;
    }

    private final int getBaseQuantum(int n, int n2) {
        if (n2 == 0 || n == 0) {
            return 0;
        }
        return n / n2 * n2;
    }

    private final void updateIntervalPeriod() {
        BRollupIntervalEnum bRollupIntervalEnum = this.interval.getDesc();
        switch (bRollupIntervalEnum.getOrdinal()) {
            case 0: {
                BRelTime bRelTime = this.interval.getTime();
                this.intervalStartTime = this.intervalStartTime.add(bRelTime);
                this.intervalEndTime = this.intervalEndTime.add(bRelTime);
                break;
            }
            case 7: {
                this.intervalStartTime = this.intervalStartTime.nextYear();
                this.intervalEndTime = this.intervalEndTime.nextYear();
                break;
            }
            case 6: {
                this.intervalStartTime = this.intervalStartTime.nextMonth();
                this.intervalEndTime = this.intervalEndTime.nextMonth();
                break;
            }
            case 5: {
                this.intervalStartTime = this.intervalStartTime.nextDay();
                this.intervalEndTime = this.intervalEndTime.nextDay();
                break;
            }
            case 4: {
                this.intervalStartTime = this.intervalStartTime.add(BRelTime.HOUR);
                this.intervalEndTime = this.intervalEndTime.add(BRelTime.HOUR);
                break;
            }
            case 3: {
                this.intervalStartTime = this.intervalStartTime.add(THIRTY_MIN);
                this.intervalEndTime = this.intervalEndTime.add(THIRTY_MIN);
                break;
            }
            case 2: {
                this.intervalStartTime = this.intervalStartTime.add(FIFTEEN_MIN);
                this.intervalEndTime = this.intervalEndTime.add(FIFTEEN_MIN);
                break;
            }
            case 1: {
                this.intervalStartTime = this.intervalStartTime.add(FIVE_MIN);
                this.intervalEndTime = this.intervalEndTime.add(FIVE_MIN);
                break;
            }
        }
    }

    public boolean next() {
        this.seriesRecords.clear();
        String string = this.getKeyField();
        RollupCursor.clearRecord((BComplex)this.record);
        if (this.prevRecord != null) {
            BAbsTime bAbsTime = (BAbsTime)this.prevRecord.get(string);
            if (bAbsTime.isAfter(this.intervalEndTime)) {
                this.initInterval(bAbsTime);
            }
            if ((bAbsTime.isAfter(this.prevIntervalEndtime) || bAbsTime.equals((Object)this.prevIntervalEndtime)) && (this.filter == null || this.filter != null && this.filter.accept((Object)this.prevRecord))) {
                this.seriesRecords.add(this.prevRecord);
            }
            this.prevRecord = null;
        }
        this.getIntervalSeries(this.seriesRecords);
        if (log.isTraceOn()) {
            this.traceSeriesData(this.seriesRecords);
        }
        if (this.seriesRecords.isEmpty()) {
            return false;
        }
        this.rollupMap.clear();
        this.rollupMap.put(this.seriesName, this.seriesRecords);
        try {
            this.applySeriesFunction(this.rollupMap, this.record, false);
        }
        catch (TransformException transformException) {
            throw new BajaRuntimeException(transformException.getMessage(), transformException.getCause());
        }
        this.record.set(string, (BValue)this.intervalStartTime);
        this.prevIntervalEndtime = BAbsTime.make((long)this.intervalEndTime.getMillis(), (BTimeZone)this.intervalEndTime.getTimeZone());
        this.updateIntervalPeriod();
        return true;
    }

    public BObject get() {
        return this.record;
    }

    private final void getIntervalSeries(List list) {
        String string = this.getKeyField();
        while (this.innerCursor.next()) {
            BComplex bComplex;
            BAbsTime bAbsTime;
            if (!(this.innerCursor.get() instanceof BComplex) || (bAbsTime = (BAbsTime)(bComplex = (BComplex)((BComplex)this.innerCursor.get()).newCopy()).get(string)) == null) continue;
            if (this.intervalStartTime == null || this.intervalStartTime == BAbsTime.DEFAULT) {
                this.initInterval(bAbsTime);
            }
            if (bAbsTime.equals((Object)this.intervalEndTime) || bAbsTime.isAfter(this.intervalEndTime)) {
                this.prevRecord = bComplex;
                break;
            }
            if (bAbsTime.isBefore(this.intervalEndTime)) {
                if (this.filter != null && (this.filter == null || !this.filter.accept((Object)bComplex))) continue;
                list.add(bComplex);
                continue;
            }
            this.prevRecord = null;
        }
    }

    private final void traceSeriesData(List list) {
        log.trace("--- Rollup Cursor ---");
        log.trace("start interval: " + this.intervalStartTime.encodeToString());
        log.trace("end interval:   " + this.intervalEndTime.encodeToString());
        log.trace("Record count:   " + list.size());
        log.trace("Record Times:");
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BComplex bComplex = (BComplex)iterator.next();
            SlotCursor slotCursor = bComplex.getProperties();
            String string2 = "";
            while (slotCursor.next()) {
                Property property = slotCursor.property();
                BValue bValue = bComplex.get(property);
                if (bl) {
                    if (string.length() > 0) {
                        string = string + ',';
                    }
                    string = string + property.getName();
                }
                if (string2.length() > 0) {
                    string2 = string2 + ',';
                }
                string2 = string2 + bValue.toString();
            }
            string2 = string2 + '\n';
            stringBuffer.append(string2);
            bl = false;
        }
        log.trace(string);
        log.trace(stringBuffer.toString());
    }

    private final /* synthetic */ void this() {
        this.seriesRecords = new LinkedList();
        this.rollupMap = new Hashtable();
    }

    public RollupCursor(BSeriesSchema bSeriesSchema, BComponent[] bComponentArray, String string, BRollupInterval bRollupInterval, BFunctionMapping[] bFunctionMappingArray) {
        this(bSeriesSchema, (BITable)new BGenericTable(bComponentArray), string, bRollupInterval, bFunctionMappingArray);
    }

    public RollupCursor(BSeriesSchema bSeriesSchema, BITable bITable, String string, BRollupInterval bRollupInterval, BFunctionMapping[] bFunctionMappingArray) {
        this(bSeriesSchema, bITable, string, bRollupInterval, bFunctionMappingArray, null);
    }

    public RollupCursor(BSeriesSchema bSeriesSchema, BITable bITable, String string, BRollupInterval bRollupInterval, BFunctionMapping[] bFunctionMappingArray, IFilter iFilter) {
        super(bSeriesSchema.getKeyField());
        this.this();
        this.seriesName = string;
        this.interval = bRollupInterval;
        this.functions = bFunctionMappingArray;
        this.filter = iFilter;
        this.innerCursor = bITable.cursor();
        this.initTimes(bITable.toTable());
        this.record = RollupCursor.createTemplateRecord(bSeriesSchema);
    }
}

