/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.graph.ui;

import com.tridium.seriestransform.BTransformQuery;
import com.tridium.seriestransform.NQueryParameters;
import com.tridium.seriestransform.graph.BTransformGraph;
import com.tridium.seriestransform.graph.ParameterSlot;
import com.tridium.seriestransform.graph.ui.BGraphOrdFE;
import com.tridium.workbench.celleditors.BStringCE;
import com.tridium.workbench.celltable.BLabeledCellTable;
import com.tridium.workbench.fieldeditors.BOrdFE;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BSlotScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.util.TextUtil;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.celleditor.BWbCellEditor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTransformQueryEditor
extends BWbEditor {
    public static final Action updateQueryTable = BTransformQueryEditor.newAction((int)0, null);
    public static final Type TYPE;
    private static final Lexicon lex;
    private static final String COL_PARAM_VAL;
    private static final String LBL_GRAPH_ORD;
    private static final String LBL_PARAM_TBL;
    private static final String TITLE;
    private static final Log log;
    private BGraphOrdFE graphOrdFE;
    private BTransformQuery query;
    private BLabeledCellTable paramTable;
    private Map paramValueMap;
    private BWidget owner;
    private BOrd base;
    static /* synthetic */ Class class$com$tridium$seriestransform$graph$ui$BTransformQueryEditor;

    public void updateQueryTable() {
        this.invoke(updateQueryTable, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BTransformQuery open(BWidget bWidget, BOrd bOrd, BTransformQuery bTransformQuery, Context context) throws CannotSaveException, Exception {
        if (bTransformQuery == null) {
            bTransformQuery = new BTransformQuery();
        }
        BTransformQueryEditor bTransformQueryEditor = new BTransformQueryEditor(bWidget, bOrd);
        bTransformQueryEditor.loadValue((BObject)bTransformQuery, context);
        int n = BDialog.open((BWidget)bWidget, (String)TITLE, (Object)((Object)bTransformQueryEditor), (int)3);
        if (n != 1) {
            return null;
        }
        bTransformQuery = (BTransformQuery)bTransformQueryEditor.saveValue();
        return bTransformQuery;
    }

    private final void buildUI() {
        String[] stringArray = new String[]{COL_PARAM_VAL};
        this.paramTable = new BLabeledCellTable(stringArray);
        this.graphOrdFE.setOrdFieldLength(45);
        BScrollPane bScrollPane = new BScrollPane((BWidget)this.paramTable);
        bScrollPane.setVpolicy(BScrollBarPolicy.asNeeded);
        bScrollPane.setHpolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bScrollPane);
        bConstrainedPane.setMinHeight(100.0);
        bConstrainedPane.setMaxHeight(150.0);
        bConstrainedPane.setMinWidth(300.0);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setRowGap(10.0);
        bGridPane.setColumnGap(10.0);
        bGridPane.add(null, (BValue)new BLabel(LBL_GRAPH_ORD));
        bGridPane.add(null, (BValue)this.graphOrdFE);
        bGridPane.add(null, (BValue)new BLabel(LBL_PARAM_TBL));
        bGridPane.add(null, (BValue)bConstrainedPane);
        this.linkTo((BComponent)this.paramTable, (Slot)BLabeledCellTable.modified, (Slot)setModified);
        this.linkTo((BComponent)this.graphOrdFE, (Slot)BOrdFE.textModified, (Slot)updateQueryTable);
        this.linkTo((BComponent)this.graphOrdFE, (Slot)BOrdFE.textModified, (Slot)setModified);
        this.setContent((BWidget)bGridPane);
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        this.query = (BTransformQuery)bObject;
        BOrd bOrd = this.query.getGraphOrd();
        this.graphOrdFE.loadValue((BObject)bOrd);
        BTransformGraph bTransformGraph = this.resolveGraphOrd(bOrd);
        if (bTransformGraph != null) {
            NQueryParameters nQueryParameters = this.query.decodeQueryParameters(bTransformGraph);
            this.populateParameterTable(bOrd, nQueryParameters);
        }
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws CannotSaveException, Exception {
        BOrd bOrd = (BOrd)this.graphOrdFE.saveValue();
        BTransformGraph bTransformGraph = this.resolveGraphOrd(bOrd);
        bTransformGraph.lease(3);
        SlotPath slotPath = bTransformGraph.getSlotPath();
        Set set = this.paramValueMap.keySet();
        this.query.lease();
        this.query.setGraphOrd(BOrd.make((OrdQuery)slotPath));
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            BWbCellEditor bWbCellEditor = (BWbCellEditor)this.paramValueMap.get(string);
            BValue bValue = (BValue)bWbCellEditor.saveValue();
            SlotPath slotPath2 = new SlotPath(string);
            String string2 = bTransformGraph.getSlotPath().toString();
            if (slotPath2.toString().startsWith(string2)) {
                string = slotPath2.toString().substring(string2.length());
            }
            BOrd bOrd2 = BOrd.make((OrdQuery)slotPath2);
            String[] stringArray = TextUtil.split((String)string, (char)'/');
            bTransformGraph.lease(stringArray.length);
            BValue bValue2 = (BValue)bOrd2.get((BObject)bTransformGraph);
            if (bValue2 == null || bValue2.equals((Object)bValue)) continue;
            this.query.encodeParameter(slotPath2, bValue);
        }
        return this.query;
    }

    private final void populateParameterTable(BOrd bOrd, NQueryParameters nQueryParameters) {
        if (bOrd == null || bOrd == BOrd.NULL) {
            this.clearParamTable();
        } else {
            BTransformGraph bTransformGraph = this.resolveGraphOrd(bOrd);
            if (bTransformGraph != null) {
                this.buildParamTable(bTransformGraph, nQueryParameters);
            }
        }
    }

    private final void buildParamTable(BTransformGraph bTransformGraph, NQueryParameters nQueryParameters) {
        bTransformGraph.lease(3);
        String string = bTransformGraph.getSlotPath().toString();
        string = string.substring(BSlotScheme.INSTANCE.getId().length() + 1);
        ParameterSlot[] parameterSlotArray = bTransformGraph.getParameterSlots();
        int n = 0;
        while (n < parameterSlotArray.length) {
            ParameterSlot parameterSlot = parameterSlotArray[n];
            SlotPath slotPath = parameterSlot.getSlotPath();
            SlotPath slotPath2 = slotPath.getParent();
            String[] stringArray = slotPath.getNames();
            String string2 = stringArray[stringArray.length - 1];
            BOrd bOrd = BOrd.make((BOrd)bTransformGraph.getAbsoluteOrd(), (OrdQuery)slotPath2);
            BObject bObject = bOrd.get((BObject)bTransformGraph);
            if (bObject != null && bObject instanceof BComponent) {
                BComponent bComponent = (BComponent)bObject;
                bComponent.lease();
                Property property = bComponent.getProperty(string2);
                BValue bValue = bComponent.get(property);
                BWbCellEditor bWbCellEditor = BWbCellEditor.makeFor((BObject)bValue, (Context)this.getCurrentContext());
                BValue bValue2 = nQueryParameters.get(slotPath);
                if (bValue2 != null && bValue2.getType().is(bValue.getType())) {
                    bValue = bValue2;
                }
                bWbCellEditor.loadValue((BObject)bValue, this.getCurrentContext());
                String string3 = slotPath.toDisplayString();
                string3 = string3.substring(string.length() + 1);
                this.paramTable.addRow(string3, new BWbCellEditor[]{bWbCellEditor});
                this.paramValueMap.put(slotPath.getBody(), bWbCellEditor);
            }
            ++n;
        }
        if (this.paramTable.getRowCount() == 0) {
            this.paramTable.addRow("<params>", new BWbCellEditor[]{new BStringCE()});
            this.paramTable.setEnabled(false);
        }
        this.paramTable.getModel().updateTable();
        this.paramTable.relayout();
        this.repaint();
    }

    private final void clearParamTable() {
        this.paramTable.clearRows();
        this.paramTable.addRow("<params>", new BWbCellEditor[]{new BStringCE()});
        this.paramTable.setEnabled(false);
        this.paramTable.getModel().updateTable();
        this.paramTable.relayout();
        this.repaint();
    }

    private final BTransformGraph resolveGraphOrd(BOrd bOrd) {
        Object object;
        BWbShell bWbShell;
        if (this.base == null) {
            bWbShell = BWbShell.getWbShell((BWidget)this.owner);
            if (bWbShell == null) {
                return null;
            }
            object = bWbShell.getActiveOrd();
            if (object == null || object == BOrd.NULL) {
                return null;
            }
            OrdQuery[] ordQueryArray = object.parse();
            OrdQueryList ordQueryList = new OrdQueryList(ordQueryArray);
            ordQueryList.shiftToSession(ordQueryList.size());
            this.base = BOrd.make((OrdQuery[])ordQueryList.toArray());
        }
        if (bOrd != null && bOrd != BOrd.NULL) {
            bOrd = BOrd.make((String)("station:|" + bOrd.encodeToString()));
            bWbShell = (bOrd = BOrd.make((BOrd)this.base, (BOrd)bOrd)).get();
            if (bWbShell == null || !(bWbShell instanceof BTransformGraph)) {
                return null;
            }
            object = (BTransformGraph)bWbShell;
            return object;
        }
        return null;
    }

    public void doUpdateQueryTable() {
        try {
            String string = this.graphOrdFE.getTextField().getText();
            BOrd bOrd = BOrd.make((String)string);
            BTransformGraph bTransformGraph = this.resolveGraphOrd(bOrd);
            if (bTransformGraph != null) {
                NQueryParameters nQueryParameters = this.query.decodeQueryParameters(bTransformGraph);
                this.paramTable.clearRows();
                this.populateParameterTable(bOrd, nQueryParameters);
            }
        }
        catch (Exception exception) {
            log.error("Transform Query Editor failed to process transform query parameters for graph ORD: " + this.graphOrdFE.getTextField().getText());
            log.error(exception.getMessage(), (Throwable)exception);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.graphOrdFE = new BGraphOrdFE();
        this.paramValueMap = new Hashtable();
    }

    public BTransformQueryEditor() {
        this.this();
    }

    public BTransformQueryEditor(BWidget bWidget) {
        this(bWidget, null);
    }

    public BTransformQueryEditor(BWidget bWidget, BOrd bOrd) {
        this.this();
        this.owner = bWidget;
        this.base = bOrd;
        this.buildUI();
    }

    static {
        Class clazz = class$com$tridium$seriestransform$graph$ui$BTransformQueryEditor;
        if (clazz == null) {
            clazz = class$com$tridium$seriestransform$graph$ui$BTransformQueryEditor = BTransformQueryEditor.class("[Lcom.tridium.seriestransform.graph.ui.BTransformQueryEditor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$seriestransform$graph$ui$BTransformQueryEditor;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$seriestransform$graph$ui$BTransformQueryEditor = BTransformQueryEditor.class("[Lcom.tridium.seriestransform.graph.ui.BTransformQueryEditor;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        COL_PARAM_VAL = lex.getText("transformParams.editor.colName");
        LBL_GRAPH_ORD = lex.getText("transformParams.editor.lblGraphOrd");
        LBL_PARAM_TBL = lex.getText("transformParams.editor.lblParamTbl");
        TITLE = lex.getText("transformParams.editor.title");
        log = Log.getLog((String)"seriesTransform");
    }
}

