/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.graph.ui;

import com.tridium.seriestransform.graph.ui.BConfigItem;
import com.tridium.ui.BRoundedPopup;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.propsheet.BPropertySheet;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Insets;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRoundedDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWindow;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BConfigEditor
extends BEdgePane {
    public static final Action setModified = BConfigEditor.newAction((int)0, null);
    public static final Action enableSave = BConfigEditor.newAction((int)0, (BValue)BBoolean.make((boolean)true), null);
    public static final Action validateConfig = BConfigEditor.newAction((int)0, null);
    public static final Topic validateEvent = BConfigEditor.newTopic((int)0, null);
    public static final Type TYPE;
    private static final Lexicon lex;
    public static final Log log;
    private static final String ICON_REMOVE_CMD = "cmd.remove.icon";
    private static final String ICON_ADD_CMD = "cmd.add.icon";
    private static final String ICON_EDIT_CMD = "cmd.edit.icon";
    private static final String ICON_KEY_CMD = "cmd.setKey.icon";
    private static final String ICON_AUTO_CMD = "cmd.auto.icon";
    private static final String ICON_UP_CMD = "cmd.moveup.icon";
    private static final String ICON_DOWN_CMD = "cmd.movedown.icon";
    protected static final BImage addIcon;
    protected static final BImage keyIcon;
    protected static final BImage minusIcon;
    public static final BImage populateDefaults;
    public static final BImage editIcon;
    public static final BImage moveUpIcon;
    public static final BImage moveDownIcon;
    protected static final BInsets insets;
    private static final int DISPLAY_TITLE_BG_COLOR = 0x666666;
    public static final BImage IMG_BLANK;
    public static final BImage IMG_WARNING;
    protected BGridPane configDisplayPane;
    private BGridPane msgDisplayPane;
    protected Map configRows;
    private Command[] cmds;
    static /* synthetic */ Class class$com$tridium$seriestransform$graph$ui$BConfigEditor;
    static /* synthetic */ Class class$javax$baja$ui$pane$BBorderPane;

    public void setModified() {
        this.invoke(setModified, null, null);
    }

    public void enableSave(BBoolean bBoolean) {
        this.invoke(enableSave, (BValue)bBoolean, null);
    }

    public void validateConfig() {
        this.invoke(validateConfig, null, null);
    }

    public void fireValidateEvent(BBoolean bBoolean) {
        this.fire(validateEvent, (BValue)bBoolean, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doSetReadonly(boolean bl) {
        if (this.cmds != null && this.cmds.length > 0) {
            int n = 0;
            while (n < this.cmds.length) {
                this.cmds[n].setEnabled(bl ^ true);
                ++n;
            }
        }
        Collection collection = this.configRows.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            BWidget bWidget = (BWidget)iterator.next();
            bWidget.setEnabled(bl ^ true);
        }
    }

    protected BWidget buildTableDisplay(String string, Command[] commandArray) {
        if (string == null) {
            string = "";
        }
        BPane bPane = BConfigEditor.makeSubTitle(string, commandArray);
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setStretchColumn(0);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setRowGap(0.0);
        bGridPane.add(null, (BValue)bPane);
        this.configDisplayPane = bGridPane;
        BScrollPane bScrollPane = new BScrollPane((BWidget)bGridPane);
        bScrollPane.setViewportBackground(Theme.pane().getControlBackground());
        return this.makeInset((BWidget)bScrollPane);
    }

    public static BPane makeSubTitle(String string, Command[] commandArray) {
        BGridPane bGridPane;
        BLabel bLabel = new BLabel(string);
        bLabel.setForeground(BColor.white.toBrush());
        bLabel.setFont(Theme.widget().getBoldText());
        bLabel.setHalign(BHalign.left);
        BGridPane bGridPane2 = new BGridPane(2);
        bGridPane2.setColumnGap((double)5);
        bGridPane2.add(null, (BValue)bLabel);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setLeft((BWidget)bGridPane2);
        if (commandArray != null && commandArray.length > 0) {
            bGridPane = new BGridPane(commandArray.length);
            int n = 0;
            while (n < commandArray.length) {
                bGridPane.add(null, (BValue)BConfigEditor.makeButton(commandArray[n], BColor.make((int)0x666666)));
                ++n;
            }
            bEdgePane.setRight((BWidget)bGridPane);
        }
        bGridPane = new BBorderPane((BWidget)bEdgePane, BInsets.make((double)3, (double)6.0, (double)3, (double)6.0));
        bGridPane.setFill(BColor.make((int)0x666666).toBrush());
        return bGridPane;
    }

    public static BLabel makeNoteLabel(String string) {
        BFont bFont = Theme.label().getBoldText();
        bFont = BFont.make((BFont)bFont, (int)2);
        BLabel bLabel = new BLabel();
        bLabel.setFont(bFont);
        bLabel.setStyleClasses("trace");
        bLabel.setText(string);
        return bLabel;
    }

    public void addConfig(BConfigItem bConfigItem, Command[] commandArray) {
        Property property;
        if (bConfigItem == null) {
            return;
        }
        this.linkTo((BComponent)bConfigItem, (Slot)BConfigItem.modified, (Slot)validateConfig);
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.add(null, (BValue)bConfigItem);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setLeft((BWidget)bGridPane);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bEdgePane, insets);
        bBorderPane.setBorder(BBorder.make((String)"top(groove)"));
        if (commandArray != null && commandArray.length > 0) {
            this.cmds = commandArray;
            property = new BGridPane(commandArray.length);
            int n = 0;
            while (n < commandArray.length) {
                property.add(null, (BValue)BConfigEditor.makeButton(commandArray[n], null));
                ++n;
            }
            bEdgePane.setRight((BWidget)property);
        }
        property = this.configDisplayPane.add(null, (BValue)bBorderPane);
        this.configRows.put(bConfigItem, property);
        this.resize();
    }

    public void removeAllConfigs() {
        Set set = this.configRows.keySet();
        BBorderPane[] bBorderPaneArray = set.iterator();
        while (bBorderPaneArray.hasNext()) {
            BWidget bWidget = (BWidget)bBorderPaneArray.next();
            BComponent bComponent = (BComponent)bWidget.getParent();
            if (bComponent == null) continue;
            bComponent.remove((BComplex)bWidget);
        }
        Class clazz = class$javax$baja$ui$pane$BBorderPane;
        if (clazz == null) {
            clazz = class$javax$baja$ui$pane$BBorderPane = BConfigEditor.class("[Ljavax.baja.ui.pane.BBorderPane;", false);
        }
        bBorderPaneArray = (BBorderPane[])this.configDisplayPane.getChildren(clazz);
        int n = 0;
        while (n < bBorderPaneArray.length) {
            if (bBorderPaneArray[n].getContent() instanceof BConfigItem) {
                this.configDisplayPane.remove((BComplex)bBorderPaneArray[n]);
            }
            ++n;
        }
        this.configRows.clear();
    }

    public void removeConfig(BWidget bWidget) {
        Property property = (Property)this.configRows.get(bWidget);
        if (property != null) {
            this.configDisplayPane.remove(property);
            this.resize();
        }
    }

    public void computePreferredSize() {
        this.getCenter().computePreferredSize();
        double d = this.getCenter().getPreferredWidth();
        double d2 = this.getCenter().getPreferredHeight();
        this.setPreferredSize(d, Math.min(d2, 450.0));
    }

    protected void resize() {
        if (this.getShell() instanceof BRoundedDialog) {
            BRoundedDialog bRoundedDialog = (BRoundedDialog)this.getShell();
            Insets insets = UiEnv.get().getWindowInsets((BWindow)bRoundedDialog);
            bRoundedDialog.computePreferredSize();
            double d = bRoundedDialog.getPreferredHeight() + insets.top + insets.bottom;
            double d2 = bRoundedDialog.getPreferredWidth() + insets.left + insets.right;
            IRectGeom iRectGeom = bRoundedDialog.getScreenBounds();
            bRoundedDialog.setScreenBounds(iRectGeom.x(), iRectGeom.y(), d2, d);
        }
    }

    public void setBottom(BWidget bWidget) {
        if (bWidget == this.msgDisplayPane) {
            super.setBottom(bWidget);
        }
    }

    protected static BButton makeButton(Command command, BColor bColor) {
        BButton bButton = new BButton(command);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        if (bColor != null) {
            bButton.setBackground(bColor.toBrush());
        }
        return bButton;
    }

    protected BWidget makeInset(BWidget bWidget) {
        BBorderPane bBorderPane = new BBorderPane(bWidget, BBorder.make((String)"1px solid black"), BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        return new BBorderPane((BWidget)bBorderPane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
    }

    public void doSetModified() {
    }

    public void doEnableSave(BBoolean bBoolean) {
        if (bBoolean == null) {
            return;
        }
        BComponent bComponent = (BComponent)this.getParent();
        while (bComponent != null) {
            if (bComponent instanceof BPropertySheet) {
                BWbShell bWbShell = BWbShell.getWbShell((BWidget)this);
                bWbShell.getSaveCommand().setEnabled(bBoolean.getBoolean());
                break;
            }
            if (bComponent instanceof BRoundedDialog) {
                BRoundedPopup bRoundedPopup = (BRoundedPopup)bComponent;
                bRoundedPopup.getOkButton().setEnabled(bBoolean.getBoolean());
                break;
            }
            bComponent = (BComponent)bComponent.getParent();
        }
    }

    public final void doValidateConfig() {
        boolean bl = this.doValidate();
        this.resize();
        this.fireValidateEvent(BBoolean.make((boolean)bl));
    }

    public boolean doValidate() {
        return true;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.msgDisplayPane = new BGridPane(1);
        this.configRows = new Hashtable();
    }

    public BConfigEditor() {
        this.this();
        this.linkTo((BComponent)this, (Slot)validateEvent, (Slot)enableSave);
        this.setBottom((BWidget)this.msgDisplayPane);
    }

    static {
        Class clazz = class$com$tridium$seriestransform$graph$ui$BConfigEditor;
        if (clazz == null) {
            clazz = class$com$tridium$seriestransform$graph$ui$BConfigEditor = BConfigEditor.class("[Lcom.tridium.seriestransform.graph.ui.BConfigEditor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$seriestransform$graph$ui$BConfigEditor;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$seriestransform$graph$ui$BConfigEditor = BConfigEditor.class("[Lcom.tridium.seriestransform.graph.ui.BConfigEditor;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        log = Log.getLog((String)"seriesTransformUI");
        addIcon = BImage.make((String)lex.getText(ICON_ADD_CMD));
        keyIcon = BImage.make((String)lex.getText(ICON_KEY_CMD));
        minusIcon = BImage.make((String)lex.getText(ICON_REMOVE_CMD));
        populateDefaults = BImage.make((String)lex.getText(ICON_AUTO_CMD));
        editIcon = BImage.make((String)lex.getText(ICON_EDIT_CMD));
        moveUpIcon = BImage.make((String)lex.getText(ICON_UP_CMD));
        moveDownIcon = BImage.make((String)lex.getText(ICON_DOWN_CMD));
        insets = BInsets.make((double)3, (double)6.0, (double)3, (double)6.0);
        IMG_BLANK = BImage.make((BIcon)BIcon.std((String)"blank.png"));
        IMG_WARNING = BImage.make((BIcon)BIcon.std((String)"warning.png"));
    }
}

