/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.composite;

import com.tridium.seriestransform.IntervalSeriesCursor;
import com.tridium.seriestransform.SubCursor;
import com.tridium.seriestransform.composite.CompositeMapping;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.util.IFilter;

public class CompositeCursor
extends IntervalSeriesCursor {
    private BComponent currentRecord;
    private SubCursor[] subCursors;
    private String keyField;

    private final void createSubCursors(CompositeMapping[] compositeMappingArray) {
        this.subCursors = new SubCursor[compositeMappingArray.length];
        int n = 0;
        while (n < compositeMappingArray.length) {
            CompositeMapping compositeMapping = compositeMappingArray[n];
            BSeriesTransformTable bSeriesTransformTable = compositeMapping.getTable();
            Map map = compositeMapping.getPropertyMappings();
            String string = bSeriesTransformTable.getSchema().getKeyField();
            MappingCursor mappingCursor = new MappingCursor(bSeriesTransformTable.cursor(), string, map);
            this.subCursors[n] = mappingCursor;
            ++n;
        }
    }

    public Context getContext() {
        return null;
    }

    public boolean next(Class clazz) {
        return false;
    }

    public boolean nextComponent() {
        return false;
    }

    public boolean next() {
        BAbsTime bAbsTime = this.getBaseTime();
        if (bAbsTime.equals((Object)BAbsTime.DEFAULT)) {
            return false;
        }
        CompositeCursor.clearRecord((BComplex)this.currentRecord);
        this.currentRecord.set(this.keyField, (BValue)bAbsTime);
        int n = 0;
        while (n < this.subCursors.length) {
            MappingCursor mappingCursor = (MappingCursor)this.subCursors[n];
            BComplex bComplex = mappingCursor.get(bAbsTime);
            Map map = mappingCursor.getMappings();
            if (bComplex != null) {
                Set set = map.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String string2 = (String)map.get(string);
                    Property property = this.currentRecord.getProperty(string);
                    BFacets bFacets = property.getFacets();
                    BValue bValue = bComplex.get(string2);
                    this.currentRecord.set(string, bValue);
                    Slot slot = this.currentRecord.getSlot(string);
                    this.currentRecord.setFacets(slot, bFacets);
                }
            }
            ++n;
        }
        return true;
    }

    public BObject get() {
        return this.currentRecord;
    }

    private final BAbsTime getBaseTime() {
        BAbsTime bAbsTime = BAbsTime.DEFAULT;
        int n = 0;
        while (n < this.subCursors.length) {
            MappingCursor mappingCursor = (MappingCursor)this.subCursors[n];
            if (mappingCursor.next()) {
                BAbsTime bAbsTime2 = mappingCursor.getTimestamp();
                if (bAbsTime == BAbsTime.DEFAULT || bAbsTime2.isBefore(bAbsTime)) {
                    bAbsTime = bAbsTime2;
                }
            } else {
                this.subCursors[n] = null;
                this.subCursors = SubCursor.reduce(this.subCursors);
                return this.getBaseTime();
            }
            ++n;
        }
        return bAbsTime;
    }

    public CompositeCursor(BSeriesSchema bSeriesSchema, CompositeMapping[] compositeMappingArray) {
        this(bSeriesSchema, compositeMappingArray, null);
    }

    public CompositeCursor(BSeriesSchema bSeriesSchema, CompositeMapping[] compositeMappingArray, IFilter iFilter) {
        this.keyField = bSeriesSchema.getKeyField();
        this.filter = null;
        this.currentRecord = CompositeCursor.createTemplateRecord(bSeriesSchema);
        this.createSubCursors(compositeMappingArray);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class MappingCursor
    extends SubCursor {
        private Map propMappings;

        public Map getMappings() {
            return this.propMappings;
        }

        public MappingCursor(Cursor cursor, String string, Map map) {
            super(cursor, string);
            this.propMappings = map;
        }
    }
}

